# API Calling Description

When requesting a api, you need to provide application authentication and user authentication information to authenticate the application and the current user.

## APP Authentication

Before using the api, you shall first get the APP Code and APP Secret depending on [Existing app](/app/list/){:target="_blank"} or [Create an app](/app/create/){:target="_blank"}, as the information for application authentication.

- **APP Code**: APP unique identification, which is specified by the creator when creating the app, and can be got through **APP Code** in the app basic information. 
- **APP Secret**: APP secret, which is generated by the platform after the app is created, and can be got through **APP Secret** in the app basic information. 

## User Authentication 
User authentication is achieved by verifying the user login token. User login token bk_token will be stored in the Cookies of browser after the user logs in. 

At the time of api calling, if the user login token is not available, the APP Code can be added to the **APP white list free of login token verification**. So, when the APP requests api, it is workable to only provide the username of the current user.

- functioncontroller: [General White List Management](/admin/bkcore/functioncontroller/){:target="_blank"}, which maintains different white lists by specifying different function codes. 
- user_auth::skip_user_auth: "APP white list free of login token verification" function code; add this function code and then add the APP Code to "Function test white list" 

## API Calling

API Calling can be carried out in two methods. One is to use the sdk package provided in the APP development framework, and another is to access directly based on api url. 


### Utilize sdk package in the APP development framework

There are two ways to access api using sdk package, i.e. shortcuts or ComponentClient. Sample is shown below:

- shortcuts -- get_client_by_request
```python

    from blueking.component.shortcuts import get_client_by_request
    # By default, APP authentication info: APP Code and APP Secret is got from django settings
    # By default, user login token bk_token is got from django request
    client = get_client_by_request(request)
    # Parameters
    kwargs = {'fields': ['bk_biz_id', 'bk_biz_name']}
    result = client.cc.search_business(kwargs)
```

- shortcuts -- get_client_by_user
```python
    from blueking.component.shortcuts import get_client_by_user
    # By default, APP authentication info: APP Code and APP Secret is got from django settings
    # By default, username is got from user which is User object or is directly the username data in User
    user = "username"
    client = get_client_by_user(user)
    # Parameters
    kwargs = {'fields': ['bk_biz_id', 'bk_biz_name']}
    result = client.cc.search_business(kwargs)
```

- ComponentClient
```python
    from blueking.component.client import ComponentClient
    # APP Code
    bk_app_code = "xxx" 
    # APP Secret
    bk_app_secret = "xxx-xxx-xxx-xxx-xxx" 
    # User login token
    common_args = {"bk_token": "xxx"}
    # If APP Code and APP Secret are not provided, the default is to get from django settings 
    client = ComponentClient(
        bk_app_code=bk_app_code, 
        bk_app_secret=bk_app_secret, 
        common_args=common_args
    )
    # Parameters
    kwargs = {'fields': ['bk_biz_id', 'bk_biz_name']}
    result = client.cc.search_business(kwargs)
```

#### SDK Package in the APP Development Framework

By default, the sdk package contains all apis provided by the system

Components developed by users and self-service access apis can be added to the sdk package by the following steps:

- Create a package file in the APP development framework directory blueking/component/apis. For example, if the system name is agent, create a system package file agent.py

- Add api information to the package file, e.g. add access interface of create_task to agent.py 

```python
# -*- coding: utf-8 -*-
from ..base import ComponentAPI


# Name of system api collections is generally Collections + System Name
class CollectionsAGENT(object):

    def __init__(self, client):
        self.client = client

        # create_task is the api name
        # method is the method used in request of api
        # path is the api path
        # api domain name is the system default domain name
        self.create_task = ComponentAPI(
            client=self.client, method='POST', path='/api/c/compapi/agent/create_task/',
            description=u'',
        )
```

- Add new package information to blueking/component/collections.py (if it has been added, ignore this step)

```python
# Import new package path
from .apis.agent import CollectionsAGENT 

AVAILABLE_COLLECTIONS = {
    'cc': CollectionsCC,
    'job': CollectionsJOB,
    'bk_login': CollectionsBkLogin,
    
    # Add new package info here
    'agent': CollectionsAGENT,
}
```


### Direct Access

Request parameters include: application information (`bk_app_code + bk_app_secret`), user information (`bk_token` or `bk_username`) and request parameters 

Direct access using curl, sample is as follows: 

```powershell
    curl -d '{"bk_app_code": "xxx", "bk_app_secret": "xxx", "bk_token": "xxx", "bk_biz_id": 1}' 'http://domain.com/path/'

    # data shall be encoded using urlencode
    curl 'http://domain.com/path/?bk_app_code=xxx&bk_app_secret=xxx&bk_token=xxx&bk_biz_id=1'   
```
