# API Gateway Introduction

The BlueKing API Gateway is an API hosting service of BlueKing system. 
It can help developers create, publish, maintain, and protect APIs to open system data or services quickly, inexpensively, and with low risk.
The API gateway supports component coding and online self-service, and provides a unified **User Authentication**, 
**BlueKing Application Authentication**, **Request Forwarding**, **Logging** and other functions.


### Component coding

In the API Gateway, developers write the component code and add the component channel configuration through the [Channel Management](/esb/manager/channel/list/){:target="_blank"} to provide the API service.

Component channel configuration, associated with the component class in the code via **component code**.
The component code is automatically generated by the API gateway based on the component code. The rules are as follows:

- Component code consists of three parts: `prefix` . `system name` . `component class name`

- prefix: the default is `generic`

- system name: specified by the sys_name property of the component class and converted to lowercase

- component class name: the class name of the component class. The non-initial uppercase letters of the class name are underlined and converted to lowercase, such as GetHostList to get_host_list

According to the above rules, the component code of the system CMDB component class GetHostList is: `generic.cmdb.get_host_list`

### Online self-service 

In the API gateway, developers configure the interface information online through [Self-service](/esb/manager/buffet_comp/list/){:target="_blank"} to provide the API service.

With self-service, developers do not need to write code. They can connect their own interfaces to the API gateway only through configuration.


## Definitions

### System

The system is mainly used for classification of APIs. In the API Gateway, each api can only belong to one system. 
System name is the unique identification of the system and mainly consists of letters and numbers.
`Note: CC, JOB, GSE, DATA, AUTH, BK_LOGIN and BK_PAAS are default systems which can not be used when a system is registered`
