# -*- coding: utf-8 -*-
"""
Tencent is pleased to support the open source community by making 蓝鲸智云PaaS平台社区版 (BlueKing PaaS
Community Edition) available.
Copyright (C) 2017-2018 THL A29 Limited, a Tencent company. All rights reserved.
Licensed under the MIT License (the "License"); you may not use this file except in compliance with the License.
You may obtain a copy of the License at http://opensource.org/licenses/MIT
Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
specific language governing permissions and limitations under the License.
"""

#
# Autogenerated by Thrift Compiler (0.10.0)
#
# DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
#
#  options string: py
#

from builtins import object
from thrift.Thrift import TType, TMessageType, TFrozenDict, TException, TApplicationException
from thrift.protocol.TProtocol import TProtocolException
import sys
import logging
from .ttypes import *
from thrift.Thrift import TProcessor
from thrift.transport import TTransport


class Iface(object):
    def login(self, user):
        """
        **** VERSION 1 API *****

        Parameters:
         - user
        """
        pass

    def logout(self, user, appId, envId):
        """
        Parameters:
         - user
         - appId
         - envId
        """
        pass

    def getUserApps(self, user):
        """
        Parameters:
         - user
        """
        pass

    def selectApp(self, user, appId, evnId, forceSelect):
        """
        Parameters:
         - user
         - appId
         - evnId
         - forceSelect
        """
        pass

    def cancelTask(self, user, appId, evnId):
        """
        Parameters:
         - user
         - appId
         - evnId
        """
        pass

    def createSession(self, user, appId, evnId):
        """
        Parameters:
         - user
         - appId
         - evnId
        """
        pass

    def start(self, cmd):
        """
        Parameters:
         - cmd
        """
        pass

    def stop(self, cmd):
        """
        Parameters:
         - cmd
        """
        pass

    def restart(self, cmd):
        """
        Parameters:
         - cmd
        """
        pass

    def kill(self, cmd):
        """
        Parameters:
         - cmd
        """
        pass

    def reload(self, cmd):
        """
        Parameters:
         - cmd
        """
        pass

    def autoproc(self, cmd):
        """
        Parameters:
         - cmd
        """
        pass

    def noauto(self, cmd):
        """
        Parameters:
         - cmd
        """
        pass

    def runshell(self, cmd):
        """
        Parameters:
         - cmd
        """
        pass

    def createcfg(self, cmd):
        """
        Parameters:
         - cmd
        """
        pass

    def pushcfg(self, cmd):
        """
        Parameters:
         - cmd
        """
        pass

    def check(self, cmd):
        """
        Parameters:
         - cmd
        """
        pass

    def listproc(self, cmd):
        """
        Parameters:
         - cmd
        """
        pass

    def checkagent(self, cmd):
        """
        Parameters:
         - cmd
        """
        pass

    def diffcfg(self, cmd):
        """
        Parameters:
         - cmd
        """
        pass

    def getremotecfg(self, cmd):
        """
        Parameters:
         - cmd
        """
        pass

    def checkconf(self, cmd):
        """
        Parameters:
         - cmd
        """
        pass

    def runcmd(self, cmd):
        """
        Parameters:
         - cmd
        """
        pass

    def getCommandResult(self, appId, envId):
        """
        Parameters:
         - appId
         - envId
        """
        pass

    def getCommandDetail(self, uniqueId):
        """
        Parameters:
         - uniqueId
        """
        pass

    def getCfgFileContent(self, appId, envId, procId):
        """
        Parameters:
         - appId
         - envId
         - procId
        """
        pass

    def getTaskResultById(self, taskId):
        """
        Parameters:
         - taskId
        """
        pass

    def history(self, appId, envId, lines):
        """
        Parameters:
         - appId
         - envId
         - lines
        """
        pass

    def create_session_v2(self, user, bk_biz_id, bk_set_type):
        """
        **** VERSION 2 API *****

        Parameters:
         - user
         - bk_biz_id
         - bk_set_type
        """
        pass

    def start_v2(self, cmd):
        """
        Parameters:
         - cmd
        """
        pass

    def stop_v2(self, cmd):
        """
        Parameters:
         - cmd
        """
        pass

    def restart_v2(self, cmd):
        """
        Parameters:
         - cmd
        """
        pass

    def kill_v2(self, cmd):
        """
        Parameters:
         - cmd
        """
        pass

    def reload_v2(self, cmd):
        """
        Parameters:
         - cmd
        """
        pass

    def auto_v2(self, cmd):
        """
        Parameters:
         - cmd
        """
        pass

    def noauto_v2(self, cmd):
        """
        Parameters:
         - cmd
        """
        pass

    def create_config_v2(self, cmd):
        """
        Parameters:
         - cmd
        """
        pass

    def push_config_v2(self, cmd):
        """
        Parameters:
         - cmd
        """
        pass

    def check_v2(self, cmd):
        """
        Parameters:
         - cmd
        """
        pass

    def get_result_by_id_v2(self, task_id):
        """
        Parameters:
         - task_id
        """
        pass


class Client(Iface):
    def __init__(self, iprot, oprot=None):
        self._iprot = self._oprot = iprot
        if oprot is not None:
            self._oprot = oprot
        self._seqid = 0

    def login(self, user):
        """
        **** VERSION 1 API *****

        Parameters:
         - user
        """
        self.send_login(user)
        return self.recv_login()

    def send_login(self, user):
        self._oprot.writeMessageBegin("login", TMessageType.CALL, self._seqid)
        args = login_args()
        args.user = user
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_login(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = login_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "login failed: unknown result")

    def logout(self, user, appId, envId):
        """
        Parameters:
         - user
         - appId
         - envId
        """
        self.send_logout(user, appId, envId)
        return self.recv_logout()

    def send_logout(self, user, appId, envId):
        self._oprot.writeMessageBegin("logout", TMessageType.CALL, self._seqid)
        args = logout_args()
        args.user = user
        args.appId = appId
        args.envId = envId
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_logout(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = logout_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "logout failed: unknown result")

    def getUserApps(self, user):
        """
        Parameters:
         - user
        """
        self.send_getUserApps(user)
        return self.recv_getUserApps()

    def send_getUserApps(self, user):
        self._oprot.writeMessageBegin("getUserApps", TMessageType.CALL, self._seqid)
        args = getUserApps_args()
        args.user = user
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_getUserApps(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = getUserApps_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "getUserApps failed: unknown result")

    def selectApp(self, user, appId, evnId, forceSelect):
        """
        Parameters:
         - user
         - appId
         - evnId
         - forceSelect
        """
        self.send_selectApp(user, appId, evnId, forceSelect)
        return self.recv_selectApp()

    def send_selectApp(self, user, appId, evnId, forceSelect):
        self._oprot.writeMessageBegin("selectApp", TMessageType.CALL, self._seqid)
        args = selectApp_args()
        args.user = user
        args.appId = appId
        args.evnId = evnId
        args.forceSelect = forceSelect
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_selectApp(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = selectApp_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "selectApp failed: unknown result")

    def cancelTask(self, user, appId, evnId):
        """
        Parameters:
         - user
         - appId
         - evnId
        """
        self.send_cancelTask(user, appId, evnId)
        return self.recv_cancelTask()

    def send_cancelTask(self, user, appId, evnId):
        self._oprot.writeMessageBegin("cancelTask", TMessageType.CALL, self._seqid)
        args = cancelTask_args()
        args.user = user
        args.appId = appId
        args.evnId = evnId
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_cancelTask(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = cancelTask_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "cancelTask failed: unknown result")

    def createSession(self, user, appId, evnId):
        """
        Parameters:
         - user
         - appId
         - evnId
        """
        self.send_createSession(user, appId, evnId)
        return self.recv_createSession()

    def send_createSession(self, user, appId, evnId):
        self._oprot.writeMessageBegin("createSession", TMessageType.CALL, self._seqid)
        args = createSession_args()
        args.user = user
        args.appId = appId
        args.evnId = evnId
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_createSession(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = createSession_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "createSession failed: unknown result")

    def start(self, cmd):
        """
        Parameters:
         - cmd
        """
        self.send_start(cmd)
        return self.recv_start()

    def send_start(self, cmd):
        self._oprot.writeMessageBegin("start", TMessageType.CALL, self._seqid)
        args = start_args()
        args.cmd = cmd
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_start(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = start_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "start failed: unknown result")

    def stop(self, cmd):
        """
        Parameters:
         - cmd
        """
        self.send_stop(cmd)
        return self.recv_stop()

    def send_stop(self, cmd):
        self._oprot.writeMessageBegin("stop", TMessageType.CALL, self._seqid)
        args = stop_args()
        args.cmd = cmd
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_stop(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = stop_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "stop failed: unknown result")

    def restart(self, cmd):
        """
        Parameters:
         - cmd
        """
        self.send_restart(cmd)
        return self.recv_restart()

    def send_restart(self, cmd):
        self._oprot.writeMessageBegin("restart", TMessageType.CALL, self._seqid)
        args = restart_args()
        args.cmd = cmd
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_restart(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = restart_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "restart failed: unknown result")

    def kill(self, cmd):
        """
        Parameters:
         - cmd
        """
        self.send_kill(cmd)
        return self.recv_kill()

    def send_kill(self, cmd):
        self._oprot.writeMessageBegin("kill", TMessageType.CALL, self._seqid)
        args = kill_args()
        args.cmd = cmd
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_kill(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = kill_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "kill failed: unknown result")

    def reload(self, cmd):
        """
        Parameters:
         - cmd
        """
        self.send_reload(cmd)
        return self.recv_reload()

    def send_reload(self, cmd):
        self._oprot.writeMessageBegin("reload", TMessageType.CALL, self._seqid)
        args = reload_args()
        args.cmd = cmd
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_reload(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = reload_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "reload failed: unknown result")

    def autoproc(self, cmd):
        """
        Parameters:
         - cmd
        """
        self.send_autoproc(cmd)
        return self.recv_autoproc()

    def send_autoproc(self, cmd):
        self._oprot.writeMessageBegin("autoproc", TMessageType.CALL, self._seqid)
        args = autoproc_args()
        args.cmd = cmd
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_autoproc(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = autoproc_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "autoproc failed: unknown result")

    def noauto(self, cmd):
        """
        Parameters:
         - cmd
        """
        self.send_noauto(cmd)
        return self.recv_noauto()

    def send_noauto(self, cmd):
        self._oprot.writeMessageBegin("noauto", TMessageType.CALL, self._seqid)
        args = noauto_args()
        args.cmd = cmd
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_noauto(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = noauto_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "noauto failed: unknown result")

    def runshell(self, cmd):
        """
        Parameters:
         - cmd
        """
        self.send_runshell(cmd)
        return self.recv_runshell()

    def send_runshell(self, cmd):
        self._oprot.writeMessageBegin("runshell", TMessageType.CALL, self._seqid)
        args = runshell_args()
        args.cmd = cmd
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_runshell(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = runshell_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "runshell failed: unknown result")

    def createcfg(self, cmd):
        """
        Parameters:
         - cmd
        """
        self.send_createcfg(cmd)
        return self.recv_createcfg()

    def send_createcfg(self, cmd):
        self._oprot.writeMessageBegin("createcfg", TMessageType.CALL, self._seqid)
        args = createcfg_args()
        args.cmd = cmd
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_createcfg(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = createcfg_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "createcfg failed: unknown result")

    def pushcfg(self, cmd):
        """
        Parameters:
         - cmd
        """
        self.send_pushcfg(cmd)
        return self.recv_pushcfg()

    def send_pushcfg(self, cmd):
        self._oprot.writeMessageBegin("pushcfg", TMessageType.CALL, self._seqid)
        args = pushcfg_args()
        args.cmd = cmd
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_pushcfg(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = pushcfg_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "pushcfg failed: unknown result")

    def check(self, cmd):
        """
        Parameters:
         - cmd
        """
        self.send_check(cmd)
        return self.recv_check()

    def send_check(self, cmd):
        self._oprot.writeMessageBegin("check", TMessageType.CALL, self._seqid)
        args = check_args()
        args.cmd = cmd
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_check(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = check_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "check failed: unknown result")

    def listproc(self, cmd):
        """
        Parameters:
         - cmd
        """
        self.send_listproc(cmd)
        return self.recv_listproc()

    def send_listproc(self, cmd):
        self._oprot.writeMessageBegin("listproc", TMessageType.CALL, self._seqid)
        args = listproc_args()
        args.cmd = cmd
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_listproc(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = listproc_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "listproc failed: unknown result")

    def checkagent(self, cmd):
        """
        Parameters:
         - cmd
        """
        self.send_checkagent(cmd)
        return self.recv_checkagent()

    def send_checkagent(self, cmd):
        self._oprot.writeMessageBegin("checkagent", TMessageType.CALL, self._seqid)
        args = checkagent_args()
        args.cmd = cmd
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_checkagent(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = checkagent_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "checkagent failed: unknown result")

    def diffcfg(self, cmd):
        """
        Parameters:
         - cmd
        """
        self.send_diffcfg(cmd)
        return self.recv_diffcfg()

    def send_diffcfg(self, cmd):
        self._oprot.writeMessageBegin("diffcfg", TMessageType.CALL, self._seqid)
        args = diffcfg_args()
        args.cmd = cmd
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_diffcfg(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = diffcfg_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "diffcfg failed: unknown result")

    def getremotecfg(self, cmd):
        """
        Parameters:
         - cmd
        """
        self.send_getremotecfg(cmd)
        return self.recv_getremotecfg()

    def send_getremotecfg(self, cmd):
        self._oprot.writeMessageBegin("getremotecfg", TMessageType.CALL, self._seqid)
        args = getremotecfg_args()
        args.cmd = cmd
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_getremotecfg(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = getremotecfg_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "getremotecfg failed: unknown result")

    def checkconf(self, cmd):
        """
        Parameters:
         - cmd
        """
        self.send_checkconf(cmd)
        return self.recv_checkconf()

    def send_checkconf(self, cmd):
        self._oprot.writeMessageBegin("checkconf", TMessageType.CALL, self._seqid)
        args = checkconf_args()
        args.cmd = cmd
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_checkconf(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = checkconf_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "checkconf failed: unknown result")

    def runcmd(self, cmd):
        """
        Parameters:
         - cmd
        """
        self.send_runcmd(cmd)
        return self.recv_runcmd()

    def send_runcmd(self, cmd):
        self._oprot.writeMessageBegin("runcmd", TMessageType.CALL, self._seqid)
        args = runcmd_args()
        args.cmd = cmd
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_runcmd(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = runcmd_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "runcmd failed: unknown result")

    def getCommandResult(self, appId, envId):
        """
        Parameters:
         - appId
         - envId
        """
        self.send_getCommandResult(appId, envId)
        return self.recv_getCommandResult()

    def send_getCommandResult(self, appId, envId):
        self._oprot.writeMessageBegin("getCommandResult", TMessageType.CALL, self._seqid)
        args = getCommandResult_args()
        args.appId = appId
        args.envId = envId
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_getCommandResult(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = getCommandResult_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "getCommandResult failed: unknown result")

    def getCommandDetail(self, uniqueId):
        """
        Parameters:
         - uniqueId
        """
        self.send_getCommandDetail(uniqueId)
        return self.recv_getCommandDetail()

    def send_getCommandDetail(self, uniqueId):
        self._oprot.writeMessageBegin("getCommandDetail", TMessageType.CALL, self._seqid)
        args = getCommandDetail_args()
        args.uniqueId = uniqueId
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_getCommandDetail(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = getCommandDetail_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "getCommandDetail failed: unknown result")

    def getCfgFileContent(self, appId, envId, procId):
        """
        Parameters:
         - appId
         - envId
         - procId
        """
        self.send_getCfgFileContent(appId, envId, procId)
        return self.recv_getCfgFileContent()

    def send_getCfgFileContent(self, appId, envId, procId):
        self._oprot.writeMessageBegin("getCfgFileContent", TMessageType.CALL, self._seqid)
        args = getCfgFileContent_args()
        args.appId = appId
        args.envId = envId
        args.procId = procId
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_getCfgFileContent(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = getCfgFileContent_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "getCfgFileContent failed: unknown result")

    def getTaskResultById(self, taskId):
        """
        Parameters:
         - taskId
        """
        self.send_getTaskResultById(taskId)
        return self.recv_getTaskResultById()

    def send_getTaskResultById(self, taskId):
        self._oprot.writeMessageBegin("getTaskResultById", TMessageType.CALL, self._seqid)
        args = getTaskResultById_args()
        args.taskId = taskId
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_getTaskResultById(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = getTaskResultById_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "getTaskResultById failed: unknown result")

    def history(self, appId, envId, lines):
        """
        Parameters:
         - appId
         - envId
         - lines
        """
        self.send_history(appId, envId, lines)
        return self.recv_history()

    def send_history(self, appId, envId, lines):
        self._oprot.writeMessageBegin("history", TMessageType.CALL, self._seqid)
        args = history_args()
        args.appId = appId
        args.envId = envId
        args.lines = lines
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_history(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = history_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "history failed: unknown result")

    def create_session_v2(self, user, bk_biz_id, bk_set_type):
        """
        **** VERSION 2 API *****

        Parameters:
         - user
         - bk_biz_id
         - bk_set_type
        """
        self.send_create_session_v2(user, bk_biz_id, bk_set_type)
        return self.recv_create_session_v2()

    def send_create_session_v2(self, user, bk_biz_id, bk_set_type):
        self._oprot.writeMessageBegin("create_session_v2", TMessageType.CALL, self._seqid)
        args = create_session_v2_args()
        args.user = user
        args.bk_biz_id = bk_biz_id
        args.bk_set_type = bk_set_type
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_create_session_v2(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = create_session_v2_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "create_session_v2 failed: unknown result")

    def start_v2(self, cmd):
        """
        Parameters:
         - cmd
        """
        self.send_start_v2(cmd)
        return self.recv_start_v2()

    def send_start_v2(self, cmd):
        self._oprot.writeMessageBegin("start_v2", TMessageType.CALL, self._seqid)
        args = start_v2_args()
        args.cmd = cmd
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_start_v2(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = start_v2_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "start_v2 failed: unknown result")

    def stop_v2(self, cmd):
        """
        Parameters:
         - cmd
        """
        self.send_stop_v2(cmd)
        return self.recv_stop_v2()

    def send_stop_v2(self, cmd):
        self._oprot.writeMessageBegin("stop_v2", TMessageType.CALL, self._seqid)
        args = stop_v2_args()
        args.cmd = cmd
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_stop_v2(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = stop_v2_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "stop_v2 failed: unknown result")

    def restart_v2(self, cmd):
        """
        Parameters:
         - cmd
        """
        self.send_restart_v2(cmd)
        return self.recv_restart_v2()

    def send_restart_v2(self, cmd):
        self._oprot.writeMessageBegin("restart_v2", TMessageType.CALL, self._seqid)
        args = restart_v2_args()
        args.cmd = cmd
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_restart_v2(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = restart_v2_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "restart_v2 failed: unknown result")

    def kill_v2(self, cmd):
        """
        Parameters:
         - cmd
        """
        self.send_kill_v2(cmd)
        return self.recv_kill_v2()

    def send_kill_v2(self, cmd):
        self._oprot.writeMessageBegin("kill_v2", TMessageType.CALL, self._seqid)
        args = kill_v2_args()
        args.cmd = cmd
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_kill_v2(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = kill_v2_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "kill_v2 failed: unknown result")

    def reload_v2(self, cmd):
        """
        Parameters:
         - cmd
        """
        self.send_reload_v2(cmd)
        return self.recv_reload_v2()

    def send_reload_v2(self, cmd):
        self._oprot.writeMessageBegin("reload_v2", TMessageType.CALL, self._seqid)
        args = reload_v2_args()
        args.cmd = cmd
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_reload_v2(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = reload_v2_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "reload_v2 failed: unknown result")

    def auto_v2(self, cmd):
        """
        Parameters:
         - cmd
        """
        self.send_auto_v2(cmd)
        return self.recv_auto_v2()

    def send_auto_v2(self, cmd):
        self._oprot.writeMessageBegin("auto_v2", TMessageType.CALL, self._seqid)
        args = auto_v2_args()
        args.cmd = cmd
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_auto_v2(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = auto_v2_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "auto_v2 failed: unknown result")

    def noauto_v2(self, cmd):
        """
        Parameters:
         - cmd
        """
        self.send_noauto_v2(cmd)
        return self.recv_noauto_v2()

    def send_noauto_v2(self, cmd):
        self._oprot.writeMessageBegin("noauto_v2", TMessageType.CALL, self._seqid)
        args = noauto_v2_args()
        args.cmd = cmd
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_noauto_v2(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = noauto_v2_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "noauto_v2 failed: unknown result")

    def create_config_v2(self, cmd):
        """
        Parameters:
         - cmd
        """
        self.send_create_config_v2(cmd)
        return self.recv_create_config_v2()

    def send_create_config_v2(self, cmd):
        self._oprot.writeMessageBegin("create_config_v2", TMessageType.CALL, self._seqid)
        args = create_config_v2_args()
        args.cmd = cmd
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_create_config_v2(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = create_config_v2_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "create_config_v2 failed: unknown result")

    def push_config_v2(self, cmd):
        """
        Parameters:
         - cmd
        """
        self.send_push_config_v2(cmd)
        return self.recv_push_config_v2()

    def send_push_config_v2(self, cmd):
        self._oprot.writeMessageBegin("push_config_v2", TMessageType.CALL, self._seqid)
        args = push_config_v2_args()
        args.cmd = cmd
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_push_config_v2(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = push_config_v2_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "push_config_v2 failed: unknown result")

    def check_v2(self, cmd):
        """
        Parameters:
         - cmd
        """
        self.send_check_v2(cmd)
        return self.recv_check_v2()

    def send_check_v2(self, cmd):
        self._oprot.writeMessageBegin("check_v2", TMessageType.CALL, self._seqid)
        args = check_v2_args()
        args.cmd = cmd
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_check_v2(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = check_v2_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "check_v2 failed: unknown result")

    def get_result_by_id_v2(self, task_id):
        """
        Parameters:
         - task_id
        """
        self.send_get_result_by_id_v2(task_id)
        return self.recv_get_result_by_id_v2()

    def send_get_result_by_id_v2(self, task_id):
        self._oprot.writeMessageBegin("get_result_by_id_v2", TMessageType.CALL, self._seqid)
        args = get_result_by_id_v2_args()
        args.task_id = task_id
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_get_result_by_id_v2(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = get_result_by_id_v2_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "get_result_by_id_v2 failed: unknown result")


class Processor(Iface, TProcessor):
    def __init__(self, handler):
        self._handler = handler
        self._processMap = {}
        self._processMap["login"] = Processor.process_login
        self._processMap["logout"] = Processor.process_logout
        self._processMap["getUserApps"] = Processor.process_getUserApps
        self._processMap["selectApp"] = Processor.process_selectApp
        self._processMap["cancelTask"] = Processor.process_cancelTask
        self._processMap["createSession"] = Processor.process_createSession
        self._processMap["start"] = Processor.process_start
        self._processMap["stop"] = Processor.process_stop
        self._processMap["restart"] = Processor.process_restart
        self._processMap["kill"] = Processor.process_kill
        self._processMap["reload"] = Processor.process_reload
        self._processMap["autoproc"] = Processor.process_autoproc
        self._processMap["noauto"] = Processor.process_noauto
        self._processMap["runshell"] = Processor.process_runshell
        self._processMap["createcfg"] = Processor.process_createcfg
        self._processMap["pushcfg"] = Processor.process_pushcfg
        self._processMap["check"] = Processor.process_check
        self._processMap["listproc"] = Processor.process_listproc
        self._processMap["checkagent"] = Processor.process_checkagent
        self._processMap["diffcfg"] = Processor.process_diffcfg
        self._processMap["getremotecfg"] = Processor.process_getremotecfg
        self._processMap["checkconf"] = Processor.process_checkconf
        self._processMap["runcmd"] = Processor.process_runcmd
        self._processMap["getCommandResult"] = Processor.process_getCommandResult
        self._processMap["getCommandDetail"] = Processor.process_getCommandDetail
        self._processMap["getCfgFileContent"] = Processor.process_getCfgFileContent
        self._processMap["getTaskResultById"] = Processor.process_getTaskResultById
        self._processMap["history"] = Processor.process_history
        self._processMap["create_session_v2"] = Processor.process_create_session_v2
        self._processMap["start_v2"] = Processor.process_start_v2
        self._processMap["stop_v2"] = Processor.process_stop_v2
        self._processMap["restart_v2"] = Processor.process_restart_v2
        self._processMap["kill_v2"] = Processor.process_kill_v2
        self._processMap["reload_v2"] = Processor.process_reload_v2
        self._processMap["auto_v2"] = Processor.process_auto_v2
        self._processMap["noauto_v2"] = Processor.process_noauto_v2
        self._processMap["create_config_v2"] = Processor.process_create_config_v2
        self._processMap["push_config_v2"] = Processor.process_push_config_v2
        self._processMap["check_v2"] = Processor.process_check_v2
        self._processMap["get_result_by_id_v2"] = Processor.process_get_result_by_id_v2

    def process(self, iprot, oprot):
        (name, type, seqid) = iprot.readMessageBegin()
        if name not in self._processMap:
            iprot.skip(TType.STRUCT)
            iprot.readMessageEnd()
            x = TApplicationException(TApplicationException.UNKNOWN_METHOD, "Unknown function %s" % (name))
            oprot.writeMessageBegin(name, TMessageType.EXCEPTION, seqid)
            x.write(oprot)
            oprot.writeMessageEnd()
            oprot.trans.flush()
            return
        else:
            self._processMap[name](self, seqid, iprot, oprot)
        return True

    def process_login(self, seqid, iprot, oprot):
        args = login_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = login_result()
        try:
            result.success = self._handler.login(args.user)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("login", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_logout(self, seqid, iprot, oprot):
        args = logout_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = logout_result()
        try:
            result.success = self._handler.logout(args.user, args.appId, args.envId)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("logout", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_getUserApps(self, seqid, iprot, oprot):
        args = getUserApps_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = getUserApps_result()
        try:
            result.success = self._handler.getUserApps(args.user)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("getUserApps", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_selectApp(self, seqid, iprot, oprot):
        args = selectApp_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = selectApp_result()
        try:
            result.success = self._handler.selectApp(args.user, args.appId, args.evnId, args.forceSelect)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("selectApp", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_cancelTask(self, seqid, iprot, oprot):
        args = cancelTask_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = cancelTask_result()
        try:
            result.success = self._handler.cancelTask(args.user, args.appId, args.evnId)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("cancelTask", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_createSession(self, seqid, iprot, oprot):
        args = createSession_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = createSession_result()
        try:
            result.success = self._handler.createSession(args.user, args.appId, args.evnId)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("createSession", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_start(self, seqid, iprot, oprot):
        args = start_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = start_result()
        try:
            result.success = self._handler.start(args.cmd)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("start", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_stop(self, seqid, iprot, oprot):
        args = stop_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = stop_result()
        try:
            result.success = self._handler.stop(args.cmd)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("stop", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_restart(self, seqid, iprot, oprot):
        args = restart_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = restart_result()
        try:
            result.success = self._handler.restart(args.cmd)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("restart", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_kill(self, seqid, iprot, oprot):
        args = kill_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = kill_result()
        try:
            result.success = self._handler.kill(args.cmd)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("kill", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_reload(self, seqid, iprot, oprot):
        args = reload_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = reload_result()
        try:
            result.success = self._handler.reload(args.cmd)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("reload", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_autoproc(self, seqid, iprot, oprot):
        args = autoproc_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = autoproc_result()
        try:
            result.success = self._handler.autoproc(args.cmd)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("autoproc", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_noauto(self, seqid, iprot, oprot):
        args = noauto_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = noauto_result()
        try:
            result.success = self._handler.noauto(args.cmd)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("noauto", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_runshell(self, seqid, iprot, oprot):
        args = runshell_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = runshell_result()
        try:
            result.success = self._handler.runshell(args.cmd)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("runshell", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_createcfg(self, seqid, iprot, oprot):
        args = createcfg_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = createcfg_result()
        try:
            result.success = self._handler.createcfg(args.cmd)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("createcfg", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_pushcfg(self, seqid, iprot, oprot):
        args = pushcfg_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = pushcfg_result()
        try:
            result.success = self._handler.pushcfg(args.cmd)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("pushcfg", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_check(self, seqid, iprot, oprot):
        args = check_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = check_result()
        try:
            result.success = self._handler.check(args.cmd)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("check", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_listproc(self, seqid, iprot, oprot):
        args = listproc_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = listproc_result()
        try:
            result.success = self._handler.listproc(args.cmd)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("listproc", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_checkagent(self, seqid, iprot, oprot):
        args = checkagent_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = checkagent_result()
        try:
            result.success = self._handler.checkagent(args.cmd)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("checkagent", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_diffcfg(self, seqid, iprot, oprot):
        args = diffcfg_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = diffcfg_result()
        try:
            result.success = self._handler.diffcfg(args.cmd)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("diffcfg", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_getremotecfg(self, seqid, iprot, oprot):
        args = getremotecfg_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = getremotecfg_result()
        try:
            result.success = self._handler.getremotecfg(args.cmd)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("getremotecfg", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_checkconf(self, seqid, iprot, oprot):
        args = checkconf_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = checkconf_result()
        try:
            result.success = self._handler.checkconf(args.cmd)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("checkconf", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_runcmd(self, seqid, iprot, oprot):
        args = runcmd_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = runcmd_result()
        try:
            result.success = self._handler.runcmd(args.cmd)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("runcmd", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_getCommandResult(self, seqid, iprot, oprot):
        args = getCommandResult_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = getCommandResult_result()
        try:
            result.success = self._handler.getCommandResult(args.appId, args.envId)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("getCommandResult", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_getCommandDetail(self, seqid, iprot, oprot):
        args = getCommandDetail_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = getCommandDetail_result()
        try:
            result.success = self._handler.getCommandDetail(args.uniqueId)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("getCommandDetail", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_getCfgFileContent(self, seqid, iprot, oprot):
        args = getCfgFileContent_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = getCfgFileContent_result()
        try:
            result.success = self._handler.getCfgFileContent(args.appId, args.envId, args.procId)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("getCfgFileContent", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_getTaskResultById(self, seqid, iprot, oprot):
        args = getTaskResultById_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = getTaskResultById_result()
        try:
            result.success = self._handler.getTaskResultById(args.taskId)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("getTaskResultById", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_history(self, seqid, iprot, oprot):
        args = history_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = history_result()
        try:
            result.success = self._handler.history(args.appId, args.envId, args.lines)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("history", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_create_session_v2(self, seqid, iprot, oprot):
        args = create_session_v2_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = create_session_v2_result()
        try:
            result.success = self._handler.create_session_v2(args.user, args.bk_biz_id, args.bk_set_type)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("create_session_v2", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_start_v2(self, seqid, iprot, oprot):
        args = start_v2_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = start_v2_result()
        try:
            result.success = self._handler.start_v2(args.cmd)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("start_v2", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_stop_v2(self, seqid, iprot, oprot):
        args = stop_v2_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = stop_v2_result()
        try:
            result.success = self._handler.stop_v2(args.cmd)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("stop_v2", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_restart_v2(self, seqid, iprot, oprot):
        args = restart_v2_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = restart_v2_result()
        try:
            result.success = self._handler.restart_v2(args.cmd)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("restart_v2", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_kill_v2(self, seqid, iprot, oprot):
        args = kill_v2_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = kill_v2_result()
        try:
            result.success = self._handler.kill_v2(args.cmd)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("kill_v2", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_reload_v2(self, seqid, iprot, oprot):
        args = reload_v2_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = reload_v2_result()
        try:
            result.success = self._handler.reload_v2(args.cmd)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("reload_v2", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_auto_v2(self, seqid, iprot, oprot):
        args = auto_v2_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = auto_v2_result()
        try:
            result.success = self._handler.auto_v2(args.cmd)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("auto_v2", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_noauto_v2(self, seqid, iprot, oprot):
        args = noauto_v2_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = noauto_v2_result()
        try:
            result.success = self._handler.noauto_v2(args.cmd)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("noauto_v2", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_create_config_v2(self, seqid, iprot, oprot):
        args = create_config_v2_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = create_config_v2_result()
        try:
            result.success = self._handler.create_config_v2(args.cmd)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("create_config_v2", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_push_config_v2(self, seqid, iprot, oprot):
        args = push_config_v2_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = push_config_v2_result()
        try:
            result.success = self._handler.push_config_v2(args.cmd)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("push_config_v2", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_check_v2(self, seqid, iprot, oprot):
        args = check_v2_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = check_v2_result()
        try:
            result.success = self._handler.check_v2(args.cmd)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("check_v2", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_get_result_by_id_v2(self, seqid, iprot, oprot):
        args = get_result_by_id_v2_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = get_result_by_id_v2_result()
        try:
            result.success = self._handler.get_result_by_id_v2(args.task_id)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, "Internal error")
        oprot.writeMessageBegin("get_result_by_id_v2", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()


# HELPER FUNCTIONS AND STRUCTURES


class login_args(object):
    """
    Attributes:
     - user
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRUCT,
            "user",
            (CCUser, CCUser.thrift_spec),
            None,
        ),  # 1
    )

    def __init__(
        self,
        user=None,
    ):
        self.user = user

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.user = CCUser()
                    self.user.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("login_args")
        if self.user is not None:
            oprot.writeFieldBegin("user", TType.STRUCT, 1)
            self.user.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class login_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (AppList, AppList.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = AppList()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("login_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class logout_args(object):
    """
    Attributes:
     - user
     - appId
     - envId
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRUCT,
            "user",
            (CCUser, CCUser.thrift_spec),
            None,
        ),  # 1
        (
            2,
            TType.STRING,
            "appId",
            "UTF8",
            None,
        ),  # 2
        (
            3,
            TType.STRING,
            "envId",
            "UTF8",
            None,
        ),  # 3
    )

    def __init__(
        self,
        user=None,
        appId=None,
        envId=None,
    ):
        self.user = user
        self.appId = appId
        self.envId = envId

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.user = CCUser()
                    self.user.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.appId = iprot.readString().decode("utf-8") if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.STRING:
                    self.envId = iprot.readString().decode("utf-8") if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("logout_args")
        if self.user is not None:
            oprot.writeFieldBegin("user", TType.STRUCT, 1)
            self.user.write(oprot)
            oprot.writeFieldEnd()
        if self.appId is not None:
            oprot.writeFieldBegin("appId", TType.STRING, 2)
            oprot.writeString(self.appId.encode("utf-8") if sys.version_info[0] == 2 else self.appId)
            oprot.writeFieldEnd()
        if self.envId is not None:
            oprot.writeFieldBegin("envId", TType.STRING, 3)
            oprot.writeString(self.envId.encode("utf-8") if sys.version_info[0] == 2 else self.envId)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class logout_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (Proc_SyncRsp, Proc_SyncRsp.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = Proc_SyncRsp()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("logout_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class getUserApps_args(object):
    """
    Attributes:
     - user
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRUCT,
            "user",
            (CCUser, CCUser.thrift_spec),
            None,
        ),  # 1
    )

    def __init__(
        self,
        user=None,
    ):
        self.user = user

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.user = CCUser()
                    self.user.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("getUserApps_args")
        if self.user is not None:
            oprot.writeFieldBegin("user", TType.STRUCT, 1)
            self.user.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class getUserApps_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (AppList, AppList.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = AppList()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("getUserApps_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class selectApp_args(object):
    """
    Attributes:
     - user
     - appId
     - evnId
     - forceSelect
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRUCT,
            "user",
            (CCUser, CCUser.thrift_spec),
            None,
        ),  # 1
        (
            2,
            TType.STRING,
            "appId",
            "UTF8",
            None,
        ),  # 2
        (
            3,
            TType.STRING,
            "evnId",
            "UTF8",
            None,
        ),  # 3
        (
            4,
            TType.BOOL,
            "forceSelect",
            None,
            None,
        ),  # 4
    )

    def __init__(
        self,
        user=None,
        appId=None,
        evnId=None,
        forceSelect=None,
    ):
        self.user = user
        self.appId = appId
        self.evnId = evnId
        self.forceSelect = forceSelect

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.user = CCUser()
                    self.user.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.appId = iprot.readString().decode("utf-8") if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.STRING:
                    self.evnId = iprot.readString().decode("utf-8") if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.BOOL:
                    self.forceSelect = iprot.readBool()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("selectApp_args")
        if self.user is not None:
            oprot.writeFieldBegin("user", TType.STRUCT, 1)
            self.user.write(oprot)
            oprot.writeFieldEnd()
        if self.appId is not None:
            oprot.writeFieldBegin("appId", TType.STRING, 2)
            oprot.writeString(self.appId.encode("utf-8") if sys.version_info[0] == 2 else self.appId)
            oprot.writeFieldEnd()
        if self.evnId is not None:
            oprot.writeFieldBegin("evnId", TType.STRING, 3)
            oprot.writeString(self.evnId.encode("utf-8") if sys.version_info[0] == 2 else self.evnId)
            oprot.writeFieldEnd()
        if self.forceSelect is not None:
            oprot.writeFieldBegin("forceSelect", TType.BOOL, 4)
            oprot.writeBool(self.forceSelect)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class selectApp_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (Proc_SyncRsp, Proc_SyncRsp.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = Proc_SyncRsp()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("selectApp_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class cancelTask_args(object):
    """
    Attributes:
     - user
     - appId
     - evnId
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRUCT,
            "user",
            (CCUser, CCUser.thrift_spec),
            None,
        ),  # 1
        (
            2,
            TType.STRING,
            "appId",
            "UTF8",
            None,
        ),  # 2
        (
            3,
            TType.STRING,
            "evnId",
            "UTF8",
            None,
        ),  # 3
    )

    def __init__(
        self,
        user=None,
        appId=None,
        evnId=None,
    ):
        self.user = user
        self.appId = appId
        self.evnId = evnId

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.user = CCUser()
                    self.user.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.appId = iprot.readString().decode("utf-8") if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.STRING:
                    self.evnId = iprot.readString().decode("utf-8") if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("cancelTask_args")
        if self.user is not None:
            oprot.writeFieldBegin("user", TType.STRUCT, 1)
            self.user.write(oprot)
            oprot.writeFieldEnd()
        if self.appId is not None:
            oprot.writeFieldBegin("appId", TType.STRING, 2)
            oprot.writeString(self.appId.encode("utf-8") if sys.version_info[0] == 2 else self.appId)
            oprot.writeFieldEnd()
        if self.evnId is not None:
            oprot.writeFieldBegin("evnId", TType.STRING, 3)
            oprot.writeString(self.evnId.encode("utf-8") if sys.version_info[0] == 2 else self.evnId)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class cancelTask_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (Proc_SyncRsp, Proc_SyncRsp.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = Proc_SyncRsp()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("cancelTask_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class createSession_args(object):
    """
    Attributes:
     - user
     - appId
     - evnId
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRUCT,
            "user",
            (CCUser, CCUser.thrift_spec),
            None,
        ),  # 1
        (
            2,
            TType.STRING,
            "appId",
            "UTF8",
            None,
        ),  # 2
        (
            3,
            TType.STRING,
            "evnId",
            "UTF8",
            None,
        ),  # 3
    )

    def __init__(
        self,
        user=None,
        appId=None,
        evnId=None,
    ):
        self.user = user
        self.appId = appId
        self.evnId = evnId

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.user = CCUser()
                    self.user.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.appId = iprot.readString().decode("utf-8") if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.STRING:
                    self.evnId = iprot.readString().decode("utf-8") if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("createSession_args")
        if self.user is not None:
            oprot.writeFieldBegin("user", TType.STRUCT, 1)
            self.user.write(oprot)
            oprot.writeFieldEnd()
        if self.appId is not None:
            oprot.writeFieldBegin("appId", TType.STRING, 2)
            oprot.writeString(self.appId.encode("utf-8") if sys.version_info[0] == 2 else self.appId)
            oprot.writeFieldEnd()
        if self.evnId is not None:
            oprot.writeFieldBegin("evnId", TType.STRING, 3)
            oprot.writeString(self.evnId.encode("utf-8") if sys.version_info[0] == 2 else self.evnId)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class createSession_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (Proc_SyncRsp, Proc_SyncRsp.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = Proc_SyncRsp()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("createSession_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class start_args(object):
    """
    Attributes:
     - cmd
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRUCT,
            "cmd",
            (Proc_Command, Proc_Command.thrift_spec),
            None,
        ),  # 1
    )

    def __init__(
        self,
        cmd=None,
    ):
        self.cmd = cmd

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.cmd = Proc_Command()
                    self.cmd.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("start_args")
        if self.cmd is not None:
            oprot.writeFieldBegin("cmd", TType.STRUCT, 1)
            self.cmd.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class start_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (Proc_AsyncRsp, Proc_AsyncRsp.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = Proc_AsyncRsp()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("start_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class stop_args(object):
    """
    Attributes:
     - cmd
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRUCT,
            "cmd",
            (Proc_Command, Proc_Command.thrift_spec),
            None,
        ),  # 1
    )

    def __init__(
        self,
        cmd=None,
    ):
        self.cmd = cmd

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.cmd = Proc_Command()
                    self.cmd.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("stop_args")
        if self.cmd is not None:
            oprot.writeFieldBegin("cmd", TType.STRUCT, 1)
            self.cmd.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class stop_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (Proc_AsyncRsp, Proc_AsyncRsp.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = Proc_AsyncRsp()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("stop_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class restart_args(object):
    """
    Attributes:
     - cmd
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRUCT,
            "cmd",
            (Proc_Command, Proc_Command.thrift_spec),
            None,
        ),  # 1
    )

    def __init__(
        self,
        cmd=None,
    ):
        self.cmd = cmd

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.cmd = Proc_Command()
                    self.cmd.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("restart_args")
        if self.cmd is not None:
            oprot.writeFieldBegin("cmd", TType.STRUCT, 1)
            self.cmd.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class restart_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (Proc_AsyncRsp, Proc_AsyncRsp.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = Proc_AsyncRsp()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("restart_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class kill_args(object):
    """
    Attributes:
     - cmd
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRUCT,
            "cmd",
            (Proc_Command, Proc_Command.thrift_spec),
            None,
        ),  # 1
    )

    def __init__(
        self,
        cmd=None,
    ):
        self.cmd = cmd

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.cmd = Proc_Command()
                    self.cmd.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("kill_args")
        if self.cmd is not None:
            oprot.writeFieldBegin("cmd", TType.STRUCT, 1)
            self.cmd.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class kill_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (Proc_AsyncRsp, Proc_AsyncRsp.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = Proc_AsyncRsp()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("kill_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class reload_args(object):
    """
    Attributes:
     - cmd
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRUCT,
            "cmd",
            (Proc_Command, Proc_Command.thrift_spec),
            None,
        ),  # 1
    )

    def __init__(
        self,
        cmd=None,
    ):
        self.cmd = cmd

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.cmd = Proc_Command()
                    self.cmd.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("reload_args")
        if self.cmd is not None:
            oprot.writeFieldBegin("cmd", TType.STRUCT, 1)
            self.cmd.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class reload_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (Proc_AsyncRsp, Proc_AsyncRsp.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = Proc_AsyncRsp()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("reload_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class autoproc_args(object):
    """
    Attributes:
     - cmd
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRUCT,
            "cmd",
            (Proc_Command, Proc_Command.thrift_spec),
            None,
        ),  # 1
    )

    def __init__(
        self,
        cmd=None,
    ):
        self.cmd = cmd

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.cmd = Proc_Command()
                    self.cmd.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("autoproc_args")
        if self.cmd is not None:
            oprot.writeFieldBegin("cmd", TType.STRUCT, 1)
            self.cmd.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class autoproc_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (Proc_AsyncRsp, Proc_AsyncRsp.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = Proc_AsyncRsp()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("autoproc_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class noauto_args(object):
    """
    Attributes:
     - cmd
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRUCT,
            "cmd",
            (Proc_Command, Proc_Command.thrift_spec),
            None,
        ),  # 1
    )

    def __init__(
        self,
        cmd=None,
    ):
        self.cmd = cmd

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.cmd = Proc_Command()
                    self.cmd.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("noauto_args")
        if self.cmd is not None:
            oprot.writeFieldBegin("cmd", TType.STRUCT, 1)
            self.cmd.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class noauto_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (Proc_AsyncRsp, Proc_AsyncRsp.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = Proc_AsyncRsp()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("noauto_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class runshell_args(object):
    """
    Attributes:
     - cmd
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRUCT,
            "cmd",
            (Proc_Command, Proc_Command.thrift_spec),
            None,
        ),  # 1
    )

    def __init__(
        self,
        cmd=None,
    ):
        self.cmd = cmd

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.cmd = Proc_Command()
                    self.cmd.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("runshell_args")
        if self.cmd is not None:
            oprot.writeFieldBegin("cmd", TType.STRUCT, 1)
            self.cmd.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class runshell_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (Proc_AsyncRsp, Proc_AsyncRsp.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = Proc_AsyncRsp()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("runshell_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class createcfg_args(object):
    """
    Attributes:
     - cmd
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRUCT,
            "cmd",
            (Proc_Command, Proc_Command.thrift_spec),
            None,
        ),  # 1
    )

    def __init__(
        self,
        cmd=None,
    ):
        self.cmd = cmd

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.cmd = Proc_Command()
                    self.cmd.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("createcfg_args")
        if self.cmd is not None:
            oprot.writeFieldBegin("cmd", TType.STRUCT, 1)
            self.cmd.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class createcfg_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (Proc_AsyncRsp, Proc_AsyncRsp.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = Proc_AsyncRsp()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("createcfg_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class pushcfg_args(object):
    """
    Attributes:
     - cmd
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRUCT,
            "cmd",
            (Proc_Command, Proc_Command.thrift_spec),
            None,
        ),  # 1
    )

    def __init__(
        self,
        cmd=None,
    ):
        self.cmd = cmd

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.cmd = Proc_Command()
                    self.cmd.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("pushcfg_args")
        if self.cmd is not None:
            oprot.writeFieldBegin("cmd", TType.STRUCT, 1)
            self.cmd.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class pushcfg_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (Proc_AsyncRsp, Proc_AsyncRsp.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = Proc_AsyncRsp()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("pushcfg_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class check_args(object):
    """
    Attributes:
     - cmd
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRUCT,
            "cmd",
            (Proc_Command, Proc_Command.thrift_spec),
            None,
        ),  # 1
    )

    def __init__(
        self,
        cmd=None,
    ):
        self.cmd = cmd

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.cmd = Proc_Command()
                    self.cmd.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("check_args")
        if self.cmd is not None:
            oprot.writeFieldBegin("cmd", TType.STRUCT, 1)
            self.cmd.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class check_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (Proc_AsyncRsp, Proc_AsyncRsp.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = Proc_AsyncRsp()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("check_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class listproc_args(object):
    """
    Attributes:
     - cmd
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRUCT,
            "cmd",
            (Proc_Command, Proc_Command.thrift_spec),
            None,
        ),  # 1
    )

    def __init__(
        self,
        cmd=None,
    ):
        self.cmd = cmd

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.cmd = Proc_Command()
                    self.cmd.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("listproc_args")
        if self.cmd is not None:
            oprot.writeFieldBegin("cmd", TType.STRUCT, 1)
            self.cmd.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class listproc_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (Proc_AsyncRsp, Proc_AsyncRsp.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = Proc_AsyncRsp()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("listproc_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class checkagent_args(object):
    """
    Attributes:
     - cmd
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRUCT,
            "cmd",
            (Proc_Command, Proc_Command.thrift_spec),
            None,
        ),  # 1
    )

    def __init__(
        self,
        cmd=None,
    ):
        self.cmd = cmd

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.cmd = Proc_Command()
                    self.cmd.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("checkagent_args")
        if self.cmd is not None:
            oprot.writeFieldBegin("cmd", TType.STRUCT, 1)
            self.cmd.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class checkagent_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (Proc_AsyncRsp, Proc_AsyncRsp.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = Proc_AsyncRsp()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("checkagent_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class diffcfg_args(object):
    """
    Attributes:
     - cmd
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRUCT,
            "cmd",
            (Proc_Command, Proc_Command.thrift_spec),
            None,
        ),  # 1
    )

    def __init__(
        self,
        cmd=None,
    ):
        self.cmd = cmd

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.cmd = Proc_Command()
                    self.cmd.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("diffcfg_args")
        if self.cmd is not None:
            oprot.writeFieldBegin("cmd", TType.STRUCT, 1)
            self.cmd.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class diffcfg_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (Proc_AsyncRsp, Proc_AsyncRsp.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = Proc_AsyncRsp()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("diffcfg_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class getremotecfg_args(object):
    """
    Attributes:
     - cmd
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRUCT,
            "cmd",
            (Proc_Command, Proc_Command.thrift_spec),
            None,
        ),  # 1
    )

    def __init__(
        self,
        cmd=None,
    ):
        self.cmd = cmd

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.cmd = Proc_Command()
                    self.cmd.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("getremotecfg_args")
        if self.cmd is not None:
            oprot.writeFieldBegin("cmd", TType.STRUCT, 1)
            self.cmd.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class getremotecfg_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (Proc_AsyncRsp, Proc_AsyncRsp.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = Proc_AsyncRsp()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("getremotecfg_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class checkconf_args(object):
    """
    Attributes:
     - cmd
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRUCT,
            "cmd",
            (Proc_Command, Proc_Command.thrift_spec),
            None,
        ),  # 1
    )

    def __init__(
        self,
        cmd=None,
    ):
        self.cmd = cmd

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.cmd = Proc_Command()
                    self.cmd.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("checkconf_args")
        if self.cmd is not None:
            oprot.writeFieldBegin("cmd", TType.STRUCT, 1)
            self.cmd.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class checkconf_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (Proc_SyncRsp, Proc_SyncRsp.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = Proc_SyncRsp()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("checkconf_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class runcmd_args(object):
    """
    Attributes:
     - cmd
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRUCT,
            "cmd",
            (Proc_Command, Proc_Command.thrift_spec),
            None,
        ),  # 1
    )

    def __init__(
        self,
        cmd=None,
    ):
        self.cmd = cmd

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.cmd = Proc_Command()
                    self.cmd.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("runcmd_args")
        if self.cmd is not None:
            oprot.writeFieldBegin("cmd", TType.STRUCT, 1)
            self.cmd.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class runcmd_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (Proc_AsyncRsp, Proc_AsyncRsp.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = Proc_AsyncRsp()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("runcmd_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class getCommandResult_args(object):
    """
    Attributes:
     - appId
     - envId
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRING,
            "appId",
            "UTF8",
            None,
        ),  # 1
        (
            2,
            TType.STRING,
            "envId",
            "UTF8",
            None,
        ),  # 2
    )

    def __init__(
        self,
        appId=None,
        envId=None,
    ):
        self.appId = appId
        self.envId = envId

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.appId = iprot.readString().decode("utf-8") if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.envId = iprot.readString().decode("utf-8") if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("getCommandResult_args")
        if self.appId is not None:
            oprot.writeFieldBegin("appId", TType.STRING, 1)
            oprot.writeString(self.appId.encode("utf-8") if sys.version_info[0] == 2 else self.appId)
            oprot.writeFieldEnd()
        if self.envId is not None:
            oprot.writeFieldBegin("envId", TType.STRING, 2)
            oprot.writeString(self.envId.encode("utf-8") if sys.version_info[0] == 2 else self.envId)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class getCommandResult_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (TaskResponse, TaskResponse.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = TaskResponse()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("getCommandResult_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class getCommandDetail_args(object):
    """
    Attributes:
     - uniqueId
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRING,
            "uniqueId",
            "UTF8",
            None,
        ),  # 1
    )

    def __init__(
        self,
        uniqueId=None,
    ):
        self.uniqueId = uniqueId

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.uniqueId = (
                        iprot.readString().decode("utf-8") if sys.version_info[0] == 2 else iprot.readString()
                    )
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("getCommandDetail_args")
        if self.uniqueId is not None:
            oprot.writeFieldBegin("uniqueId", TType.STRING, 1)
            oprot.writeString(self.uniqueId.encode("utf-8") if sys.version_info[0] == 2 else self.uniqueId)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class getCommandDetail_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (Proc_SyncRsp, Proc_SyncRsp.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = Proc_SyncRsp()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("getCommandDetail_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class getCfgFileContent_args(object):
    """
    Attributes:
     - appId
     - envId
     - procId
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRING,
            "appId",
            "UTF8",
            None,
        ),  # 1
        (
            2,
            TType.STRING,
            "envId",
            "UTF8",
            None,
        ),  # 2
        (
            3,
            TType.STRING,
            "procId",
            "UTF8",
            None,
        ),  # 3
    )

    def __init__(
        self,
        appId=None,
        envId=None,
        procId=None,
    ):
        self.appId = appId
        self.envId = envId
        self.procId = procId

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.appId = iprot.readString().decode("utf-8") if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.envId = iprot.readString().decode("utf-8") if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.STRING:
                    self.procId = (
                        iprot.readString().decode("utf-8") if sys.version_info[0] == 2 else iprot.readString()
                    )
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("getCfgFileContent_args")
        if self.appId is not None:
            oprot.writeFieldBegin("appId", TType.STRING, 1)
            oprot.writeString(self.appId.encode("utf-8") if sys.version_info[0] == 2 else self.appId)
            oprot.writeFieldEnd()
        if self.envId is not None:
            oprot.writeFieldBegin("envId", TType.STRING, 2)
            oprot.writeString(self.envId.encode("utf-8") if sys.version_info[0] == 2 else self.envId)
            oprot.writeFieldEnd()
        if self.procId is not None:
            oprot.writeFieldBegin("procId", TType.STRING, 3)
            oprot.writeString(self.procId.encode("utf-8") if sys.version_info[0] == 2 else self.procId)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class getCfgFileContent_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (Proc_SyncRsp, Proc_SyncRsp.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = Proc_SyncRsp()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("getCfgFileContent_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class getTaskResultById_args(object):
    """
    Attributes:
     - taskId
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRING,
            "taskId",
            "UTF8",
            None,
        ),  # 1
    )

    def __init__(
        self,
        taskId=None,
    ):
        self.taskId = taskId

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.taskId = (
                        iprot.readString().decode("utf-8") if sys.version_info[0] == 2 else iprot.readString()
                    )
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("getTaskResultById_args")
        if self.taskId is not None:
            oprot.writeFieldBegin("taskId", TType.STRING, 1)
            oprot.writeString(self.taskId.encode("utf-8") if sys.version_info[0] == 2 else self.taskId)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class getTaskResultById_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (TaskResponse, TaskResponse.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = TaskResponse()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("getTaskResultById_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class history_args(object):
    """
    Attributes:
     - appId
     - envId
     - lines
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRING,
            "appId",
            "UTF8",
            None,
        ),  # 1
        (
            2,
            TType.STRING,
            "envId",
            "UTF8",
            None,
        ),  # 2
        (
            3,
            TType.I32,
            "lines",
            None,
            None,
        ),  # 3
    )

    def __init__(
        self,
        appId=None,
        envId=None,
        lines=None,
    ):
        self.appId = appId
        self.envId = envId
        self.lines = lines

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.appId = iprot.readString().decode("utf-8") if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.envId = iprot.readString().decode("utf-8") if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.I32:
                    self.lines = iprot.readI32()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("history_args")
        if self.appId is not None:
            oprot.writeFieldBegin("appId", TType.STRING, 1)
            oprot.writeString(self.appId.encode("utf-8") if sys.version_info[0] == 2 else self.appId)
            oprot.writeFieldEnd()
        if self.envId is not None:
            oprot.writeFieldBegin("envId", TType.STRING, 2)
            oprot.writeString(self.envId.encode("utf-8") if sys.version_info[0] == 2 else self.envId)
            oprot.writeFieldEnd()
        if self.lines is not None:
            oprot.writeFieldBegin("lines", TType.I32, 3)
            oprot.writeI32(self.lines)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class history_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (Proc_SyncRsp, Proc_SyncRsp.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = Proc_SyncRsp()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("history_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class create_session_v2_args(object):
    """
    Attributes:
     - user
     - bk_biz_id
     - bk_set_type
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRUCT,
            "user",
            (user_info, user_info.thrift_spec),
            None,
        ),  # 1
        (
            2,
            TType.STRING,
            "bk_biz_id",
            "UTF8",
            None,
        ),  # 2
        (
            3,
            TType.STRING,
            "bk_set_type",
            "UTF8",
            None,
        ),  # 3
    )

    def __init__(
        self,
        user=None,
        bk_biz_id=None,
        bk_set_type=None,
    ):
        self.user = user
        self.bk_biz_id = bk_biz_id
        self.bk_set_type = bk_set_type

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.user = user_info()
                    self.user.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.bk_biz_id = (
                        iprot.readString().decode("utf-8") if sys.version_info[0] == 2 else iprot.readString()
                    )
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.STRING:
                    self.bk_set_type = (
                        iprot.readString().decode("utf-8") if sys.version_info[0] == 2 else iprot.readString()
                    )
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("create_session_v2_args")
        if self.user is not None:
            oprot.writeFieldBegin("user", TType.STRUCT, 1)
            self.user.write(oprot)
            oprot.writeFieldEnd()
        if self.bk_biz_id is not None:
            oprot.writeFieldBegin("bk_biz_id", TType.STRING, 2)
            oprot.writeString(self.bk_biz_id.encode("utf-8") if sys.version_info[0] == 2 else self.bk_biz_id)
            oprot.writeFieldEnd()
        if self.bk_set_type is not None:
            oprot.writeFieldBegin("bk_set_type", TType.STRING, 3)
            oprot.writeString(self.bk_set_type.encode("utf-8") if sys.version_info[0] == 2 else self.bk_set_type)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class create_session_v2_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (proc_sync_rsp, proc_sync_rsp.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = proc_sync_rsp()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("create_session_v2_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class start_v2_args(object):
    """
    Attributes:
     - cmd
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRUCT,
            "cmd",
            (proc_command, proc_command.thrift_spec),
            None,
        ),  # 1
    )

    def __init__(
        self,
        cmd=None,
    ):
        self.cmd = cmd

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.cmd = proc_command()
                    self.cmd.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("start_v2_args")
        if self.cmd is not None:
            oprot.writeFieldBegin("cmd", TType.STRUCT, 1)
            self.cmd.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class start_v2_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (proc_async_rsp, proc_async_rsp.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = proc_async_rsp()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("start_v2_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class stop_v2_args(object):
    """
    Attributes:
     - cmd
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRUCT,
            "cmd",
            (proc_command, proc_command.thrift_spec),
            None,
        ),  # 1
    )

    def __init__(
        self,
        cmd=None,
    ):
        self.cmd = cmd

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.cmd = proc_command()
                    self.cmd.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("stop_v2_args")
        if self.cmd is not None:
            oprot.writeFieldBegin("cmd", TType.STRUCT, 1)
            self.cmd.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class stop_v2_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (proc_async_rsp, proc_async_rsp.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = proc_async_rsp()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("stop_v2_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class restart_v2_args(object):
    """
    Attributes:
     - cmd
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRUCT,
            "cmd",
            (proc_command, proc_command.thrift_spec),
            None,
        ),  # 1
    )

    def __init__(
        self,
        cmd=None,
    ):
        self.cmd = cmd

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.cmd = proc_command()
                    self.cmd.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("restart_v2_args")
        if self.cmd is not None:
            oprot.writeFieldBegin("cmd", TType.STRUCT, 1)
            self.cmd.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class restart_v2_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (proc_async_rsp, proc_async_rsp.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = proc_async_rsp()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("restart_v2_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class kill_v2_args(object):
    """
    Attributes:
     - cmd
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRUCT,
            "cmd",
            (proc_command, proc_command.thrift_spec),
            None,
        ),  # 1
    )

    def __init__(
        self,
        cmd=None,
    ):
        self.cmd = cmd

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.cmd = proc_command()
                    self.cmd.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("kill_v2_args")
        if self.cmd is not None:
            oprot.writeFieldBegin("cmd", TType.STRUCT, 1)
            self.cmd.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class kill_v2_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (proc_async_rsp, proc_async_rsp.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = proc_async_rsp()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("kill_v2_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class reload_v2_args(object):
    """
    Attributes:
     - cmd
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRUCT,
            "cmd",
            (proc_command, proc_command.thrift_spec),
            None,
        ),  # 1
    )

    def __init__(
        self,
        cmd=None,
    ):
        self.cmd = cmd

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.cmd = proc_command()
                    self.cmd.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("reload_v2_args")
        if self.cmd is not None:
            oprot.writeFieldBegin("cmd", TType.STRUCT, 1)
            self.cmd.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class reload_v2_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (proc_async_rsp, proc_async_rsp.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = proc_async_rsp()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("reload_v2_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class auto_v2_args(object):
    """
    Attributes:
     - cmd
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRUCT,
            "cmd",
            (proc_command, proc_command.thrift_spec),
            None,
        ),  # 1
    )

    def __init__(
        self,
        cmd=None,
    ):
        self.cmd = cmd

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.cmd = proc_command()
                    self.cmd.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("auto_v2_args")
        if self.cmd is not None:
            oprot.writeFieldBegin("cmd", TType.STRUCT, 1)
            self.cmd.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class auto_v2_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (proc_async_rsp, proc_async_rsp.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = proc_async_rsp()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("auto_v2_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class noauto_v2_args(object):
    """
    Attributes:
     - cmd
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRUCT,
            "cmd",
            (proc_command, proc_command.thrift_spec),
            None,
        ),  # 1
    )

    def __init__(
        self,
        cmd=None,
    ):
        self.cmd = cmd

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.cmd = proc_command()
                    self.cmd.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("noauto_v2_args")
        if self.cmd is not None:
            oprot.writeFieldBegin("cmd", TType.STRUCT, 1)
            self.cmd.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class noauto_v2_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (proc_async_rsp, proc_async_rsp.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = proc_async_rsp()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("noauto_v2_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class create_config_v2_args(object):
    """
    Attributes:
     - cmd
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRUCT,
            "cmd",
            (proc_command, proc_command.thrift_spec),
            None,
        ),  # 1
    )

    def __init__(
        self,
        cmd=None,
    ):
        self.cmd = cmd

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.cmd = proc_command()
                    self.cmd.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("create_config_v2_args")
        if self.cmd is not None:
            oprot.writeFieldBegin("cmd", TType.STRUCT, 1)
            self.cmd.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class create_config_v2_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (proc_async_rsp, proc_async_rsp.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = proc_async_rsp()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("create_config_v2_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class push_config_v2_args(object):
    """
    Attributes:
     - cmd
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRUCT,
            "cmd",
            (proc_command, proc_command.thrift_spec),
            None,
        ),  # 1
    )

    def __init__(
        self,
        cmd=None,
    ):
        self.cmd = cmd

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.cmd = proc_command()
                    self.cmd.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("push_config_v2_args")
        if self.cmd is not None:
            oprot.writeFieldBegin("cmd", TType.STRUCT, 1)
            self.cmd.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class push_config_v2_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (proc_async_rsp, proc_async_rsp.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = proc_async_rsp()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("push_config_v2_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class check_v2_args(object):
    """
    Attributes:
     - cmd
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRUCT,
            "cmd",
            (proc_command, proc_command.thrift_spec),
            None,
        ),  # 1
    )

    def __init__(
        self,
        cmd=None,
    ):
        self.cmd = cmd

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.cmd = proc_command()
                    self.cmd.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("check_v2_args")
        if self.cmd is not None:
            oprot.writeFieldBegin("cmd", TType.STRUCT, 1)
            self.cmd.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class check_v2_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (proc_async_rsp, proc_async_rsp.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = proc_async_rsp()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("check_v2_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class get_result_by_id_v2_args(object):
    """
    Attributes:
     - task_id
    """

    thrift_spec = (
        None,  # 0
        (
            1,
            TType.STRING,
            "task_id",
            "UTF8",
            None,
        ),  # 1
    )

    def __init__(
        self,
        task_id=None,
    ):
        self.task_id = task_id

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.task_id = (
                        iprot.readString().decode("utf-8") if sys.version_info[0] == 2 else iprot.readString()
                    )
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("get_result_by_id_v2_args")
        if self.task_id is not None:
            oprot.writeFieldBegin("task_id", TType.STRING, 1)
            oprot.writeString(self.task_id.encode("utf-8") if sys.version_info[0] == 2 else self.task_id)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class get_result_by_id_v2_result(object):
    """
    Attributes:
     - success
    """

    thrift_spec = (
        (
            0,
            TType.STRUCT,
            "success",
            (task_response, task_response.thrift_spec),
            None,
        ),  # 0
    )

    def __init__(
        self,
        success=None,
    ):
        self.success = success

    def read(self, iprot):
        if (
            iprot._fast_decode is not None
            and isinstance(iprot.trans, TTransport.CReadableTransport)
            and self.thrift_spec is not None
        ):
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = task_response()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin("get_result_by_id_v2_result")
        if self.success is not None:
            oprot.writeFieldBegin("success", TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ["%s=%r" % (key, value) for key, value in list(self.__dict__.items())]
        return "%s(%s)" % (self.__class__.__name__, ", ".join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
