### 功能描述

保存处理套餐

### 请求参数

{{ common_args_desc }}

#### 接口参数

| 字段           | 类型   | 必选 | 描述                                                         |
| -------------- | ------ | ---- | ------------------------------------------------------------ |
| bk_biz_id      | Int    | 是   | 业务ID                                                       |
| name           | String | 是   | 名称                                                         |
| plugin_id      | Int    | 是   | 插件ID，可选项：2（HTTP回调），3（作业平台），4（标准运维），5（流程服务），6（标准运维公共流程） |
| desc           | String | 否   | 描述                                                         |
| execute_config | Dict   | 是   | 执行参数（根据plug_in对应的 plugin_type不同，所需参数也不同） |

#### 执行参数（plugin_id为2时）

| 字段                 | 类型   | 必选 | 描述                                                     |
| -------------------- | ------ | ---- | -------------------------------------------------------- |
| method               | String | 否   | 请求方法，可选（"POST","GET","PUT"）默认"GET"            |
| url                  | String | 是   | 回调地址                                                 |
| headers              | List   | 否   | 请求头                                                   |
| authorize            | Dict   | 否   | 认证信息                                                 |
| body                 | Dict   | 否   | 请求体                                                   |
| query_params         | List   | 否   | 请求参数                                                 |
| failed_retry         | Dict   | 否   | 失败重试机制                                             |
| need_poll            | Bool   | 否   | 是否需要告警（默认是）                                   |
| notify_interval      | Int    | 否   | 告警周期（按s为单位，最小1分钟，默认1h）                 |
| interval_notify_mode | String | 否   | 告警方法（可选"increasing", "standard"，默认"standard"） |

##### execute_config.template_detail.headers

| 字段       | 类型   | 必选 | 描述     |
| ---------- | ------ | ---- | -------- |
| key        | String | 是   | 字段名   |
| value      | String | 否   | 字段值   |
| desc       | String | 否   | 描述     |
| is_builtin | Bool   | 否   | 是否内嵌 |
| is_enabled | Bool   | 否   | 是否启用 |

##### execute_config.template_detail.authorize

| 字段        | 类型   | 必选 | 描述                                              |
| ----------- | ------ | ---- | ------------------------------------------------- |
| auth_type   | String | 是   | 类型（可选"none", "basic_auth", "bearer_token" ） |
| auth_config | Dict   | 否   | 配置信息                                          |

##### execute_config.template_detail.body

| 字段         | 类型   | 必选 | 描述                                                         |
| ------------ | ------ | ---- | ------------------------------------------------------------ |
| data_type    | String | 否   | 类型（可选"default", "raw", "form_data", "x_www_form_urlencoded"） |
| params       | List   | 否   | 与execute_config.headers参数配置一样                         |
| content      | String | 否   | 当type为raw时这里配置相关内容                                |
| content_type | String | 否   | 内容类型（可选"text","json", "html","xml"默认"text"）        |

##### execute_config.template_detail.query_params

| 字段       | 类型   | 必选 | 描述     |
| ---------- | ------ | ---- | -------- |
| key        | String | 是   | 字段名   |
| value      | String | 否   | 字段值   |
| desc       | String | 否   | 描述     |
| is_builtin | Bool   | 否   | 是否内嵌 |
| is_enabled | Bool   | 否   | 是否启用 |

##### execute_config.template_detail.failed_retry

| 字段            | 类型 | 必选 | 描述                  |
| --------------- | ---- | ---- | --------------------- |
| is_enabled      | Bool | 否   | 是否启用              |
| value           | Int  | 否   | 处理时间              |
| max_retry_times | Int  | 是   | 最大重试时间（最小0） |
| retry_interval  | Int  | 是   | 重试间隔（最小0）     |

#### 执行参数（plugin_id为其他选项时）

| 字段            | 类型   | 必选 | 描述                            |
| --------------- | ------ | ---- | ------------------------------- |
| template_id     | String | 是   | 周边系统的模版ID                |
| template_detail | Dict   | 是   | 模版详情（默认{}）              |
| timeout         | Int    | 是   | 执行超时时间（单位s，默认600s） |

#### 示例数据

```json
{
    "bk_app_code": "xxx",
    "bk_app_secret": "xxxxx",
    "bk_token": "xxxx",
    "execute_config": {
        "template_detail": {
            "method": "GET",
            "url": "http://www.baidu.com",
            "headers": [],
            "authorize": {
                "auth_config": {},
                "auth_type": "none",
                "insecure_skip_verify": false
            },
            "body": {
                "data_type": "default",
                "content_type": "",
                "content": "",
                "params": []
            },
            "query_params": [],
            "need_poll": false,
            "notify_interval": 7200,
            "failed_retry": {
                "is_enabled": true,
                "max_retry_times": 2,
                "retry_interval": 2,
                "timeout": 10
            }
        },
        "timeout": 600
    },
    "name": "测试新建处理套餐",
    "desc": "测试新建处理套餐1111",
    "is_enabled": false,
    "bk_biz_id": 2,
    "plugin_id": 2
}
```

### 响应参数

| 字段    | 类型   | 描述           |
| ------- | ------ | -------------- |
| result  | bool   | 请求是否成功   |
| code    | int    | 返回的状态码   |
| message | string | 描述信息       |
| data    | Int    | 处理套餐配置id |

#### 示例数据

```json
{
    "message": "OK",
    "code": 200,
    "data": {
        "id": 1
    },
    "result": true
}
```