### Functional description

Monitor events generated by system resource change (v3.8 and above)


**The key features of this watch feature include:**


* Provide users with highly available data change watch services for a limited period of time (currently 3 hours, may be adjusted, do not rely on this time).


* Within a limited time, the user can perform event backtracking or data tracing according to the cursor of the previous event, which is applicable to abnormal data backtracking or system change for data supplementary entry.


* It supports backtracking of change data according to time point, backtracking of change data according to cursor, and data change watch from current time point.


* Support the ability to watch according to event type, including add, delete, and modify. The event contains the full amount of data.


* Event watch capability to support host-to-host relationship data changes.


* The design of short and long chain is adopted. When the user watches events through the cursor, if there is no event, the session connection will be maintained, and if there is an event change within 20s, the event will be directly pushed back. Avoid the continuous request of the user, and ensure that the user can get the changed data in time.


* Support batch event watch capability to improve system throughput.


* Support customized event data fields of interest to meet users "lightweight watch needs.


### Request Parameters

{{ common_args_desc }}

#### Interface Parameters

| Field                | Type           | Required   | Description      |
| ------------------- | -------------- | ------ |-------------------------|
| bk_event_types      |  array   string |no     | Event type, if filled in, it is only concerned with events of this type. The optional values are: create/update/delete. For example, if you use create, you only focus on new events for that resource. If it is not filled in blank, it is all concerned.|
| bk_fields           |  array string   | It depends.| List of fields to be returned in the returned event. Currently, this field is required for monitoring host resource and can not be blank. Host relationship can be blank. If left blank, all fields are returned by default. |
| bk_start_from       |  Int64          | no     | The start time of the listening event, which is the number of seconds in Unix time, that is, the total number of seconds from 0:00:00 on January 1,1970 to the point in time you want to watch. |
| bk_cursor           |  string         | no     | The cursor that listens for events represents the address of the event to start or continue watch, and the system returns the next event, or batch of events, for this cursor. |
| bk_resource         |  string         | yes  | The type of resource to listen on, with enumerated values: host, host_relation, biz, set, module, process, object_instance, mainline_instance, biz_set, biz_set_relation, plat, project。Where host represents a host Detail Event, host_recall represents a relationship event of the host, biz represents a Service detail event, set represents a set Detail Event, module represents a module Detail Event, process represents a process Detail Event, object_instance represents a general model instance event, mainline_instance represents a mainline model instance event, biz_set represents a service set event, and biz_set_recall represents a relationship event between a service set and a service, plat represents a cloud area detail event, project represents a project detail event. |
| bk_supplier_account | string         | yes  | Developer account number|
| bk_filter           |  object         | no     | Filter condition|
**Note: the biz_set_recall event will be triggered when adding, deleting and updating the bk_scope field of a business set, and when adding, deleting and updating a business involves a change in the business set relationship. The event type (bk_event_type) of all business set relationship events is update. The event details will return the ID of the business set whose relationship has changed and the list of all business IDs contained in the business set. When the event is triggered by a service set deletion event, the service ID list in the returned event details is empty**

#### bk_filter

| Field                 | Type           | Required   | Description                                                         |
| ------------------- | -------------- | ------ | ------------------------------------------------------------ |
| bk_sub_resource     |  string         | no     | The subordinate resource type to be monitored, which can only be used when bk_resource is object_instance or mainline_instance, and represents the bk_obj_id of the model to be monitored|


### Request Parameters Example

Host:

```json
{
  "bk_app_code": "esb_test",
  "bk_app_secret": "xxx",
  "bk_username": "xxx",
  "bk_token": "xxx",
  "bk_event_types": ["create","update","delete"],
  "bk_fields": ["bk_host_innerip", "bk_mac"],
  "bk_start_from": 12345678999,
  "bk_cursor": "MQ0yDTE1ODkyMDcyODENMQ01ZWI3ZWZjNTBiOTA5ZTYyMGFmYWQzZGY=",
  "bk_resource": "host"
}

```

Common model instance:

```json
{
  "bk_event_types": [],
  "bk_fields": ["bk_inst_id", "bk_inst_name"],
  "bk_start_from": 12345678999,
  "bk_cursor": "MQ0yDTE1ODkyMDcyODENMQ01ZWI3ZWZjNTBiOTA5ZTYyMGFmYWQzZGY=",
  "bk_resource": "object_instance",
  "bk_filter": {
    "bk_sub_resource": "xxx"
  },
  "bk_supplier_account": "0"
}

```

## Return parameter

```json
{
  "result": true,
  "code": 0,
  "message": "success",
  "permission": null,
  "request_id": "e43da4ef221746868dc4c837d36f3807",
  "data": {
    "bk_watched": true,
    "bk_events": [
      {
        "bk_cursor": "MQ0yDTE1ODkyMDcyODENMQ01ZWI3ZWZjNTBiOTA5ZTYyMGFmYWQzZGY=",
        "bk_resource": "host",
        "bk_event_type": "update",
        "bk_detail": {
          "bk_cpu": 2
        }
      },
      {
        "bk_cursor": "MQ0yDTE1ODkzNDExMDcNMQ01ZWI3ZWZjNTBiOTA5ZTYyMGFmYWQzZGY=",
        "bk_resource": "host",
        "bk_event_type": "update",
        "bk_detail": {
          "bk_cpu": 2
        }
      }
    ]
  }
}

```

### Return Result Parameters Description

#### response

| Name| Type| Description|
|---|---|---|
| result | bool |Whether the request was successful or not. True: request succeeded;false request failed|
| code | int |Wrong code. 0 indicates success,>0 indicates failure error|
| message | string |Error message returned by request failure|
| permission    |  object |Permission information    |
| request_id    |  string |Request chain id    |
| data | Array |Event data details are an ordered array, and the event at the end of the array is a new event. |

- Data data description

| Name       | Type             | Description                                                         |
| ---------- | ---------------- | ------------------------------------------------------------ |
| bk_watched | bool             | Whether an event was heard, true: Event heard;false: Event not monitored     |
| bk_events  |Details of events monitored| The maximum length of the monitored Event Details list is 200, which may be adjusted in the future. Please do not rely on this length. |

- bk_events data description

| Name          | Type        | Description                                                         |
| ------------- | ----------- | ------------------------------------------------------------ |
| bk_cursor     |  string      | Represents the cursor value of the current resource event that the caller can use to get the next event after the event|
| bk_resource   |  enum string |The resource type corresponding to this event                                         |
| bk_event_type | enum string |The event type corresponding to the event, and the enumeration value is: Create/update/delete. |
| bk_detail     |  object      | The detail data of the corresponding resource of the event, and the corresponding detail is different for different resources.   |

#### Host_recall resource bk_detail field data example:
```json

{
  "bk_biz_id" : 1,
  "bk_host_id" : 2,
  "bk_module_id" : 3,
  "bk_set_id" : 4,
  "bk_supplier_account" : "0"
}
```

#### Host resource bk_detail field data example:
```json
{
  "bk_host_name" : "hostname",
  "bk_mem" : null,
  "bk_cloud_id" : 0,
  "operator" : "user",
  "bk_cpu" : null,
  "bk_mac" : "",
  "bk_host_innerip" : "192.168.1.1",
  "bk_supplier_account" : "0",
  ....
}
```

#### biz_set_recall resource bk_detail field data example:
```json
{
  "bk_biz_set_id": 1,
  "bk_biz_ids": [1 ,2, 3]
}
```

- biz_set_recall resource bk_detail data description

| Name          | Type      | Description                                   |
| ------------- | --------- | -------------------------------------- |
| bk_biz_set_id | int       | Business set ID whose relationship between business set and business has changed|
| bk_biz_ids    |  int array |ID list of all business included in the business set      |


### Operating instructions

Flow of use of this interface:

1. Determine the initial monitoring mode, which can be:

- 1.1 specify a time to listen for events

- 1.2 specify the current time to start listening for events

- 1.3 specify to start listening for events with the cursor bk_cursor position

  After confirmation, a request is initiated.

2. CMDB returns a list of events that meet your expectations:
- 2.1: if bk_watchd is ture, it indicates that the event has been monitored. bk_events is the event details list. The caller can take the cursor of the last event in the array and continue to watch the next time in the way in Step 1.3.
- 2.2: if bk_watched is false, it indicates that no event is monitored. There is only one event in bk_watched. Use the watched of this event to perform the next watch.

**note**:

The event has an expiration time, currently 3 hours. If it expires, the event will be released and the expired cursor will expire. You can re-watch in two ways:

1. Specify a time to start listening for event
2. Specify that current time to start listening for event



