### Functional description

create template version

### Request Parameters

{{ common_args_desc }}

#### Interface Parameters

| Field            | Type       | Required | Description |
|------------------|------------|----------|-------------|
| biz_id           |  string    | Y        | business id |
| template_id      |  string    | Y        | template id |
| version_tag      |  string    | Y        | version tag (max_length: 64)  |
| content_id       |  string    | Y        | content sha256 id (min_length: 64, max_length: 64) |
| content_size     |  integer   | Y        | content size |
| memo             |  string    | N        | memo description (max_length: 256) |
| validate_content |  bool      | N        | validate content or not, default: false |

### Request Parameters Example

```json
{
    "bk_app_code": "xxx",
    "bk_app_secret": "xxx",
    "bk_token": "xxx",
    "biz_id": "xxx",
    "template_id": "T-0b67a798-e9c1-11e9-8c23-525400f99278",
    "version_tag": "v1",
    "content_id": "4c2d4c4231d1ff93975879226fe92250616082cbaed6a4a888d2adc490ba9b44",
    "content_size": 1024,
    "memo": "template version 1"
}
```

### Return Result Example

```json
{
    "result": true,
    "code": 0,
    "message": "OK",
    "data": {
        "version_id": "TV-0b67a798-e9c1-11e9-8c23-525400f99278"
    }
}
```

### Return Result Parameters Description

#### data

| Field      | Type   | Description   |
|------------|--------|---------------|
| version_id | string | template version id |
