import { type NextPage } from "next";

import {
  Button,
  Card,
  Group,
  SimpleGrid,
  Stack,
  Text,
  Title,
} from "@mantine/core";
import Image from "next/image";
import Link from "next/link";

const Home: NextPage = () => {
  return (
    <>
      {/* <Head>
        <title>Create T3 App</title>
        <meta name="description" content="Generated by create-t3-app" />
        <link rel="icon" href="/favicon.ico" />
      </Head> */}
      <Stack m="auto" w="max-content" mt={12} align="center">
        <Title>Welcome To Your Self-Hosted Chat GPT</Title>
      </Stack>

      <SimpleGrid cols={4} m="auto" mt={32} p={64}>
        <NavigationCard
          title="Manage settings: before using he app add your OpenAI API key"
          image="https://images.unsplash.com/photo-1610986602538-431d65df4385?ixlib=rb-4.0.3&ixid=MnwxMjA3fDB8MHxzZWFyY2h8MTl8fGNvbmZpZ3VyYXRpb258ZW58MHwwfDB8fA%3D%3D&auto=format&fit=crop&w=800&q=60"
          path="/settings"
          cta="Settings"
        />
        <NavigationCard
          title="Start chatting with your ChatGPT powered chatbot"
          image="https://images.unsplash.com/photo-1675557009483-e6cf3867976b?ixlib=rb-4.0.3&ixid=MnwxMjA3fDB8MHxzZWFyY2h8OHx8Y2hhdGdwdHxlbnwwfDB8MHx8&auto=format&fit=crop&w=800&q=60I"
          path="/chats"
          cta="Start Chatting"
        />

        <NavigationCard
          title="Streamline your process with powerful templates"
          image="https://images.unsplash.com/photo-1530435460869-d13625c69bbf?ixlib=rb-4.0.3&ixid=MnwxMjA3fDB8MHxzZWFyY2h8Mnx8dGVtcGxhdGVzfGVufDB8fDB8fA%3D%3D&auto=format&fit=crop&w=800&q=60"
          path="/templates/manage"
          cta="Create Templates"
        />

        <NavigationCard
          title="Import templates from other sources. Get inspired!"
          image="https://images.unsplash.com/photo-1667984390527-850f63192709?ixlib=rb-4.0.3&ixid=MnwxMjA3fDB8MHxzZWFyY2h8NDV8fGRpc3RyaWJ1dGVkJTIwY29tcHV0aW5nfGVufDB8fDB8fA%3D%3D&auto=format&fit=crop&w=800&q=60"
          path="/templates/import"
          cta="Import Templates"
        />
      </SimpleGrid>
    </>
  );
};

export default Home;

interface NavigationCardProps {
  title: string;
  path: string;
  image: string;
  cta: string;
}
function NavigationCard({ title, path, image, cta }: NavigationCardProps) {
  return (
    <Card
      shadow="sm"
      padding="lg"
      radius="md"
      withBorder
      w="100%"
      sx={{ maxWidth: "400px" }}
    >
      <Card.Section pos="relative" sx={{ aspectRatio: "21 / 9" }}>
        <Image src={image} fill alt={title} style={{ objectFit: "cover" }} />
      </Card.Section>

      <Group position="apart" mt="md" mb="xs">
        <Text weight={500}>{title}</Text>
      </Group>

      <Link href={path}>
        <Button variant="light" fullWidth mt="md" radius="md">
          {cta}
        </Button>
      </Link>
    </Card>
  );
}
