import {environment} from 'src/environments/environment';

export const API_URL: string = environment.api_url;

export enum ApiMethod {
  GET = "GET",
  POST = "POST",
  PUT = "PUT",
  DELETE = "DELETE",
  PATCH = "PATCH"
}


export const API_ENDPOINTS = {
logIn:'users/login',
signUp:'users/signup',
resetPassword:'users/resetPassword/',
forgetPassword:'users/forgotPassword',
getBrowserDetail:'users/getBrowserDetail/',
setBrowserDetail:'users/setBrowserDetail',
users: 'users',
deleteUser: 'users/deleteUser/',
editUser: 'users/updateUser',
createUser: 'users/createUser',
getRoles:'roles',
getPermissions: 'permissions',
getAllPermissionsByRole: 'permissions/getAllPermissionsByRole',
getAllPermissionsByCompany: 'permissions/getAllPermissionsByCompany/',
getPermissionByID: 'permissions/',
createPermissions: 'permissions/createPermission',
assignPermissions: 'permissions/assignPermission',
assignCompanyPermission: 'permissions/assignCompanyPermission',
updatePermissions: 'permissions/updatePermission',
deletePermissions: 'permissions/deletePermission/',
unAssignPermission: 'permissions/unAssignPermission/',
getRoleByID:'roles/',
createRoles:'roles/createRole',
updateRoles:'roles/updateRole',
deleteRoles:'roles/deleteRole/',
getAllCountriesList:'countries',
getCountryById:'countries/',
createCountry:'countries/createCountry',
updateCountry:'countries/updateCountry',
deleteCountry:'countries/deleteCountry/',
getAllCompaniesList:'companies',
getAllCompaniesListByCountry:'companies/getAllCompaniesByCountry/',
getCompanyById:'companies/',
createCompany:'companies/createCompany',
updateCompany:'companies/updateCompany',
deleteCompany:'companies/deleteCompany/',
getAllBranchesList:'branches',
getAllBranchesListByCompany:'branches/getAllBranchesByCompany/',
getBranchById:'branches/',
createBranch:'branches/createBranch',
updateBranch:'branches/updateBranch',
deleteBranch:'branches/deleteBranch/',
categories:'categories',
getCategoryById:'categories/',
getNestedCategories:'categories/nest',
getAllCategoriesByCountry:'categories/getAllCategoriesByCountry/',
getAllCategoriesByCompany:'categories/getAllCategoriesByCompany/',
createCategory:'categories/createCategory',
editCategory:'categories/updateCategory',
deleteCategory:'categories/deleteCategory/',
units:'units',
getUnitById:'units/',
getAllUnitsByCountry:'units/getAllUnitsByCountry/',
getAllUnitsByCompany:'units/getAllUnitsByCompany/',
createUnit:'units/createUnit',
editUnit:'units/updateUnit',
deleteUnit:'units/deleteUnit/',
manufacturers:'manufacturers',
getManufacturerById:'manufacturers/',
getAllManufacturersByCountry:'manufacturers/getAllManufacturersByCountry/',
getAllManufacturersByCompany:'manufacturers/getAllManufacturersByCompany/',
createManufacturer:'manufacturers/createManufacturer',
editManufacturer:'manufacturers/updateManufacturer',
deleteManufacturer:'manufacturers/deleteManufacturer/',
taxClasses:'taxClasses',
getTaxClassById:'taxClasses/',
getAllTaxClassesByCountry:'taxClasses/getAllTaxClassesByCountry/',
getAllTaxClassesByCompany:'taxClasses/getAllTaxClassesByCompany/',
createTaxClass:'taxClasses/createTaxClass',
editTaxClass:'taxClasses/updateTaxClass',
deleteTaxClass:'taxClasses/deleteTaxClass/',
taxRates:'taxRates',
getTaxRateById:'taxRates/',
getAllTaxRatesByCountry:'taxRates/getAllTaxRatesByCountry/',
getAllTaxRatesByCompany:'taxRates/getAllTaxRatesByCompany/',
createTaxRate:'taxRates/createTaxRate',
editTaxRate:'taxRates/updateTaxRate',
deleteTaxRate:'taxRates/deleteTaxRate/',
productOptions:'productOptions',
getProductOptionById:'productOptions/',
getAllProductOptionsByCountry:'productOptions/getAllProductOptionsByCountry/',
getAllProductOptionsByCompany:'productOptions/getAllProductOptionsByCompany/',
createProductOption:'productOptions/createProductOption',
editProductOption:'productOptions/updateProductOption',
deleteProductOption:'productOptions/deleteProductOption/',
productOptionValues:'productOptionValues',
getProductOptionValuesById:'productOptionValues/',
getAllProductOptionValuesByCountry:'productOptionValues/getAllProductOptionValuesByCountry/',
getAllProductOptionValuesByCompany:'productOptionValues/getAllProductOptionValuesByCompany/',
createProductOptionValue:'productOptionValues/createProductOptionValue',
editProductOptionValue:'productOptionValues/updateProductOptionValue',
deleteProductOptionValue:'productOptionValues/deleteProductOptionValue/',
products:'products',
getProductById:'products/',
getAllProductsByCountry:'products/getAllProductsByCountry/',
getAllProductsByCompany:'products/getAllProductsByCompany/',
createProduct:'products/createProduct',
editProduct:'products/updateProduct',
updateProductImages:'products/updateProductImages',
updateProductInfo:'products/updateProductInfo',
deleteProduct:'products/deleteProduct/',
deleteProductImage:'products/deleteProductImage/',
createInventory:'products/createInventory',
banners:'banners',
getBannerById:'banners/',
getAllBannersByCompany:'banners/getAllBannersByCompany/',
createBanner:'banners/createBanner',
editBanner:'banners/updateBanner',
deleteBanner:'banners/deleteBanner/',
landingPageCategories:'landingPageCategories',
getLandingPageCategoryById:'landingPageCategories/',
getAllLandingPageCategoriesByCompany:'landingPageCategories/getAllLandingPageCategoriesByCompany/',
createLandingPageCategory:'landingPageCategories/createLandingPageCategory',
editLandingPageCategory:'landingPageCategories/updateLandingPageCategory',
deleteLandingPageCategory:'landingPageCategories/deleteLandingPageCategory/',
brands:'brands',
getBrandById:'brands/',
getAllBrandsByCompany:'brands/getAllBrandsByCompany/',
createBrand:'brands/createBrand',
editBrand:'brands/updateBrand',
deleteBrand:'brands/deleteBrand/',
generalSettings:'generalSettings',
getGeneralSettingById:'generalSettings/',
getAllGeneralSettingsByCompany:'generalSettings/getAllGeneralSettingsByCompany/',
createGeneralSetting:'generalSettings/createGeneralSetting',
editGeneralSetting:'generalSettings/updateGeneralSetting',
deleteGeneralSetting:'generalSettings/deleteGeneralSetting/',
orders:'orders',
getOrderById:'orders/',
getAllOrdersByCountry:'orders/getAllOrdersByCountry/',
getAllOrdersByCompany:'orders/getAllOrdersByCompany/',
createOrder:'orders/createOrder',
editOrder:'orders/updateOrder',
deleteOrder:'orders/deleteOrder/',
}
