<h1 align="center">Awesome Android Open-Source Projects</h1><br>

<p align="center">
:eyeglasses: A curated list of awesome android projects by open-source contributors.
</p><br>

<p align="center">
  <a href="#"><img alt="Android OS" src="https://img.shields.io/badge/OS-Android-3DDC84?style=flat-square&logo=android"></a>
  <a href="#"><img alt="Languages-Kotlin" src="https://flat.badgen.net/badge/Language/Kotlin?icon=https://raw.githubusercontent.com/binaryshrey/Awesome-Android-Open-Source-Projects/master/assets/Kotlin_Logo_icon_white.svg&color=f18e33"/></a>
  <a href="#"><img alt="Languages-Java" src="https://img.shields.io/badge/Language-Java-1DA1F2?style=flat-square&logo=java"></a>
  <a href="#"><img alt="OpenSource" src="https://flat.badgen.net/badge/Open-Source/HacktoberFest?icon=https://raw.githubusercontent.com/binaryshrey/Awesome-Android-Open-Source-Projects/master/assets/DO_Logo_icon_white.svg&color=f18e33"/></a>
  <a href="#"><img alt="PRs" src="https://img.shields.io/badge/PRs-Welcome-3DDC84?style=flat-square"></a>
</p>
<p align="center">
  <a href="https://github.com/binaryShrey"><img alt="Github - binaryShrey" src="https://img.shields.io/badge/GitHub-binaryShrey-181717?style=flat-square&logo=github"></a>
  <a href="https://twitter.com/binaryShrey"><img alt="Twitter - binaryShrey" src="https://img.shields.io/badge/Twitter-binaryShrey-1DA1F2?style=flat-square&logo=twitter"></a>
</p>

<br>
<p align="center">
<img width="720px" src="https://raw.githubusercontent.com/binaryshrey/Awesome-Android-Open-Source-Projects/master/assets/AAOSP.webp" alt="aaosp"></img>
</p><br>

<p> Awesome Android Open-Source Projects aims to be the starting point for those who are new to the world of Open-Source and want to contribute for the same. It also serves experienced contributors to participate and contribute in the mentioned list of projects.
</p><br>

## Contents
:shamrock:  [**Categories**](#shamrock--categories)
- :tv: [Android TV](#tv-android-tv)
- :watch: [Android Wear](#watch-android-wear)
- :office: [Architecture](#office-architecture)
- :iphone: [Communication](#iphone-communication)
- :book: [eBook Reader](#book-ebook-reader)
- :movie_camera: [Entertainment](#movie_camera-entertainment)
- :moneybag: [Finance](#moneybag-finance)
- :soccer: [Games](#soccer-games)
- :weight_lifting: [Health & Fitness](#weight_lifting-health--fitness)
- :books: [Libraries](#books-libraries)
- :art: [Misc](#art-misc)
- :newspaper: [News](#newspaper-news)
- :rocket: [Productivity](#rocket-productivity)
- :hammer_and_wrench: [Tools](#hammer_and_wrench-tools)
- :earth_africa: [Travel](#earth_africa-travel)
- :gear: [Utilities](#gear-utilities)
- :partly_sunny: [Weather](#partly_sunny-weather)

:dart:  [**HacktoberFest**](#dart--hacktoberfest)

:memo:  [**Contributing**](#memo--contributing)
<br><br>

## :shamrock:  **Categories**

### :tv: Android TV
- [AndroidTVMovieParadise](https://github.com/halilozel1903/AndroidTVMovieParadise)

    - Android TV is a version of the Android operating system. It is developed by Google for soundbars, set-top boxes, digital media players, and TVs with native applications.Movie Paradise is an Android TV app. Application is using The Movie Database.
    
- [SmartYouTubeTV](https://github.com/yuliskov/SmartYouTubeTV)

    - SmartYouTubeTV: A YouTube client for set-top boxes and Android-based TVs.

- [Tv-samples](https://github.com/android/tv-samples)

    - This repository consists of multiple samples showing best practices in app development on Android TV. 
    
- [Vineyard](https://github.com/hitherejoe/Vineyard)

    - Vineyard is an unofficial Vine client for Android TV.

- [Kodi TV](https://github.com/xbmc/xbmc)

    - Kodi is an award-winning free and open source home theater/media center software and entertainment hub for digital media. With its beautiful interface and powerful skinning engine, it's available for Android, BSD, Linux, macOS, iOS, tvOS and Windows.
    
    
    
### :watch: Android Wear
- [FORMWatchFace](https://github.com/romannurik/FORMWatchFace)

    - This is a watch face for Android Wear based on the typeface used for the FORM design conference. 
    
- [Smartalarm](https://github.com/fridgecow/smartalarm)

    - Smart Alarm is a privacy-focused sleep tracker with powerful features and works without an internet or phone connection.
    
- [Twelveish](https://github.com/LayoutXML/Twelveish)

    - Twelveish is a unique Wear OS (Android Wear) Watch Face that displays the approximate time in words (in multiple languages). 
    
- [Wear-notify-for-reddit](https://github.com/emmaguy/wear-notify-for-reddit)

    - Get notifications from your favourite subreddits right on your android wearable.
    
- [Wear-os-samples](https://github.com/android/wear-os-samples)

    - Multiple samples showing best practices in app and watch face development on Wear OS. 
    
- [WearSquare](https://github.com/davidvavra/WearSquare)

    - Unofficial Foursquare® Client for Android Wear.
    
    
    
### :office: Architecture

- [Github Visualizer](https://github.com/DheerajKotwani/GithubVisualizer)

    - Android Application to track any user activity on Github built using the Github Developers Api. The tools used for implementations - Github Developers Api, Kotlin, Coroutines, MVVM, Glide, Retrofit.


- [Android-mvp-architecture](https://github.com/MindorksOpenSource/android-mvp-architecture)

    - This repository contains a detailed sample app that implements MVP architecture using Dagger2, GreenDao, RxJava, FastAndroidNetworking, PlaceHolderView and AndroidDebugDatabase.
    
- [Android-mvvm-architecture](https://github.com/MindorksOpenSource/android-mvvm-architecture)

    - This repository contains a detailed sample app that implements MVVM architecture using Dagger2, Room, RxJava, FastAndroidNetworking, PlaceHolderView and AndroidDebugDatabase.
    
- [Archi](https://github.com/ivacf/archi)

    - This repository showcases and compares different architectural patterns that can be used to build Android apps. The exact same sample app is built three times with different architectures.
    
- [Baking-App-Kotlin](https://github.com/Ezike/Baking-App-Kotlin)

    - Android architecture sample with dynamic feature modularisation, clean architecture with MVI (Uni-directional data flow), dagger hilt, DFM Navigation, kotlin coroutines with StateFlow and Exo player. 
    
- [Clean-MVP](https://github.com/carlosmacmar/clean-MVP)

    - Kotlin MVP clean architecture for Android using Koin, Room and RxJava2 
    
- [Clean-Notes](https://github.com/mitchtabian/Clean-Notes)

    - Android example with Clean Architecture by layer.

- [Foodium](https://github.com/PatilShreyas/Foodium)

    - Foodium is a sample food blog Android application built to demonstrate use of Modern Android development tools - (Kotlin, Coroutines, Flow, Dagger 2, Architecture Components, MVVM, Room, Retrofit, Moshi, Material Components). 
    
- [RestApiMVVM](https://github.com/mitchtabian/RestApiMVVM)

    - App that interacts with a Rest Api. Architecture is MVVM.
    
- [NotyKT](https://github.com/PatilShreyas/NotyKT)

    - NotyKT is a complete Kotlin-stack (Backend + Android) application built to demonstrate the use of Modern development tools with best practices implementation.

- [JetJoke](https://github.com/swapnil-musale/JetJoke)

    - JetJoke is a Joke generator app build using Jetpack Compose & Clean + MVVM Architecture to demonstrate it's use with other modern Android Development libraries and tools.
    
### :iphone: Communication
 - [FairEmail](https://github.com/M66B/FairEmail/)
  
    - An advanced email client for Android

- [Irccloud-android](https://github.com/irccloud/android)

    - The official Android app for IRCCloud.com
    
- [Jetchat](https://github.com/android/compose-samples/tree/master/Jetchat)

    - Jetchat is a sample chat app built with Jetpack Compose.
    
- [Jetpack-Compose-WhatsApp-Clone](https://github.com/MindorksOpenSource/Jetpack-Compose-WhatsApp-Clone)

    - An example project to demonstrate how to build WhatsApp using Jetpack Compose. 
    
- [K-9](https://github.com/k9mail/k-9)

    - K-9 Mail is an open-source email client for Android.
    
- [Kdeconnect-android](https://github.com/KDE/kdeconnect-android)

    - Native Android port of the KDE Connect Qt app 
    
- [Proton-mail-android](https://github.com/ProtonMail/proton-mail-android)

    - ProtonMail Android app 
    
- [Qksms](https://github.com/moezbhatti/qksms)

    - QKSMS is an open source replacement to the stock messaging app on Android. It is currently available on the Google Play Store and on F-Droid
    
- [Replify-Messenger](https://github.com/vidit135g/Replify-Messenger)

    - Minimal text messenger with a ton of features. 
    
- [Signal-Android](https://github.com/WhisperSystems/Signal-Android)

    - Signal is a messaging app for simple private communication with friends.
    
- [Telegram](https://github.com/DrKLO/Telegram)

    - Telegram is a messaging app with a focus on speed and security. It’s superfast, simple and free. This repo contains the official source code for Telegram App for Android.
    
- [Tindroid](https://github.com/tinode/tindroid)

    - Android instant messenger using Tinode backend. Beta-quality software. Debug APKs are available in releases.
    
- [Tutanota](https://github.com/tutao/tutanota)

    - Tutanota is an email client with a strong focus on security and privacy that lets you encrypt emails on all your devices. 

- [Wire-android](https://github.com/wireapp/wire-android)

    - The project in this repository contains the Wire for Android client project. 

- [forem-Dev](https://github.com/forem/DEV-Android)

    - The is in official Dev.to Android App. Dev.to is a community for Developers to engage with other Developers. 
    
    
    
### :book: eBook Reader
- [Bookdash-android-app](https://github.com/bookdash/bookdash-android-app)

    - An Android app that lets you download free children's books in different languages from non-profit publisher Book Dash 
 
- [ComicReaderApp_MVI_Coroutine_RxKotlin_Jetpack](https://github.com/hoc081098/ComicReaderApp_MVI_Coroutine_RxKotlin_Jetpack)

    - Comic reader app. Learning MVVM / MVI with RxKotlin, Retrofit, Kotlin Coroutine, Work Manager, Room, Firebase, AndroidX, Clean Architecture.
 
- [Hummingbird-for-Android](https://github.com/xiprox/Hummingbird-for-Android)

    - A cool, modern client app for the anime tracking website Hummingbird.me 
 
- [tachiyomi](https://github.com/inorichi/tachiyomi)

    - Free and open source manga reader for Android 

- [AbsolutReader](https://github.com/xvalme/AbsolutReader)

    - AbsolutReader is the next generation e-book reader, 100% Open source, highly customizable, and featuring Chaimager.
    
    
 
### :movie_camera: Entertainment
- [AntennaPod](https://github.com/AntennaPod/AntennaPod)
    
    - This is the official repository of AntennaPod, the easy-to-use, flexible and open-source podcast manager for Android.

- [Jetcaster](https://github.com/android/compose-samples/tree/master/Jetcaster)
    
    - Jetcaster is a sample podcast app, built with Jetpack Compose. The goal of the sample is to showcase dynamic theming and full featured architecture.
    
- [MovieGuide](https://github.com/esoxjem/MovieGuide)
    
    - Movie discovery app showcasing MVP, RxJava, Dagger 2 and Clean Architecture 
    
- [MovieHunt](https://github.com/enginebai/MovieHunt)
    
    - Movie Android App written in Kotlin, MVVM, RxJava, Android Architecture Components. 
    
- [NewPipe](https://github.com/TeamNewPipe/NewPipe)
    
    - A libre lightweight streaming front-end for Android. 
    
- [Phonograph](https://github.com/kabouzeid/Phonograph)
    
    - A material designed music player for Android 
    
- [Shuttle](https://github.com/timusus/Shuttle)
    
    - Shuttle is an open source, local music player for Android.
    
- [SoundSpice-mobile](https://github.com/farshed/SoundSpice-mobile)
    
    - A light-weight and minimalist music player for Android 
    
- [Timber](https://github.com/naman14/Timber)
    
    - Material Design Music Player
    
- [Topcorn](https://github.com/theapache64/topcorn)
    
    - A minimalistic movie listing app to browse IMDB's top 250 movies, built to demonstrate MVVM with latest hot-trending Android development tools.
    
- [TvFlix](https://github.com/reactivedroid/TvFlix)
    
    - TvFlix android app using Dagger Hilt, Coroutines, Jetpack(Room, ViewModel, Paging, LiveData) based on MVVM architecture purely written in Kotlin.

- [MovieMade](https://github.com/michaelbel/Movies)

    - Moviemade - easy way to discover popular movies. This is a simple TMDb client for Android with material design.
      
    
### :moneybag: Finance    
- [Bitcoin-wallet](https://github.com/bitcoin-wallet/bitcoin-wallet)
    
    - Bitcoin Wallet app for your Android device. Standalone Bitcoin node, no centralized backend required. 
    
- [CoCoin](https://github.com/Nightonke/CoCoin)
    
    - CoCoin, Multi-view Accounting Application 
    
- [Expenses](https://github.com/nominalista/expenses)
    
    - App written in Kotlin for budget tracking. 
    
- [Finance-Manager](https://github.com/josharsh/Finance-Manager)
    
    - Finance Manager is an Android Application which contains Income Tax Calculator and EMI Calculator. 

- [Financius](https://github.com/mvarnagiris/financius)

    - Financius is a simple application that helps you log and track your expenses and keep an eye on your balance.
    
- [Gnucash-android](https://github.com/codinguser/gnucash-android)
    
    - GnuCash Android is a companion expense-tracker application for GnuCash (desktop) designed for Android. It allows you to record transactions on-the-go and later import the data into GnuCash for the desktop.

- [Kripto](https://github.com/sauravrao637/Kripto)

    - Kripto is cryptocurrency and exchanges app for Android, written in Kotlin and made using Coingecko's API.
    
- [CurrencyExchange](https://github.com/Marwa-Eltayeb/CurrencyExchange)

    - Currency Exchange App displays real-time currency rates, shows a chart for any currency pair. 
    
- [bither-android](https://github.com/bither/bither-android)
 
    - Bither is a simple and secure Bitcoin wallet!
    
### :soccer: Games 
- [2048-android](https://github.com/uberspot/2048-android)
    
    - This is the Android port of the 2048 game made by Gabriele Cirulli.
    
- [Pixel-dungeon](https://github.com/watabou/pixel-dungeon)
    
    - Traditional roguelike game with pixel-art graphics and simple interface 
    
- [Santa-tracker-android](https://github.com/google/santa-tracker-android)
    
    - Google Santa Tracker app for Android is an educational and entertaining tradition that brings joy to millions of children (and children at heart) across the world over the December holiday period.
    
- [CuboidalDrift](https://github.com/virejdasani/CuboidalDrift)
    
    - Cuboidal Drift is a casual, fun android game with cool looking graphics, made by Virej Dasani.

- [QuizApp](https://github.com/pratyaksh1610/Quiz_App)
 
   - This is a Quiz App that Users can play to enjoy thier free time and also gain some knowledge on the go 

- [Freeciv](https://github.com/freeciv/freeciv)

    - Freeciv is a Free and Open Source empire-building strategy game inspired by the history of human civilization.


### :weight_lifting: Health & Fitness
- [Android-heart-rate-monitor](https://github.com/phishman3579/android-heart-rate-monitor)
    
    - Android based heart rate monitor which uses the camera and its flash to determine the users heart rate in beats per minute.
    
- [Pedometer](https://github.com/j4velin/Pedometer)
    
    - Lightweight pedometer app for Android using the hardware step sensor 

- [Petals](https://github.com/LeoColman/Petals)

    - The Open Source app Petals aims to help its users to either quit weed, reduce usage or simply know how much they're using. 
    
- [Runnerup](https://github.com/jonasoreland/runnerup)
    
    - Track your sport activities with RunnerUp using the GPS in your Android phone.
    
- [Water-Intake-Tracker](https://github.com/JacobKerames/water-intake-tracker)

    - Determine and track daily hydration goals based on body weight, and export data.

- [7minWorkout](https://github.com/sharshv2012/7minWorkout)

    - An workout app which tracks my workouts, has BMI calculator for different metrics and audio assistance.
    
 
### :books: Libraries
- [Accompanist](https://github.com/chrisbanes/accompanist)
    
    - Accompanist is a group of libraries that contains some utilities which I've found myself copying around projects which use Jetpack Compose. 
    
- [AndroidCharts](https://github.com/HackPlan/AndroidCharts)
    
    - An easy-to-use Android charts library with animation. 
    
- [Android-Debug-Database](https://github.com/amitshekhariitbhu/Android-Debug-Database)
    
    - A library for debugging android databases and shared preferences - Make Debugging Great Again 
    
- [Butterknife](https://github.com/JakeWharton/butterknife)
    
    - Bind Android views and callbacks to fields and methods.
    
- [Dagger](https://github.com/google/dagger)
    
    - A fast dependency injector for Android and Java. 
    
- [EventBus](https://github.com/greenrobot/EventBus)
    
    - Event bus for Android and Java that simplifies communication between Activities, Fragments, Threads, Services, etc. Less code, better quality. 
   
- [ExoPlayer](https://github.com/google/ExoPlayer)
    
    - ExoPlayer is an application level media player for Android. It provides an alternative to Android’s MediaPlayer API for playing audio and video both locally and over the Internet. ExoPlayer supports features not currently supported by Android’s MediaPlayer API, including DASH and SmoothStreaming adaptive playbacks. 
    
- [FilterLibrary](https://github.com/hgayan7/FilterLibrary)
    
    - Android filter library -This library has 16 filters which can be applied to image bitmaps. 
    
- [Glide](https://github.com/bumptech/glide)
    
    - An image loading and caching library for Android focused on smooth scrolling 
    
- [Gson](https://github.com/google/gson)
    
    -  A Java serialization/deserialization library to convert Java Objects into JSON and back 

- [Junit5](https://github.com/junit-team/junit5/)
    
    - This repository is the home of the next generation of JUnit, JUnit 5.
    
- [Logger](https://github.com/orhanobut/logger)
    
    - Simple, pretty and powerful logger for android 
    
- [Lottie-android](https://github.com/airbnb/lottie-android)
    
    - Render After Effects animations natively on Android and iOS, Web, and React Native 
    
- [MotionToast](https://github.com/Spikeysanju/MotionToast)
    
    - A Beautiful Multipurpose Motion Toast Library in Android using Kotlin heart_eyes

- [MPAndroidChart](https://github.com/PhilJay/MPAndroidChart)
    
    - A powerful Android chart view / graph view library, supporting line- bar- pie- radar- bubble- and candlestick charts as well as scaling, panning and animations. 
    
- [Okhttp](https://github.com/square/okhttp/)
    
    -  Square’s meticulous HTTP client for Java and Kotlin. 
    
- [Picasso](https://github.com/square/picasso)
    
    - A powerful image downloading and caching library for Android
    
- [PreviewSeekBar](https://github.com/rubensousa/PreviewSeekBar)
    
    - A SeekBar suited for showing a preview of something. As seen in Google Play Movies. 
    
- [Retrofit](https://github.com/square/retrofit)
    
    - A type-safe HTTP client for Android and the JVM 

- [RxJava](https://github.com/ReactiveX/RxJava)
    
    - RxJava – Reactive Extensions for the JVM – a library for composing asynchronous and event-based programs using observable sequences for the Java VM. 
 
- [Toasty](https://github.com/GrenderG/Toasty)
    
    - The usual Toast, but with steroids
    
- [ZoomRecylerLayout](https://github.com/Spikeysanju/ZoomRecylerLayout)
    
    - An beautiful Zoom Animation Library for RecyclerView Items in Android using Kotlin.
    
- [Zxing](https://github.com/zxing/zxing)
    
    - ZXing ("Zebra Crossing") barcode scanning library for Java, Android 
    
- [ReactButton](https://github.com/amrdeveloper/reactbutton)
    
    - Android Library to make it easy to add ReactButton feature in your app with Multi Reactions.
    
- [LottieDIalog](https://github.com/amrdeveloper/LottieDIalog)
    
    - Android Library to create Lottie animation view dialog easily with a lot of customization.

- [MathView](https://github.com/derysudrajat/math-view)

    - A Library for displaying math equations in Android
    

### :art: Misc    
- [Android-conferences](https://github.com/jitinsharma/android-conferences)
    
    - An app which displays conferences from http://androidstudygroup.github.io/conferences/
    
- [AndroidTensorFlowMachineLearning](https://github.com/MindorksOpenSource/AndroidTensorFlowMachineLearningExample)
 
    - Android TensorFlow MachineLearning Example (Building TensorFlow for Android) 

- [Android-wikipedia](https://github.com/wikimedia/apps-android-wikipedia)
        
    - The official Wikipedia app for Android! 
    
- [ComposeAcademy-Playground](https://github.com/hitherejoe/ComposeAcademy-Playground)
    
    - Playground project for the Jetpack Compose APIs 
    
- [Compose-pokedex](https://github.com/zsoltk/compose-pokedex)
    
    -  Pokedex on Jetpack Compose 
    
- [CoronavirusWorldStatus](https://github.com/HamdiBoumaiza/CoronavirusWorldStatus)
    
    - An app to stay up to date with the latest stats of the coronavirus , using Kotlin with MVVM ,Coroutines , Android Architecture Components and Dagger 
    
- [CrashReporter](https://github.com/MindorksOpenSource/CrashReporter)
    
    - CrashReporter is a handy tool to capture app crashes and save them in a file. 
    
- [Duckduckgo](https://github.com/duckduckgo/android)
    
    -  DuckDuckGo Android App 
    
- [Iosched](https://github.com/google/iosched)
    
    -  The Google I/O 2019 Android App 
    
- [Jetsurvey](https://github.com/android/compose-samples/tree/master/Jetsurvey)
    
    - Jetsurvey is a sample survey app, built with Jetpack Compose. The goal of the sample is to showcase text input, validation and state capabilities of Compose.
    
- [Kickmaterial](https://github.com/byoutline/kickmaterial)
    
    - Crowdfunding app concept for Android. Created to showcase new trends in Android development with strong focus on Material Design. 
    
- [LeafPic](https://github.com/HoraApps/LeafPic)
     
    - LeafPic is a fluid, material-designed alternative gallery, it also is ad-free and open source under GPLv3 license. It doesn't miss any of the main features of a stock gallery, and we also have plans to add more useful features. 
    
- [MoonShot](https://github.com/haroldadmin/MoonShot)
    
    - MoonShot is a SpaceX companion app to help you keep up with their launches. It uses the SpaceX API to fetch data.
    
- [Openfoodfacts-androidapp](https://github.com/openfoodfacts/openfoodfacts-androidapp)
    
    -  Native version of Open Food Facts on Android - Coders & Decoders welcome 
    
- [Plaid](https://github.com/nickbutcher/plaid)
    
    - An Android app which provides design news & inspiration as well as being an example of implementing material design. 
    
- [Pokedex](https://github.com/skydoves/Pokedex)
    
    - Android Pokedex using Dagger Hilt, Motion, Coroutines, Flow, Jetpack (Room, ViewModel, LiveData) based on MVVM architecture. 
    
- [Ridesharing-uber-lyft-app](https://github.com/MindorksOpenSource/ridesharing-uber-lyft-app)
    
    - Ride-Sharing Uber Lyft Android App - Learn to build a ride-sharing Android Taxi Clone App like Uber, Lyft - Open-Source Project By MindOrks 
    
- [Space-app](https://github.com/ValterKasper/space-app)
    
    - An Android app which shows timeline of upcoming rocket launches and showcases architecture of real application. 
 
- [UAMP](https://github.com/android/uamp)

    - A sample audio app for Android
    
    
### :newspaper: News    
- [Cheddar](https://github.com/adrianblancode/Cheddar/)
    
    - Hacker News reader for Android, written in Compose 
    
- [Flym](https://github.com/FredJul/Flym)
    
    - Flym News Reader is a light Android feed reader (RSS/Atom) 
    
- [JetNews](https://github.com/android/compose-samples/tree/master/JetNews)
    
    - Jetnews is a sample news reading app, built with Jetpack Compose. The goal of the sample is to showcase the current UI capabilities of Compose.
    
- [Materialistic](https://github.com/hidroh/materialistic)
    
    - A material-design Hacker News Android reader 
    
- [NewsFeed](https://github.com/KevinGitonga/NewsFeed)
    
    - A localized News reader Android app powered by newsapi.org 
    
- [NewsFeed-MVI-Dagger](https://github.com/HadySalhab/NewsFeed-MVI-Dagger)
    
    -  Android News Application built in kotlin: MVI+Dagger+NetworkBoundResource+ViewModel+Livedata. 
    
- [Newzz-Compose](https://github.com/Akashkamble/Newzz-Compose)
    
    - News App built with Jetpack Compose 
    
- [Nextcloud News Reader](https://github.com/nextcloud/news-android)

    -  Android client for the Nextcloud news/feed reader app.
    
- [NYTimes-App](https://github.com/TheCodeMonks/NYTimes-App)
    
    - A Simple Demonstration of the New York Times App using Jsoup web crawler with MVVM Architecture
    
- [Awesome NewsApp](https://github.com/Mehranalam/NewsApp)
    
    - A Awesome news app using volley library and picasso library This app uses an open source API for its news sources.


    
### :rocket: Productivity     
- [Studify](https://github.com/cmcodes1/Studify)

    - ☑️ Student Utility Mobile App. Features: Mark Attendance, View Time Table, Create Tasks.

- [AmazeFileManager](https://github.com/TeamAmaze/AmazeFileManager)
     
    - Material design file manager for Android 
    
- [AnExplorer](https://github.com/1hakr/AnExplorer)
    
    - Another Android Explorer ( File Manager ) is an All-in-One Open source file manager. AnExplorer File Manager (File Explorer) is designed for all android devices including Phones, Phablets, Tablets, Chromecast, Wear OS, Android TV and Chromebooks. It's a fully designed with Material guidelines by Google. 
    
- [Clean-Notes](https://github.com/mitchtabian/Clean-Notes)
    
    - Clean Architecture by layer 
    
- [Compose-ShoppingList](https://github.com/QArtur99/Compose-ShoppingList)
    
    - Jetpack compose shopping list app 
    
- [Etar](https://github.com/Etar-Group/Etar-Calendar/)
    
    - An enhanced fork of the AOSP calendar app
    
- [Joplin](https://github.com/laurent22/joplin)
    
    - Joplin - an open source note taking and to-do application with synchronization capabilities for Windows, macOS, Linux, Android and iOS.
    
- [JetpackComposeCalculator](https://github.com/ahmedrizwan/JetpackComposeCalculator)
    
    -  A jetpack compose clone of Android 10 Calculator UI 
    
- [Minimal-Todo](https://github.com/avjinder/Minimal-Todo)
    
    - Material To-Do App 
    
- [MLManager](https://github.com/javiersantos/MLManager)
    
    - A modern, easy and customizable app manager for Android with Material Design 

- [Notes-Central](https://github.com/vidit135g/Notes-Central)
    
    - Simple note taking app. 

- [Omni-Notes](https://github.com/federicoiosue/Omni-Notes)
    
    - Open source note-taking application for Android 

- [Owncloud - Android](https://github.com/owncloud/android)
    
    - The ownCloud Android App 

- [Scarlet-Notes](https://github.com/BijoySingh/Scarlet-Notes)
    
    - Simple yet powerful rich note taking android application, with a lot of flexibilty of usage.
  
- [Linkhub](https://github.com/amrdeveloper/linkhub)
    
    - Open source link manager with folders and widget feature and sort links depend on usage.

- [LeetDroid](https://github.com/cdhiraj40/LeetDroid)

    - LeetDroid is an android client for LeetCode.

- [uhabits](https://github.com/iSoron/uhabits)

    - It is an mobile app that helps you create and maintain good habits, allowing you to achieve your long-term goals. Detailed graphs and statistics show you how your habits improved over time. It is completely ad-free and open source.
    
- [StackOverflow - Community Version](https://github.com/mayorJAY/StackOverflow-Community-Version)

    - This is an Android StackOverflow client application implemented using the MVVM architecture, Retrofit, LiveData, Flow, ViewModel, Repository pattern, View Binding. Users can get to view Questions which have been asked on Stack Overflow; picking a particular Question makes the user view it in detail as well as the Answers provided. Users can also search for a particular problem they are having by typing in a search query or by capturing an image and performing an OCR on it.
  
- [Work Tracker](https://github.com/parmstrong842/WorkTracker)

  - Worktracker is a comprehensive and user-friendly app designed to help you keep a record of your work hours. With its intuitive interface, you can effortlessly log in and out of your shift, no matter where you are. Whether you're clocking in at the office or logging your hours from home, the app has got you covered.

    
### :hammer_and_wrench: Tools

- [GitFox](https://gitlab.com/terrakok/gitlab-client)

    - Client to manage GitLab projects. Clean Architecture implementation

- [Google Science Journal](https://github.com/google/science-journal)

    - Use the sensors in your mobile devices to perform science experiments.

- [Hash Checker](https://github.com/hash-checker/hash-checker)

    - Fast and simple application for generating and comparison hashes from files or text

- [KDEConnect](https://github.com/KDE/kdeconnect-android)

    - KDE Connect is a multi-platform app that allows your devices to communicate (eg: your phone and your computer).

- [Red-moon](https://github.com/LibreShift/red-moon)
    
    - Android screen filter app for night time phone use. 

- [SoundRecorder](https://github.com/dkim0419/SoundRecorder)
    
    - A simple sound recording app implementing Material Design 

- [Turbo-editor](https://github.com/vmihalachi/turbo-editor)
    
    - Simple and powerful File Editor for Android. All is licensed under the GPLv3 license. 

- [Wally](https://github.com/Musenkishi/wally)
    
    - Wally is a fast and efficient wallpaper application for Android 
    
   
   
### :earth_africa: Travel    
- [Cyclestreets](https://github.com/cyclestreets/android)
    
    - CycleStreets is a UK-wide cycle journey planner system, which lets you plan routes from A to B to C by bike. It is designed by cyclists, for cyclists, and caters to the needs of both confident and less confident cyclists.

- [Transportr](https://github.com/grote/Transportr)
    
    - The public transport companion that respects your privacy and your freedom. Transportr is a non-profit app developed by people around the world to make using public transport as easy as possible wherever you are.

- [Travel-Mate](https://github.com/Swati4star/Travel-Mate)
    
    - Travel Mate is an android app for travellers. It provides features like choosing the correct destination, making bookings, and organizing the trip. It provides solutions for every problem a traveller might face during their journey. It provides a comprehensive list of information about a destination: current weather, best places to hangout, and city's current trends. 
    
- [HolidayInfo](https://github.com/mayorJAY/HolidayInfo)
    
    - HolidayInfo is a multi-module, offline-first Android Application that fetches and displays the various holidays observed in different Countries and different years. The App fetches the data from Nager.Date API and uses Room for offline caching. It is implemented using Multi-module, Clean Architecture, Model-View-ViewModel (MVVM) pattern and uses Modern Android Development pattern and libraries.
    
    
    
### :gear: Utilities
- [AnotherMonitor](https://github.com/AntonioRedondo/AnotherMonitor)
    
    - Monitors and records the CPU and memory usage of Android devices

- [Authpass](https://github.com/authpass/authpass)
    
    - AuthPass - Password Manager based on Flutter for all platforms. Keepass 2.x (kdbx 3.x) compatible. 

- [Bitwarden](https://github.com/bitwarden/mobile)
    
    - Password management solution for individuals, teams, and business organizations written in C# with Xamarin Android, Xamarin iOS, and Xamarin Forms. 

- [Earthview-android](https://github.com/PDDStudio/earthview-android)
    
    - A library to include 'EarthView with Google' into your application with ease. 

- [Images-to-PDF](https://github.com/Swati4star/Images-to-PDF)
    
    - An app to convert images to PDF file! 
    
- [Memento-Calendar](https://github.com/alexstyl/Memento-Calendar)
    
    - Memento Calendar is a modern namedays app for Android. This repository contains the source code of Memento Calendar.

- [Moticons](https://github.com/javiersantos/Moticons)

    - A simple, easy and modern app to manage and use Japanese Emoticons with Material Design

- [Photo-affix](https://github.com/afollestad/photo-affix)
    
    - Stitch your photos together vertically or horizontally easily! 

- [Simple-Calendar](https://github.com/SimpleMobileTools/Simple-Calendar)
    
    - A simple calendar with events, customizable widgets and no ads. 

- [Talalarmo](https://github.com/trikita/talalarmo)
    
    - Minimal, simple and beautiful alarm clock thoughtfully designed by nap enthusiasts. 

- [Varis-Android](https://github.com/dkhmelenko/Varis-Android)
    
    - Android client for Travis CI 

- [WiFiKeyShare](https://github.com/bparmentier/WiFiKeyShare)
    
    - Share Wi-Fi passwords with QR codes or NFC tags 
    
- [ImageSearching](https://github.com/MinhyeokOh/android_app_ui)    
    - Quickly find photos stored in the Android gallery using tags, date taken, and location, select one photo to write a diary, and select keyword from the diary to create additional tags

- [Pdfview-Android](https://github.com/Dmitry-Borodin/pdfview-android)
    
    - Small Android library to show PDF files
    
### :partly_sunny: Weather
- [CoolWeather](https://github.com/akoufa/CoolWeather)
    
    -  Weather App that uses Android best practices. Android Jetpack, clean architecture. Written in Kotlin 

- [Good-weather](https://github.com/qqq3/good-weather)
    
    - Open source weather app for Andorid 

- [Weathercast](https://github.com/vidit135g/Weathercast)
    
    - Minimal weather app for Android 

- [WeatherZone](https://github.com/SoumikBhatt/WeatherZone)

    - Simple Weather app for Android following MVVM architecture, and Jetpack Component like Room etc.

- [Sunshine](https://github.com/pragyaSingh13/Sunshine)

    - Weather app to get current weather info of any city around the globe using OpenWeatherMap API.


- [WeatherForecast](https://github.com/Marwa-Eltayeb/WeatherForecast)

    - Weather Forecast App implemented in MVP Architecture using Kotlin that enable users to have instant access to weather data.

## :dart:  **HacktoberFest**
<p align="center">
<img width="720px" src="https://miro.medium.com/v2/resize:fit:1400/1*-QXDiWByW0DozxYYWh_X2g.png" alt="hacktoberfest"></img>
</p>

[Hacktoberfest](https://hacktoberfest.digitalocean.com/) is a month-long celebration of open source software organized by DigitalOcean in partnership with [GitHub](https://github.com/) and [Dev](https://dev.to/). Hacktoberfest is open to everyone in our global community. Whether you’re new to development, a student, long-time contributor, event host, or company of any size, you can help drive growth of open source and make positive contributions to an ever-growing community. All backgrounds and skills levels are encouraged to complete the challenge.

To qualify for the official Hacktoberfest swag options, you must [register](https://hacktoberfest.digitalocean.com/) and make four pull requests between October 1-31. Pull requests can be made to any public repository on GitHub, not just the ones with issues labeled Hacktoberfest. If a maintainer reports your pull request as spam or behavior not in line with [Hacktoberfest’s quality standards](https://hacktoberfest.digitalocean.com/details#quality), you will be ineligible to participate.

You can also check the [swag-list](https://hacktoberfestswaglist.com/) and other companies giving away swags for HacktoberFest.


## :memo:  **Contributing**

See [CONTRIBUTING.md](https://github.com/binaryshrey/Awesome-Android-Open-Source-Projects/blob/master/CONTRIBUTING.md)
