from setuptools import setup
import os

from pyrouge.utils.file_utils import list_files


data_files = list_files('pyrouge/tests/data')
data_files = [p.replace('pyrouge/tests/', '') for p in data_files]
script_files = [os.path.join('bin', s) for s in os.listdir('bin')]

setup(
    name='pyrouge',
    version='0.1.3',
    author='Benjamin Heinzerling, Anders Johannsen',
    author_email='benjamin.heinzerling@h-its.org',
    packages=['pyrouge', 'pyrouge.utils', 'pyrouge.tests'],
    scripts=script_files,
    #test_suite='pyrouge.test.suite',
    package_data={'pyrouge.tests': data_files},
    url='https://github.com/noutenki/pyrouge',
    license='LICENSE.txt',
    description='A Python wrapper for the ROUGE summarization evaluation'
        ' package.',
    classifiers=[
        'Intended Audience :: Science/Research',
        'License :: OSI Approved :: MIT License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3',
        'Topic :: Text Processing :: Linguistic'],
    long_description=open('README.rst').read(),
    )
