from __future__ import print_function, unicode_literals, division

import re


def remove_newlines(s):
    p = re.compile("[\n|\r\n|\n\r]")
    s = re.sub(p, " ", s)
    s = remove_extraneous_whitespace(s)
    return s


def remove_extraneous_whitespace(s):
    p = re.compile("(\s+)")
    s = re.sub(p, " ", s)
    return s


def cleanup(s):
    return remove_newlines(s)
