import argparse

io_parser = argparse.ArgumentParser(add_help=False)
io_parser.add_argument(
    '-i', '--input-files-dir',
    help="Path of the directory containing the files to be converted.",
    type=str, action="store", dest="input_dir",
    required=True
    )
io_parser.add_argument(
    '-o', '--output-files-dir',
    help="Path of the directory in which the converted files will be saved.",
    type=str, action="store", dest="output_dir",
    required=True
    )

ss_parser = argparse.ArgumentParser(add_help=False)
ss_parser.add_argument(
    '-ss', '--split-sentences',
    help="ROUGE assumes one sentence per line as default summary format. Use "
    "this flag to split sentences using NLTK if the summary texts have "
    "another format.",
    action="store_true", dest="split_sents"
    )

rouge_path_parser = argparse.ArgumentParser(add_help=False)
rouge_path_parser.add_argument(
    '-hd', '--home-dir',
    help="Path of the directory containing ROUGE-1.5.5.pl.",
    type=str, action="store", dest="rouge_home",
    required=True
    )

model_sys_parser = argparse.ArgumentParser(add_help=False)
model_sys_parser.add_argument(
    '-mfp', '--model-fn-pattern',
    help="Regexp matching model filenames.",
    type=str, action="store", dest="model_filename_pattern",
    required=True
    )
model_sys_parser.add_argument(
    '-sfp', '--system-fn-pattern',
    help="Regexp matching system filenames.",
    type=str, action="store", dest="system_filename_pattern",
    required=True
    )
model_sys_parser.add_argument(
    '-m', '--model-dir',
    help="Path of the directory containing model summaries.",
    type=str, action="store", dest="model_dir",
    required=True
    )
model_sys_parser.add_argument(
    '-s', '--system-dir',
    help="Path of the directory containing system summaries.",
    type=str, action="store", dest="system_dir",
    required=True
    )
model_sys_parser.add_argument(
    '-id', '--system-id',
    help="Optional system ID. This is useful when comparing several systems.",
    action="store", dest="system_id"
    )

config_parser = argparse.ArgumentParser(add_help=False)
config_parser.add_argument(
    '-c', '--config-file-path',
    help="Path of configfile to be written, including file name.",
    type=str, action="store", dest="config_file_path",
    required=True
    )

main_parser = argparse.ArgumentParser(
    parents=[model_sys_parser], add_help=False)
main_parser.add_argument(
    '-hd', '--home-dir',
    help="Path of the directory containing ROUGE-1.5.5.pl.",
    type=str, action="store", dest="rouge_home",
    )
main_parser.add_argument(
    '-rargs', '--rouge-args',
    help="Override pyrouge default ROUGE command line options with the "
    "ROUGE_ARGS string, enclosed in qoutation marks.",
    type=str, action="store", dest="rouge_args"
    )
