## Disclaimer:
![image](https://user-images.githubusercontent.com/53433312/95980882-6ed14580-0e3b-11eb-80f8-8bdd1717205b.png)

#### Edit 2: You contribution would be counted towards Hacktoberfest if it has been approved or merged or has a "hacktoberfest-accepted" label. It is not mandatory to have all 3 on a particular PR.
![image](https://user-images.githubusercontent.com/53433312/95441866-49929200-0978-11eb-9fcb-adf3c935adba.png)
#### Edit 1: Don't add something if its already there in the same programming language. Try to add quality content. I won't merge, if you are spamming with PRs.




  
  
# Overview
The goal of this project is to help the beginners with their contributions in Open Source. We aim to achieve this collaboratively, so feel free to contribute in any way you want, just make sure to follow the contribution guidelines. You can contribute to it in either of the following ways:


- Beginner/Intermediate:
	- Add a project you have worked on, **if and only if it's not already present in the repository.**
- Expert:
	- Add a graphical game in your favorite programming language, **if and only if it's not already present in the repository.**
	- Add a ML project you have worked on.

# HacktoberFest-2020

Open source is changing the world - one pull request at a time. 


- [HacktoberFest-2020](#hacktoberfest-2020)
  - [What is Hacktoberfest?](#what-is-hacktoberfest)
  - [Why Should I Contribute?](#-why-should-i-contribute)
  - [What Can I Contribute?](#what-can-i-contribute)
  - [How to Contribute in this repo.](#how-to-contribute-in-this-repo)

## What is Hacktoberfest?

Hacktoberfest is a month long virtual festival event to celebrate open source contributions presented by Digital Ocean and DEV. It is the easiest way to get into open source!

During the entire month of October 2020, all you have to do is contribute to any open source projects and open at least 4 pull requests. Yes, any project and any kind of contributions.

## Why Should I Contribute?

The Hacktoberfest’s simple plain objective is:
Support open source and earn a limited edition T-shirt!
But, it’s not just about the t-shirts or stickers. Its about supporting open source. Its about celebrating open source, and giving it back. If you’ve never contributed to open source before, this is the perfect time to get started because Hacktoberfest provides a large list of available contribution opportunities.

## What Can I Contribute?

Hacktoberfest® is open to everyone in our global community. Whether you’re a developer, student learning to code. You can contribute to anything from code to simple fix, new feature to grammar mistake.

## How to Contribute in this repo.

Contributing to open-source is easy.


- Fork the repository
- Improve current program by
  - improving functionality
  - adding new feature
  - improving the documentation
- Push your work and Create a Pull Request

[Click here for detailed explanation](/Contribute.md)

## What if my pull requests aren’t accepted?

Even if your pull requests aren’t accepted, they should still count toward your 4 pull requests necessary to earn the shirt. The only exception would be if the project maintainer chooses to mark your pull request as “invalid”. They may do this if they perceive your pull request to be low effort, or if it contains plagiarism.

## What kinds of pull requests count toward earning the Hacktoberfest shirt?
Any pull request made to a public repo on GitHub will count. The pull request must contain commits you personally made yourself — not automated commits from bots.

You can contribute to any open source project hosted on Github.com and contribute anything between October 1 to October 31 midnight in 2020. You will find plenty of issues labeled with hacktoberfest or good-first-issue etc on Github. These will be the simple ones most probably and easy to fix.


---
## References

- [Hacktoberfest presented by DigitalOcean](https://hacktoberfest.digitalocean.com/)
- [A participation guide for Hacktoberfest](https://dev.to/zenika/a-participation-guide-for-hacktoberfest-19c1)
- [What is Hacktoberfest and How can a beginner contribute?](https://medium.com/@bawantharathnayaka/what-is-hacktoberfest-and-how-can-a-beginner-contribute-39cf2081804e)
- [Hacktoberfest 2019: How you can get your free shirt — even if you’re new to coding](https://www.freecodecamp.org/news/hacktoberfest-2018-how-you-can-get-your-free-shirt-even-if-youre-new-to-coding-96080dd0b01b/)
