## Target Timeline for Executing the PSIP Process

PSIP is an iterative process where each iteration may take weeks or months to complete.  This document describes a suggested timeline and issues to consider when applying PSIP to a specific project.

Roles in the process are:
- **Software Team:** The group of people developing a software product and using PSIP to improve software practices.
- **Interview Lead:** The person setting up and leading the interview process.
- **PSIP Shepherd:** The person from the PSIP Interview team who monitors and assists the software team throughout the PSIP process over the span of weeks needed to complete a PSIP iteration.
- **PSIP Interview Scribes:** Interview team members who will actively capture interview discussions.

We use the START label to indicate the date when the interview and software team meet to create or revise the Software Practices Document (Step one in the [PSIP workflow diagram](SwPspWorkflow.jpg)).  Other times are given relative to this date in number of weeks.

### Timeline

The following table shows target dates **in weeks** relative to START for each phase.  For example, if the start date is June 28, `-2` in the Date column is June 14. Additional columns list who is involved and provide a brief description of activities.

| Phase                   | Date       | Participants    | Activity |
|:-------------:          |:-----:     |:---------------:|----------|
| **Invitation**          | - 4 weeks  | Interview Lead  | Send an invitation to the software project team. Point them to the PSIP Overview. A [Letter Template](../interviews/IntroductoryLetterTemplate.md) is available.  Include a link to the [Information Policy](../PSIPInformationPolicy.md) in the invitation.
| **PSIP Preparation**    | - 3 weeks  | Interview Lead  | If you receive a positive response, send the software team a link to the [PSIP Overview](../PSIP-Overview.md), asking them to review it and identify questions they may have prior to the interview.
| **Plan the Interview**      | -2 weeks   | All             | Determine participants: Who will lead the interview, who will take notes, who will lead responses from the software team.  Send out meeting participation information (room, video or teleconference). Review the [PSIP Interviewers Guide](../interviews/SoftwareTeamInterviewerGuide.md).
| **Pre-Interview Check** | - 1 week   | Interview Lead  | Contact software project team asking if there are questions about the PSIP scope and preparations.
| **Interview**           | START      | All             | Conduct interview using the [PSIP process](../README.md).  Make sure that all expected outcomes from the interview are completed. Set date for first follow up, which should be in about a week.
| **First Follow-up**     | + 1        | Shepherd, software team | Contact software team to check on progress toward creating productivity improvement plan and progress tracking cards.
| **Second Follow-up**    | + 4        | Shepherd, software team | Contact software team to check on progress toward improving selected practices, identify any impediments and requests for information to improve progress tracking scores.
| **Complete PSIP Goals**  | + 8        | Software team           | Software team completes practice improvement goals established in their plan.
| **Wrap-up**             | + 8        | Shepherd, software team | Goal completion status is reviewed. Progress tracking card is scored. All artifacts (initial PTC scores, PSIP plan and final scores) are retained in the team permanent repository.
