### Productivity and Sustainability Improvement Planning (PSIP) Tools

This repository contains a collection of documents that support an iterative planning process for improving scientific software developer productivity and product sustainability through improved software practices, processes and tools.

#### Key Repository Documents

- [PSIP Information Policy:](interviews/PSIPInformationPolicy.md) This document describes how we will handle information collected from software teams, with the intent to enable trusted conversations.
- [Overview of the PSIP Process:](PSIP-Overview.md) This document provides and overview of PSIP and a step by step description of how to execute the planning process.
- [Timeline for Completing a PSIP Cycle:](process/PSIP-Timeline.md) While a PSIP cycle can vary in length, we provide a 12-week sketch of typical activities to complete one cycle.
- [Interviewer Guide:](interviews/SoftwareTeamInterviewerGuide.md) The PSIP process starts with a team interview, where a brief sketch of a team's software activies are gathered.  This sketch serves as the foundation for subsequent practice improvement efforts.
- [Interview Template:](interviews/SoftwareTeamInterviewTemplate.md) This document contains a set of interview prompts that facilitate discusion and recording of a team's current approach to software product development.  It is written in plain language to facilitate an accessible discussion and to avoid misuse and lack of understanding that can come from using formal software engineering terms that may not be well or consistently understood.
- [Progress Tracking Card (PTC) Construction Guide:](PTCs/README.md) This document gives some background on the philosophy and structure of PTCs, and instructions for how to construct a good PTC.

#### PSIP Training

The PSIP interview process is intended to gain knowledge of how a scientific software team gets it work done.  The interview process explicitly avoids the use of software engineering terminology in order to facilitate a thorough and accessible discussion.  Effective use of this tool does require some training.  Please contact Mike Heroux <maherou@sandia.gov> if you are interested in using it.
