# Progress Tracking Cards

An essential aspect of the PSIP process is defining goals and tracking progress.  A Progress Tracking Cards (PTC) is a brief structured document that lists concrete steps toward a specific productivity and sustainability goal.

### Pre-requisites

Selecting the specific productivity or sustainability improvement effort to pursue is critical.  A poor selection can result in no progress, or in a trivial result.  A key analysis step is to make sure that any proposed improvement effort is not blocked by some other impediment that must be addressed first.  As you define a progress tracking card, discuss possible impediments with the team.  If there is an impediment, you may want the first PTC to focus on that impediment.

### PTC Steps

Each PTC step is given a score.  A score of 0 is the baseline, indicating a team's current approach, regardless of how advanced it is.  Most PTCs will have a top score of 3, 4 or 5, meaning there are 3 to 5 steps on the way to the goal.  The completion of each step should itself provide tangible value to the team beyond making partial progress to the final goal.

### About PTC Scores

PTC values are meant to be ordinal, not cardinal.  In other words, the values are not meant to indicate a global calibration of how well a team conducts a certain practices.  Scores are used within a team to track progress.  They should not be used to assess practices across teams.

### PTC Examples

- [Coverage Testing Template:](./CoverageTestingPractice/CoverageTestingPractice.jpg) [[PPTX Source]](./CoverageTestingPractice/CoverageTestingPractice.pptx) Sample card template for a team wanting to improve the fraction of its code that is tested.  Statements should be customized and made precise for the team's goals.
- [Source Management Template:](./SourceManagementPractice/SourceManagementPractice.jpg) [[PPTX Source]](./SourceManagementPractice/SourceManagementPractice.pptx) Sample card template for a team wanting to introduce or improve source code management.  Statements should be customized and made precise for the team's goals.
- [Unit Testing Example:](./UnitTestingExample/UnitTestingExample.jpg) [[PPTX Source]](./UnitTestingExample/UnitTestingExample.pptx) Example card taken from a project where the team was starting a refactoring effort and wanted to establish a comprehensive and sustainable unit testing capability.
