## Test Coverage Progress Tracking

Use this issue to track overall progress towards the long-term goal of *better test coverage*.
As progress is made check these items off:

- [ ] Functional testing via users.
      Little or no independent testing.
- [ ] Independent functional testing of primary capabilities.
- [ ] Primary functional testing, some unit test coverage.
- [ ] Comprehensive unit testing, primary functional testing.
- [ ] Functional testing for documented use cases.
- [ ] Test coverage commitment.

This PTC is provided as an example. Statements should be customized and made precise for the team's goals.

### Definitions:

- **Functional testing**: Testing capabilities from user's perspective. Many functions can be called. Good for usability assurance. Insufficient to protect against some regressions. Difficult to isolate regressions. Can require extensive execution times.
- **Unit testing**: Isolated, independent testing of functions and methods. Enable test-driven development, rapid test execution, and fault isolation. Insufficient to ensure functional correctness.
- **Comprehensive**: Does not mean 100% line coverage, but sufficient coverage to detect most errors. Experts suggest various metrics such as >80% line coverage or a high percentage of function coverage.
- **Commitment**: Team is committed to writing comprehensive tests concurrent with functionality.
