﻿using System;
using System.ComponentModel.DataAnnotations;
using Vidly_MVCProject.Models;

namespace Vidly_MVCProject.Dtos
{
    public class CustomerDto : IDto
    {
        public int Id { get; set; }

        [Required(ErrorMessage = "Please enter customer's name.")]
        [StringLength(255)]
        public string Name { get; set; }

        public DateTime? Birthdate { get; set; }

        public bool IsSubscribedToNewsletter { get; set; }

        [Min18YearsIfAMember]
        public byte MembershipTypeId { get; set; }

        public MembershipTypeDto MembershipType { get; set; }
    }
}