---
title: Contributing
pagination: false
---

# Contributing

We welcome contributions to Boox! If you'd like to help improve the library, here are some ways you can contribute:

## Reporting Bugs

If you encounter a bug while using Boox, please report it on the [Boox repository](https://github.com/{{repoPath}}). When reporting a bug, please provide the following information:

- A clear and concise description of the bug.
- Steps to reproduce the bug.
- Expected behavior and actual behavior.
- Any relevant code snippets or error messages.

## Suggesting Features

If you have ideas for new features that would improve Boox, please create an issue on the GitHub repository to discuss your proposal.

## Contributing Code

If you'd like to contribute code to Boox, please follow these steps:

1. Fork the Boox repository on GitHub.
2. Create a new branch for your changes.
3. Make your changes and commit them with clear and descriptive commit messages.
4. Push your changes to your fork.
5. Create a pull request on the Boox repository.

Please make sure your code adheres to the following guidelines:

- Follow the existing code style and conventions.
- Write clear and concise code.
- Add comments to explain your code.
- Include tests for any new functionality or bug fixes.

## Contributing Documentation

If you'd like to contribute to the Boox documentation, please feel free to suggest improvements or create pull requests with your changes.

## Other Ways to Contribute

There are other ways to contribute to Boox, such as:

- Answering questions on the GitHub repository or Stack Overflow.
- Writing blog posts or tutorials about Boox.
- Spreading the word about Boox to other developers.

We appreciate all contributions to Boox!

## Commit Guidelines

When committing code, please follow the [semantic-release commit standards](https://www.conventionalcommits.org/). This helps us automate the release process and generate meaningful changelogs.

To make it easier to follow these standards, we recommend using commitizen. You can install it globally using:

```bash
npm install -g commitizen cz-conventional-changelog
```

Then, you can use `git cz` instead of `git commit` when committing your changes.

Thank you for your contributions!
