# <img src="https://stilearning.com/boox/boox-logo.svg?v1" width="24" /> Boox

Boox is a lightweight, zero-dependency full-text search library designed for both browser and Node.js. It enables you to efficiently search through multiple documents and datasets, returning relevant results based on your queries.

## Documentation

Go to [Boox documentation](https://stilearning.com/boox).

# Integration

Boox is designed to be flexible and can be easily integrated with other libraries and frameworks to enhance your search functionality. The key is to manage the search state and update the UI based on the search results returned by Boox. Here are some examples of how you can integrate Boox with popular tools:

- [Vanilla JavaScript](https://github.com/bent10/boox/tree/main/examples/vanilla)
- [React](https://github.com/bent10/boox/tree/main/examples/react)
- [Vue.js](https://github.com/bent10/boox/tree/main/examples/vue)
- [Svelte](https://github.com/bent10/boox/tree/main/examples/svelte)
- [Angular](https://github.com/bent10/boox/tree/main/examples/angular)
- [Express.js](https://github.com/bent10/boox/tree/main/examples/express)
- [Next.js](https://github.com/bent10/boox/tree/main/examples/nextjs)

## Contributing

We 💛&nbsp; issues.

When committing, please conform to [the semantic-release commit standards](https://www.conventionalcommits.org/). Please install `commitizen` and the adapter globally, if you have not already.

```bash
npm i -g commitizen cz-conventional-changelog
```

Now you can use `git cz` or just `cz` instead of `git commit` when committing. You can also use `git-cz`, which is an alias for `cz`.

```bash
git add . && git cz
```

## License

![GitHub](https://img.shields.io/github/license/bent10/boox)

A project by [Stilearning](https://stilearning.com) &copy; 2024.
