/* tslint:disable: max-line-length */

export const asciiLogo: string[] =
				 ['___________________________________________________________',
				  '',
				  ' _____  _    _ _______  ______ _______ _____ __   _ ______ ',
				  '|     |  \\  /  |______ |_____/ |  |  |   |   | \\  | |     \\',
				  '|_____|   \\/   |______ |    \\_ |  |  | __|__ |  \\_| |_____/',
				  '',
				  '_______________________ Screeps AI ________________________'];

export const asciiLogoSmall: string[] =
				 [' _____  _    _ _______  ______ _______ _____ __   _ ______ ',
				  '|     |  \\  /  |______ |_____/ |  |  |   |   | \\  | |     \\',
				  '|_____|   \\/   |______ |    \\_ |  |  | __|__ |  \\_| |_____/'];

export const asciiLogoRL: string[] =
				 [' _____  _    _ _______  ______ _______ _____ __   _ ______ ',
				  '|     |  \\  /  |______ |_____/ |  |  |   |   | \\  | |     \\',
				  '|_____|   \\/   |______ |    \\_ |  |  | __|__ |  \\_| |_____/',
				  '....... R E I N F O R C E M E N T   L E A R N I N G .......'];


const _logoComponents: { [part: string]: { style: PolyStyle, points: [number, number][] } } = {
	black : {
		style : {fill: '#000000', stroke: '#000000', strokeWidth: 0},
		points: [[-4.4, -0.34], [-3.44, -1.04], [-3.08, -1.04], [-2.78, -0.82], [-2.7, -0.6], [-2.92, -0.24], [-3.36, -0.24], [-3.58, -0.5], [-3.8, -0.28], [-4.14, 0.42], [-4.22, 1.24], [-3.6, 0.42], [-2.98, 0.46], [-2.84, 0.72], [-2.9, 1.02], [-3.26, 1.22], [-3.68, 1.12], [-3.72, 1.22], [-3.76, 2.18], [-3.58, 2.9], [-3.22, 1.8], [-2.72, 1.66], [-2.4, 2.08], [-2.64, 2.44], [-3.1, 2.42], [-3.1, 2.86], [-2.86, 3.4], [-2.52, 3.74], [-2.58, 3.08], [-2.34, 2.86], [-1.98, 2.82], [-1.48, 3.12], [-1.34, 3.72], [-1.64, 4.16], [-2.08, 4.32], [-2.78, 4.24], [-3.4, 3.84], [-3.02, 4.34], [-2.56, 4.6], [-0.94, 4.78], [4.0e-2, 4.5], [0.86, 3.9], [-0.44, 3.18], [-0.46, 2.86], [0.88, 2.84], [2.02, 3.2], [3.1, 2.22], [4.18, 0.6], [4.54, -1], [3.84, 0], [3.5, 0.12], [3.18, 2.0e-2], [3.14, -0.46], [3.38, -0.6], [3.82, -0.5], [4, -0.94], [4.08, -1.88], [3.96, -2.6], [3.56, -1.54], [3.16, -1.22], [2.78, -1.28], [2.6, -1.6], [2.7, -1.88], [2.96, -2.02], [3.4, -1.92], [3.46, -2.12], [3.38, -2.98], [2.9, -3.98], [2.52, -4.32], [2.7, -3.58], [2.54, -2.82], [2.22, -2.38], [1.7, -2.36], [1.48, -2.64], [1.56, -3.1], [2.18, -3.24], [1.94, -3.9], [1.2, -4.62], [0.14, -5.14], [0.88, -4.18], [0.9, -3.54], [0.66, -3.04], [0.3, -2.82], [-0.14, -2.9], [-0.2, -3.42], [0.28, -3.66], [-0.38, -4.16], [-1.26, -4.32], [-2.4, -4.22], [-1.64, -4.02], [-1.08, -3.64], [-0.82, -3.04], [-0.88, -2.56], [-1.12, -2.4], [-1.5, -2.44], [-1.68, -2.7], [-1.56, -3.12], [-1.84, -3.2], [-2.72, -3.16], [-3.44, -2.84], [-3.98, -2.34], [-3.38, -2.5], [-2.48, -2.36], [-2.12, -2.12], [-2.06, -1.7], [-2.18, -1.52], [-2.56, -1.44], [-2.82, -1.6], [-2.84, -2.06], [-3.38, -1.84], [-4.06, -1.18], [-4.4, -0.36]],
	},
	blue  : {
		style : {fill: '#6482B0', stroke: '#6482B0', strokeWidth: 0},
		points: [[-2.48, -0.72], [-1.5, -0.34], [-1.18, -0.88], [-0.74, -1.24], [-6.0e-2, -1.46], [0.54, -1.44], [0.94, -1.34], [1.82, -0.46], [2.74, -0.9], [2.92, -0.42], [3.02, 0.32], [2.9, 1.02], [2.52, 1.86], [1.94, 2.5], [1.2, 2.94], [0.82, 2.02], [1.32, 1.72], [1.56, 1.48], [1.8, 1.1], [1.98, 0.44], [1.94, 0], [1.8, -0.46], [0.94, -1.36], [1.34, -2.3], [0.5, -2.54], [-0.12, -2.54], [-0.86, -2.36], [-1.38, -2.1], [-1.82, -1.76], [-2.26, -1.22], [-2.48, -0.74]],
	},
	red   : {
		style : {fill: '#EA3747', stroke: '#EA3747', strokeWidth: 0},
		points: [[0.94, -1.3], [1.28, -1.08], [1.58, -0.78], [1.78, -0.46], [2.7, -0.92], [2.72, -1], [2.44, -1.46], [2.02, -1.9], [1.42, -2.28], [0.94, -1.32]],
	},
	pink  : {
		style : {fill: '#FF0080', stroke: '#FF0080', strokeWidth: 0},
		points: [[-1.4, 0.32], [-0.92, 0.2], [-0.46, -6.0e-2], [-8.0e-2, -0.5], [0.12, -0.98], [0.14, -1.18], [0.2, -1.18], [0.22, -0.98], [0.4, -0.54], [0.8, -6.0e-2], [1.26, 0.2], [1.74, 0.32], [1.62, 0.3], [1.62, 0.36], [1.26, 0.44], [0.78, 0.72], [0.38, 1.22], [0.18, 1.84], [-6.0e-2, 1.18], [-0.46, 0.7], [-0.92, 0.44], [-1.38, 0.34]],
	},
	lgray : {
		style : {fill: '#ABB7C5', stroke: '#ABB7C5', strokeWidth: 0},
		points: [[-2.64, 1.04], [-2.34, 1.78], [-2.06, 2.18], [-1.56, 2.64], [-0.98, 2.96], [-0.62, 3.08], [-0.52, 3.06], [-0.28, 2.06], [-0.72, 1.88], [-1.06, 1.62], [-1.36, 1.26], [-1.58, 0.76], [-2.56, 0.94], [-2.64, 1.02]],
	},
	purple: {
		style : {fill: '#2F0092', stroke: '#2F0092', strokeWidth: 0},
		points: [[-1.48, 0.4], [-1.38, -0.24], [-1.04, -0.8], [-0.46, -1.2], [0.22, -1.32], [0.14, -1.24], [0.1, -0.94], [-8.0e-2, -0.52], [-0.42, -0.1], [-0.84, 0.16], [-1.4, 0.3], [-0.94, 0.44], [-0.34, 0.82], [4.0e-2, 1.4], [0.18, 1.88], [0.32, 1.36], [0.72, 0.78], [1.28, 0.44], [1.74, 0.34], [1.06, 0.1], [0.6, -0.26], [0.24, -0.94], [0.2, -1.24], [0.28, -1.32], [0.74, -1.22], [1.18, -0.98], [1.46, -0.7], [1.72, -0.24], [1.82, 0.26], [1.78, 0.68], [1.6, 1.14], [1.28, 1.54], [0.84, 1.82], [0.46, 1.94], [0.18, 1.98], [-0.46, 1.84], [-0.82, 1.64], [-1.22, 1.2], [-1.4, 0.82], [-1.46, 0.4]]
	},
	dgray : {
		style : {fill: '#303030', stroke: '#303030', strokeWidth: 0},
		points: [[-2.42, 0.52], [-2.4, -8.0e-2], [-2.28, -0.56], [-1.52, -0.3], [-1.62, 0.24], [-1.58, 0.7], [-0.2, 2.06], [0.34, 2.1], [0.8, 2.02], [1.06, 2.7], [1.04, 2.78], [0.54, 2.92], [6.0e-2, 2.94], [-0.42, 2.86], [-0.22, 2.06], [-0.26, 2.08], [-1.6, 0.7], [-2.36, 0.86], [-2.4, 0.52]]
	},
};

const _logoText: { [char: string]: { coords: [number, number], style: PolyStyle, points: [number, number][] } } = {
	V : {
		coords: [75, 500],
		style : {fill: '#6b6b6b', stroke: '#6b6b6b', strokeWidth: 0},
		points: [[-3.94, -3.7], [-3.72, -3.86], [-3.58, -3.68], [-1, 2.54], [-0.62, 2.9], [-0.16, 2.96], [0.46, 2.6], [3.1, -3.72], [3.38, -3.82], [3.4, -3.56], [0.86, 2.52], [0.48, 3.04], [0, 3.26], [-0.66, 3.22], [-1.26, 2.72], [-3.92, -3.68]]
	},
	E : {
		coords: [500, 880],
		style : {fill: '#6b6b6b', stroke: '#6b6b6b', strokeWidth: 0},
		points: [[-4.28, 0.52], [-4.1, 1.3], [-3.7, 2.04], [-3.12, 2.64], [-2.4, 3.06], [-1.64, 3.26], [1.4, 3.2], [1.4, 3], [1.16, 2.9], [-1.5, 2.92], [-2.2, 2.76], [-3.14, 2.16], [-3.76, 1.2], [-3.92, 0.52], [-3.84, -0.12], [0.84, -0.12], [0.96, -0.24], [0.78, -0.48], [-3.9, -0.48], [-3.92, -1.12], [-3.7, -1.94], [-3.26, -2.62], [-2.6, -3.16], [-1.46, -3.52], [1.38, -3.56], [1.4, -3.8], [1.2, -3.88], [-1.42, -3.88], [-2.82, -3.44], [-3.88, -2.36], [-4.28, -1.12], [-4.26, 0.52]]
	},
	R1: {
		coords: [850, 1000],
		style : {fill: '#6b6b6b', stroke: '#6b6b6b', strokeWidth: 0},
		points: [[-4.36, 3.1], [-4.36, -2.56], [-4.26, -2.96], [-3.82, -3.56], [-3.38, -3.8], [-1.88, -3.88], [-1.78, -3.5], [-3.2, -3.48], [-3.58, -3.3], [-3.88, -2.94], [-4, -2.54], [-4, 0.3], [-1.78, 0.36], [-1.9, 0.38], [-1.96, 0.72], [-1.78, 0.74], [-3.98, 0.74], [-3.98, 3.06], [-4.1, 3.26], [-4.3, 3.24], [-4.34, 3.1]]
	},
	R2: {
		coords: [1000, 1200],
		style : {fill: '#6b6b6b', stroke: '#6b6b6b', strokeWidth: 0},
		points: [[-4.78, 0.74], [-4.78, 0.36], [-3.1, 0.36], [-2.22, -2.0e-2], [-1.62, -0.78], [-1.46, -1.78], [-1.74, -2.58], [-2.38, -3.22], [-3.28, -3.52], [-4.78, -3.5], [-4.7, -3.86], [-4.78, -3.88], [-3.12, -3.86], [-2.12, -3.48], [-1.62, -3.02], [-1.26, -2.42], [-1.1, -1.78], [-1.2, -0.88], [-1.56, -0.18], [-2.04, 0.3], [-2.64, 0.62], [-3.4, 0.8], [-1.22, 2.96], [-1.22, 3.24], [-1.44, 3.26], [-3.94, 0.74], [-4.76, 0.72]]
	},
	M : {
		coords: [1200, 1799],
		style : {fill: '#6b6b6b', stroke: '#6b6b6b', strokeWidth: 0},
		points: [[-3.82, 3.14], [-3.6, 3.28], [-3.48, 3.08], [-2.52, -3.48], [-2.26, -3.52], [-2.1, -3.34], [0.28, 3.04], [0.56, 3.26], [0.9, 3.28], [1.3, 2.92], [3.62, -3.34], [3.88, -3.54], [4.14, -3.3], [5.02, 3.16], [5.28, 3.26], [4.44, -3.4], [4.28, -3.7], [3.98, -3.84], [3.56, -3.76], [3.34, -3.48], [1.02, 2.78], [0.78, 2.98], [0.52, 2.82], [-1.88, -3.6], [-2.24, -3.84], [-2.78, -3.68], [-3.8, 3.12]]
	},
	I : {
		coords: [1750, 1850],
		style : {fill: '#6b6b6b', stroke: '#6b6b6b', strokeWidth: 0},
		points: [[-4.58, 3.1], [-4.32, 3.26], [-4.2, 3.06], [-4.2, -3.66], [-4.46, -3.86], [-4.58, -3.7], [-4.56, 3.1]]
	},
	N : {
		coords: [1850, 2250],
		style : {fill: '#6b6b6b', stroke: '#6b6b6b', strokeWidth: 0},
		points: [[-4.46, 3.16], [-4.46, -3.4], [-4.34, -3.66], [-3.88, -3.88], [-3.4, -3.64], [1.52, 2.74], [1.84, 2.96], [2.12, 2.64], [2.12, -3.76], [2.36, -3.82], [2.42, 2.8], [2.28, 3.08], [1.66, 3.26], [1.38, 3.08], [-3.62, -3.4], [-3.96, -3.54], [-4.16, -3.28], [-4.16, 3.16], [-4.44, 3.18]]
	},
	D : {
		coords: [2250, 2700],
		style : {fill: '#6b6b6b', stroke: '#6b6b6b', strokeWidth: 0},
		points: [[-4.12, 1.82], [-3.76, 2.78], [-2.8, 3.28], [-0.36, 3.24], [0.3, 3.04], [1.14, 2.5], [1.78, 1.68], [2.08, 0.84], [2.04, -1.6], [1.68, -2.44], [1.06, -3.16], [0.28, -3.64], [-0.56, -3.86], [-2.88, -3.86], [-3, -3.82], [-2.92, -3.48], [-0.32, -3.46], [0.52, -3.12], [1.2, -2.52], [1.6, -1.84], [1.78, -1.1], [1.78, 0.54], [1.38, 1.68], [0.68, 2.42], [-0.38, 2.88], [-2.78, 2.92], [-3.5, 2.54], [-3.74, 1.98], [-3.74, -2.58], [-3.46, -3.18], [-2.94, -3.48], [-3.06, -3.82], [-3.72, -3.42], [-4.08, -2.72], [-4.1, 1.8]]
	},
};

const logoX = 2.5; // x-position of logo
const logoY = 3.0; // y position of logo
const logoScale = 0.6;
export const logoComponents = _.mapValues(_logoComponents,
										  c => ({
											  style : c.style,
											  points: _.map(c.points, xy => [logoX + logoScale * xy[0],
																			 logoY + logoScale * xy[1]])
										  })) as { [part: string]: { style: PolyStyle, points: [number, number][] } };


const textX = logoX + 5.6 * logoScale; // x-position of logo
const textY = logoY + .5 * logoScale; // y position of logo
const textScale = 0.6 * logoScale;
const charScale = 0.052 * textScale;

let offset = 0;
export const logoText = _.mapValues(_logoText, function(c) {
	const ret = {
		style : c.style,
		points: _.map(c.points, xy => [textX + textScale * (offset + xy[0]),
									   textY + textScale * xy[1]])
	};
	offset += charScale * (c.coords[1] - c.coords[0]);
	return ret;
}) as { [part: string]: { style: PolyStyle, points: [number, number][] } };


