# 6.逻辑斯蒂回归与最大熵

### 知识树

Knowledge tree

![1618835422531](assets/1618835422531.png)

相较前面的算法，性能更好，也更符合工业场景



### 一个逻辑斯蒂回归回归的故事

A story about the Logistic regression

1. 之前的f(x) = sign(w*x+b)只输出+1和-1，这样的判别方式真的有效吗？
2. 超平面左侧0.001距离的点和超平面右侧0.001距离的点真的有天壤之别吗？

![1618839609843](assets/1618839609843.png)

> 如上面两个黑点，明明只差分毫，却变成了+1或者-1。这也是感知机的缺陷

**我们想要解决的：**

1. 怎么解决极小距离带来的+1和-1的天壤之别
2. 怎么让最终的预测式子连续可微



### 逻辑斯蒂回归

Logistic regression

![1618844224722](assets/1618844224722.png)

![1618844241748](assets/1618844241748.png)

![1618844289114](assets/1618844289114.png)



> 连续可微
>
> 可输出概率



**参数估计：**

由上面的式子可知，里面参数只有w和x，x为已知的特征，也就是更新w即可

逻辑斯蒂回归模型学习时，对于给定的训练数据集T={(x1,y1), (x2,y2), ...,(xn,yn)}，可以应用极大似然估计法估计模型参数，从而得到逻辑斯蒂回归模型。

设：![1618849843275](assets/1618849843275.png)

> Y=1和Y=0相加时为1，所以当Y=1=π(x)，那么Y=0就等于1-π(x)

似然函数为

![1618849856107](assets/1618849856107.png)

> 当前的条件做连乘，变换成log则是相加

对数似然函数为

![1618849880623](assets/1618849880623.png)

对L(w)求极大值，得到w的估计值

**似然函数对w求导：**

![1618850290883](assets/1618850290883.png)

![1618850302122](assets/1618850302122.png)

![1618850312660](assets/1618850312660.png)



### 总结

Summarization

1. 逻辑斯蒂以输出概率的形式解决了极小距离带来的+1和-1的天壤之别，同时概率也可作为模型输出的置信程度。
2. 逻辑斯蒂使得了最终的模型函数连续可微，训练目标与预测目标达成一致。
3. 逻辑斯蒂采用了较大似然估计来估计参数。



### 一个最大熵的小故事

A story about the Maximum entropy model

我们去到拉斯维加斯赌场

问1：我手里有个骰子，问你扔下去后某个面朝上的概率是多少？

答1：都是1/6，因为概率相同



问2：我竟然认为有道理，可如果是老千手里的骰子呢？你还觉得是1/6吗？

答2：可是你没说是老千手里的



问3：可是为什么你不去假设可能是老千手里的骰子这种情况？

答3：因为你没说是老千手里的



问4：好像是这么个道理，如果要考虑老千，那可能还要考虑骰子是否破损，桌面是否有问题

答4：所以1/6最保险



问5：如果我告诉你，1朝上的概率是1/2呢？

答5：那剩下的就是1/10



**什么是最大熵？**

在我们猜测概率时，不确定的部分我们认为是等可能的，就像骰子一样，我们知道有6个面，因此认为每个面的概率是1/6，也就是等可能。

换句话说，就是趋向于均匀分布，最大熵使用的就是这么朴素的道理：

​	凡是我们知道的，就把它考虑进去，凡是不知道的，通通均匀分布。



### 最大熵模型

Maximum entropy model

终极目标：P(Y|X)

熵：![1619102072918](assets/1619102072918.png)

将终极目标代入熵：

![1619102101155](assets/1619102101155.png)

做些改变，调整熵：

![1619102153364](assets/1619102153364.png)

我们手里有训练集，包含所有样本及对应的标签。

![1619102378061](assets/1619102378061.png)

> v表示数目，满足X=x，Y=y的数目
>
> 统计出来概率，通过频数

![1619102385980](assets/1619102385980.png)



**特征函数**

其作用是为了将某个特征x，进行一些转换后，让它和标签y起到重大的相关作用

![1619102621448](assets/1619102621448.png)

特征函数f(x,y)关于经验分布，![1619102676233](assets/1619102676233.png)的期望值：

![1619102692422](assets/1619102692422.png)

特征函数f(x,y)关于模型P(Y|X)与经验分布![1619102890428](assets/1619102890428.png)的期望值：

![1619102909494](assets/1619102909494.png)

> 下面的P表示真实世界中全部数据的分布，即训练集不可能用上全部的数据，一般都是某段时间的，比如N年，所以用![1619103339948](assets/1619103339948.png)表示它是真实的全部时间P中的某段的经验分布

约束：![1619103420910](assets/1619103420910.png)

> 希望训练集的和真实的全部数据是一致的分布



max

![1619103794313](assets/1619103794313.png)

![1619103711622](assets/1619103711622.png)

> fi表示让所有的特征都满足约束条件

min

![1619103835595](assets/1619103835595.png)

![1619103802671](assets/1619103802671.png)



**拉格朗日乘子法：**

![1619103884422](assets/1619103884422.png)

![1619103914972](assets/1619103914972.png)

> 求最小的值

![1619103936518](assets/1619103936518.png)

![1619103949860](assets/1619103949860.png)



### 总结

Summarization

1. 最大熵强调不提任何假设，以熵最大为目标。

2. 将终极目标代入熵的公式后，将其最大化。

3. 在训练集中寻找现有的约束，计算期望，将其作为约束。

   使用拉格朗日乘子发得到P(y|x)，之后使用优化算法得到P(y|x)中的参数w。

