# z-index-group

Используется для формирования на странице нескольких слоев блоков, располагающихся друг над другом.

## Обзор блока

### Модификаторы блока

| Модификатор | Допустимые значения | Способы использования | Описание |
| ----------- | ------------------- | -------------------- | -------- |
| <a href="#index-level">level</a> | Целое число от 0 до 9 | <code>BEMJSON</code> | Уровень слоя. |

## Описание блока

Блок `z-index-group` располагает блоки слоями друг над другом. Их размещением по z-оси управляет модификатор [level](#index-level).

### Модификаторы блока

<a name="index-level"></a>

#### Модификатор `level`

Допустимые значения: целые числа от 0 до 9.

Способы использования: `BEMJSON`.

Определяет уровень слоя блока относительно других слоев блоков на странице.

Чем больше значение модификатора `level`, тем выше находится слой. При равных значениях `level` на переднем плане находится тот слой, который в BEMJSON задекларирован позже.

На примере ниже открывающееся всплывающее окно не перекрывает другие блоки, находящиеся на странице. Например, шапка страницы всегда остается на первом плане:

```javascript
{
    block : 'popup',
    mix : { block : 'z-index-group', mods : { level : 1 } },
    content : 'Я блок с { level : 1 }, который находится под блоком с { level : 2 }.'
    mods : { autoclosable : true, theme : 'normal' },
}
```
