# progressbar

Используется для создания индикации степени выполнения какого-либо процесса.

## Обзор блока

### Модификаторы блока

| Модификатор | Допустимые значения | Способы использования | Описание |
| ----------- | ------------------- | -------------------- | -------- |
| <a href="#theme">theme</a> | <code>'islands'</code> | <code>BEMJSON</code> | Стилевое оформление. |

### Специализированные поля блока

| Поле | Тип | Описание |
| ---- | --- | -------- |
| <a href="#val">val</a> | <code>Number</code> | Степень выполнения процесса в процентах. |

## Описание блока

Блок `progressbar` – индикатор процесса. Принципиально отличается от блока [spin](../spin/spin.ru.md) тем, что показывает степень выполнения (прогресс) какого-то процесса.

По умолчанию блок занимает всю ширину родителя.

### Модификаторы блока

<a name="theme"></a>

#### Модификатор `theme`

Допустимое значение: `'islands'`.

Способ использования: `BEMJSON`.

Отвечает за стилевое оформление блока.

```js
{
    block : 'progressbar',
    mods : { theme : 'islands' },
    val : 25
}
```

### Специализированные поля блока

<a name="val"></a>

#### Поле `val`

Тип: `Number`.

Определяет степень выполнения процесса в процентах относительно родителя. При отсутствии этого поля степень выполнения равна нулю.

```js
{
    block : 'progressbar',
    mods : { theme : 'islands' },
    val : 25
}
```
