/**
 * @module menu
 */

modules.define('menu', function(provide, Menu) {

/**
 * @exports
 * @class menu
 * @bem
 */
provide(Menu.declMod({ modName : 'mode', modVal : 'radio' }, /** @lends menu.prototype */{
    /**
     * @override
     */
    _getVal : function() {
        var items = this.getItems(),
            i = 0,
            item;

        while(item = items.get(i++))
            if(item.hasMod('checked'))
                return item.getVal();
    },

    /**
     * @override
     */
    _setVal : function(val) {
        var wasChanged = false,
            hasVal = false,
            itemsCheckedVals = this.getItems().map(function(item) {
                if(!item.isValEq(val)) return false;

                item.hasMod('checked') || (wasChanged = true);
                return hasVal = true;
            });

        if(!hasVal) return false;

        this._updateItemsCheckedMod(itemsCheckedVals);

        return wasChanged;
    },

    /**
     * @override
     */
    _onItemClick : function(clickedItem) {
        this.__base.apply(this, arguments);

        var isChanged = false;
        this.getItems().forEach(function(item) {
            if(item === clickedItem) {
                if(!item.hasMod('checked')) {
                    item.setMod('checked', true);
                    this._isValValid = false;
                    isChanged = true;
                }
            } else {
                item.delMod('checked');
            }
        }, this);
        isChanged && this._emit('change');
    }
}));

});
