/**
 * @module menu
 */

modules.define('menu', function(provide, Menu) {

/**
 * @exports
 * @class menu
 * @bem
 */
provide(Menu.declMod({ modName : 'mode', modVal : 'check' }, /** @lends menu.prototype */{
    /**
     * @override
     */
    _getVal : function() {
        return this.getItems()
            .filter(function(item) { return item.hasMod('checked'); })
            .map(function(item) { return item.getVal(); });
    },

    /**
     * @override
     * @param {Array} vals
     */
    _setVal : function(vals) {
        var wasChanged = false,
            notFoundValsCnt = vals.length,
            itemsCheckedVals = this.getItems().map(function(item) {
                var isChecked = item.hasMod('checked'),
                    hasEqVal = vals.some(function(val) {
                        return item.isValEq(val);
                    });
                if(hasEqVal) {
                    --notFoundValsCnt;
                    isChecked || (wasChanged = true);
                } else {
                    isChecked && (wasChanged = true);
                }
                return hasEqVal;
            });

        if(!wasChanged || notFoundValsCnt)
            return false;

        this._updateItemsCheckedMod(itemsCheckedVals);

        return wasChanged;
    },

    /**
     * @override
     */
    _onItemClick : function(clickedItem) {
        this.__base.apply(this, arguments);

        this.getItems().forEach(function(item) {
            item === clickedItem && item.toggleMod('checked');
        });
        this._isValValid = false;
        this._emit('change');
    }
}));

});
