/**
 * @module button
 */

modules.define('button', function(provide, Button) {

/**
 * @exports
 * @class button
 * @bem
 */
provide(Button.declMod({ modName : 'type', modVal : 'link' }, /** @lends button.prototype */{
    onSetMod : {
        'js' : {
            'inited' : function() {
                this.__base.apply(this, arguments);
                this._url = this.params.url || this.domElem.attr('href');

                this.hasMod('disabled') && this.domElem.removeAttr('href');
            }
        },

        'disabled' : {
            'true' : function() {
                this.__base.apply(this, arguments);
                this.domElem
                    .removeAttr('href')
                    .attr('aria-disabled', true);
            },

            '' : function() {
                this.__base.apply(this, arguments);
                this.domElem
                    .attr('href', this._url)
                    .removeAttr('aria-disabled');
            }
        }
    },

    /**
     * Returns url
     * @returns {String}
     */
    getUrl : function() {
        return this._url;
    },

    /**
     * Sets url
     * @param {String} url
     * @returns {button} this
     */
    setUrl : function(url) {
        this._url = url;
        this.hasMod('disabled') || this.domElem.attr('href', url);
        return this;
    },

    _doAction : function() {
        this._url && (document.location = this._url);
    }
}));

});
