/*
 * Copyright (c) 2024, APT Group, Department of Computer Science,
 * The University of Manchester.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package uk.ac.manchester.tornado.unittests.runtime;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

import uk.ac.manchester.tornado.api.TornadoBackend;
import uk.ac.manchester.tornado.api.TornadoRuntime;
import uk.ac.manchester.tornado.api.runtime.TornadoRuntimeProvider;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

/**
 * How to run?
 *
 * <p>
 * <code>
 * tornado-test -V uk.ac.manchester.tornado.unittests.runtime.TestRuntimeAPI
 * </code>
 * </p>
 */
public class TestRuntimeAPI extends TornadoTestBase {

    @Test
    public void test01() {

        TornadoRuntime runtime = TornadoRuntimeProvider.getTornadoRuntime();

        // Obtain the first backend in the list
        TornadoBackend backend = runtime.getBackend(0);
        assertNotNull(backend);

        // TornadoVM finds at least one backend
        var numBackends = runtime.getNumBackends();
        assertTrue(numBackends >= 1);

        // At least one device should be available per backend.
        for (int i = 0; i < numBackends; i++) {
            backend = runtime.getBackend(i);
            assertTrue(backend.getNumDevices() >= 1);
        }
    }
}
