#include <Arduino.h>
#include <stdint.h>

typedef struct {
  uint16_t bitmapOffset;
  uint8_t width;
  uint8_t height;
  uint8_t xAdvance;
  int8_t xOffset;
  int8_t yOffset;
} GFXglyph;

typedef struct {
  uint8_t *bitmap;
  GFXglyph *glyph;
  uint16_t first;
  uint16_t last;
  uint8_t yAdvance;
} GFXfont;

#define Source_Pixel 240
#define Gate_Pixel 360

#define EPD_EN WB_IO2
#define BUSY_Pin WB_IO4
#define RES_Pin -1
#define DC_Pin WB_IO1
#define CS_Pin SS
#define SCK_Pin SCK
#define SDI_Pin MOSI

#define PIC_WHITE 0xFF
#define PIC_BLACK 0x00
// EPD
#define EPD_W21_MOSI_0 digitalWrite(SDI_Pin, LOW)
#define EPD_W21_MOSI_1 digitalWrite(SDI_Pin, HIGH)
#define EPD_W21_CLK_0 digitalWrite(SCK_Pin, LOW)
#define EPD_W21_CLK_1 digitalWrite(SCK_Pin, HIGH)
#define EPD_W21_CS_0 digitalWrite(CS_Pin, LOW)
#define EPD_W21_CS_1 digitalWrite(CS_Pin, HIGH)
#define EPD_W21_DC_0 digitalWrite(DC_Pin, LOW)
#define EPD_W21_DC_1 digitalWrite(DC_Pin, HIGH)
#define EPD_W21_RST_0 digitalWrite(RES_Pin, LOW)
#define EPD_W21_RST_1 digitalWrite(RES_Pin, HIGH)
#define isEPD_W21_BUSY digitalRead(BUSY_Pin)

class SE0352NQ01 {
  public:
    SE0352NQ01();
    ~SE0352NQ01();
    void sleep(void);
    void refresh(void);
    void send(uint8_t*);
    void send_DU(uint8_t*);
    void fillScreen(uint8_t);
    //void drawString(char *, uint16_t, uint16_t, GFXfont, uint8_t, uint8_t*);
    uint16_t drawString(char *, uint16_t, uint16_t, GFXfont, uint8_t, uint8_t*);
    uint16_t strWidth(char *, GFXfont);
    void drawUnicode(uint16_t*, uint8_t, uint16_t, uint16_t, uint8_t*, uint8_t*, uint16_t, uint8_t, uint8_t, uint8_t*);
    void drawBitmap(uint8_t, uint8_t, uint16_t, uint16_t, int8_t, int8_t, uint16_t, uint8_t *, uint8_t *, uint8_t);
    void drawBitmap(uint8_t, uint8_t, uint16_t, uint16_t, uint8_t *, uint8_t *, uint8_t);
    void setPixel(uint16_t, uint16_t, uint8_t, uint8_t *);
    void clearPixel(uint16_t, uint16_t, uint8_t, uint8_t *);
    uint8_t getPixel(uint16_t, uint16_t, uint8_t, uint8_t *);
    void drawRect(uint16_t, uint16_t, uint16_t, uint16_t, uint8_t, uint8_t *);
    void fillRect(uint16_t, uint16_t, uint16_t, uint16_t, uint8_t, uint8_t *);
    void clearRect(uint16_t, uint16_t, uint16_t, uint16_t, uint8_t, uint8_t *);
    void drawCircle(uint16_t, uint16_t, uint16_t, uint8_t, uint8_t *);
    void fillCircle(uint16_t, uint16_t, uint16_t, uint8_t, uint8_t *);
    void drawLine(uint16_t, uint16_t, uint16_t, uint16_t, uint8_t, uint8_t *);
    void drawHLine(uint16_t, uint16_t, uint16_t, uint8_t, uint8_t *);
    void drawVLine(uint16_t, uint16_t, uint16_t, uint8_t, uint8_t *);
    void drawPolygon(uint16_t *, uint16_t, uint8_t, uint8_t *);
    void fillContour(uint16_t, uint16_t, uint8_t, uint8_t *);
    void partialRefresh(uint16_t, uint16_t, uint16_t, uint16_t, uint8_t, uint8_t*);
    uint16_t width(uint8_t);
    uint16_t height(uint8_t);

  private:
    void EPD_Reset(void);
    void EPD_init(void);
    void lcd_chkstatus(void);
    void PIC_display(uint8_t);
    void PIC_display1(uint8_t*);
    void KEY_Scan(void);
    void driver_delay_us(unsigned int xus);
    void driver_delay_xms(unsigned long xms);
    void DELAY_S(unsigned int delaytime);
    void DELAY_M(unsigned int delaytime);
    void SPI_Write(uint8_t);
    void get_ch2(uint16_t, const uint8_t*, uint16_t, uint8_t*, uint8_t);
    uint16_t bs(const uint8_t *, uint16_t, uint16_t);
    void drawFillCircle(uint16_t, uint16_t, uint16_t, uint8_t, uint8_t *, uint8_t);
    void drawCirclePoints(uint16_t, uint16_t, uint16_t, uint16_t, uint8_t, uint8_t *);
    void fillCirclePoints(uint16_t, uint16_t, uint16_t, uint16_t, uint8_t, uint8_t *);
    void EPD_W21_WriteCMD(uint8_t);
    void EPD_W21_WriteDATA(uint8_t);

    // LUT
    void lut_DU(void);
    void lut_GC(void);
    void lut_5S(void);
    unsigned long LUT_Flag = 0;

    uint16_t doff, next_offs, myHeight, myWidth;
};

// full screen update LUT
// GC全刷
const uint8_t lut_R20_GC[] = {
  0x01, 0x0f, 0x0f, 0x0f, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

const uint8_t lut_R21_GC[] = {
  0x01, 0x4f, 0x8f, 0x0f, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

const uint8_t lut_R22_GC[] = {
  0x01, 0x0f, 0x8f, 0x0f, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

const uint8_t lut_R23_GC[] = {
  0x01, 0x4f, 0x8f, 0x4f, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

const uint8_t lut_R24_GC[] = {
  0x01, 0x0f, 0x8f, 0x4f, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

// DU 局刷
const uint8_t lut_R20_DU[] = {
  0x01, 0x0f, 0x01, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

const uint8_t lut_R21_DU[] = {
  0x01, 0x0f, 0x01, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

const uint8_t lut_R22_DU[] = {
  0x01, 0x8f, 0x01, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

const uint8_t lut_R23_DU[] = {
  0x01, 0x4f, 0x01, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

const uint8_t lut_R24_DU[] = {
  0x01, 0x0f, 0x01, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

const uint8_t lut_vcom[] = {
  0x01, 0x19, 0x19, 0x19, 0x19, 0x01, 0x01, 0x01, 0x19, 0x19, 0x19, 0x01, 0x01, 0x01, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

const uint8_t lut_ww[] = {
  0x01, 0x59, 0x99, 0x59, 0x99, 0x01, 0x01, 0x01, 0x59, 0x99, 0x19, 0x01, 0x01, 0x01, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

const uint8_t lut_bw[] = {
  0x01, 0x59, 0x99, 0x59, 0x99, 0x01, 0x01, 0x01, 0x59, 0x99, 0x19, 0x01, 0x01, 0x01, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

const uint8_t lut_wb[] = {

  0x01, 0x19, 0x99, 0x59, 0x99, 0x01, 0x01, 0x01, 0x59, 0x99, 0x59, 0x01, 0x01, 0x01, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

const uint8_t lut_bb[] = {
  0x01, 0x19, 0x99, 0x59, 0x99, 0x01, 0x01, 0x01, 0x59, 0x99, 0x59, 0x01, 0x01, 0x01, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

extern SE0352NQ01 SE0352;
