/**
 * @file RAK14000_epd.h
 * @author Bernd Giesecke (bernd@giesecke.tk)
 * @brief Global definitions and forward declarations, Images for the EPD display
 * @version 0.1
 * @date 2022-06-25
 *
 * @copyright Copyright (c) 2022
 * Images cortesy of <a href="https://www.flaticon.com/free-icons" title="Freepik - Flaticon">Icons created by Freepik - Flaticon</a>
 */
#ifndef RAK14000_GFX_H
#define RAK14000_GFX_H
#include <Arduino.h>
#include <Adafruit_GFX.h>
#include <Adafruit_EPD.h>

const unsigned char rak_img[] = {
	// 'RAK-logo, 150x56px
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff,
	0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x07, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x80, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	0xfc, 0x1f, 0x80, 0x00, 0x00, 0x1f, 0xff, 0xff, 0x80, 0x00, 0x7f, 0xc0, 0x07, 0xf8, 0x01, 0xff,
	0x80, 0x00, 0x03, 0xf8, 0xff, 0xc0, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xe0, 0x00, 0x7f, 0xc0, 0x07,
	0xf8, 0x03, 0xff, 0x00, 0x00, 0x03, 0xf3, 0xff, 0xc0, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xf0, 0x00,
	0xff, 0xe0, 0x07, 0xf8, 0x07, 0xfe, 0x00, 0x00, 0x07, 0xe7, 0xff, 0xc8, 0x00, 0x00, 0x1f, 0xff,
	0xff, 0xf0, 0x00, 0xff, 0xe0, 0x07, 0xf8, 0x0f, 0xfc, 0x00, 0x00, 0x07, 0xcf, 0xff, 0xce, 0x00,
	0x00, 0x1f, 0xff, 0xff, 0xf8, 0x00, 0xff, 0xe0, 0x07, 0xf8, 0x1f, 0xf8, 0x00, 0x00, 0x00, 0x02,
	0x00, 0x1f, 0x80, 0x00, 0x1f, 0xff, 0xff, 0xf8, 0x01, 0xff, 0xf0, 0x07, 0xf8, 0x3f, 0xf8, 0x00,
	0x00, 0x1c, 0x30, 0x1e, 0x1f, 0xc0, 0x00, 0x1f, 0xe0, 0x0f, 0xf8, 0x01, 0xff, 0xf0, 0x07, 0xf8,
	0x7f, 0xf0, 0x00, 0x0f, 0x3e, 0x79, 0xff, 0xcf, 0xe0, 0x00, 0x1f, 0xe0, 0x07, 0xf8, 0x01, 0xff,
	0xf0, 0x07, 0xf8, 0x7f, 0xe0, 0x00, 0x0f, 0x3e, 0x7d, 0xff, 0xc7, 0xf0, 0x00, 0x1f, 0xe0, 0x03,
	0xfc, 0x03, 0xff, 0xf8, 0x07, 0xf8, 0xff, 0xc0, 0x00, 0x1f, 0x3e, 0xfd, 0xff, 0xc3, 0xf0, 0x00,
	0x1f, 0xe0, 0x03, 0xf8, 0x03, 0xfb, 0xf8, 0x07, 0xf9, 0xff, 0x80, 0x00, 0x1f, 0x3e, 0xfd, 0xff,
	0xc9, 0xf8, 0x00, 0x1f, 0xe0, 0x03, 0xf8, 0x07, 0xfb, 0xfc, 0x07, 0xfb, 0xff, 0x00, 0x00, 0x1f,
	0x3e, 0xfd, 0xff, 0x99, 0xf8, 0x00, 0x1f, 0xe0, 0x07, 0xf8, 0x07, 0xfb, 0xfc, 0x07, 0xff, 0xfe,
	0x00, 0x00, 0x1f, 0x3e, 0xfc, 0x00, 0x1c, 0xfc, 0x00, 0x1f, 0xe0, 0x0f, 0xf8, 0x07, 0xf1, 0xfc,
	0x07, 0xff, 0xfc, 0x00, 0x00, 0x1f, 0xbe, 0xfc, 0x03, 0x9e, 0x7c, 0x00, 0x1f, 0xff, 0xff, 0xf0,
	0x0f, 0xf1, 0xfe, 0x07, 0xff, 0xfe, 0x00, 0x00, 0x0f, 0x9e, 0x7c, 0x07, 0xde, 0x7e, 0x00, 0x1f,
	0xff, 0xff, 0xf0, 0x0f, 0xf1, 0xfe, 0x07, 0xff, 0xff, 0x00, 0x00, 0x0f, 0x9e, 0x7c, 0x07, 0xcf,
	0x7e, 0x00, 0x1f, 0xff, 0xff, 0xe0, 0x0f, 0xe0, 0xfe, 0x07, 0xff, 0xff, 0x00, 0x00, 0x0f, 0xde,
	0x7c, 0x07, 0xcf, 0x3e, 0x00, 0x1f, 0xff, 0xff, 0xc0, 0x1f, 0xe0, 0xff, 0x07, 0xff, 0xff, 0x80,
	0x00, 0x0f, 0xcf, 0x00, 0x07, 0xcf, 0x3e, 0x00, 0x1f, 0xff, 0xff, 0xe0, 0x1f, 0xe0, 0xff, 0x07,
	0xff, 0xff, 0xc0, 0x00, 0x07, 0xe7, 0x00, 0x07, 0xcf, 0x3e, 0x00, 0x1f, 0xff, 0xff, 0xf0, 0x3f,
	0xff, 0xff, 0x87, 0xff, 0x7f, 0xc0, 0x00, 0x07, 0xe6, 0x7f, 0xe7, 0xcf, 0x3e, 0x00, 0x1f, 0xe0,
	0x1f, 0xf8, 0x3f, 0xff, 0xff, 0x87, 0xfe, 0x7f, 0xe0, 0x00, 0x03, 0xf2, 0x7f, 0xe7, 0xcf, 0x3e,
	0x00, 0x1f, 0xe0, 0x0f, 0xf8, 0x3f, 0xff, 0xff, 0x87, 0xfc, 0x3f, 0xf0, 0x00, 0x01, 0xf8, 0xff,
	0xe7, 0xcf, 0x3e, 0x00, 0x1f, 0xe0, 0x07, 0xf8, 0x7f, 0xff, 0xff, 0xc7, 0xf8, 0x1f, 0xf0, 0x00,
	0x01, 0xfc, 0xff, 0xe7, 0xcf, 0x3e, 0x00, 0x1f, 0xe0, 0x07, 0xf8, 0x7f, 0xff, 0xff, 0xc7, 0xf8,
	0x1f, 0xf8, 0x00, 0x00, 0xfe, 0x7f, 0xe7, 0x8f, 0x1c, 0x00, 0x1f, 0xe0, 0x03, 0xf8, 0x7f, 0xff,
	0xff, 0xc7, 0xf8, 0x0f, 0xfc, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xe0, 0x03,
	0xf8, 0xff, 0x00, 0x1f, 0xe7, 0xf8, 0x07, 0xfe, 0x00, 0x00, 0x3e, 0x00, 0x38, 0x30, 0x00, 0x00,
	0x1f, 0xe0, 0x03, 0xf8, 0xff, 0x00, 0x1f, 0xe7, 0xf8, 0x07, 0xfe, 0x00, 0x00, 0x0e, 0x7f, 0xfc,
	0xf8, 0x00, 0x00, 0x1f, 0xe0, 0x03, 0xf9, 0xfe, 0x00, 0x1f, 0xf7, 0xf8, 0x03, 0xff, 0x00, 0x00,
	0x00, 0xff, 0xf9, 0xf8, 0x00, 0x00, 0x1f, 0xe0, 0x03, 0xfd, 0xfe, 0x00, 0x0f, 0xf7, 0xf8, 0x01,
	0xff, 0x80, 0x00, 0x00, 0xff, 0xf3, 0xf0, 0x00, 0x00, 0x1f, 0xe0, 0x03, 0xfd, 0xfe, 0x00, 0x0f,
	0xf7, 0xf8, 0x01, 0xff, 0x80, 0x00, 0x00, 0x7f, 0xc7, 0xf0, 0x00, 0x00, 0x1f, 0xe0, 0x03, 0xff,
	0xfc, 0x00, 0x0f, 0xff, 0xf8, 0x00, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x1f, 0xe0, 0x00, 0x00, 0x1f,
	0xe0, 0x01, 0xff, 0xfc, 0x00, 0x07, 0xff, 0xf8, 0x00, 0x7f, 0xe0, 0x00, 0x00, 0x00, 0x7f, 0xc0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x3f, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x7f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xe0, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

// const unsigned char lora_img[] = {
// 	// 'features_lora_02, 60x40px
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x0f, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x03, 0xf0, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x38, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xfe, 0x10, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x07, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x20, 0x78, 0x01, 0xfe, 0x0f, 0xff, 0x00, 0x00, 0x20,
// 	0x78, 0x03, 0x03, 0x8f, 0xff, 0x80, 0x00, 0x00, 0x78, 0x00, 0x00, 0x0f, 0xff, 0xc0, 0x00, 0x00,
// 	0x78, 0x00, 0x78, 0x0f, 0x03, 0xc1, 0xe0, 0x00, 0x78, 0x01, 0xfe, 0x0f, 0x03, 0xc7, 0xfc, 0x00,
// 	0x78, 0x03, 0xff, 0x0f, 0x03, 0xcf, 0xfc, 0x00, 0x78, 0x07, 0xc7, 0x8f, 0x07, 0xcf, 0x1c, 0x00,
// 	0x78, 0x07, 0x83, 0x8f, 0xff, 0x80, 0x1c, 0x00, 0x78, 0x07, 0x03, 0xcf, 0xff, 0x01, 0xfc, 0x00,
// 	0x78, 0x07, 0x03, 0xcf, 0xfe, 0x07, 0xfc, 0x00, 0x78, 0x07, 0x03, 0xcf, 0x1e, 0x0f, 0x9c, 0x00,
// 	0x78, 0x07, 0x83, 0x8f, 0x0f, 0x0e, 0x1c, 0x00, 0x7f, 0xe7, 0x87, 0x8f, 0x0f, 0x8e, 0x3c, 0x00,
// 	0x7f, 0xf3, 0xff, 0x8f, 0x07, 0x8f, 0xfc, 0x00, 0x7f, 0xf1, 0xff, 0x0f, 0x07, 0xcf, 0xfe, 0x00,
// 	0x7f, 0xe0, 0x7c, 0x0f, 0x03, 0xc3, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x0f, 0xc7, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x38, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x01, 0xf8, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x0f, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

const unsigned char celsius_img[] = {
	0x00, 0x06, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x1f, 0x80, 0x00,
	0x00, 0x1f, 0x80, 0x00, 0x00, 0x1f, 0x80, 0x00, 0x00, 0x19, 0x80, 0x00,
	0x00, 0x19, 0x80, 0x00, 0x00, 0x19, 0x80, 0x00, 0x00, 0x19, 0x80, 0x00,
	0x00, 0x19, 0x80, 0x00, 0x0f, 0x99, 0x80, 0x00, 0x00, 0x19, 0x80, 0x00,
	0x01, 0x99, 0x80, 0x00, 0x01, 0x99, 0x80, 0x00, 0x00, 0x19, 0x8f, 0x38,
	0x07, 0x99, 0x89, 0x38, 0x00, 0x19, 0x99, 0x80, 0x00, 0x19, 0x98, 0x00,
	0x03, 0x99, 0x98, 0x00, 0x00, 0x19, 0x98, 0x00, 0x00, 0x99, 0x99, 0x80,
	0x00, 0x99, 0x89, 0x00, 0x07, 0x99, 0x8f, 0x00, 0x0f, 0x99, 0x80, 0x00,
	0x00, 0x39, 0xc0, 0x00, 0x00, 0x39, 0xc0, 0x00, 0x00, 0x30, 0xc0, 0x00,
	0x00, 0x30, 0xc0, 0x00, 0x00, 0x39, 0xc0, 0x00, 0x00, 0x3f, 0xc0, 0x00,
	0x00, 0x1f, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00};

const unsigned char humidity_img[] = {
	0x00, 0x01, 0x80, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x03, 0xc0, 0x00,
	0x00, 0x06, 0x60, 0x00, 0x00, 0x0e, 0x70, 0x00, 0x00, 0x0c, 0x30, 0x00,
	0x00, 0x18, 0x18, 0x00, 0x00, 0x38, 0x1c, 0x00, 0x00, 0x70, 0x0e, 0x00,
	0x00, 0x60, 0x06, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x01, 0x80, 0x01, 0x80,
	0x01, 0x9e, 0x01, 0x80, 0x03, 0x3f, 0x00, 0xc0, 0x07, 0x33, 0x0c, 0xe0,
	0x06, 0x33, 0x1c, 0x60, 0x06, 0x3f, 0x38, 0x60, 0x0c, 0x1e, 0x70, 0x30,
	0x0c, 0x00, 0xe0, 0x30, 0x0c, 0x01, 0xc0, 0x30, 0x0c, 0x03, 0x80, 0x30,
	0x0c, 0x07, 0x00, 0x30, 0x0c, 0x0e, 0x78, 0x30, 0x06, 0x1c, 0xfc, 0x60,
	0x06, 0x38, 0xcc, 0x60, 0x07, 0x30, 0xcc, 0xe0, 0x03, 0x00, 0xf8, 0xc0,
	0x01, 0x80, 0x71, 0x80, 0x00, 0xe0, 0x07, 0x00, 0x00, 0x78, 0x1e, 0x00,
	0x00, 0x3f, 0xfc, 0x00, 0x00, 0x07, 0xe0, 0x00};

const unsigned char co2_img[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x0f, 0xe0, 0x00, 0x00, 0x1f, 0xf8, 0x00, 0x00, 0x70, 0x1c, 0x00,
	0x00, 0x60, 0x0e, 0x00, 0x00, 0xc0, 0x06, 0x00, 0x00, 0xc0, 0x03, 0x00,
	0x01, 0x80, 0x03, 0x80, 0x01, 0x80, 0x03, 0xf0, 0x01, 0x80, 0x00, 0x38,
	0x1f, 0x80, 0x00, 0x0c, 0x3c, 0x9c, 0x38, 0x06, 0x70, 0x3f, 0x7e, 0x02,
	0x60, 0x20, 0x46, 0x03, 0xc0, 0x60, 0xc2, 0x03, 0xc0, 0x60, 0xc2, 0x03,
	0xc0, 0x32, 0x66, 0x03, 0xc0, 0x1e, 0x7c, 0xc3, 0xc0, 0x00, 0x00, 0x86,
	0x60, 0x00, 0x00, 0xc6, 0x70, 0x00, 0x00, 0x1c, 0x3f, 0xff, 0xff, 0xf8,
	0x0f, 0xff, 0xff, 0xe0, 0x03, 0xff, 0xff, 0x80};

const unsigned char barometer_img[] = {
	0x00, 0x07, 0xe0, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0xf0, 0x0f, 0x00,
	0x03, 0x80, 0x01, 0xc0, 0x07, 0x0f, 0xf0, 0xe0, 0x0c, 0x3f, 0xfc, 0x30,
	0x18, 0xf1, 0x8f, 0x18, 0x19, 0xc0, 0x03, 0x98, 0x33, 0xc0, 0x03, 0xcc,
	0x63, 0xc1, 0x83, 0xc6, 0x66, 0x01, 0x80, 0x66, 0x66, 0x01, 0x80, 0x66,
	0x4c, 0x01, 0x80, 0x32, 0xcc, 0x01, 0x80, 0x33, 0xcc, 0x03, 0xc0, 0x33,
	0xcf, 0x06, 0x60, 0xf3, 0xcf, 0x06, 0x60, 0xf3, 0xcc, 0x03, 0xc0, 0x33,
	0xcc, 0x03, 0xc0, 0x33, 0x4c, 0x06, 0x60, 0x32, 0x66, 0x07, 0xe0, 0x66,
	0x66, 0x03, 0xc0, 0x66, 0x63, 0xc0, 0x03, 0xc6, 0x33, 0xc0, 0x03, 0xcc,
	0x19, 0x9b, 0x71, 0x98, 0x18, 0x1b, 0x58, 0x18, 0x0c, 0x1d, 0x70, 0x30,
	0x07, 0x15, 0x58, 0xe0, 0x03, 0x85, 0x61, 0xc0, 0x00, 0xe0, 0x07, 0x00,
	0x00, 0x7f, 0xfe, 0x00, 0x00, 0x07, 0xe0, 0x00};

const unsigned char voc_img[] = {
	0x00, 0x03, 0xc0, 0x00, 0x00, 0x0e, 0x70, 0x00, 0x00, 0x1c, 0x39, 0xf0,
	0x00, 0x30, 0x0f, 0x30, 0x00, 0xe3, 0xc7, 0x30, 0x01, 0x8f, 0x71, 0xb0,
	0x07, 0x1e, 0x38, 0xf0, 0x0e, 0x38, 0x1e, 0x70, 0x18, 0xf0, 0x07, 0x18,
	0x71, 0xc0, 0x03, 0xce, 0xe3, 0x80, 0x01, 0xe7, 0x8e, 0x00, 0x00, 0x79,
	0x9c, 0x00, 0x00, 0x1d, 0xf8, 0x07, 0x80, 0x17, 0x08, 0x0c, 0x80, 0x10,
	0x08, 0x08, 0x5c, 0x10, 0x08, 0x00, 0xb2, 0x10, 0x08, 0xff, 0xa2, 0x10,
	0x08, 0x00, 0x02, 0x10, 0x08, 0xff, 0xfe, 0x10, 0x08, 0x00, 0x00, 0x10,
	0x08, 0x7f, 0xe0, 0x10, 0x08, 0x00, 0x18, 0x10, 0x08, 0x00, 0x08, 0x10,
	0x08, 0x00, 0x88, 0x10, 0x08, 0x00, 0xd8, 0x10, 0x08, 0x00, 0x30, 0x10,
	0x08, 0x00, 0x00, 0x10, 0x08, 0x00, 0x00, 0x10, 0x08, 0x00, 0x00, 0x10,
	0x08, 0x00, 0x00, 0x10, 0x07, 0xff, 0xff, 0xf0};

const unsigned char pm_img[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x00, 0x00, 0x0f, 0xf0, 0x00,
	0x00, 0x1c, 0x38, 0x00, 0x00, 0x30, 0x0c, 0x00, 0x00, 0x30, 0x0c, 0x00,
	0x00, 0x61, 0x86, 0x00, 0x00, 0x63, 0xc6, 0x00, 0x00, 0x63, 0xc6, 0x00,
	0x00, 0xe1, 0x87, 0x80, 0x01, 0x80, 0x01, 0x80, 0x03, 0x18, 0x18, 0xc0,
	0x03, 0x3c, 0x3c, 0xc0, 0x0f, 0x3c, 0x3c, 0xf0, 0x1c, 0x18, 0x18, 0x38,
	0x18, 0x00, 0x00, 0x18, 0x31, 0x81, 0x81, 0x8c, 0x33, 0xc3, 0xc3, 0xcc,
	0x33, 0xc3, 0xc3, 0xcc, 0x31, 0x81, 0x81, 0x8c, 0x18, 0x00, 0x00, 0x18,
	0x1c, 0x18, 0x18, 0x38, 0x0f, 0x3c, 0x3c, 0xf0, 0x03, 0x3c, 0x3c, 0xc0,
	0x03, 0x18, 0x18, 0xc0, 0x03, 0x00, 0x00, 0xc0, 0x01, 0x84, 0x21, 0x80,
	0x00, 0xff, 0xff, 0x00, 0x00, 0x7b, 0xde, 0x00};

// const unsigned char pm10_img[] = {
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x38, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x30, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x61, 0x86, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x63, 0xc6, 0x00, 0x03, 0x00, 0x1f, 0x00, 0x00, 0xe1, 0x87, 0x80,
// 	0x07, 0x00, 0x3f, 0x80, 0x01, 0x80, 0x01, 0x80, 0x0f, 0x00, 0x31, 0xc0,
// 	0x03, 0x18, 0x18, 0xc0, 0x1f, 0x00, 0x71, 0xc0, 0x03, 0x3c, 0x3c, 0xc0,
// 	0x3f, 0x00, 0x71, 0xc0, 0x0f, 0x3c, 0x3c, 0xf0, 0x27, 0x00, 0x71, 0xc0,
// 	0x1c, 0x18, 0x18, 0x38, 0x07, 0x00, 0x71, 0xc0, 0x18, 0x00, 0x00, 0x18,
// 	0x07, 0x00, 0x71, 0xc0, 0x31, 0x81, 0x81, 0x8c, 0x07, 0x00, 0x71, 0xc0,
// 	0x33, 0xc3, 0xc3, 0xcc, 0x07, 0x0e, 0x31, 0xc0, 0x33, 0xc3, 0xc3, 0xcc,
// 	0x07, 0x0e, 0x3f, 0x80, 0x31, 0x81, 0x81, 0x8c, 0x07, 0x0e, 0x1f, 0x00,
// 	0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x18, 0x18, 0x38,
// 	0x00, 0x00, 0x00, 0x00, 0x0f, 0x3c, 0x3c, 0xf0, 0x00, 0x00, 0x00, 0x00,
// 	0x03, 0x3c, 0x3c, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x03, 0x18, 0x18, 0xc0,
// 	0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00,
// 	0x01, 0x84, 0x21, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x7b, 0xde, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x00, 0x00, 0x00};

// const unsigned char pm25_img[] = {
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x38, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x30, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x61, 0x86, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x63, 0xc6, 0x00, 0x0f, 0x80, 0x1f, 0xe0, 0x00, 0xe1, 0x87, 0x80,
// 	0x1f, 0xc0, 0x1f, 0xe0, 0x01, 0x80, 0x01, 0x80, 0x38, 0xe0, 0x18, 0x00,
// 	0x03, 0x18, 0x18, 0xc0, 0x38, 0xe0, 0x18, 0x00, 0x03, 0x3c, 0x3c, 0xc0,
// 	0x00, 0xe0, 0x1f, 0x80, 0x0f, 0x3c, 0x3c, 0xf0, 0x01, 0xe0, 0x3f, 0xc0,
// 	0x1c, 0x18, 0x18, 0x38, 0x03, 0xc0, 0x18, 0xe0, 0x18, 0x00, 0x00, 0x18,
// 	0x07, 0x80, 0x00, 0xe0, 0x31, 0x81, 0x81, 0x8c, 0x0f, 0x00, 0x38, 0xe0,
// 	0x33, 0xc3, 0xc3, 0xcc, 0x1e, 0x07, 0x38, 0xe0, 0x33, 0xc3, 0xc3, 0xcc,
// 	0x3f, 0xe7, 0x1f, 0xc0, 0x31, 0x81, 0x81, 0x8c, 0x3f, 0xe7, 0x0f, 0x80,
// 	0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x18, 0x18, 0x38,
// 	0x00, 0x00, 0x00, 0x00, 0x0f, 0x3c, 0x3c, 0xf0, 0x00, 0x00, 0x00, 0x00,
// 	0x03, 0x3c, 0x3c, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x03, 0x18, 0x18, 0xc0,
// 	0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00,
// 	0x01, 0x84, 0x21, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x7b, 0xde, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x00, 0x00, 0x00};

// const unsigned char pm100_img[] = {
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x38, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x30, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x61, 0x86, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0xc6, 0x00, 0x03, 0x03, 0xe0, 0x00,
// 	0x00, 0x63, 0xc6, 0x00, 0x07, 0x07, 0xf0, 0x00, 0x00, 0xe1, 0x87, 0x80,
// 	0x0f, 0x06, 0x38, 0x00, 0x01, 0x80, 0x01, 0x80, 0x1f, 0x0e, 0x38, 0x00,
// 	0x03, 0x18, 0x18, 0xc0, 0x3f, 0x0e, 0x38, 0x00, 0x03, 0x3c, 0x3c, 0xc0,
// 	0x27, 0x0e, 0x38, 0x00, 0x0f, 0x3c, 0x3c, 0xf0, 0x07, 0x0e, 0x38, 0x00,
// 	0x1c, 0x18, 0x18, 0x38, 0x07, 0x0e, 0x38, 0x00, 0x18, 0x00, 0x00, 0x18,
// 	0x07, 0x0e, 0x38, 0x00, 0x31, 0x81, 0x81, 0x8c, 0x07, 0x06, 0x38, 0x00,
// 	0x33, 0xc3, 0xc3, 0xcc, 0x07, 0x07, 0xf0, 0x00, 0x33, 0xc3, 0xc3, 0xcc,
// 	0x07, 0x03, 0xe0, 0x00, 0x31, 0x81, 0x81, 0x8c, 0x00, 0x00, 0x00, 0x00,
// 	0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x18, 0x18, 0x38,
// 	0x00, 0x00, 0x00, 0x00, 0x0f, 0x3c, 0x3c, 0xf0, 0x00, 0x00, 0x00, 0x00,
// 	0x03, 0x3c, 0x3c, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x03, 0x18, 0x18, 0xc0,
// 	0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00,
// 	0x01, 0x84, 0x21, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x7b, 0xde, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x00, 0x00, 0x00};

// const unsigned char alert_img[] = {
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xc0, 0x00,
// 	0x00, 0x07, 0xc0, 0x00, 0x00, 0x07, 0xc0, 0x00, 0x00, 0x07, 0xc0, 0x00,
// 	0x00, 0x07, 0xc0, 0x00, 0x00, 0x07, 0xc0, 0x00, 0x00, 0x07, 0xc0, 0x00,
// 	0x00, 0x07, 0xc0, 0x00, 0x00, 0x03, 0x80, 0x00, 0x00, 0x03, 0x80, 0x00,
// 	0x00, 0x03, 0x80, 0x00, 0x00, 0x03, 0x80, 0x00, 0x00, 0x03, 0x80, 0x00,
// 	0x00, 0x03, 0x80, 0x00, 0x00, 0x03, 0x80, 0x00, 0x00, 0x03, 0x80, 0x00,
// 	0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
// 	0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x03, 0x80, 0x00, 0x00, 0x07, 0xc0, 0x00, 0x00, 0x0f, 0xe0, 0x00,
// 	0x00, 0x0f, 0xe0, 0x00, 0x00, 0x07, 0xc0, 0x00, 0x00, 0x03, 0x80, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

// const unsigned char alarm_img[] = {
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xe0, 0x07, 0xc0,
// 	0x03, 0xe0, 0x07, 0xc0, 0x03, 0xe0, 0x07, 0xc0, 0x03, 0xe0, 0x07, 0xc0,
// 	0x03, 0xe0, 0x07, 0xc0, 0x03, 0xe0, 0x07, 0xc0, 0x03, 0xe0, 0x07, 0xc0,
// 	0x03, 0xe0, 0x07, 0xc0, 0x01, 0xc0, 0x03, 0x80, 0x01, 0xc0, 0x03, 0x80,
// 	0x01, 0xc0, 0x03, 0x80, 0x01, 0xc0, 0x03, 0x80, 0x01, 0xc0, 0x03, 0x80,
// 	0x01, 0xc0, 0x03, 0x80, 0x01, 0xc0, 0x03, 0x80, 0x01, 0xc0, 0x03, 0x80,
// 	0x00, 0x80, 0x01, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x80, 0x01, 0x00,
// 	0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x01, 0xc0, 0x03, 0x80, 0x03, 0xe0, 0x07, 0xc0, 0x07, 0xf0, 0x0f, 0xe0,
// 	0x07, 0xf0, 0x0f, 0xe0, 0x03, 0xe0, 0x07, 0xc0, 0x01, 0xc0, 0x03, 0x80,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

const unsigned char built_img[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0xff, 0xff, 0xfe, 0x00, 0x03, 0xff, 0xff, 0xff, 0x00, 0x03, 
  0xff, 0xff, 0xf0, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0x00, 0x07, 0xff, 
  0xff, 0xff, 0x80, 0x07, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x03, 0xff, 0xff, 
  0xff, 0x80, 0x0f, 0xff, 0xff, 0xff, 0xc0, 0x0f, 0xff, 0xff, 0xfc, 0x00, 
  0x00, 0x03, 0xff, 0xff, 0xff, 0x80, 0x0f, 0xff, 0xff, 0xff, 0xc0, 0x0f, 
  0xff, 0xff, 0xfc, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0x80, 0x0f, 0xff, 
  0xff, 0xff, 0xc0, 0x0f, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x03, 0xff, 0xff, 
  0xff, 0x80, 0x0f, 0xff, 0xff, 0xff, 0xc0, 0x0f, 0xff, 0xff, 0xfc, 0x00, 
  0x00, 0x03, 0xff, 0xff, 0xff, 0x80, 0x0f, 0xff, 0xff, 0xff, 0xc0, 0x0f, 
  0xff, 0xff, 0xfc, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0x80, 0x0f, 0xff, 
  0xff, 0xff, 0xc0, 0x0f, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x03, 0xff, 0xff, 
  0xff, 0x80, 0x0f, 0xff, 0xff, 0xff, 0xc0, 0x0f, 0xff, 0xff, 0xfc, 0x00, 
  0x00, 0x07, 0xff, 0xff, 0xff, 0xc0, 0x1f, 0xff, 0xff, 0xff, 0xc0, 0x0f, 
  0xff, 0xff, 0xfc, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xe0, 0x1f, 0xff, 0xff, 0xfc, 0x00, 0x3f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 
  0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xf0, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x7f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 
  0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xfe, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x7f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 
  0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xfe, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x7f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 
  0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xfe, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x7f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 
  0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xfe, 0x7f, 0xff, 0xc1, 0xff, 0xed, 0xff, 0xff, 0xfb, 
  0xfb, 0xfe, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x7f, 0xff, 0xc0, 0x7f, 
  0xec, 0xdf, 0xff, 0xfb, 0x33, 0xfe, 0x07, 0xcf, 0x39, 0xbf, 0xff, 0xfe, 
  0x7f, 0xff, 0xdf, 0x7f, 0xfc, 0xcf, 0xff, 0xff, 0x33, 0xfe, 0x73, 0x8f, 
  0x33, 0xbf, 0xff, 0xfe, 0x7f, 0xff, 0xde, 0x6e, 0x6c, 0x87, 0xcd, 0xda, 
  0x10, 0x3e, 0x73, 0x87, 0x27, 0xbf, 0xff, 0xfe, 0x7f, 0xff, 0xc0, 0xee, 
  0x6c, 0xdf, 0xc8, 0x9b, 0x33, 0x3e, 0x43, 0x37, 0x0f, 0xf0, 0xff, 0xfe, 
  0x7f, 0xff, 0xde, 0x6e, 0x6c, 0xdf, 0xea, 0xbb, 0x3b, 0xbe, 0x07, 0x33, 
  0x07, 0xe7, 0xff, 0xfe, 0x7f, 0xff, 0xdf, 0x6e, 0x6c, 0xdf, 0xea, 0xbb, 
  0x3b, 0xbe, 0x63, 0x03, 0x23, 0xf1, 0xff, 0xfe, 0x7f, 0xff, 0xde, 0x6e, 
  0x6c, 0xdf, 0xe2, 0x3b, 0x3b, 0xbe, 0x72, 0x03, 0x33, 0xfe, 0x7f, 0xfe, 
  0x7f, 0xff, 0xc0, 0xe0, 0x6c, 0xc7, 0xf3, 0x7b, 0x13, 0xbe, 0x72, 0x79, 
  0x31, 0xe7, 0x7f, 0xfe, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xfe, 0x72, 0x79, 0x38, 0xf0, 0xff, 0xfe, 0x7f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 
  0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xfe, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x7f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 
  0x7f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xfe, 0x7f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x7f, 0xff, 0x00, 0x00, 
  0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 
  0x7f, 0xff, 0x1c, 0x38, 0x30, 0x00, 0x18, 0x03, 0xe3, 0xfc, 0x07, 0xf0, 
  0x71, 0xe1, 0xff, 0xfe, 0x7f, 0xff, 0x1c, 0x38, 0x77, 0x00, 0x18, 0x03, 
  0xe3, 0xf8, 0x03, 0xc0, 0x11, 0xc3, 0xff, 0xfe, 0x7f, 0xff, 0x1c, 0x3c, 
  0x77, 0x00, 0x18, 0xf3, 0xe3, 0xf8, 0xf1, 0xc7, 0x11, 0x87, 0xff, 0xfe, 
  0x7f, 0xff, 0x0c, 0x7c, 0x70, 0x1c, 0x18, 0xf3, 0xe3, 0xf1, 0xf8, 0x8f, 
  0x91, 0x8f, 0xff, 0xfe, 0x7f, 0xff, 0x0e, 0x7c, 0x67, 0x7f, 0x18, 0xf3, 
  0xe3, 0xf1, 0xf8, 0x8f, 0xf1, 0x1f, 0xff, 0xfe, 0x7f, 0xff, 0x0e, 0x6c, 
  0xe6, 0x63, 0x98, 0x00, 0x63, 0xf3, 0xfc, 0x9f, 0xf0, 0x3f, 0xff, 0xfe, 
  0x7f, 0xff, 0x0e, 0x6e, 0xe6, 0xe1, 0x18, 0x00, 0x63, 0xf3, 0xfc, 0x9f, 
  0xf0, 0x1f, 0xff, 0xfe, 0x7f, 0xff, 0x06, 0xee, 0xc6, 0x7c, 0x18, 0x00, 
  0x63, 0xf3, 0xfc, 0x9f, 0xf0, 0x0f, 0xff, 0xfe, 0x7f, 0xff, 0x07, 0xc7, 
  0xc6, 0x3f, 0x18, 0xfe, 0x63, 0xf1, 0xfc, 0x8f, 0xf1, 0x8f, 0xff, 0xfe, 
  0x7f, 0xff, 0x07, 0xc7, 0xc6, 0x07, 0x98, 0xfe, 0x63, 0xf1, 0xf8, 0x8f, 
  0x91, 0xc7, 0xff, 0xfe, 0x7f, 0xff, 0x07, 0xc7, 0xc6, 0xc3, 0x98, 0xfe, 
  0x63, 0xf8, 0xf1, 0xc7, 0x11, 0xe3, 0xff, 0xfe, 0x7f, 0xff, 0x03, 0xc7, 
  0x86, 0xe3, 0x98, 0x00, 0x60, 0x08, 0x01, 0xc0, 0x11, 0xe1, 0xff, 0xfe, 
  0x7f, 0xff, 0x03, 0x83, 0x86, 0x7f, 0x18, 0x00, 0x60, 0x0e, 0x07, 0xf0, 
  0x71, 0xf1, 0xff, 0xfe, 0x7f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x7f, 0xff, 0x00, 0x00, 
  0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 
  0x7f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xfe, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x7f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 
  0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xfe, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x7f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 
  0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xfc, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x0f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0};

// const uint8_t RAK_Small_FontBitmaps[] PROGMEM = {
// 	0xFA, 0xFA, 0xB4, 0x52, 0xBE, 0xAF, 0xA9, 0x40, 0x23, 0xE8, 0xE2, 0xF8,
// 	0x80, 0xC6, 0x44, 0x44, 0x4C, 0x60, 0x64, 0xA8, 0x8A, 0xC9, 0xA0, 0xD8,
// 	0x00, 0x6A, 0xA4, 0x00, 0x95, 0x58, 0x00, 0x25, 0x5D, 0xF7, 0x54, 0x80,
// 	0x21, 0x3E, 0x42, 0x00, 0xD0, 0xF8, 0x00, 0xF0, 0x08, 0x88, 0x88, 0x00,
// 	0x74, 0x67, 0x5C, 0xC5, 0xC0, 0x59, 0x24, 0xB8, 0x00, 0x74, 0x42, 0x22,
// 	0x23, 0xE0, 0xF8, 0x88, 0x20, 0xC5, 0xC0, 0x11, 0x95, 0x2F, 0x88, 0x40,
// 	0xFC, 0x21, 0xE0, 0xC5, 0xC0, 0x32, 0x21, 0xE8, 0xC5, 0xC0, 0xF8, 0x44,
// 	0x44, 0x21, 0x00, 0x74, 0x62, 0xE8, 0xC5, 0xC0, 0x74, 0x62, 0xF0, 0x89,
// 	0x80, 0xF3, 0xC0, 0xF3, 0x60, 0x12, 0x48, 0x42, 0x10, 0xF8, 0x3E, 0x00,
// 	0x84, 0x21, 0x24, 0x80, 0x74, 0x42, 0x22, 0x00, 0x80, 0x74, 0x6B, 0x7B,
// 	0xC1, 0xC0, 0x22, 0xA3, 0xF8, 0xC6, 0x20, 0xF4, 0x63, 0xE8, 0xC7, 0xC0,
// 	0x74, 0x61, 0x08, 0x45, 0xC0, 0xE4, 0xA3, 0x18, 0xCB, 0x80, 0xFC, 0x21,
// 	0xE8, 0x43, 0xE0, 0xFC, 0x21, 0xE8, 0x42, 0x00, 0x74, 0x61, 0x38, 0xC5,
// 	0xC0, 0x8C, 0x63, 0xF8, 0xC6, 0x20, 0xE9, 0x24, 0xB8, 0x00, 0x38, 0x41,
// 	0x04, 0x12, 0x46, 0x00, 0x8C, 0xA9, 0x8A, 0x4A, 0x20, 0x84, 0x21, 0x08,
// 	0x43, 0xE0, 0x8E, 0xEB, 0x18, 0xC6, 0x20, 0x8C, 0x73, 0x59, 0xC6, 0x20,
// 	0x74, 0x63, 0x18, 0xC5, 0xC0, 0xF4, 0x63, 0xE8, 0x42, 0x00, 0x74, 0x63,
// 	0x1A, 0xC9, 0xA0, 0xF4, 0x63, 0xEA, 0x4A, 0x20, 0x7C, 0x20, 0xE0, 0x87,
// 	0xC0, 0xF9, 0x08, 0x42, 0x10, 0x80, 0x8C, 0x63, 0x18, 0xC5, 0xC0, 0x8C,
// 	0x63, 0x18, 0xA8, 0x80, 0x8C, 0x63, 0x1A, 0xEE, 0x20, 0x8C, 0x54, 0x45,
// 	0x46, 0x20, 0x8C, 0x54, 0x42, 0x10, 0x80, 0xF8, 0x44, 0x44, 0x43, 0xE0,
// 	0xF2, 0x49, 0x38, 0x00, 0x82, 0x08, 0x20, 0x80, 0xE4, 0x92, 0x78, 0x00,
// 	0x22, 0xA2, 0x00, 0xF8, 0x88, 0x80, 0x70, 0x5F, 0x17, 0x80, 0x84, 0x3D,
// 	0x18, 0xC7, 0xC0, 0x7C, 0x21, 0x07, 0x80, 0x08, 0x5F, 0x18, 0xC5, 0xE0,
// 	0x74, 0x7F, 0x07, 0x00, 0x25, 0x4E, 0x44, 0x40, 0x7C, 0x5E, 0x17, 0x00,
// 	0x84, 0x3D, 0x18, 0xC6, 0x20, 0xBE, 0x10, 0x11, 0x19, 0x60, 0x88, 0x9A,
// 	0xCA, 0x90, 0xFE, 0x00, 0xDD, 0x6B, 0x18, 0x80, 0xB6, 0x63, 0x18, 0x80,
// 	0x74, 0x63, 0x17, 0x00, 0xF4, 0x7D, 0x08, 0x00, 0x7C, 0x5E, 0x10, 0x80,
// 	0xB6, 0x61, 0x08, 0x00, 0x7C, 0x1C, 0x1F, 0x00, 0x21, 0x3E, 0x42, 0x14,
// 	0x40, 0x8C, 0x63, 0x17, 0x00, 0x8C, 0x62, 0xA2, 0x00, 0x8C, 0x6B, 0x55,
// 	0x00, 0x8A, 0x88, 0xA8, 0x80, 0x8C, 0x5E, 0x17, 0x00, 0xF8, 0x88, 0x8F,
// 	0x80, 0x29, 0x44, 0x88, 0x00, 0xFE, 0x00, 0xA2, 0x14, 0xA0, 0x00, 0x74,
// 	0x62, 0xE0, 0x8C, 0x73, 0x68, 0x00, 0x30, 0x44, 0x13, 0x00};

// const GFXglyph RAK_Small_FontGlyphs[] PROGMEM = {
// 	{0, 0, 1, 6, 0, 0},	   // 0x20 ' '
// 	{1, 1, 7, 6, 2, -7},   // 0x21 '!'
// 	{2, 3, 2, 6, 1, -7},   // 0x22 '"'
// 	{3, 5, 7, 6, 0, -7},   // 0x23 '#'
// 	{8, 5, 7, 6, 0, -7},   // 0x24 '$'
// 	{13, 5, 7, 6, 0, -7},  // 0x25 '%'
// 	{18, 5, 7, 6, 0, -7},  // 0x26 '&'
// 	{23, 2, 3, 6, 1, -7},  // 0x27 '''
// 	{25, 2, 7, 6, 2, -7},  // 0x28 '('
// 	{28, 2, 7, 6, 1, -7},  // 0x29 ')'
// 	{31, 5, 7, 6, 0, -7},  // 0x2A '*'
// 	{36, 5, 5, 6, 0, -6},  // 0x2B '+'
// 	{40, 2, 2, 6, 1, -2},  // 0x2C ','
// 	{41, 5, 1, 6, 0, -4},  // 0x2D '-'
// 	{43, 2, 2, 6, 1, -2},  // 0x2E '.'
// 	{44, 5, 5, 6, 0, -6},  // 0x2F '/'
// 	{48, 5, 7, 6, 0, -7},  // 0x30 '0'
// 	{53, 3, 7, 6, 1, -7},  // 0x31 '1'
// 	{57, 5, 7, 6, 0, -7},  // 0x32 '2'
// 	{62, 5, 7, 6, 0, -7},  // 0x33 '3'
// 	{67, 5, 7, 6, 0, -7},  // 0x34 '4'
// 	{72, 5, 7, 6, 0, -7},  // 0x35 '5'
// 	{77, 5, 7, 6, 0, -7},  // 0x36 '6'
// 	{82, 5, 7, 6, 0, -7},  // 0x37 '7'
// 	{87, 5, 7, 6, 0, -7},  // 0x38 '8'
// 	{92, 5, 7, 6, 0, -7},  // 0x39 '9'
// 	{97, 2, 5, 6, 1, -6},  // 0x3A ':'
// 	{99, 2, 6, 6, 1, -6},  // 0x3B ';'
// 	{101, 4, 7, 6, 0, -7}, // 0x3C '<'
// 	{105, 5, 3, 6, 0, -5}, // 0x3D '='
// 	{108, 4, 7, 6, 1, -7}, // 0x3E '>'
// 	{112, 5, 7, 6, 0, -7}, // 0x3F '?'
// 	{117, 5, 7, 6, 0, -7}, // 0x40 '@'
// 	{122, 5, 7, 6, 0, -7}, // 0x41 'A'
// 	{127, 5, 7, 6, 0, -7}, // 0x42 'B'
// 	{132, 5, 7, 6, 0, -7}, // 0x43 'C'
// 	{137, 5, 7, 6, 0, -7}, // 0x44 'D'
// 	{142, 5, 7, 6, 0, -7}, // 0x45 'E'
// 	{147, 5, 7, 6, 0, -7}, // 0x46 'F'
// 	{152, 5, 7, 6, 0, -7}, // 0x47 'G'
// 	{157, 5, 7, 6, 0, -7}, // 0x48 'H'
// 	{162, 3, 7, 6, 1, -7}, // 0x49 'I'
// 	{166, 6, 7, 6, 0, -7}, // 0x4A 'J'
// 	{172, 5, 7, 6, 0, -7}, // 0x4B 'K'
// 	{177, 5, 7, 6, 0, -7}, // 0x4C 'L'
// 	{182, 5, 7, 6, 0, -7}, // 0x4D 'M'
// 	{187, 5, 7, 6, 0, -7}, // 0x4E 'N'
// 	{192, 5, 7, 6, 0, -7}, // 0x4F 'O'
// 	{197, 5, 7, 6, 0, -7}, // 0x50 'P'
// 	{202, 5, 7, 6, 0, -7}, // 0x51 'Q'
// 	{207, 5, 7, 6, 0, -7}, // 0x52 'R'
// 	{212, 5, 7, 6, 0, -7}, // 0x53 'S'
// 	{217, 5, 7, 6, 0, -7}, // 0x54 'T'
// 	{222, 5, 7, 6, 0, -7}, // 0x55 'U'
// 	{227, 5, 7, 6, 0, -7}, // 0x56 'V'
// 	{232, 5, 7, 6, 0, -7}, // 0x57 'W'
// 	{237, 5, 7, 6, 0, -7}, // 0x58 'X'
// 	{242, 5, 7, 6, 0, -7}, // 0x59 'Y'
// 	{247, 5, 7, 6, 0, -7}, // 0x5A 'Z'
// 	{252, 3, 7, 6, 1, -7}, // 0x5B '['
// 	{256, 5, 5, 6, 0, -6}, // 0x5C '\'
// 	{260, 3, 7, 6, 1, -7}, // 0x5D ']'
// 	{264, 5, 3, 6, 0, -7}, // 0x5E '^'
// 	{267, 5, 1, 6, 0, -1}, // 0x5F '_'
// 	{268, 3, 3, 6, 1, -7}, // 0x60 '`'
// 	{270, 5, 5, 6, 0, -5}, // 0x61 'a'
// 	{274, 5, 7, 6, 0, -7}, // 0x62 'b'
// 	{279, 5, 5, 6, 0, -5}, // 0x63 'c'
// 	{283, 5, 7, 6, 0, -7}, // 0x64 'd'
// 	{288, 5, 5, 6, 0, -5}, // 0x65 'e'
// 	{292, 4, 7, 6, 0, -7}, // 0x66 'f'
// 	{296, 5, 5, 6, 0, -5}, // 0x67 'g'
// 	{300, 5, 7, 6, 0, -7}, // 0x68 'h'
// 	{305, 1, 7, 6, 2, -7}, // 0x69 'i'
// 	{306, 4, 7, 6, 0, -7}, // 0x6A 'j'
// 	{310, 4, 7, 6, 0, -7}, // 0x6B 'k'
// 	{314, 1, 7, 6, 2, -7}, // 0x6C 'l'
// 	{316, 5, 5, 6, 0, -5}, // 0x6D 'm'
// 	{320, 5, 5, 6, 0, -5}, // 0x6E 'n'
// 	{324, 5, 5, 6, 0, -5}, // 0x6F 'o'
// 	{328, 5, 5, 6, 0, -5}, // 0x70 'p'
// 	{332, 5, 5, 6, 0, -5}, // 0x71 'q'
// 	{336, 5, 5, 6, 0, -5}, // 0x72 'r'
// 	{340, 5, 5, 6, 0, -5}, // 0x73 's'
// 	{344, 5, 7, 6, 0, -7}, // 0x74 't'
// 	{349, 5, 5, 6, 0, -5}, // 0x75 'u'
// 	{353, 5, 5, 6, 0, -5}, // 0x76 'v'
// 	{357, 5, 5, 6, 0, -5}, // 0x77 'w'
// 	{361, 5, 5, 6, 0, -5}, // 0x78 'x'
// 	{365, 5, 5, 6, 0, -5}, // 0x79 'y'
// 	{369, 5, 5, 6, 0, -5}, // 0x7A 'z'
// 	{373, 3, 7, 6, 1, -7}, // 0x7B '{'
// 	{377, 1, 7, 6, 2, -7}, // 0x7C '|'
// 	{379, 3, 7, 6, 1, -7}, // 0x7D '}'
// 	{383, 5, 4, 6, 0, -7}, // 0x7E '°'
// 	{386, 5, 5, 6, 0, -5}, // 0x7F 'μ'
// 	{390, 5, 5, 6, 0, -7}  // 0x80 '³'
// };

// const GFXfont RAK_Small_Font PROGMEM = {
// 	(uint8_t *)RAK_Small_FontBitmaps,
// 	(GFXglyph *)RAK_Small_FontGlyphs, 0x20, 0x80, 7};

// const uint8_t RAK_Large_FontBitmaps[] PROGMEM = {
// 	0xFF, 0xFF, 0xFF, 0xF0, 0xF0, 0xFF, 0xFF, 0xFF, 0xF0, 0xF0, 0xCF, 0x3C,
// 	0xF3, 0x8A, 0x20, 0x06, 0x30, 0x31, 0x03, 0x18, 0x18, 0xC7, 0xFF, 0xBF,
// 	0xFC, 0x31, 0x03, 0x18, 0x18, 0xC7, 0xFF, 0xBF, 0xFC, 0x31, 0x01, 0x18,
// 	0x18, 0xC0, 0xC6, 0x06, 0x30, 0x04, 0x03, 0xE1, 0xFF, 0x72, 0x6C, 0x47,
// 	0x88, 0xF1, 0x07, 0x20, 0x7E, 0x03, 0xF0, 0x17, 0x02, 0x3C, 0x47, 0x88,
// 	0xF1, 0x1B, 0x26, 0x7F, 0xC3, 0xE0, 0x10, 0x02, 0x00, 0x00, 0x06, 0x03,
// 	0xC0, 0x40, 0x7E, 0x0C, 0x0E, 0x70, 0x80, 0xC3, 0x18, 0x0C, 0x31, 0x00,
// 	0xE7, 0x30, 0x07, 0xE6, 0x00, 0x3C, 0x40, 0x00, 0x0C, 0x7C, 0x00, 0x8F,
// 	0xE0, 0x19, 0xC7, 0x01, 0x18, 0x30, 0x31, 0x83, 0x02, 0x1C, 0x70, 0x40,
// 	0xFE, 0x04, 0x07, 0xC0, 0x0F, 0x00, 0x7E, 0x03, 0x9C, 0x0C, 0x30, 0x30,
// 	0xC0, 0xE7, 0x01, 0xF8, 0x03, 0x80, 0x3E, 0x01, 0xCC, 0x6E, 0x19, 0xB0,
// 	0x7C, 0xC0, 0xF3, 0x03, 0xCE, 0x1F, 0x9F, 0xE6, 0x1E, 0x1C, 0xFF, 0xA0,
// 	0x08, 0x8C, 0x66, 0x31, 0x98, 0xC6, 0x31, 0x8C, 0x63, 0x08, 0x63, 0x08,
// 	0x61, 0x0C, 0x20, 0x82, 0x18, 0xC3, 0x18, 0xC3, 0x18, 0xC6, 0x31, 0x8C,
// 	0x62, 0x31, 0x88, 0xC4, 0x62, 0x00, 0x10, 0x23, 0x5B, 0xE3, 0x8D, 0x91,
// 	0x00, 0x0C, 0x03, 0x00, 0xC0, 0x30, 0xFF, 0xFF, 0xF0, 0xC0, 0x30, 0x0C,
// 	0x03, 0x00, 0xC0, 0xF5, 0x60, 0xFF, 0xF0, 0xF0, 0x02, 0x0C, 0x10, 0x20,
// 	0xC1, 0x02, 0x0C, 0x10, 0x20, 0xC1, 0x02, 0x0C, 0x10, 0x20, 0xC1, 0x00,
// 	0x1F, 0x07, 0xF1, 0xC7, 0x30, 0x6E, 0x0F, 0x80, 0xF0, 0x1E, 0x03, 0xC0,
// 	0x78, 0x0F, 0x01, 0xE0, 0x3C, 0x0E, 0xC1, 0x9C, 0x71, 0xFC, 0x1F, 0x00,
// 	0x08, 0xCF, 0xFF, 0x8C, 0x63, 0x18, 0xC6, 0x31, 0x8C, 0x63, 0x18, 0x1F,
// 	0x0F, 0xF9, 0x87, 0x60, 0x7C, 0x06, 0x00, 0xC0, 0x18, 0x07, 0x01, 0xC0,
// 	0xF0, 0x78, 0x1C, 0x06, 0x00, 0x80, 0x30, 0x07, 0xFF, 0xFF, 0xE0, 0x3F,
// 	0x0F, 0xF3, 0x87, 0x60, 0x6C, 0x0C, 0x01, 0x80, 0x70, 0x7C, 0x0F, 0x80,
// 	0x18, 0x01, 0x80, 0x3C, 0x07, 0x80, 0xD8, 0x73, 0xFC, 0x1F, 0x00, 0x01,
// 	0x80, 0x70, 0x0E, 0x03, 0xC0, 0xD8, 0x1B, 0x06, 0x61, 0x8C, 0x21, 0x8C,
// 	0x33, 0x06, 0x7F, 0xFF, 0xFE, 0x03, 0x00, 0x60, 0x0C, 0x01, 0x80, 0x3F,
// 	0xCF, 0xF9, 0x80, 0x30, 0x06, 0x00, 0xDE, 0x1F, 0xE7, 0x0E, 0x00, 0xE0,
// 	0x0C, 0x01, 0x80, 0x30, 0x07, 0x81, 0xF8, 0x73, 0xFC, 0x1F, 0x00, 0x0F,
// 	0x07, 0xF9, 0xC3, 0x30, 0x74, 0x01, 0x80, 0x33, 0xC7, 0xFE, 0xF0, 0xDC,
// 	0x1F, 0x01, 0xE0, 0x3C, 0x06, 0xC1, 0xDC, 0x71, 0xFC, 0x1F, 0x00, 0xFF,
// 	0xFF, 0xFC, 0x01, 0x00, 0x60, 0x18, 0x02, 0x00, 0xC0, 0x30, 0x06, 0x01,
// 	0x80, 0x30, 0x04, 0x01, 0x80, 0x30, 0x06, 0x01, 0x80, 0x30, 0x00, 0x1F,
// 	0x07, 0xF1, 0xC7, 0x30, 0x66, 0x0C, 0xC1, 0x8C, 0x61, 0xFC, 0x3F, 0x8E,
// 	0x3B, 0x01, 0xE0, 0x3C, 0x07, 0x80, 0xD8, 0x31, 0xFC, 0x1F, 0x00, 0x1F,
// 	0x07, 0xF1, 0xC7, 0x70, 0x6C, 0x07, 0x80, 0xF0, 0x1E, 0x07, 0x61, 0xEF,
// 	0xFC, 0x79, 0x80, 0x30, 0x05, 0x81, 0x98, 0x73, 0xFC, 0x1E, 0x00, 0xF0,
// 	0x00, 0x03, 0xC0, 0xF0, 0x00, 0x0F, 0x56, 0x00, 0x00, 0x07, 0x01, 0xE0,
// 	0xF8, 0x3C, 0x0F, 0x00, 0xE0, 0x07, 0xC0, 0x0F, 0x00, 0x3C, 0x00, 0xF0,
// 	0x01, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x00, 0x0E,
// 	0x00, 0x78, 0x01, 0xF0, 0x07, 0xC0, 0x0F, 0x00, 0x70, 0x1E, 0x0F, 0x03,
// 	0xC0, 0xF0, 0x08, 0x00, 0x1F, 0x1F, 0xEE, 0x1B, 0x03, 0xC0, 0xC0, 0x30,
// 	0x0C, 0x06, 0x03, 0x81, 0xC0, 0xE0, 0x30, 0x0C, 0x03, 0x00, 0x00, 0x00,
// 	0x0C, 0x03, 0x00, 0x00, 0xFE, 0x00, 0x0F, 0xFE, 0x00, 0xF0, 0x3E, 0x07,
// 	0x00, 0x3C, 0x38, 0x00, 0x30, 0xC1, 0xE0, 0x66, 0x0F, 0xD9, 0xD8, 0x61,
// 	0xC3, 0xC3, 0x07, 0x0F, 0x1C, 0x1C, 0x3C, 0x60, 0x60, 0xF1, 0x81, 0x83,
// 	0xC6, 0x06, 0x1B, 0x18, 0x38, 0xEE, 0x71, 0xE7, 0x18, 0xFD, 0xF8, 0x71,
// 	0xE7, 0xC0, 0xE0, 0x00, 0x01, 0xE0, 0x00, 0x01, 0xFF, 0xC0, 0x01, 0xFC,
// 	0x00, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x07, 0xE0, 0x06, 0x60, 0x06,
// 	0x60, 0x0E, 0x70, 0x0C, 0x30, 0x0C, 0x30, 0x1C, 0x38, 0x18, 0x18, 0x1F,
// 	0xF8, 0x3F, 0xFC, 0x30, 0x1C, 0x30, 0x0C, 0x70, 0x0E, 0x60, 0x06, 0x60,
// 	0x06, 0xFF, 0xC7, 0xFF, 0x30, 0x19, 0x80, 0x6C, 0x03, 0x60, 0x1B, 0x00,
// 	0xD8, 0x0C, 0xFF, 0xC7, 0xFF, 0x30, 0x0D, 0x80, 0x3C, 0x01, 0xE0, 0x0F,
// 	0x00, 0x78, 0x06, 0xFF, 0xF7, 0xFE, 0x00, 0x07, 0xE0, 0x3F, 0xF0, 0xE0,
// 	0x73, 0x80, 0x66, 0x00, 0x6C, 0x00, 0x30, 0x00, 0x60, 0x00, 0xC0, 0x01,
// 	0x80, 0x03, 0x00, 0x06, 0x00, 0x06, 0x00, 0x6C, 0x00, 0xDC, 0x03, 0x1E,
// 	0x0E, 0x1F, 0xF8, 0x0F, 0xC0, 0xFF, 0x83, 0xFF, 0x8C, 0x07, 0x30, 0x0E,
// 	0xC0, 0x1B, 0x00, 0x7C, 0x00, 0xF0, 0x03, 0xC0, 0x0F, 0x00, 0x3C, 0x00,
// 	0xF0, 0x03, 0xC0, 0x1F, 0x00, 0x6C, 0x03, 0xB0, 0x1C, 0xFF, 0xE3, 0xFF,
// 	0x00, 0xFF, 0xFF, 0xFF, 0xC0, 0x0C, 0x00, 0xC0, 0x0C, 0x00, 0xC0, 0x0C,
// 	0x00, 0xFF, 0xEF, 0xFE, 0xC0, 0x0C, 0x00, 0xC0, 0x0C, 0x00, 0xC0, 0x0C,
// 	0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x60, 0x0C, 0x01, 0x80,
// 	0x30, 0x06, 0x00, 0xFF, 0xDF, 0xFB, 0x00, 0x60, 0x0C, 0x01, 0x80, 0x30,
// 	0x06, 0x00, 0xC0, 0x18, 0x00, 0x07, 0xF0, 0x1F, 0xFC, 0x3C, 0x1E, 0x70,
// 	0x06, 0x60, 0x03, 0xE0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x7F, 0xC0,
// 	0x7F, 0xC0, 0x03, 0xC0, 0x03, 0x60, 0x03, 0x60, 0x07, 0x30, 0x0F, 0x3C,
// 	0x1F, 0x1F, 0xFB, 0x07, 0xE1, 0xC0, 0x1E, 0x00, 0xF0, 0x07, 0x80, 0x3C,
// 	0x01, 0xE0, 0x0F, 0x00, 0x78, 0x03, 0xFF, 0xFF, 0xFF, 0xF0, 0x07, 0x80,
// 	0x3C, 0x01, 0xE0, 0x0F, 0x00, 0x78, 0x03, 0xC0, 0x1E, 0x00, 0xC0, 0xFF,
// 	0xFF, 0xFF, 0xFF, 0xF0, 0x01, 0x80, 0xC0, 0x60, 0x30, 0x18, 0x0C, 0x06,
// 	0x03, 0x01, 0x80, 0xC0, 0x60, 0x3C, 0x1E, 0x0F, 0x07, 0xC7, 0x7F, 0x1F,
// 	0x00, 0xC0, 0x3B, 0x01, 0xCC, 0x0E, 0x30, 0x70, 0xC3, 0x83, 0x1C, 0x0C,
// 	0xE0, 0x33, 0x80, 0xDE, 0x03, 0xDC, 0x0E, 0x38, 0x30, 0x60, 0xC1, 0xC3,
// 	0x03, 0x8C, 0x06, 0x30, 0x1C, 0xC0, 0x3B, 0x00, 0x60, 0xC0, 0x30, 0x0C,
// 	0x03, 0x00, 0xC0, 0x30, 0x0C, 0x03, 0x00, 0xC0, 0x30, 0x0C, 0x03, 0x00,
// 	0xC0, 0x30, 0x0C, 0x03, 0x00, 0xFF, 0xFF, 0xF0, 0xE0, 0x07, 0xE0, 0x07,
// 	0xF0, 0x0F, 0xF0, 0x0F, 0xD0, 0x0F, 0xD8, 0x1B, 0xD8, 0x1B, 0xD8, 0x1B,
// 	0xCC, 0x33, 0xCC, 0x33, 0xCC, 0x33, 0xC6, 0x63, 0xC6, 0x63, 0xC6, 0x63,
// 	0xC3, 0xC3, 0xC3, 0xC3, 0xC3, 0xC3, 0xC1, 0x83, 0xE0, 0x1F, 0x00, 0xFC,
// 	0x07, 0xE0, 0x3D, 0x81, 0xEE, 0x0F, 0x30, 0x79, 0xC3, 0xC6, 0x1E, 0x18,
// 	0xF0, 0xE7, 0x83, 0x3C, 0x1D, 0xE0, 0x6F, 0x01, 0xF8, 0x0F, 0xC0, 0x3E,
// 	0x01, 0xC0, 0x03, 0xE0, 0x0F, 0xFC, 0x0F, 0x07, 0x86, 0x00, 0xC6, 0x00,
// 	0x33, 0x00, 0x1B, 0x00, 0x07, 0x80, 0x03, 0xC0, 0x01, 0xE0, 0x00, 0xF0,
// 	0x00, 0x78, 0x00, 0x36, 0x00, 0x33, 0x00, 0x18, 0xC0, 0x18, 0x78, 0x3C,
// 	0x1F, 0xFC, 0x03, 0xF8, 0x00, 0xFF, 0x8F, 0xFE, 0xC0, 0x6C, 0x03, 0xC0,
// 	0x3C, 0x03, 0xC0, 0x3C, 0x07, 0xFF, 0xEF, 0xFC, 0xC0, 0x0C, 0x00, 0xC0,
// 	0x0C, 0x00, 0xC0, 0x0C, 0x00, 0xC0, 0x0C, 0x00, 0x03, 0xE0, 0x0F, 0xFC,
// 	0x0F, 0x07, 0x86, 0x00, 0xC6, 0x00, 0x33, 0x00, 0x1B, 0x00, 0x07, 0x80,
// 	0x03, 0xC0, 0x01, 0xE0, 0x00, 0xF0, 0x00, 0x78, 0x00, 0x36, 0x00, 0x33,
// 	0x01, 0x98, 0xC0, 0xFC, 0x78, 0x3C, 0x1F, 0xFF, 0x03, 0xF9, 0x80, 0x00,
// 	0x40, 0xFF, 0xC3, 0xFF, 0xCC, 0x03, 0xB0, 0x06, 0xC0, 0x1B, 0x00, 0x6C,
// 	0x01, 0xB0, 0x0C, 0xFF, 0xE3, 0xFF, 0xCC, 0x03, 0xB0, 0x06, 0xC0, 0x1B,
// 	0x00, 0x6C, 0x01, 0xB0, 0x06, 0xC0, 0x1B, 0x00, 0x70, 0x0F, 0xE0, 0x7F,
// 	0xC3, 0x83, 0x9C, 0x07, 0x60, 0x0D, 0x80, 0x06, 0x00, 0x1E, 0x00, 0x3F,
// 	0x80, 0x3F, 0xC0, 0x0F, 0x80, 0x07, 0xC0, 0x0F, 0x00, 0x3E, 0x00, 0xDE,
// 	0x0E, 0x3F, 0xF0, 0x3F, 0x80, 0xFF, 0xFF, 0xFF, 0x06, 0x00, 0x60, 0x06,
// 	0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06,
// 	0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0xC0, 0x1E, 0x00, 0xF0,
// 	0x07, 0x80, 0x3C, 0x01, 0xE0, 0x0F, 0x00, 0x78, 0x03, 0xC0, 0x1E, 0x00,
// 	0xF0, 0x07, 0x80, 0x3C, 0x01, 0xE0, 0x0F, 0x80, 0xEE, 0x0E, 0x3F, 0xE0,
// 	0x7C, 0x00, 0x60, 0x06, 0xC0, 0x1D, 0xC0, 0x31, 0x80, 0x63, 0x01, 0xC7,
// 	0x03, 0x06, 0x06, 0x0C, 0x1C, 0x1C, 0x30, 0x18, 0x60, 0x31, 0xC0, 0x73,
// 	0x00, 0x66, 0x00, 0xDC, 0x01, 0xF0, 0x01, 0xE0, 0x03, 0xC0, 0x07, 0x00,
// 	0xE0, 0x30, 0x1D, 0x80, 0xE0, 0x76, 0x07, 0x81, 0xD8, 0x1E, 0x06, 0x70,
// 	0x7C, 0x18, 0xC1, 0xB0, 0xE3, 0x0C, 0xC3, 0x8C, 0x33, 0x0C, 0x38, 0xC6,
// 	0x30, 0x67, 0x18, 0xC1, 0x98, 0x67, 0x06, 0x61, 0xD8, 0x1D, 0x83, 0x60,
// 	0x3C, 0x0D, 0x80, 0xF0, 0x3E, 0x03, 0xC0, 0x70, 0x0F, 0x01, 0xC0, 0x18,
// 	0x07, 0x00, 0x70, 0x0E, 0x60, 0x38, 0xE0, 0x60, 0xE1, 0xC0, 0xC3, 0x01,
// 	0xCC, 0x01, 0xF8, 0x01, 0xE0, 0x03, 0x80, 0x07, 0x80, 0x1F, 0x00, 0x33,
// 	0x00, 0xE7, 0x03, 0x86, 0x06, 0x0E, 0x1C, 0x0E, 0x70, 0x0C, 0xC0, 0x1C,
// 	0x60, 0x06, 0x70, 0x0E, 0x30, 0x1C, 0x38, 0x18, 0x1C, 0x38, 0x0C, 0x30,
// 	0x0E, 0x70, 0x06, 0x60, 0x03, 0xC0, 0x03, 0xC0, 0x01, 0x80, 0x01, 0x80,
// 	0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80,
// 	0xFF, 0xFF, 0xFF, 0xC0, 0x0E, 0x00, 0xE0, 0x0E, 0x00, 0x60, 0x07, 0x00,
// 	0x70, 0x07, 0x00, 0x30, 0x03, 0x80, 0x38, 0x03, 0x80, 0x18, 0x01, 0xC0,
// 	0x1C, 0x00, 0xFF, 0xFF, 0xFF, 0xC0, 0xFF, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC,
// 	0xCC, 0xCC, 0xCC, 0xCC, 0xCF, 0xF0, 0x81, 0x81, 0x02, 0x06, 0x04, 0x08,
// 	0x18, 0x10, 0x20, 0x60, 0x40, 0x81, 0x81, 0x02, 0x06, 0x04, 0xFF, 0x33,
// 	0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3F, 0xF0, 0x0C, 0x0E,
// 	0x05, 0x86, 0xC3, 0x21, 0x19, 0x8C, 0x83, 0xC1, 0x80, 0xFF, 0xFE, 0xE3,
// 	0x8C, 0x30, 0x3F, 0x07, 0xF8, 0xE1, 0xCC, 0x0C, 0x00, 0xC0, 0x1C, 0x3F,
// 	0xCF, 0x8C, 0xC0, 0xCC, 0x0C, 0xE3, 0xC7, 0xEF, 0x3C, 0x70, 0xC0, 0x0C,
// 	0x00, 0xC0, 0x0C, 0x00, 0xC0, 0x0C, 0xF8, 0xDF, 0xCF, 0x0E, 0xE0, 0x7C,
// 	0x03, 0xC0, 0x3C, 0x03, 0xC0, 0x3C, 0x03, 0xE0, 0x6F, 0x0E, 0xDF, 0xCC,
// 	0xF8, 0x1F, 0x0F, 0xE7, 0x1B, 0x83, 0xC0, 0x30, 0x0C, 0x03, 0x00, 0xC0,
// 	0x38, 0x37, 0x1C, 0xFE, 0x1F, 0x00, 0x00, 0x60, 0x0C, 0x01, 0x80, 0x30,
// 	0x06, 0x3C, 0xCF, 0xFB, 0x8F, 0xE0, 0xF8, 0x0F, 0x01, 0xE0, 0x3C, 0x07,
// 	0x80, 0xF8, 0x3B, 0x8F, 0x3F, 0x63, 0xCC, 0x1F, 0x07, 0xF1, 0xC7, 0x70,
// 	0x3C, 0x07, 0xFF, 0xFF, 0xFE, 0x00, 0xC0, 0x1C, 0x0D, 0xC3, 0x1F, 0xE1,
// 	0xF0, 0x3B, 0xD8, 0xC6, 0x7F, 0xEC, 0x63, 0x18, 0xC6, 0x31, 0x8C, 0x63,
// 	0x00, 0x1E, 0x67, 0xFD, 0xC7, 0xF0, 0x7C, 0x07, 0x80, 0xF0, 0x1E, 0x03,
// 	0xC0, 0x7C, 0x1D, 0xC7, 0x9F, 0xB1, 0xE6, 0x00, 0xC0, 0x3E, 0x0E, 0x7F,
// 	0xC7, 0xE0, 0xC0, 0x30, 0x0C, 0x03, 0x00, 0xC0, 0x33, 0xCD, 0xFB, 0xC7,
// 	0xE0, 0xF0, 0x3C, 0x0F, 0x03, 0xC0, 0xF0, 0x3C, 0x0F, 0x03, 0xC0, 0xF0,
// 	0x30, 0xF0, 0x3F, 0xFF, 0xFF, 0xF0, 0x33, 0x00, 0x03, 0x33, 0x33, 0x33,
// 	0x33, 0x33, 0x33, 0x33, 0x3F, 0xE0, 0xC0, 0x18, 0x03, 0x00, 0x60, 0x0C,
// 	0x01, 0x83, 0x30, 0xC6, 0x30, 0xCC, 0x1B, 0x83, 0xF0, 0x77, 0x0C, 0x61,
// 	0x8E, 0x30, 0xE6, 0x0C, 0xC1, 0xD8, 0x18, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
// 	0xCF, 0x1F, 0x6F, 0xDF, 0xFC, 0x78, 0xFC, 0x18, 0x3C, 0x0C, 0x1E, 0x06,
// 	0x0F, 0x03, 0x07, 0x81, 0x83, 0xC0, 0xC1, 0xE0, 0x60, 0xF0, 0x30, 0x78,
// 	0x18, 0x3C, 0x0C, 0x18, 0xCF, 0x37, 0xEF, 0x1F, 0x83, 0xC0, 0xF0, 0x3C,
// 	0x0F, 0x03, 0xC0, 0xF0, 0x3C, 0x0F, 0x03, 0xC0, 0xC0, 0x1F, 0x07, 0xF1,
// 	0xC7, 0x70, 0x7C, 0x07, 0x80, 0xF0, 0x1E, 0x03, 0xC0, 0x7C, 0x1D, 0xC7,
// 	0x1F, 0xC1, 0xF0, 0xCF, 0x8D, 0xFC, 0xF0, 0xEE, 0x06, 0xC0, 0x3C, 0x03,
// 	0xC0, 0x3C, 0x03, 0xC0, 0x3E, 0x07, 0xF0, 0xEF, 0xFC, 0xCF, 0x8C, 0x00,
// 	0xC0, 0x0C, 0x00, 0xC0, 0x00, 0x1E, 0x67, 0xFD, 0xC7, 0xF0, 0x7C, 0x07,
// 	0x80, 0xF0, 0x1E, 0x03, 0xC0, 0x7C, 0x1D, 0xC7, 0x9F, 0xF1, 0xE6, 0x00,
// 	0xC0, 0x18, 0x03, 0x00, 0x60, 0xCF, 0x7F, 0x38, 0xC3, 0x0C, 0x30, 0xC3,
// 	0x0C, 0x30, 0xC0, 0x3E, 0x1F, 0xEE, 0x1B, 0x00, 0xC0, 0x3C, 0x07, 0xF0,
// 	0x3E, 0x01, 0xF0, 0x3E, 0x1D, 0xFE, 0x3E, 0x00, 0x63, 0x19, 0xFF, 0xB1,
// 	0x8C, 0x63, 0x18, 0xC6, 0x31, 0xE7, 0xC0, 0xF0, 0x3C, 0x0F, 0x03, 0xC0,
// 	0xF0, 0x3C, 0x0F, 0x03, 0xC0, 0xF0, 0x7E, 0x3D, 0xFB, 0x3C, 0xC0, 0xE0,
// 	0x66, 0x06, 0x60, 0x67, 0x0C, 0x30, 0xC3, 0x0C, 0x39, 0x81, 0x98, 0x19,
// 	0x81, 0xF0, 0x0F, 0x00, 0xE0, 0x0E, 0x00, 0xC1, 0xC1, 0xB0, 0xE1, 0xD8,
// 	0x70, 0xCC, 0x2C, 0x66, 0x36, 0x31, 0x9B, 0x18, 0xCD, 0x98, 0x64, 0x6C,
// 	0x16, 0x36, 0x0F, 0x1A, 0x07, 0x8F, 0x03, 0x83, 0x80, 0xC1, 0xC0, 0x60,
// 	0xEE, 0x18, 0xC6, 0x0C, 0xC1, 0xF0, 0x1C, 0x01, 0x80, 0x78, 0x1B, 0x03,
// 	0x30, 0xC7, 0x30, 0x66, 0x06, 0xE0, 0x6C, 0x0D, 0x83, 0x38, 0x63, 0x0C,
// 	0x63, 0x0E, 0x60, 0xCC, 0x1B, 0x03, 0x60, 0x3C, 0x07, 0x00, 0xE0, 0x18,
// 	0x03, 0x00, 0xE0, 0x78, 0x0E, 0x00, 0xFF, 0xFF, 0xF0, 0x18, 0x0C, 0x07,
// 	0x03, 0x81, 0xC0, 0x60, 0x30, 0x18, 0x0E, 0x03, 0xFF, 0xFF, 0xC0, 0x19,
// 	0xCC, 0x63, 0x18, 0xC6, 0x31, 0x99, 0x86, 0x18, 0xC6, 0x31, 0x8C, 0x63,
// 	0x1C, 0x60, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xC7, 0x18, 0xC6, 0x31,
// 	0x8C, 0x63, 0x0C, 0x33, 0x31, 0x8C, 0x63, 0x18, 0xC6, 0x73, 0x00, 0x1E,
// 	0x0F, 0xC6, 0x19, 0x86, 0x61, 0x98, 0x63, 0xF0, 0x78, 0x00, 0x00, 0xC0,
// 	0x78, 0x0F, 0x01, 0xE0, 0x3C, 0x07, 0x80, 0xF0, 0x1E, 0x03, 0xC0, 0x7C,
// 	0x0F, 0xC3, 0xEF, 0xCC, 0xF1, 0x80, 0x30, 0x06, 0x00, 0xC0, 0x00, 0x3C,
// 	0x3F, 0x30, 0xC0, 0xE1, 0xC0, 0xE0, 0x1D, 0x86, 0x7E, 0x1E, 0x00};

// const GFXglyph RAK_Large_FontGlyphs[] PROGMEM = {
// 	{0, 0, 0, 6, 0, 1},			// 0x20 ' '
// 	{5, 2, 18, 8, 3, -17},		// 0x21 '!'
// 	{10, 6, 6, 8, 1, -16},		// 0x22 '"'
// 	{15, 13, 16, 13, 0, -15},	// 0x23 '#'
// 	{41, 11, 20, 13, 1, -17},	// 0x24 '$'
// 	{69, 20, 17, 21, 1, -16},	// 0x25 '%'
// 	{112, 14, 17, 16, 1, -16},	// 0x26 '&'
// 	{142, 2, 6, 5, 1, -16},		// 0x27 '''
// 	{144, 5, 23, 8, 2, -17},	// 0x28 '('
// 	{159, 5, 23, 8, 1, -17},	// 0x29 ')'
// 	{174, 7, 7, 9, 1, -17},		// 0x2A '*'
// 	{181, 10, 11, 14, 2, -10},	// 0x2B '+'
// 	{195, 2, 6, 7, 2, -1},		// 0x2C ','
// 	{197, 6, 2, 8, 1, -7},		// 0x2D '-'
// 	{199, 2, 2, 6, 2, -1},		// 0x2E '.'
// 	{200, 7, 18, 7, 0, -17},	// 0x2F '/'
// 	{216, 11, 17, 13, 1, -16},	// 0x30 '0'
// 	{240, 5, 17, 13, 3, -16},	// 0x31 '1'
// 	{251, 11, 17, 13, 1, -16},	// 0x32 '2'
// 	{275, 11, 17, 13, 1, -16},	// 0x33 '3'
// 	{299, 11, 17, 13, 1, -16},	// 0x34 '4'
// 	{323, 11, 17, 13, 1, -16},	// 0x35 '5'
// 	{347, 11, 17, 13, 1, -16},	// 0x36 '6'
// 	{371, 11, 17, 13, 1, -16},	// 0x37 '7'
// 	{395, 11, 17, 13, 1, -16},	// 0x38 '8'
// 	{419, 11, 17, 13, 1, -16},	// 0x39 '9'
// 	{443, 2, 13, 6, 2, -12},	// 0x3A ':'
// 	{447, 2, 16, 6, 2, -11},	// 0x3B ';'
// 	{451, 12, 12, 14, 1, -11},	// 0x3C '<'
// 	{469, 12, 6, 14, 1, -8},	// 0x3D '='
// 	{478, 12, 12, 14, 1, -11},	// 0x3E '>'
// 	{496, 10, 18, 13, 2, -17},	// 0x3F '?'
// 	{519, 22, 21, 24, 1, -17},	// 0x40 '@'
// 	{577, 16, 18, 16, 0, -17},	// 0x41 'A'
// 	{613, 13, 18, 16, 2, -17},	// 0x42 'B'
// 	{643, 15, 18, 17, 1, -17},	// 0x43 'C'
// 	{677, 14, 18, 17, 2, -17},	// 0x44 'D'
// 	{709, 12, 18, 15, 2, -17},	// 0x45 'E'
// 	{736, 11, 18, 14, 2, -17},	// 0x46 'F'
// 	{761, 16, 18, 18, 1, -17},	// 0x47 'G'
// 	{797, 13, 18, 17, 2, -17},	// 0x48 'H'
// 	{827, 2, 18, 7, 2, -17},	// 0x49 'I'
// 	{832, 9, 18, 13, 1, -17},	// 0x4A 'J'
// 	{853, 14, 18, 16, 2, -17},	// 0x4B 'K'
// 	{885, 10, 18, 14, 2, -17},	// 0x4C 'L'
// 	{908, 16, 18, 20, 2, -17},	// 0x4D 'M'
// 	{944, 13, 18, 18, 2, -17},	// 0x4E 'N'
// 	{974, 17, 18, 19, 1, -17},	// 0x4F 'O'
// 	{1013, 12, 18, 16, 2, -17}, // 0x50 'P'
// 	{1040, 17, 19, 19, 1, -17}, // 0x51 'Q'
// 	{1081, 14, 18, 17, 2, -17}, // 0x52 'R'
// 	{1113, 14, 18, 16, 1, -17}, // 0x53 'S'
// 	{1145, 12, 18, 15, 1, -17}, // 0x54 'T'
// 	{1172, 13, 18, 17, 2, -17}, // 0x55 'U'
// 	{1202, 15, 18, 15, 0, -17}, // 0x56 'V'
// 	{1236, 22, 18, 22, 0, -17}, // 0x57 'W'
// 	{1286, 15, 18, 16, 0, -17}, // 0x58 'X'
// 	{1320, 16, 18, 16, 0, -17}, // 0x59 'Y'
// 	{1356, 13, 18, 15, 1, -17}, // 0x5A 'Z'
// 	{1386, 4, 23, 7, 2, -17},	// 0x5B '['
// 	{1398, 7, 18, 7, 0, -17},	// 0x5C '\'
// 	{1414, 4, 23, 7, 1, -17},	// 0x5D ']'
// 	{1426, 9, 9, 11, 1, -16},	// 0x5E '^'
// 	{1437, 15, 1, 13, -1, 4},	// 0x5F '_'
// 	{1439, 5, 4, 6, 1, -17},	// 0x60 '`'
// 	{1442, 12, 13, 13, 1, -12}, // 0x61 'a'
// 	{1462, 12, 18, 13, 1, -17}, // 0x62 'b'
// 	{1489, 10, 13, 12, 1, -12}, // 0x63 'c'
// 	{1506, 11, 18, 13, 1, -17}, // 0x64 'd'
// 	{1531, 11, 13, 13, 1, -12}, // 0x65 'e'
// 	{1549, 5, 18, 7, 1, -17},	// 0x66 'f'
// 	{1561, 11, 18, 13, 1, -12}, // 0x67 'g'
// 	{1586, 10, 18, 13, 1, -17}, // 0x68 'h'
// 	{1609, 2, 18, 5, 2, -17},	// 0x69 'i'
// 	{1614, 4, 23, 6, 0, -17},	// 0x6A 'j'
// 	{1626, 11, 18, 12, 1, -17}, // 0x6B 'k'
// 	{1651, 2, 18, 5, 1, -17},	// 0x6C 'l'
// 	{1656, 17, 13, 19, 1, -12}, // 0x6D 'm'
// 	{1684, 10, 13, 13, 1, -12}, // 0x6E 'n'
// 	{1701, 11, 13, 13, 1, -12}, // 0x6F 'o'
// 	{1719, 12, 17, 13, 1, -12}, // 0x70 'p'
// 	{1745, 11, 17, 13, 1, -12}, // 0x71 'q'
// 	{1769, 6, 13, 8, 1, -12},	// 0x72 'r'
// 	{1779, 10, 13, 12, 1, -12}, // 0x73 's'
// 	{1796, 5, 16, 7, 1, -15},	// 0x74 't'
// 	{1806, 10, 13, 13, 1, -12}, // 0x75 'u'
// 	{1823, 12, 13, 12, 0, -12}, // 0x76 'v'
// 	{1843, 17, 13, 17, 0, -12}, // 0x77 'w'
// 	{1871, 11, 13, 11, 0, -12}, // 0x78 'x'
// 	{1889, 11, 18, 11, 0, -12}, // 0x79 'y'
// 	{1914, 10, 13, 12, 1, -12}, // 0x7A 'z'
// 	{1931, 5, 23, 8, 1, -17},	// 0x7B '{'
// 	{1946, 2, 23, 6, 2, -17},	// 0x7C '|'
// 	{1952, 5, 23, 8, 2, -17},	// 0x7D '}'
// 	{1967, 10, 9, 12, 1, -17},	// 0x7E '°'
// 	{1979, 11, 17, 14, 1, -12}, // 0x7F 'μ'
// 	{2003, 9, 10, 11, 1, -17}	// 0x80 '³'
// };

// const GFXfont RAK_Large_Font PROGMEM = {(uint8_t *)RAK_Large_FontBitmaps,
// 										(GFXglyph *)RAK_Large_FontGlyphs, 0x20, 0x80, 29};

// const uint8_t RAK_Medium_FontBitmaps[] PROGMEM = {
// 	0x00, 0xFF, 0xF1, 0xC0, 0xD9, 0x99, 0x29, 0xA6, 0xBF, 0x69, 0xAF, 0xD6,
// 	0x59, 0x60, 0x31, 0xF4, 0xD0, 0x78, 0x3C, 0x7F, 0x30, 0xC1, 0x00, 0xF2,
// 	0x47, 0x07, 0xF8, 0x92, 0x47, 0x01, 0xE4, 0x18, 0x6F, 0xFD, 0x9F, 0xF4,
// 	0x0F, 0x69, 0x24, 0xC9, 0x80, 0x93, 0x26, 0xDA, 0x5A, 0x00, 0x00, 0xCF,
// 	0xDE, 0x39, 0xA0, 0x10, 0x60, 0xC7, 0xEF, 0xE6, 0x0C, 0x18, 0x6B, 0x40,
// 	0xFD, 0xFC, 0x70, 0x04, 0x10, 0xC2, 0x18, 0x43, 0x08, 0x61, 0x0C, 0x00,
// 	0x31, 0xEC, 0xF1, 0xC7, 0x1C, 0x53, 0x78, 0x13, 0xC3, 0x0C, 0x30, 0xC3,
// 	0x0C, 0xFC, 0x33, 0xE8, 0xC3, 0x18, 0xC6, 0x31, 0xFC, 0x33, 0xF0, 0x43,
// 	0x38, 0x30, 0x63, 0xF8, 0x18, 0x63, 0x8A, 0x4B, 0x2F, 0xC2, 0x3C, 0x79,
// 	0xF4, 0x1E, 0x7C, 0x10, 0x63, 0xF8, 0x1C, 0xF6, 0x10, 0xFF, 0x14, 0x59,
// 	0x3C, 0xFF, 0xF8, 0xC2, 0x08, 0x61, 0x04, 0x30, 0x31, 0xFC, 0x73, 0x79,
// 	0x3C, 0x73, 0x78, 0x39, 0xF4, 0x51, 0x7C, 0xD0, 0xC6, 0xF0, 0xF0, 0x70,
// 	0x6C, 0x06, 0xB4, 0x04, 0x77, 0x38, 0x38, 0x30, 0xFF, 0xF8, 0x07, 0xF0,
// 	0x81, 0xC0, 0xE0, 0xE7, 0x18, 0x00, 0x7B, 0x30, 0x43, 0x38, 0x41, 0x0C,
// 	0x01, 0xEC, 0xE1, 0xBE, 0x9A, 0x67, 0x81, 0x07, 0x80, 0x78, 0x0C, 0x0F,
// 	0x04, 0x87, 0xE3, 0xF1, 0x0D, 0xCE, 0xFC, 0x66, 0x62, 0x7E, 0x7E, 0x63,
// 	0x63, 0xFE, 0x3E, 0x63, 0x42, 0xC0, 0xC0, 0x40, 0x63, 0x3E, 0xFC, 0x46,
// 	0x42, 0x43, 0x43, 0x42, 0x46, 0xFC, 0xFE, 0x62, 0x6A, 0x78, 0x78, 0x6A,
// 	0x63, 0xFF, 0xFF, 0x63, 0x6A, 0x78, 0x78, 0x68, 0x60, 0xF8, 0x3F, 0x63,
// 	0x42, 0xC0, 0xCF, 0x4F, 0x63, 0x3E, 0x77, 0x62, 0x62, 0x7E, 0x7E, 0x62,
// 	0x62, 0xF7, 0xFC, 0xC3, 0x0C, 0x30, 0xC3, 0x3F, 0x3E, 0x18, 0x30, 0x68,
// 	0xD1, 0xA3, 0x7C, 0xF7, 0x66, 0x6C, 0x78, 0x6C, 0x64, 0x66, 0xF3, 0xF8,
// 	0x30, 0x30, 0x30, 0x30, 0x33, 0x33, 0xFF, 0xC3, 0x33, 0x99, 0xCF, 0xE5,
// 	0xF2, 0xD9, 0x0D, 0xCF, 0xE7, 0x62, 0x72, 0x5A, 0x4A, 0x4E, 0x46, 0xF2,
// 	0x3C, 0x66, 0x43, 0xC1, 0xC1, 0x43, 0x66, 0x3C, 0xFC, 0xCD, 0x8B, 0x37,
// 	0xCC, 0x18, 0x7C, 0x3C, 0x66, 0x43, 0xC1, 0xC1, 0x43, 0x66, 0x3C, 0x3B,
// 	0x3E, 0xFC, 0x66, 0x62, 0x66, 0x7C, 0x66, 0x62, 0xF3, 0x7F, 0x3C, 0x5C,
// 	0x3E, 0x1C, 0xFF, 0xFF, 0x6E, 0xDD, 0x83, 0x06, 0x0C, 0x3E, 0xF7, 0x42,
// 	0x42, 0x42, 0x42, 0x42, 0x66, 0x3C, 0xE7, 0x21, 0x98, 0x84, 0xC3, 0x41,
// 	0xE0, 0x60, 0x30, 0xE7, 0x43, 0x5B, 0x5A, 0x5E, 0x76, 0x66, 0x66, 0xE7,
// 	0x66, 0x3C, 0x18, 0x18, 0x34, 0x66, 0xE7, 0xE7, 0x66, 0x34, 0x1C, 0x18,
// 	0x18, 0x18, 0x3E, 0xFF, 0x3D, 0x8C, 0x21, 0x9C, 0x7F, 0xEE, 0xCC, 0xCC,
// 	0xCC, 0xCC, 0xE0, 0x03, 0x04, 0x18, 0x20, 0xC1, 0x06, 0x08, 0x30, 0xC1,
// 	0xFD, 0xB6, 0xDB, 0x6F, 0x80, 0x00, 0xC7, 0xB3, 0x04, 0xFF, 0x19, 0x80,
// 	0xF8, 0x19, 0xF6, 0x68, 0xDF, 0xC0, 0xC0, 0xC0, 0x40, 0x7E, 0x62, 0x43,
// 	0x43, 0x62, 0xFE, 0x7D, 0x8A, 0x14, 0x0C, 0x6F, 0x80, 0x06, 0x06, 0x02,
// 	0x3E, 0x66, 0xC2, 0xC2, 0x66, 0x3F, 0x3C, 0x66, 0xFE, 0xFF, 0x62, 0x3E,
// 	0x08, 0x7C, 0x87, 0xE2, 0x04, 0x08, 0x10, 0xFC, 0x3F, 0x66, 0xC2, 0xC2,
// 	0x66, 0x3E, 0x02, 0x3E, 0x3C, 0x60, 0xE0, 0x60, 0x7C, 0x66, 0x62, 0x62,
// 	0x62, 0xF7, 0x30, 0xC0, 0x3C, 0x30, 0xC3, 0x0C, 0xFC, 0x31, 0x81, 0xF1,
// 	0x8C, 0x63, 0x18, 0xFD, 0xC0, 0x60, 0x60, 0x20, 0x2E, 0x2C, 0x38, 0x38,
// 	0x2C, 0xEF, 0x71, 0xC3, 0x0C, 0x30, 0xC3, 0x0C, 0xFC, 0xFE, 0x2D, 0x96,
// 	0xCB, 0x65, 0xB7, 0xFC, 0xFC, 0x66, 0x62, 0x62, 0x62, 0xF7, 0x79, 0x9A,
// 	0x1C, 0x3C, 0xCF, 0x00, 0xDE, 0x62, 0x43, 0x63, 0x7E, 0x5C, 0x40, 0xF0,
// 	0xF0, 0x3F, 0x66, 0xC2, 0x42, 0x7E, 0x3A, 0x02, 0x07, 0x0F, 0xFE, 0xE5,
// 	0x83, 0x06, 0x1F, 0x80, 0x7F, 0x3F, 0x87, 0xC7, 0xF0, 0x20, 0x43, 0xF1,
// 	0x02, 0x04, 0x08, 0x9F, 0xEE, 0x62, 0x62, 0x62, 0x66, 0x3B, 0xF7, 0x62,
// 	0x26, 0x34, 0x1C, 0x18, 0xE7, 0x5A, 0x5A, 0x7E, 0x36, 0x24, 0x77, 0x66,
// 	0x1C, 0x3C, 0x66, 0xF7, 0xE7, 0x62, 0x26, 0x34, 0x1C, 0x18, 0x18, 0x78,
// 	0xF8, 0xFF, 0x31, 0x88, 0x47, 0xF0, 0x03, 0x66, 0x6E, 0x66, 0x66, 0x30,
// 	0x3F, 0xFF, 0xFC, 0x0E, 0x66, 0x63, 0x26, 0x66, 0xC0, 0x31, 0x28, 0x52,
// 	0x30, 0x00, 0xE2, 0x62, 0x62, 0x62, 0x62, 0x5C, 0x40, 0xE0, 0xF0, 0x61,
// 	0x21, 0x60};

// const GFXglyph RAK_Medium_FontGlyphs[] PROGMEM = {
// 	{0, 1, 1, 8, 0, 0},		// 0x20 ' '
// 	{1, 2, 9, 8, 3, -8},	// 0x21 '!'
// 	{4, 4, 4, 8, 2, -7},	// 0x22 '"'
// 	{6, 6, 10, 8, 1, -8},	// 0x23 '#'
// 	{14, 6, 11, 8, 1, -8},	// 0x24 '$'
// 	{23, 6, 8, 8, 1, -7},	// 0x25 '%'
// 	{29, 6, 8, 8, 1, -7},	// 0x26 '&'
// 	{35, 2, 4, 8, 3, -7},	// 0x27 '''
// 	{36, 3, 11, 8, 4, -8},	// 0x28 '('
// 	{41, 3, 11, 8, 2, -8},	// 0x29 ')'
// 	{46, 6, 6, 8, 1, -8},	// 0x2A '*'
// 	{51, 7, 8, 8, 1, -7},	// 0x2B '+'
// 	{58, 3, 4, 8, 2, -1},	// 0x2C ','
// 	{60, 7, 2, 8, 1, -4},	// 0x2D '-'
// 	{62, 2, 2, 8, 3, -1},	// 0x2E '.'
// 	{63, 6, 12, 8, 1, -9},	// 0x2F '/'
// 	{72, 6, 9, 8, 1, -8},	// 0x30 '0'
// 	{79, 6, 9, 8, 1, -8},	// 0x31 '1'
// 	{86, 6, 9, 8, 1, -8},	// 0x32 '2'
// 	{93, 6, 9, 8, 1, -8},	// 0x33 '3'
// 	{100, 6, 9, 8, 1, -8},	// 0x34 '4'
// 	{107, 6, 9, 8, 1, -8},	// 0x35 '5'
// 	{114, 6, 9, 8, 1, -8},	// 0x36 '6'
// 	{121, 6, 9, 8, 1, -8},	// 0x37 '7'
// 	{128, 6, 9, 8, 1, -8},	// 0x38 '8'
// 	{135, 6, 9, 8, 1, -8},	// 0x39 '9'
// 	{142, 2, 6, 8, 3, -5},	// 0x3A ':'
// 	{144, 3, 8, 8, 2, -5},	// 0x3B ';'
// 	{147, 6, 6, 8, 1, -6},	// 0x3C '<'
// 	{152, 7, 4, 8, 1, -5},	// 0x3D '='
// 	{156, 7, 6, 8, 1, -6},	// 0x3E '>'
// 	{162, 6, 8, 8, 1, -7},	// 0x3F '?'
// 	{168, 6, 11, 8, 1, -8}, // 0x40 '@'
// 	{177, 9, 8, 8, 0, -7},	// 0x41 'A'
// 	{186, 8, 8, 8, 0, -7},	// 0x42 'B'
// 	{194, 8, 8, 8, 0, -7},	// 0x43 'C'
// 	{202, 8, 8, 8, 0, -7},	// 0x44 'D'
// 	{210, 8, 8, 8, 0, -7},	// 0x45 'E'
// 	{218, 8, 8, 8, 0, -7},	// 0x46 'F'
// 	{226, 8, 8, 8, 0, -7},	// 0x47 'G'
// 	{234, 8, 8, 8, 0, -7},	// 0x48 'H'
// 	{242, 6, 8, 8, 1, -7},	// 0x49 'I'
// 	{248, 7, 8, 8, 1, -7},	// 0x4A 'J'
// 	{255, 8, 8, 8, 0, -7},	// 0x4B 'K'
// 	{263, 8, 8, 8, 0, -7},	// 0x4C 'L'
// 	{271, 9, 8, 8, 0, -7},	// 0x4D 'M'
// 	{280, 8, 8, 8, 0, -7},	// 0x4E 'N'
// 	{288, 8, 8, 8, 0, -7},	// 0x4F 'O'
// 	{296, 7, 8, 8, 0, -7},	// 0x50 'P'
// 	{303, 8, 10, 8, 0, -7}, // 0x51 'Q'
// 	{313, 8, 8, 8, 0, -7},	// 0x52 'R'
// 	{321, 6, 8, 8, 1, -7},	// 0x53 'S'
// 	{327, 7, 8, 8, 1, -7},	// 0x54 'T'
// 	{334, 8, 8, 8, 0, -7},	// 0x55 'U'
// 	{342, 9, 8, 8, 0, -7},	// 0x56 'V'
// 	{351, 8, 8, 8, 0, -7},	// 0x57 'W'
// 	{359, 8, 8, 8, 0, -7},	// 0x58 'X'
// 	{367, 8, 8, 8, 0, -7},	// 0x59 'Y'
// 	{375, 6, 8, 8, 1, -7},	// 0x5A 'Z'
// 	{381, 4, 11, 8, 3, -8}, // 0x5B '['
// 	{387, 6, 12, 8, 1, -9}, // 0x5C '\'
// 	{396, 3, 11, 8, 2, -8}, // 0x5D ']'
// 	{401, 6, 5, 8, 1, -8},	// 0x5E '^'
// 	{405, 8, 1, 8, 0, 2},	// 0x5F '_'
// 	{406, 3, 3, 8, 2, -9},	// 0x60 '`'
// 	{408, 7, 6, 8, 1, -5},	// 0x61 'a'
// 	{414, 8, 9, 8, 0, -8},	// 0x62 'b'
// 	{423, 7, 6, 8, 1, -5},	// 0x63 'c'
// 	{429, 8, 9, 8, 0, -8},	// 0x64 'd'
// 	{438, 8, 6, 8, 0, -5},	// 0x65 'e'
// 	{444, 7, 9, 8, 1, -8},	// 0x66 'f'
// 	{452, 8, 9, 8, 0, -5},	// 0x67 'g'
// 	{461, 8, 9, 8, 0, -8},	// 0x68 'h'
// 	{470, 6, 9, 8, 1, -8},	// 0x69 'i'
// 	{477, 5, 12, 8, 2, -8}, // 0x6A 'j'
// 	{485, 8, 9, 8, 0, -8},	// 0x6B 'k'
// 	{494, 6, 9, 8, 1, -8},	// 0x6C 'l'
// 	{501, 9, 6, 8, 0, -5},	// 0x6D 'm'
// 	{508, 8, 6, 8, 0, -5},	// 0x6E 'n'
// 	{514, 7, 6, 8, 1, -5},	// 0x6F 'o'
// 	{520, 8, 9, 8, 0, -5},	// 0x70 'p'
// 	{529, 8, 9, 8, 0, -5},	// 0x71 'q'
// 	{538, 7, 6, 8, 1, -5},	// 0x72 'r'
// 	{544, 6, 6, 8, 1, -5},	// 0x73 's'
// 	{549, 7, 8, 8, 0, -7},	// 0x74 't'
// 	{556, 8, 6, 8, 0, -5},	// 0x75 'u'
// 	{562, 8, 6, 8, 0, -5},	// 0x76 'v'
// 	{568, 8, 6, 8, 0, -5},	// 0x77 'w'
// 	{574, 8, 6, 8, 0, -5},	// 0x78 'x'
// 	{580, 8, 9, 8, 0, -5},	// 0x79 'y'
// 	{589, 6, 6, 8, 1, -5},	// 0x7A 'z'
// 	{594, 4, 11, 8, 2, -8}, // 0x7B '{'
// 	{600, 2, 11, 8, 3, -8}, // 0x7C '|'
// 	{603, 4, 11, 8, 2, -8}, // 0x7D '}'
// 	{609, 6, 5, 8, 1, -9},	// 0x7E '°'
// 	{614, 8, 9, 8, 0, -5},	// 0x7F 'μ'
// 	{623, 4, 5, 4, 0, -9}	// 0x80 '³'
// };

// const GFXfont RAK_Medium_Font PROGMEM = {
// 	(uint8_t *)RAK_Medium_FontBitmaps,
// 	(GFXglyph *)RAK_Medium_FontGlyphs, 0x20, 0x80, 22};

// const uint8_t Font_5x7_practical8pt7bBitmaps[] PROGMEM = {
// 	0xFA, 0xFA, 0xB6, 0x80, 0x57, 0xD5, 0xF5, 0x00, 0x23, 0xA3, 0x07, 0x06,
// 	0x2E, 0x20, 0xCE, 0x44, 0x44, 0x4E, 0x60, 0x64, 0xA4, 0xCA, 0xC9, 0xA0,
// 	0xE0, 0x6A, 0xA4, 0x95, 0x58, 0x55, 0x00, 0x21, 0x3E, 0x42, 0x00, 0xF6,
// 	0xF8, 0xF0, 0x25, 0x25, 0x20, 0x74, 0x63, 0x58, 0xC5, 0xC0, 0x75, 0x54,
// 	0x74, 0x62, 0x22, 0x23, 0xE0, 0xF8, 0x88, 0xE0, 0xC5, 0xC0, 0x12, 0x95,
// 	0x2F, 0x88, 0x40, 0xFC, 0x21, 0xE0, 0x87, 0xC0, 0x74, 0x61, 0x6C, 0xC5,
// 	0xC0, 0xF8, 0x44, 0x22, 0x10, 0x80, 0x74, 0x62, 0xE8, 0xC5, 0xC0, 0x74,
// 	0x62, 0xF0, 0xC5, 0xC0, 0xF0, 0xF0, 0xF0, 0xF6, 0x1B, 0x20, 0xC1, 0x80,
// 	0xF8, 0x3E, 0xC1, 0x82, 0x6C, 0x00, 0x74, 0x62, 0x22, 0x00, 0x80, 0x74,
// 	0x67, 0x59, 0xC1, 0xC0, 0x22, 0x95, 0x1F, 0xC6, 0x20, 0xF4, 0x63, 0xE8,
// 	0xC7, 0xC0, 0x74, 0x61, 0x08, 0x45, 0xC0, 0xF4, 0x63, 0x18, 0xC7, 0xC0,
// 	0xFC, 0x21, 0xE8, 0x43, 0xE0, 0xFC, 0x21, 0xE8, 0x42, 0x00, 0x74, 0x61,
// 	0x38, 0xC5, 0xE0, 0x8C, 0x63, 0xF8, 0xC6, 0x20, 0xFE, 0xF8, 0x43, 0x18,
// 	0xC5, 0xC0, 0x8C, 0x65, 0xC9, 0x46, 0x20, 0x84, 0x21, 0x08, 0x43, 0xE0,
// 	0x8E, 0xF7, 0x5A, 0xC6, 0x20, 0x8E, 0x73, 0x5A, 0xCE, 0x60, 0x74, 0x63,
// 	0x18, 0xC5, 0xC0, 0xF4, 0x63, 0xE8, 0x42, 0x00, 0x74, 0x63, 0x1A, 0xC9,
// 	0xA0, 0xF4, 0x63, 0xEA, 0x4A, 0x20, 0x74, 0x60, 0xE0, 0xC5, 0xC0, 0xF9,
// 	0x08, 0x42, 0x10, 0x80, 0x8C, 0x63, 0x18, 0xC5, 0xE0, 0x8C, 0x63, 0x15,
// 	0x28, 0x80, 0x8C, 0x6B, 0x5A, 0xA9, 0x40, 0x8C, 0x54, 0x45, 0x46, 0x20,
// 	0x8C, 0x54, 0x42, 0x10, 0x80, 0xF8, 0x44, 0x44, 0x43, 0xE0, 0xEA, 0xAC,
// 	0x91, 0x24, 0x48, 0xD5, 0x5C, 0x22, 0xA3, 0x10, 0xF8, 0x88, 0x80, 0x70,
// 	0x5F, 0x17, 0x80, 0x84, 0x2D, 0x98, 0xC7, 0xC0, 0x7C, 0x21, 0x07, 0x80,
// 	0x08, 0x5B, 0x38, 0xC5, 0xE0, 0x74, 0x7F, 0x07, 0x00, 0x34, 0x4F, 0x44,
// 	0x40, 0x6C, 0xE3, 0x17, 0x85, 0xC0, 0x84, 0x2D, 0x98, 0xC6, 0x20, 0xBE,
// 	0x45, 0x55, 0x80, 0x88, 0x9A, 0xCA, 0x90, 0xAA, 0xA4, 0xD5, 0x6B, 0x5A,
// 	0x80, 0xB6, 0x63, 0x18, 0x80, 0x74, 0x63, 0x17, 0x00, 0xB6, 0x63, 0x1F,
// 	0x42, 0x00, 0x6C, 0xE3, 0x17, 0x84, 0x20, 0xBC, 0x88, 0x80, 0x7C, 0x1C,
// 	0x1F, 0x00, 0x44, 0xF4, 0x44, 0x30, 0x8C, 0x63, 0x36, 0x80, 0x8C, 0x62,
// 	0xA2, 0x00, 0x8D, 0x6A, 0xA5, 0x00, 0x8A, 0x88, 0xA8, 0x80, 0x8C, 0x62,
// 	0xA2, 0x22, 0x00, 0xF8, 0x88, 0x8F, 0x80, 0x69, 0x44, 0x98, 0xFE, 0xC9,
// 	0x14, 0xB0, 0x74, 0x62, 0xE0, 0x8C, 0x63, 0x9B, 0x42, 0x00, 0x61, 0x21,
// 	0x60};

// const GFXglyph Font_5x7_practical8pt7bGlyphs[] PROGMEM = {
// 	{0, 0, 0, 4, 0, 1},		// 0x20 ' '
// 	{1, 1, 7, 2, 0, -6},	// 0x21 '!'
// 	{2, 3, 3, 4, 0, -7},	// 0x22 '"'
// 	{4, 5, 5, 6, 0, -5},	// 0x23 '#'
// 	{8, 5, 9, 6, 0, -7},	// 0x24 '$'
// 	{14, 5, 7, 6, 0, -6},	// 0x25 '%'
// 	{19, 5, 7, 6, 0, -6},	// 0x26 '&'
// 	{24, 1, 3, 2, 0, -7},	// 0x27 '''
// 	{25, 2, 7, 4, 1, -6},	// 0x28 '('
// 	{27, 2, 7, 4, 0, -6},	// 0x29 ')'
// 	{29, 3, 3, 5, 1, -7},	// 0x2A '*'
// 	{31, 5, 5, 6, 0, -5},	// 0x2B '+'
// 	{35, 2, 4, 5, 0, -1},	// 0x2C ','
// 	{36, 5, 1, 6, 0, -3},	// 0x2D '-'
// 	{37, 2, 2, 5, 0, -1},	// 0x2E '.'
// 	{38, 3, 7, 5, 1, -6},	// 0x2F '/'
// 	{41, 5, 7, 6, 0, -6},	// 0x30 '0'
// 	{46, 2, 7, 3, 0, -6},	// 0x31 '1'
// 	{48, 5, 7, 6, 0, -6},	// 0x32 '2'
// 	{53, 5, 7, 6, 0, -6},	// 0x33 '3'
// 	{58, 5, 7, 6, 0, -6},	// 0x34 '4'
// 	{63, 5, 7, 6, 0, -6},	// 0x35 '5'
// 	{68, 5, 7, 6, 0, -6},	// 0x36 '6'
// 	{73, 5, 7, 6, 0, -6},	// 0x37 '7'
// 	{78, 5, 7, 6, 0, -6},	// 0x38 '8'
// 	{83, 5, 7, 6, 0, -6},	// 0x39 '9'
// 	{88, 2, 6, 5, 0, -6},	// 0x3A ':'
// 	{90, 2, 8, 5, 0, -6},	// 0x3B ';'
// 	{92, 5, 5, 6, 0, -5},	// 0x3C '<'
// 	{96, 5, 3, 6, 0, -4},	// 0x3D '='
// 	{98, 5, 5, 6, 0, -5},	// 0x3E '>'
// 	{102, 5, 7, 6, 0, -6},	// 0x3F '?'
// 	{107, 5, 7, 6, 0, -6},	// 0x40 '@'
// 	{112, 5, 7, 6, 0, -6},	// 0x41 'A'
// 	{117, 5, 7, 6, 0, -6},	// 0x42 'B'
// 	{122, 5, 7, 6, 0, -6},	// 0x43 'C'
// 	{127, 5, 7, 6, 0, -6},	// 0x44 'D'
// 	{132, 5, 7, 6, 0, -6},	// 0x45 'E'
// 	{137, 5, 7, 6, 0, -6},	// 0x46 'F'
// 	{142, 5, 7, 6, 0, -6},	// 0x47 'G'
// 	{147, 5, 7, 6, 0, -6},	// 0x48 'H'
// 	{152, 1, 7, 2, 0, -6},	// 0x49 'I'
// 	{153, 5, 7, 6, 0, -6},	// 0x4A 'J'
// 	{158, 5, 7, 6, 0, -6},	// 0x4B 'K'
// 	{163, 5, 7, 6, 0, -6},	// 0x4C 'L'
// 	{168, 5, 7, 6, 0, -6},	// 0x4D 'M'
// 	{173, 5, 7, 6, 0, -6},	// 0x4E 'N'
// 	{178, 5, 7, 6, 0, -6},	// 0x4F 'O'
// 	{183, 5, 7, 6, 0, -6},	// 0x50 'P'
// 	{188, 5, 7, 6, 0, -6},	// 0x51 'Q'
// 	{193, 5, 7, 6, 0, -6},	// 0x52 'R'
// 	{198, 5, 7, 6, 0, -6},	// 0x53 'S'
// 	{203, 5, 7, 6, 0, -6},	// 0x54 'T'
// 	{208, 5, 7, 6, 0, -6},	// 0x55 'U'
// 	{213, 5, 7, 6, 0, -6},	// 0x56 'V'
// 	{218, 5, 7, 6, 0, -6},	// 0x57 'W'
// 	{223, 5, 7, 6, 0, -6},	// 0x58 'X'
// 	{228, 5, 7, 6, 0, -6},	// 0x59 'Y'
// 	{233, 5, 7, 6, 0, -6},	// 0x5A 'Z'
// 	{238, 2, 7, 4, 1, -6},	// 0x5B '['
// 	{240, 3, 7, 5, 1, -6},	// 0x5C '\'
// 	{243, 2, 7, 4, 0, -6},	// 0x5D ']'
// 	{245, 5, 4, 6, 0, -7},	// 0x5E '^'
// 	{248, 5, 1, 6, 0, 1},	// 0x5F '_'
// 	{249, 3, 3, 5, 1, -7},	// 0x60 '`'
// 	{251, 5, 5, 6, 0, -4},	// 0x61 'a'
// 	{255, 5, 7, 6, 0, -6},	// 0x62 'b'
// 	{260, 5, 5, 6, 0, -4},	// 0x63 'c'
// 	{264, 5, 7, 6, 0, -6},	// 0x64 'd'
// 	{269, 5, 5, 6, 0, -4},	// 0x65 'e'
// 	{273, 4, 7, 5, 0, -6},	// 0x66 'f'
// 	{277, 5, 7, 6, 0, -4},	// 0x67 'g'
// 	{282, 5, 7, 6, 0, -6},	// 0x68 'h'
// 	{287, 1, 7, 2, 0, -6},	// 0x69 'i'
// 	{288, 2, 9, 2, -1, -6}, // 0x6A 'j'
// 	{291, 4, 7, 5, 0, -6},	// 0x6B 'k'
// 	{295, 2, 7, 3, 0, -6},	// 0x6C 'l'
// 	{297, 5, 5, 6, 0, -4},	// 0x6D 'm'
// 	{301, 5, 5, 6, 0, -4},	// 0x6E 'n'
// 	{305, 5, 5, 6, 0, -4},	// 0x6F 'o'
// 	{309, 5, 7, 6, 0, -4},	// 0x70 'p'
// 	{314, 5, 7, 6, 0, -4},	// 0x71 'q'
// 	{319, 4, 5, 5, 0, -4},	// 0x72 'r'
// 	{322, 5, 5, 6, 0, -4},	// 0x73 's'
// 	{326, 4, 7, 5, 0, -6},	// 0x74 't'
// 	{330, 5, 5, 6, 0, -4},	// 0x75 'u'
// 	{334, 5, 5, 6, 0, -4},	// 0x76 'v'
// 	{338, 5, 5, 6, 0, -4},	// 0x77 'w'
// 	{342, 5, 5, 6, 0, -4},	// 0x78 'x'
// 	{346, 5, 7, 6, 0, -4},	// 0x79 'y'
// 	{351, 5, 5, 6, 0, -4},	// 0x7A 'z'
// 	{355, 3, 7, 6, 2, -6},	// 0x7B '{'
// 	{358, 1, 7, 4, 1, -6},	// 0x7C '|'
// 	{359, 3, 7, 4, 0, -6},	// 0x7D '}'
// 	{362, 5, 4, 6, 0, -7},	// 0x7E '°'
// 	{365, 5, 7, 6, 0, -4},	// 0x7F 'μ'
// 	{370, 4, 5, 4, 0, -7}	// 0x80 '³'
// };

// const GFXfont Font_5x7_practical8pt7b PROGMEM = {
// 	(uint8_t *)Font_5x7_practical8pt7bBitmaps,
// 	(GFXglyph *)Font_5x7_practical8pt7bGlyphs, 0x20, 0x80, 10};

// const uint8_t Monospaced_plain_11Bitmaps[] PROGMEM = {
// 	0x00, 0xAA, 0xA2, 0xAA, 0xA0, 0x14, 0x24, 0x7E, 0x28, 0x28, 0xFC, 0x48,
// 	0x50, 0x21, 0xEA, 0x28, 0x70, 0xA2, 0xBC, 0x20, 0x80, 0xE1, 0x43, 0x90,
// 	0xC2, 0x1B, 0x85, 0x0E, 0x70, 0x81, 0x03, 0x0B, 0x52, 0xA2, 0x3E, 0xA8,
// 	0x52, 0x49, 0x24, 0x88, 0x91, 0x24, 0x92, 0x90, 0x22, 0xA7, 0x1C, 0xA8,
// 	0x80, 0x20, 0x8F, 0x88, 0x20, 0x4A, 0x00, 0xE0, 0xA0, 0x08, 0x41, 0x08,
// 	0x20, 0x84, 0x10, 0x80, 0x79, 0x9A, 0x14, 0xA8, 0x50, 0xB3, 0x3C, 0xE0,
// 	0x82, 0x08, 0x20, 0x82, 0x3E, 0x79, 0x08, 0x10, 0x61, 0x86, 0x10, 0x7E,
// 	0x79, 0x08, 0x13, 0xC0, 0xC0, 0xA1, 0x3C, 0x18, 0x30, 0xA2, 0x4C, 0x9F,
// 	0x82, 0x04, 0xF9, 0x02, 0x07, 0xC0, 0xC0, 0x81, 0x7C, 0x3C, 0x82, 0x05,
// 	0xCC, 0x50, 0xA1, 0x3C, 0xFC, 0x10, 0x20, 0x81, 0x04, 0x08, 0x20, 0x79,
// 	0x0A, 0x13, 0xC8, 0x50, 0xA1, 0x3C, 0x79, 0x0A, 0x14, 0x27, 0xC0, 0x82,
// 	0x78, 0xA0, 0xA0, 0x48, 0x04, 0xA0, 0x04, 0x73, 0x03, 0x80, 0xC0, 0xFC,
// 	0x03, 0xF0, 0x80, 0xE0, 0x31, 0xCC, 0x00, 0xE0, 0x8C, 0xC4, 0x20, 0x08,
// 	0x38, 0x9A, 0x14, 0xEA, 0x54, 0xA7, 0x60, 0x40, 0x70, 0x30, 0x60, 0xC2,
// 	0x44, 0x8F, 0x21, 0x42, 0xF9, 0x0A, 0x17, 0xC8, 0x50, 0xA1, 0x7C, 0x38,
// 	0x8A, 0x04, 0x08, 0x10, 0x11, 0x1C, 0xF1, 0x12, 0x14, 0x28, 0x50, 0xA2,
// 	0x78, 0xFD, 0x02, 0x07, 0xE8, 0x10, 0x20, 0x7E, 0xFD, 0x02, 0x07, 0xE8,
// 	0x10, 0x20, 0x40, 0x38, 0x8A, 0x04, 0x08, 0xD0, 0x91, 0x1C, 0x85, 0x0A,
// 	0x17, 0xE8, 0x50, 0xA1, 0x42, 0xF8, 0x82, 0x08, 0x20, 0x82, 0x3E, 0x38,
// 	0x20, 0x82, 0x08, 0x28, 0x9C, 0x89, 0x22, 0x86, 0x0A, 0x12, 0x22, 0x42,
// 	0x81, 0x02, 0x04, 0x08, 0x10, 0x20, 0x7E, 0x85, 0x9B, 0x35, 0xAB, 0x50,
// 	0xA1, 0x42, 0x85, 0x8A, 0x95, 0x29, 0x52, 0xA3, 0x42, 0x79, 0x9A, 0x14,
// 	0x28, 0x50, 0xB3, 0x3C, 0xF9, 0x0A, 0x14, 0x2F, 0x90, 0x20, 0x40, 0x79,
// 	0x9A, 0x14, 0x28, 0x50, 0xB3, 0x3C, 0x0C, 0xF8, 0x84, 0x84, 0x84, 0xF8,
// 	0x88, 0x84, 0x82, 0x79, 0x0A, 0x07, 0x80, 0xC0, 0xA1, 0x3C, 0xFE, 0x10,
// 	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x85, 0x0A, 0x14, 0x28, 0x50, 0xA1,
// 	0x3C, 0x85, 0x09, 0x22, 0x44, 0x86, 0x0C, 0x18, 0x82, 0x92, 0x92, 0xAA,
// 	0x6C, 0x6C, 0x44, 0x44, 0x84, 0x91, 0x21, 0x83, 0x09, 0x12, 0x42, 0xC6,
// 	0x44, 0x28, 0x38, 0x10, 0x10, 0x10, 0x10, 0xFC, 0x10, 0x20, 0x82, 0x0C,
// 	0x10, 0x7E, 0xD2, 0x49, 0x24, 0x98, 0x81, 0x04, 0x08, 0x20, 0x81, 0x04,
// 	0x08, 0xC9, 0x24, 0x92, 0x58, 0x30, 0x92, 0x10, 0xFE, 0x42, 0xF0, 0x27,
// 	0xA2, 0x89, 0xE0, 0x82, 0x08, 0x3C, 0x8A, 0x28, 0xA2, 0xF0, 0x7B, 0x08,
// 	0x20, 0xC1, 0xE0, 0x08, 0x20, 0x9E, 0x8A, 0x28, 0xA2, 0x78, 0x72, 0x2F,
// 	0xA0, 0x81, 0xE0, 0x18, 0x82, 0x3E, 0x20, 0x82, 0x08, 0x20, 0x7A, 0x28,
// 	0xA2, 0x89, 0xE0, 0x9C, 0x82, 0x08, 0x2C, 0xCA, 0x28, 0xA2, 0x88, 0x20,
// 	0x00, 0x38, 0x20, 0x82, 0x08, 0xF8, 0x20, 0x0E, 0x22, 0x22, 0x22, 0xC0,
// 	0x82, 0x08, 0x24, 0xA3, 0x0A, 0x24, 0x88, 0xE0, 0x82, 0x08, 0x20, 0x82,
// 	0x08, 0x18, 0xFA, 0xAA, 0xAA, 0xAA, 0xA0, 0xB3, 0x28, 0xA2, 0x8A, 0x20,
// 	0x72, 0x28, 0xA2, 0x89, 0xC0, 0xF2, 0x28, 0xA2, 0x8B, 0xC8, 0x20, 0x7A,
// 	0x28, 0xA2, 0x89, 0xE0, 0x82, 0xF4, 0xA1, 0x08, 0x40, 0x7A, 0x0E, 0x06,
// 	0x0B, 0xC0, 0x20, 0x8F, 0x88, 0x20, 0x82, 0x0E, 0x8A, 0x28, 0xA2, 0x89,
// 	0xE0, 0x8A, 0x25, 0x14, 0x50, 0x80, 0x82, 0x82, 0x54, 0x54, 0x28, 0x28,
// 	0xD9, 0x42, 0x08, 0x53, 0x60, 0x8A, 0x45, 0x14, 0x60, 0x84, 0x30, 0xF8,
// 	0x43, 0x18, 0x43, 0xE0, 0x38, 0x82, 0x08, 0xC0, 0x82, 0x08, 0x20, 0xE0,
// 	0xAA, 0xAA, 0xA8, 0xE0, 0x82, 0x08, 0x18, 0x82, 0x08, 0x23, 0x80, 0x74,
// 	0x63, 0x17, 0x00, 0x8A, 0x28, 0xA2, 0x8B, 0x2B, 0x20, 0x70, 0x42, 0x60,
// 	0x85, 0xC0};

// const GFXglyph Monospaced_plain_11Glyphs[] PROGMEM = {
// 	{0, 1, 1, 8, 0, 0},		// 0x20 ' '
// 	{1, 2, 8, 8, 3, -8},	// 0x21 '!'
// 	{3, 4, 3, 8, 2, -8},	// 0x22 '"'
// 	{5, 8, 8, 8, 0, -8},	// 0x23 '#'
// 	{13, 6, 10, 8, 1, -8},	// 0x24 '$'
// 	{21, 7, 8, 8, 0, -8},	// 0x25 '%'
// 	{28, 7, 8, 8, 1, -8},	// 0x26 '&'
// 	{35, 2, 3, 8, 3, -8},	// 0x27 '''
// 	{36, 3, 10, 8, 2, -9},	// 0x28 '('
// 	{40, 3, 10, 8, 2, -9},	// 0x29 ')'
// 	{44, 6, 6, 8, 1, -8},	// 0x2A '*'
// 	{49, 6, 5, 8, 1, -6},	// 0x2B '+'
// 	{53, 3, 3, 8, 2, -2},	// 0x2C ','
// 	{55, 4, 1, 8, 2, -4},	// 0x2D '-'
// 	{56, 2, 2, 8, 3, -2},	// 0x2E '.'
// 	{57, 6, 9, 8, 1, -8},	// 0x2F '/'
// 	{64, 7, 8, 8, 1, -8},	// 0x30 '0'
// 	{71, 6, 8, 8, 1, -8},	// 0x31 '1'
// 	{77, 7, 8, 8, 1, -8},	// 0x32 '2'
// 	{84, 7, 8, 8, 1, -8},	// 0x33 '3'
// 	{91, 7, 8, 8, 1, -8},	// 0x34 '4'
// 	{98, 7, 8, 8, 1, -8},	// 0x35 '5'
// 	{105, 7, 8, 8, 1, -8},	// 0x36 '6'
// 	{112, 7, 8, 8, 1, -8},	// 0x37 '7'
// 	{119, 7, 8, 8, 1, -8},	// 0x38 '8'
// 	{126, 7, 8, 8, 1, -8},	// 0x39 '9'
// 	{133, 2, 6, 8, 3, -6},	// 0x3A ':'
// 	{135, 3, 7, 8, 2, -6},	// 0x3B ';'
// 	{138, 7, 5, 8, 1, -6},	// 0x3C '<'
// 	{143, 7, 3, 8, 0, -5},	// 0x3D '='
// 	{146, 7, 5, 8, 1, -6},	// 0x3E '>'
// 	{151, 5, 8, 8, 2, -8},	// 0x3F '?'
// 	{156, 7, 10, 8, 1, -8}, // 0x40 '@'
// 	{165, 7, 8, 8, 1, -8},	// 0x41 'A'
// 	{172, 7, 8, 8, 1, -8},	// 0x42 'B'
// 	{179, 7, 8, 8, 1, -8},	// 0x43 'C'
// 	{186, 7, 8, 8, 1, -8},	// 0x44 'D'
// 	{193, 7, 8, 8, 1, -8},	// 0x45 'E'
// 	{200, 7, 8, 8, 1, -8},	// 0x46 'F'
// 	{207, 7, 8, 8, 1, -8},	// 0x47 'G'
// 	{214, 7, 8, 8, 1, -8},	// 0x48 'H'
// 	{221, 6, 8, 8, 1, -8},	// 0x49 'I'
// 	{227, 6, 8, 8, 1, -8},	// 0x4A 'J'
// 	{233, 7, 8, 8, 1, -8},	// 0x4B 'K'
// 	{240, 7, 8, 8, 1, -8},	// 0x4C 'L'
// 	{247, 7, 8, 8, 1, -8},	// 0x4D 'M'
// 	{254, 7, 8, 8, 1, -8},	// 0x4E 'N'
// 	{261, 7, 8, 8, 1, -8},	// 0x4F 'O'
// 	{268, 7, 8, 8, 1, -8},	// 0x50 'P'
// 	{275, 7, 9, 8, 1, -8},	// 0x51 'Q'
// 	{283, 8, 8, 8, 1, -8},	// 0x52 'R'
// 	{291, 7, 8, 8, 1, -8},	// 0x53 'S'
// 	{298, 8, 8, 8, 0, -8},	// 0x54 'T'
// 	{306, 7, 8, 8, 1, -8},	// 0x55 'U'
// 	{313, 7, 8, 8, 1, -8},	// 0x56 'V'
// 	{320, 8, 8, 8, 0, -8},	// 0x57 'W'
// 	{328, 7, 8, 8, 1, -8},	// 0x58 'X'
// 	{335, 8, 8, 8, 0, -8},	// 0x59 'Y'
// 	{343, 7, 8, 8, 1, -8},	// 0x5A 'Z'
// 	{350, 3, 10, 8, 2, -9}, // 0x5B '['
// 	{354, 6, 9, 8, 1, -8},	// 0x5C '\'
// 	{361, 3, 10, 8, 2, -9}, // 0x5D ']'
// 	{365, 7, 3, 8, 0, -8},	// 0x5E '^'
// 	{368, 8, 1, 8, 0, 2},	// 0x5F '_'
// 	{369, 4, 2, 8, 2, -9},	// 0x60 '`'
// 	{370, 6, 6, 8, 1, -6},	// 0x61 'a'
// 	{375, 6, 9, 8, 1, -9},	// 0x62 'b'
// 	{382, 6, 6, 8, 1, -6},	// 0x63 'c'
// 	{387, 6, 9, 8, 1, -9},	// 0x64 'd'
// 	{394, 6, 6, 8, 1, -6},	// 0x65 'e'
// 	{399, 6, 9, 8, 1, -9},	// 0x66 'f'
// 	{406, 6, 8, 8, 1, -6},	// 0x67 'g'
// 	{412, 6, 9, 8, 1, -9},	// 0x68 'h'
// 	{419, 6, 9, 8, 1, -9},	// 0x69 'i'
// 	{426, 4, 11, 8, 1, -9}, // 0x6A 'j'
// 	{432, 6, 9, 8, 1, -9},	// 0x6B 'k'
// 	{439, 6, 9, 8, 0, -9},	// 0x6C 'l'
// 	{446, 6, 6, 8, 1, -6},	// 0x6D 'm'
// 	{451, 6, 6, 8, 1, -6},	// 0x6E 'n'
// 	{456, 6, 6, 8, 1, -6},	// 0x6F 'o'
// 	{461, 6, 8, 8, 1, -6},	// 0x70 'p'
// 	{467, 6, 8, 8, 1, -6},	// 0x71 'q'
// 	{473, 5, 6, 8, 2, -6},	// 0x72 'r'
// 	{477, 6, 6, 8, 1, -6},	// 0x73 's'
// 	{482, 6, 8, 8, 0, -8},	// 0x74 't'
// 	{488, 6, 6, 8, 1, -6},	// 0x75 'u'
// 	{493, 6, 6, 8, 1, -6},	// 0x76 'v'
// 	{498, 8, 6, 8, 0, -6},	// 0x77 'w'
// 	{504, 6, 6, 8, 1, -6},	// 0x78 'x'
// 	{509, 6, 8, 8, 1, -6},	// 0x79 'y'
// 	{515, 6, 6, 8, 1, -6},	// 0x7A 'z'
// 	{520, 6, 10, 8, 1, -9}, // 0x7B '{'
// 	{528, 2, 11, 8, 3, -9}, // 0x7C '|'
// 	{531, 6, 10, 8, 1, -9}, // 0x7D '}'
// 	{539, 5, 5, 5, 0, -9},	// 0x7E '°'
// 	{543, 6, 8, 7, 0, -6},	// 0x7F 'μ'
// 	{549, 5, 7, 5, 0, -9}	// 0x80 '³'
// };

// const GFXfont Monospaced_plain_11 PROGMEM = {
// 	(uint8_t *)Monospaced_plain_11Bitmaps, (GFXglyph *)Monospaced_plain_11Glyphs, 0x20, 0x80, 14};

const uint8_t RAK_EPD_10pt_Bitmaps[] PROGMEM = {
	0x00, 0xDB, 0x61, 0xB0, 0xAA, 0xA0, 0x14, 0x24, 0x7E, 0x28, 0xFC, 0x48,
	0x50, 0x21, 0xEA, 0x3C, 0x78, 0xAF, 0x08, 0x62, 0x25, 0x09, 0x41, 0xAC,
	0x14, 0x85, 0x22, 0x30, 0x38, 0x30, 0x18, 0x0E, 0x2D, 0xF6, 0x71, 0xEC,
	0xA8, 0x64, 0xCC, 0xCC, 0xC4, 0x60, 0xC4, 0x66, 0x66, 0x64, 0xC0, 0x22,
	0xA7, 0x1C, 0xA8, 0x80, 0x10, 0x10, 0x10, 0xFE, 0x10, 0x10, 0x10, 0xDA,
	0x00, 0xE0, 0xD8, 0x11, 0x08, 0x44, 0x21, 0x10, 0x79, 0x9B, 0x36, 0x6C,
	0xD9, 0x9E, 0x00, 0xF0, 0x60, 0xC1, 0x83, 0x06, 0x3F, 0x00, 0xF8, 0x18,
	0x30, 0xC3, 0x0C, 0x3F, 0x00, 0xF8, 0x18, 0x33, 0xC0, 0xC1, 0xBE, 0x00,
	0x18, 0x71, 0x64, 0xCF, 0xC3, 0x06, 0x00, 0xF9, 0x83, 0xE0, 0x60, 0xC1,
	0xBE, 0x00, 0x3C, 0x83, 0xE6, 0x6C, 0xD9, 0x9E, 0x00, 0xFC, 0x18, 0x60,
	0xC3, 0x06, 0x18, 0x00, 0x79, 0x9B, 0x33, 0xCC, 0xD9, 0x9E, 0x00, 0x79,
	0x9B, 0x36, 0x67, 0xC1, 0x3C, 0x00, 0xD8, 0x6C, 0xD8, 0x6D, 0x00, 0x04,
	0x73, 0x87, 0x03, 0x80, 0x80, 0xFC, 0x03, 0xF0, 0x80, 0xE0, 0x70, 0xE7,
	0x10, 0x00, 0xF1, 0x9C, 0xC0, 0x31, 0x80, 0x3E, 0x18, 0x4D, 0xEA, 0x8A,
	0xA2, 0xA8, 0xAD, 0xF1, 0x88, 0x3C, 0x00, 0x18, 0x1E, 0x0F, 0x0C, 0xC7,
	0xE3, 0x33, 0x0C, 0xF9, 0x9B, 0x37, 0xCC, 0xD9, 0xBE, 0x00, 0x3C, 0xCB,
	0x06, 0x0C, 0x0C, 0x8F, 0x00, 0xF8, 0xCC, 0xC6, 0xC6, 0xC6, 0xCC, 0xF8,
	0xFB, 0x0C, 0x3E, 0xC3, 0x0F, 0x80, 0xFB, 0x0C, 0x3E, 0xC3, 0x0C, 0x00,
	0x3E, 0x62, 0xC0, 0xCE, 0xC6, 0x66, 0x3E, 0xC6, 0xC6, 0xC6, 0xFE, 0xC6,
	0xC6, 0xC6, 0xDB, 0x6D, 0xB0, 0x66, 0x66, 0x66, 0x66, 0xC0, 0xCC, 0xD8,
	0xF0, 0xE0, 0xF0, 0xD8, 0xCC, 0xC3, 0x0C, 0x30, 0xC3, 0x0F, 0x80, 0xC3,
	0x73, 0xB9, 0xDB, 0x6D, 0xB6, 0x1B, 0x0C, 0xE6, 0xE6, 0xD6, 0xD6, 0xCE,
	0xCE, 0xC6, 0x7C, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x7C, 0xF9, 0x9B, 0x36,
	0x6F, 0x98, 0x30, 0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x7C, 0x0C,
	0xF8, 0xCC, 0xCC, 0xCC, 0xF8, 0xCC, 0xC6, 0x7D, 0x8B, 0x03, 0xC0, 0xD1,
	0xBE, 0x00, 0xFC, 0x60, 0xC1, 0x83, 0x06, 0x0C, 0x00, 0xC6, 0xC6, 0xC6,
	0xC6, 0xC6, 0xC6, 0x7C, 0xC3, 0x33, 0x19, 0x8C, 0xC3, 0xC1, 0xE0, 0x60,
	0xCC, 0xD9, 0x99, 0x32, 0x3F, 0xC7, 0x38, 0x66, 0x0C, 0xC0, 0xC6, 0x6C,
	0x28, 0x38, 0x28, 0x6C, 0xC6, 0xC3, 0x33, 0x0F, 0x03, 0x01, 0x80, 0xC0,
	0x60, 0xFC, 0x18, 0x61, 0x86, 0x18, 0x3F, 0x00, 0xEC, 0xCC, 0xCC, 0xCC,
	0xE0, 0x82, 0x10, 0x82, 0x10, 0x82, 0xE6, 0x66, 0x66, 0x66, 0xE0, 0x30,
	0xF3, 0x30, 0xF8, 0x42, 0xF8, 0x19, 0xF6, 0x6F, 0xC0, 0xC1, 0x83, 0x07,
	0xCC, 0xD9, 0xB3, 0x7C, 0x7B, 0x0C, 0x30, 0x78, 0x0C, 0x18, 0x33, 0xEC,
	0xD9, 0xB3, 0x3E, 0x79, 0x9B, 0xF6, 0x07, 0xC0, 0x39, 0x86, 0x3E, 0x61,
	0x86, 0x18, 0x7D, 0x9B, 0x36, 0x67, 0xC1, 0x9E, 0x00, 0xC1, 0x83, 0x07,
	0xCC, 0xD9, 0xB3, 0x66, 0xD8, 0x6D, 0xB6, 0x66, 0x06, 0x66, 0x66, 0x6C,
	0xC1, 0x83, 0x06, 0x6D, 0x9E, 0x36, 0x66, 0xDB, 0x6D, 0xB6, 0xFF, 0x99,
	0x9B, 0x33, 0x66, 0x6C, 0xCC, 0xF9, 0x9B, 0x36, 0x6C, 0xC0, 0x79, 0x9B,
	0x36, 0x67, 0x80, 0xF9, 0x9B, 0x36, 0x6F, 0x98, 0x30, 0x00, 0x7D, 0x9B,
	0x36, 0x67, 0xC1, 0x83, 0x00, 0xF6, 0x31, 0x8C, 0x00, 0xFB, 0x0F, 0x86,
	0xF0, 0x61, 0x8F, 0x98, 0x61, 0x87, 0x80, 0xCD, 0x9B, 0x36, 0x67, 0xC0,
	0xCD, 0x99, 0x23, 0xC3, 0x00, 0xDB, 0x6D, 0x9F, 0x8C, 0xC6, 0x60, 0xCC,
	0xF0, 0xC3, 0xCC, 0xC0, 0xCC, 0x91, 0xE1, 0x83, 0x04, 0x18, 0x00, 0xF1,
	0x99, 0x8F, 0x00, 0x38, 0xC3, 0x0C, 0xE0, 0xC3, 0x0C, 0x38, 0xAA, 0xAA,
	0xA0, 0xE1, 0x86, 0x18, 0x39, 0x86, 0x18, 0xE0, 0x31, 0xEC, 0xDE, 0x30,
	0x00, 0xCD, 0x9B, 0x36, 0x6F, 0x9F, 0x30, 0x00, 0x73, 0xC6, 0xF1, 0xBD,
	0xC0};

const GFXglyph RAK_EPD_10pt_Glyphs[] PROGMEM = {
	{0, 1, 1, 4, 0, 0},		 // 0x20 ' '
	{1, 3, 7, 6, 1, -7},	 // 0x21 '!'
	{4, 4, 3, 6, 1, -7},	 // 0x22 '"'
	{6, 8, 7, 9, 1, -7},	 // 0x23 '#'
	{13, 6, 8, 8, 1, -7},	 // 0x24 '$'
	{19, 10, 7, 11, 1, -7},	 // 0x25 '%'
	{28, 9, 7, 10, 1, -7},	 // 0x26 '&'
	{36, 2, 3, 4, 1, -7},	 // 0x27 '''
	{37, 4, 9, 6, 1, -8},	 // 0x28 '('
	{42, 4, 9, 6, 1, -8},	 // 0x29 ')'
	{47, 6, 6, 6, 0, -7},	 // 0x2A '*'
	{52, 8, 7, 9, 1, -7},	 // 0x2B '+'
	{59, 3, 3, 5, 1, -2},	 // 0x2C ','
	{61, 4, 1, 5, 1, -4},	 // 0x2D '-'
	{62, 3, 2, 5, 1, -2},	 // 0x2E '.'
	{63, 5, 8, 5, 0, -7},	 // 0x2F '/'
	{68, 7, 7, 8, 1, -7},	 // 0x30 '0'
	{75, 7, 7, 8, 1, -7},	 // 0x31 '1'
	{82, 7, 7, 8, 1, -7},	 // 0x32 '2'
	{89, 7, 7, 8, 1, -7},	 // 0x33 '3'
	{96, 7, 7, 8, 1, -7},	 // 0x34 '4'
	{103, 7, 7, 8, 1, -7},	 // 0x35 '5'
	{110, 7, 7, 8, 1, -7},	 // 0x36 '6'
	{117, 7, 7, 8, 1, -7},	 // 0x37 '7'
	{124, 7, 7, 8, 1, -7},	 // 0x38 '8'
	{131, 7, 7, 8, 1, -7},	 // 0x39 '9'
	{138, 3, 5, 5, 1, -5},	 // 0x3A ':'
	{140, 3, 6, 5, 1, -5},	 // 0x3B ';'
	{143, 7, 6, 9, 1, -6},	 // 0x3C '<'
	{149, 7, 3, 9, 1, -5},	 // 0x3D '='
	{152, 7, 6, 9, 1, -6},	 // 0x3E '>'
	{158, 5, 7, 7, 1, -7},	 // 0x3F '?'
	{163, 10, 9, 11, 1, -7}, // 0x40 '@'
	{175, 9, 7, 10, 1, -7},	 // 0x41 'A'
	{183, 7, 7, 8, 1, -7},	 // 0x42 'B'
	{190, 7, 7, 8, 1, -7},	 // 0x43 'C'
	{197, 8, 7, 9, 1, -7},	 // 0x44 'D'
	{204, 6, 7, 7, 1, -7},	 // 0x45 'E'
	{210, 6, 7, 7, 1, -7},	 // 0x46 'F'
	{216, 8, 7, 9, 1, -7},	 // 0x47 'G'
	{223, 8, 7, 9, 1, -7},	 // 0x48 'H'
	{230, 3, 7, 4, 1, -7},	 // 0x49 'I'
	{233, 4, 9, 4, 0, -7},	 // 0x4A 'J'
	{238, 8, 7, 8, 1, -7},	 // 0x4B 'K'
	{245, 6, 7, 7, 1, -7},	 // 0x4C 'L'
	{251, 9, 7, 10, 1, -7},	 // 0x4D 'M'
	{259, 8, 7, 9, 1, -7},	 // 0x4E 'N'
	{266, 8, 7, 9, 1, -7},	 // 0x4F 'O'
	{273, 7, 7, 8, 1, -7},	 // 0x50 'P'
	{280, 8, 8, 9, 1, -7},	 // 0x51 'Q'
	{288, 8, 7, 9, 1, -7},	 // 0x52 'R'
	{295, 7, 7, 8, 1, -7},	 // 0x53 'S'
	{302, 7, 7, 8, 1, -7},	 // 0x54 'T'
	{309, 8, 7, 9, 1, -7},	 // 0x55 'U'
	{316, 9, 7, 10, 1, -7},	 // 0x56 'V'
	{324, 11, 7, 12, 1, -7}, // 0x57 'W'
	{334, 8, 7, 9, 1, -7},	 // 0x58 'X'
	{341, 9, 7, 8, 0, -7},	 // 0x59 'Y'
	{349, 7, 7, 8, 1, -7},	 // 0x5A 'Z'
	{356, 4, 9, 6, 1, -8},	 // 0x5B '['
	{361, 5, 8, 5, 0, -7},	 // 0x5C '\'
	{366, 4, 9, 6, 1, -8},	 // 0x5D ']'
	{371, 7, 3, 9, 1, -7},	 // 0x5E '^'
	{374, 6, 1, 6, 0, 1},	 // 0x5F '_'
	{375, 4, 2, 6, 0, -8},	 // 0x60 '`'
	{376, 7, 5, 8, 1, -5},	 // 0x61 'a'
	{381, 7, 8, 8, 1, -8},	 // 0x62 'b'
	{388, 6, 5, 7, 1, -5},	 // 0x63 'c'
	{392, 7, 8, 8, 1, -8},	 // 0x64 'd'
	{399, 7, 5, 8, 1, -5},	 // 0x65 'e'
	{404, 6, 8, 5, 0, -8},	 // 0x66 'f'
	{410, 7, 7, 8, 1, -5},	 // 0x67 'g'
	{417, 7, 8, 8, 1, -8},	 // 0x68 'h'
	{424, 3, 8, 4, 1, -8},	 // 0x69 'i'
	{427, 4, 10, 4, 0, -8},	 // 0x6A 'j'
	{432, 7, 8, 8, 1, -8},	 // 0x6B 'k'
	{439, 3, 8, 4, 1, -8},	 // 0x6C 'l'
	{442, 11, 5, 12, 1, -5}, // 0x6D 'm'
	{449, 7, 5, 8, 1, -5},	 // 0x6E 'n'
	{454, 7, 5, 8, 1, -5},	 // 0x6F 'o'
	{459, 7, 7, 8, 1, -5},	 // 0x70 'p'
	{466, 7, 7, 8, 1, -5},	 // 0x71 'q'
	{473, 5, 5, 6, 1, -5},	 // 0x72 'r'
	{477, 6, 5, 7, 1, -5},	 // 0x73 's'
	{481, 6, 7, 6, 0, -7},	 // 0x74 't'
	{487, 7, 5, 8, 1, -5},	 // 0x75 'u'
	{492, 7, 5, 8, 1, -5},	 // 0x76 'v'
	{497, 9, 5, 10, 1, -5},	 // 0x77 'w'
	{503, 7, 5, 8, 1, -5},	 // 0x78 'x'
	{508, 7, 7, 8, 1, -5},	 // 0x79 'y'
	{515, 5, 5, 6, 1, -5},	 // 0x7A 'z'
	{519, 6, 9, 8, 1, -8},	 // 0x7B '{'
	{526, 2, 10, 5, 1, -8},	 // 0x7C '|'
	{529, 6, 9, 8, 2, -8},	 // 0x7D '}'
	{536, 6, 5, 6, 0, -8},	 // 0x7E '°'
	{541, 7, 7, 8, 1, -5},	 // 0x7F 'μ'
	{548, 5, 7, 5, 0, -8}	 // 0x80 '³'
};

const GFXfont RAK_EPD_10pt PROGMEM = {
	(uint8_t *)RAK_EPD_10pt_Bitmaps, (GFXglyph *)RAK_EPD_10pt_Glyphs, 0x20, 0x80, 13};

const uint8_t RAK_EPD_20pt_Bitmaps[] PROGMEM = {
	0x00, 0xF7, 0xBD, 0xEF, 0x7B, 0xDE, 0xF7, 0x81, 0xEF, 0x7B, 0xC0, 0xCD,
	0x9B, 0x36, 0x6C, 0xC0, 0x06, 0x30, 0x0C, 0x60, 0x18, 0xC0, 0x33, 0x07,
	0xFF, 0xCF, 0xFF, 0x83, 0x38, 0x06, 0x60, 0x18, 0xC1, 0xFF, 0xF3, 0xFF,
	0xE0, 0xCC, 0x03, 0x98, 0x06, 0x30, 0x0C, 0x60, 0x00, 0x06, 0x00, 0x30,
	0x07, 0xF0, 0xFF, 0xCE, 0x62, 0x73, 0x03, 0xD8, 0x1F, 0xF0, 0x7F, 0xE0,
	0xFF, 0x81, 0xBC, 0x0C, 0xE8, 0x67, 0x7F, 0xF0, 0xFF, 0x00, 0xC0, 0x06,
	0x00, 0x30, 0x00, 0x3C, 0x06, 0x07, 0xE0, 0xC0, 0xE7, 0x1C, 0x0C, 0x31,
	0x80, 0xC3, 0x38, 0x0E, 0x73, 0x00, 0x7E, 0x60, 0x03, 0xCE, 0x78, 0x00,
	0xCF, 0xC0, 0x19, 0xCE, 0x03, 0x98, 0x60, 0x31, 0x86, 0x07, 0x1C, 0xE0,
	0x60, 0xFC, 0x0C, 0x07, 0x80, 0x0F, 0x80, 0x1F, 0xC0, 0x3C, 0x40, 0x3C,
	0x00, 0x3C, 0x00, 0x1E, 0x00, 0x3F, 0x1C, 0x7F, 0x1C, 0xF3, 0x9C, 0xF3,
	0xF8, 0xF1, 0xF8, 0xF0, 0xF0, 0x78, 0xF0, 0x7F, 0xF8, 0x1F, 0xBC, 0xDB,
	0x6C, 0x3C, 0x71, 0xE3, 0x87, 0x1C, 0x38, 0x70, 0xE1, 0xC3, 0x87, 0x0E,
	0x0E, 0x1C, 0x3C, 0x38, 0x78, 0xF0, 0xE1, 0xE1, 0xC3, 0x83, 0x87, 0x0E,
	0x1C, 0x38, 0x70, 0xE1, 0xC7, 0x0E, 0x3C, 0x71, 0xE0, 0x0C, 0x01, 0x83,
	0x33, 0x3F, 0xC1, 0xE0, 0xFF, 0x33, 0x30, 0x60, 0x0C, 0x00, 0x06, 0x00,
	0x30, 0x01, 0x80, 0x0C, 0x00, 0x60, 0x7F, 0xFB, 0xFF, 0xC0, 0xC0, 0x06,
	0x00, 0x30, 0x01, 0x80, 0x0C, 0x00, 0x79, 0xE7, 0x9E, 0x73, 0x8C, 0x00,
	0xFD, 0xFB, 0xF0, 0xF7, 0xBD, 0xE0, 0x06, 0x0E, 0x0C, 0x0C, 0x0C, 0x18,
	0x18, 0x18, 0x30, 0x30, 0x30, 0x60, 0x60, 0x60, 0xE0, 0xC0, 0x1F, 0x81,
	0xFE, 0x1E, 0x78, 0xE1, 0xCF, 0x0F, 0x78, 0x7B, 0xC3, 0xDE, 0x1E, 0xF0,
	0xF7, 0x87, 0xBC, 0x3C, 0xE1, 0xC7, 0x9E, 0x1F, 0xE0, 0x7E, 0x00, 0x7E,
	0x1F, 0xC3, 0x78, 0x0F, 0x01, 0xE0, 0x3C, 0x07, 0x80, 0xF0, 0x1E, 0x03,
	0xC0, 0x78, 0x0F, 0x01, 0xE1, 0xFF, 0xBF, 0xF0, 0x3F, 0x0F, 0xFC, 0xC3,
	0xE8, 0x1E, 0x01, 0xE0, 0x1E, 0x03, 0xE0, 0x3E, 0x07, 0xC0, 0xFC, 0x1F,
	0x03, 0xE0, 0x7C, 0x0F, 0xFE, 0xFF, 0xE0, 0x7F, 0x8F, 0xFC, 0x83, 0xE0,
	0x1E, 0x01, 0xE0, 0x3C, 0x1F, 0x81, 0xFC, 0x03, 0xE0, 0x1E, 0x01, 0xE0,
	0x1E, 0x83, 0xEF, 0xFC, 0x7F, 0x00, 0x07, 0xC0, 0x3E, 0x03, 0xF0, 0x3F,
	0x81, 0xBC, 0x1D, 0xE1, 0xCF, 0x0C, 0x78, 0xE3, 0xC6, 0x1E, 0x3F, 0xFD,
	0xFF, 0xE0, 0x3C, 0x01, 0xE0, 0x0F, 0x00, 0x7F, 0xC7, 0xFC, 0x70, 0x07,
	0x00, 0x70, 0x07, 0xF0, 0x7F, 0xC4, 0x3C, 0x01, 0xE0, 0x1E, 0x01, 0xE0,
	0x1E, 0x83, 0xCF, 0xFC, 0x7F, 0x00, 0x0F, 0xC1, 0xFF, 0x0F, 0x08, 0xF0,
	0x0F, 0x00, 0x7B, 0xC3, 0xFF, 0x9F, 0x3E, 0xF0, 0xF7, 0x87, 0xBC, 0x3C,
	0xE1, 0xE7, 0x9E, 0x1F, 0xE0, 0x7E, 0x00, 0xFF, 0xEF, 0xFE, 0x03, 0xE0,
	0x3C, 0x03, 0xC0, 0x7C, 0x07, 0x80, 0xF8, 0x0F, 0x01, 0xF0, 0x1E, 0x03,
	0xE0, 0x3C, 0x03, 0xC0, 0x7C, 0x00, 0x3F, 0xC3, 0xFF, 0x3E, 0x7D, 0xE1,
	0xEF, 0x0F, 0x3C, 0xF0, 0xFF, 0x07, 0xF8, 0x79, 0xE7, 0x87, 0xBC, 0x3D,
	0xE1, 0xEF, 0x9F, 0x3F, 0xF0, 0x7E, 0x00, 0x1F, 0x01, 0xFE, 0x1E, 0x79,
	0xE1, 0xCF, 0x0F, 0x78, 0x7B, 0xC3, 0xDF, 0x3E, 0x7F, 0xF0, 0xF7, 0x80,
	0x3C, 0x03, 0xC4, 0x3C, 0x3F, 0xE0, 0xFC, 0x00, 0xF7, 0xBD, 0xE0, 0x00,
	0x1E, 0xF7, 0xBC, 0x79, 0xE7, 0x9E, 0x00, 0x00, 0x1E, 0x79, 0xE7, 0x9C,
	0xE3, 0x00, 0x00, 0x08, 0x01, 0xE0, 0x3F, 0x87, 0xE0, 0xFC, 0x03, 0x80,
	0x0F, 0xC0, 0x07, 0xE0, 0x03, 0xF8, 0x01, 0xE0, 0x00, 0x80, 0xFF, 0xFB,
	0xFF, 0xE0, 0x00, 0x00, 0x00, 0xFF, 0xFB, 0xFF, 0xE0, 0x80, 0x03, 0xC0,
	0x0F, 0xE0, 0x03, 0xF0, 0x01, 0xF8, 0x00, 0xE0, 0x1F, 0x83, 0xF0, 0xFE,
	0x03, 0xC0, 0x08, 0x00, 0x00, 0x7E, 0x3F, 0xC8, 0x78, 0x1E, 0x07, 0x83,
	0xE1, 0xF0, 0xF8, 0x3C, 0x0F, 0x00, 0x00, 0xF0, 0x3C, 0x0F, 0x03, 0xC0,
	0x03, 0xF0, 0x03, 0xFF, 0x01, 0xC1, 0xE0, 0xE0, 0x1C, 0x73, 0xDB, 0x19,
	0xFE, 0xEC, 0xE3, 0x9B, 0x30, 0x66, 0xCC, 0x19, 0xB3, 0x06, 0x6C, 0xC1,
	0x9B, 0x38, 0xEC, 0x67, 0xFE, 0x1C, 0xF7, 0x03, 0x80, 0x40, 0x70, 0x70,
	0x0F, 0xF8, 0x00, 0xF8, 0x00, 0x07, 0xC0, 0x07, 0xC0, 0x0F, 0xE0, 0x0F,
	0xE0, 0x0E, 0xE0, 0x1E, 0xF0, 0x1E, 0xF0, 0x1C, 0x70, 0x3C, 0x78, 0x3C,
	0x78, 0x3F, 0xF8, 0x7F, 0xFC, 0x78, 0x3C, 0x78, 0x3C, 0xF0, 0x1E, 0xFF,
	0x87, 0xFE, 0x3C, 0x79, 0xE3, 0xCF, 0x1E, 0x78, 0xF3, 0xFF, 0x1F, 0xFC,
	0xF1, 0xE7, 0x87, 0xBC, 0x3D, 0xE1, 0xEF, 0x1F, 0x7F, 0xF3, 0xFE, 0x00,
	0x0F, 0xE0, 0xFF, 0x8F, 0x04, 0xF0, 0x0F, 0x80, 0x78, 0x03, 0xC0, 0x1E,
	0x00, 0xF0, 0x07, 0x80, 0x3E, 0x00, 0xF0, 0x03, 0xC1, 0x0F, 0xF8, 0x3F,
	0x80, 0xFF, 0x81, 0xFF, 0xC3, 0xC3, 0xC7, 0x83, 0xCF, 0x07, 0xDE, 0x07,
	0xBC, 0x0F, 0x78, 0x1E, 0xF0, 0x3D, 0xE0, 0x7B, 0xC1, 0xF7, 0x83, 0xCF,
	0x0F, 0x1F, 0xFC, 0x3F, 0xE0, 0x00, 0xFF, 0xDF, 0xFB, 0xC0, 0x78, 0x0F,
	0x01, 0xE0, 0x3F, 0xE7, 0xFC, 0xF0, 0x1E, 0x03, 0xC0, 0x78, 0x0F, 0x01,
	0xFF, 0xBF, 0xF0, 0xFF, 0xDF, 0xFB, 0xC0, 0x78, 0x0F, 0x01, 0xE0, 0x3F,
	0xF7, 0xFE, 0xF0, 0x1E, 0x03, 0xC0, 0x78, 0x0F, 0x01, 0xE0, 0x3C, 0x00,
	0x07, 0xF0, 0x3F, 0xF0, 0xF0, 0x23, 0xC0, 0x0F, 0x80, 0x1E, 0x00, 0x3C,
	0x00, 0x78, 0x7E, 0xF0, 0xFD, 0xE0, 0x7B, 0xC0, 0xF3, 0xC1, 0xE3, 0xC3,
	0xC3, 0xFF, 0x81, 0xFC, 0x00, 0xF0, 0x7B, 0xC1, 0xEF, 0x07, 0xBC, 0x1E,
	0xF0, 0x7B, 0xC1, 0xEF, 0xFF, 0xBF, 0xFE, 0xF0, 0x7B, 0xC1, 0xEF, 0x07,
	0xBC, 0x1E, 0xF0, 0x7B, 0xC1, 0xEF, 0x07, 0x80, 0xF7, 0xBD, 0xEF, 0x7B,
	0xDE, 0xF7, 0xBD, 0xEF, 0x7B, 0xC0, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x5E,
	0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x3E, 0xFC,
	0xF0, 0xF0, 0x79, 0xE1, 0xE3, 0xC7, 0x87, 0x9E, 0x0F, 0x78, 0x1F, 0xE0,
	0x3F, 0x80, 0x7F, 0x00, 0xFF, 0x01, 0xFF, 0x03, 0xDF, 0x07, 0x9F, 0x0F,
	0x1F, 0x1E, 0x1F, 0x3C, 0x1F, 0x00, 0xF0, 0x1E, 0x03, 0xC0, 0x78, 0x0F,
	0x01, 0xE0, 0x3C, 0x07, 0x80, 0xF0, 0x1E, 0x03, 0xC0, 0x78, 0x0F, 0x01,
	0xFF, 0xBF, 0xF0, 0xF8, 0x1F, 0x7C, 0x0F, 0xBF, 0x0F, 0xDF, 0x87, 0xEF,
	0xC3, 0xF7, 0xF3, 0xFB, 0xD9, 0xBD, 0xEC, 0xDE, 0xF7, 0xEF, 0x79, 0xE7,
	0xBC, 0xF3, 0xDE, 0x31, 0xEF, 0x00, 0xF7, 0x80, 0x7B, 0xC0, 0x3C, 0xF8,
	0x7B, 0xE1, 0xEF, 0xC7, 0xBF, 0x1E, 0xFE, 0x7B, 0xD9, 0xEF, 0x67, 0xBD,
	0xDE, 0xF3, 0x7B, 0xCD, 0xEF, 0x3F, 0xBC, 0x7E, 0xF1, 0xFB, 0xC3, 0xEF,
	0x0F, 0x80, 0x0F, 0xE0, 0x1F, 0xF0, 0x3C, 0x78, 0x78, 0x3C, 0xF0, 0x1E,
	0xF0, 0x1E, 0xF0, 0x1E, 0xF0, 0x1E, 0xF0, 0x1E, 0xF0, 0x1E, 0xF0, 0x1E,
	0x78, 0x3C, 0x3C, 0x78, 0x1F, 0xF0, 0x0F, 0xE0, 0xFF, 0x87, 0xFF, 0x3C,
	0x79, 0xE1, 0xEF, 0x0F, 0x78, 0x7B, 0xC3, 0xDE, 0x3C, 0xFF, 0xE7, 0xFC,
	0x3C, 0x01, 0xE0, 0x0F, 0x00, 0x78, 0x03, 0xC0, 0x00, 0x0F, 0xE0, 0x1F,
	0xF0, 0x3C, 0x78, 0x78, 0x3C, 0xF0, 0x1E, 0xF0, 0x1E, 0xF0, 0x1E, 0xF0,
	0x1E, 0xF0, 0x1E, 0xF0, 0x1E, 0xF0, 0x1E, 0x78, 0x3C, 0x3C, 0x78, 0x1F,
	0xF0, 0x0F, 0xE0, 0x00, 0xF0, 0x00, 0x78, 0x00, 0x38, 0xFF, 0x83, 0xFF,
	0x0F, 0x1E, 0x3C, 0x78, 0xF1, 0xE3, 0xC7, 0x8F, 0x1C, 0x3F, 0xE0, 0xFF,
	0x83, 0xCF, 0x0F, 0x3E, 0x3C, 0x78, 0xF1, 0xF3, 0xC3, 0xCF, 0x0F, 0x80,
	0x1F, 0xE3, 0xFF, 0x3E, 0x19, 0xE0, 0x4F, 0x00, 0x7C, 0x03, 0xFE, 0x0F,
	0xFC, 0x1F, 0xF0, 0x0F, 0x80, 0x3D, 0x01, 0xEE, 0x1F, 0x7F, 0xF1, 0xFE,
	0x00, 0xFF, 0xFD, 0xFF, 0xF8, 0x1E, 0x00, 0x3C, 0x00, 0x78, 0x00, 0xF0,
	0x01, 0xE0, 0x03, 0xC0, 0x07, 0x80, 0x0F, 0x00, 0x1E, 0x00, 0x3C, 0x00,
	0x78, 0x00, 0xF0, 0x01, 0xE0, 0x00, 0xF0, 0x7B, 0xC1, 0xEF, 0x07, 0xBC,
	0x1E, 0xF0, 0x7B, 0xC1, 0xEF, 0x07, 0xBC, 0x1E, 0xF0, 0x7B, 0xC1, 0xEF,
	0x07, 0xBC, 0x1E, 0x78, 0xF1, 0xFF, 0xC1, 0xFC, 0x00, 0xF0, 0x1E, 0x78,
	0x3C, 0x78, 0x3C, 0x78, 0x3C, 0x3C, 0x78, 0x3C, 0x78, 0x3C, 0x78, 0x1E,
	0xF0, 0x1E, 0xF0, 0x1E, 0xF0, 0x0F, 0xE0, 0x0F, 0xE0, 0x0F, 0xE0, 0x07,
	0xC0, 0x07, 0xC0, 0xF0, 0x70, 0x7B, 0xC1, 0xC1, 0xE7, 0x8F, 0x8F, 0x1E,
	0x3E, 0x3C, 0x78, 0xD8, 0xF0, 0xE7, 0x73, 0x83, 0xDD, 0xDE, 0x0F, 0x63,
	0x78, 0x3D, 0x8D, 0xE0, 0x7E, 0x3F, 0x01, 0xF8, 0xFC, 0x07, 0xC1, 0xF0,
	0x0F, 0x07, 0x80, 0x3C, 0x1E, 0x00, 0xE0, 0x38, 0x00, 0xF8, 0x3E, 0x78,
	0x3C, 0x3C, 0x78, 0x3E, 0xF8, 0x1E, 0xF0, 0x0F, 0xE0, 0x07, 0xC0, 0x07,
	0xC0, 0x0F, 0xE0, 0x0F, 0xE0, 0x1E, 0xF0, 0x3E, 0xF8, 0x3C, 0x78, 0x78,
	0x3C, 0xF8, 0x3E, 0xF8, 0x1F, 0x3E, 0x1F, 0x0F, 0x0F, 0x07, 0xCF, 0x81,
	0xE7, 0x80, 0x7F, 0x80, 0x3F, 0xC0, 0x0F, 0xC0, 0x03, 0xC0, 0x01, 0xE0,
	0x00, 0xF0, 0x00, 0x78, 0x00, 0x3C, 0x00, 0x1E, 0x00, 0x0F, 0x00, 0xFF,
	0xFB, 0xFF, 0xE0, 0x0F, 0x80, 0x7C, 0x03, 0xE0, 0x0F, 0x80, 0x7C, 0x03,
	0xE0, 0x1F, 0x00, 0xF8, 0x03, 0xE0, 0x1F, 0x00, 0xF8, 0x03, 0xFF, 0xEF,
	0xFF, 0x80, 0xFD, 0xFB, 0x87, 0x0E, 0x1C, 0x38, 0x70, 0xE1, 0xC3, 0x87,
	0x0E, 0x1C, 0x38, 0x70, 0xFD, 0xF8, 0xC0, 0xE0, 0x60, 0x60, 0x60, 0x30,
	0x30, 0x30, 0x18, 0x18, 0x18, 0x0C, 0x0C, 0x0C, 0x0E, 0x06, 0xFD, 0xF8,
	0x70, 0xE1, 0xC3, 0x87, 0x0E, 0x1C, 0x38, 0x70, 0xE1, 0xC3, 0x87, 0x0E,
	0xFD, 0xF8, 0x07, 0x00, 0x3E, 0x01, 0xDC, 0x0E, 0x38, 0x60, 0x30, 0xFF,
	0xDF, 0xF8, 0xE0, 0xE0, 0xE0, 0xE0, 0x3F, 0x87, 0xFC, 0x41, 0xE0, 0x1E,
	0x3F, 0xE7, 0xFE, 0xF1, 0xEF, 0x1E, 0xF3, 0xE7, 0xFE, 0x3D, 0xE0, 0xF0,
	0x07, 0x80, 0x3C, 0x01, 0xE0, 0x0F, 0x3C, 0x7F, 0xF3, 0xE7, 0x9E, 0x1E,
	0xF0, 0xF7, 0x87, 0xBC, 0x3D, 0xE1, 0xEF, 0x9E, 0x7F, 0xF3, 0xCF, 0x00,
	0x1F, 0x87, 0xF9, 0xE1, 0x78, 0x0F, 0x01, 0xE0, 0x3C, 0x07, 0x80, 0x78,
	0x47, 0xF8, 0x7E, 0x00, 0x00, 0xF0, 0x07, 0x80, 0x3C, 0x01, 0xE3, 0xCF,
	0x3F, 0xF9, 0xE7, 0xDE, 0x1E, 0xF0, 0xF7, 0x87, 0xBC, 0x3D, 0xE1, 0xE7,
	0x9F, 0x3F, 0xF8, 0xF3, 0xC0, 0x1F, 0x81, 0xFF, 0x1E, 0x79, 0xE1, 0xEF,
	0xFF, 0x7F, 0xFB, 0xC0, 0x1E, 0x00, 0x78, 0x21, 0xFF, 0x07, 0xF0, 0x0F,
	0x8F, 0xE3, 0xC0, 0xF0, 0xFF, 0xBF, 0xE3, 0xC0, 0xF0, 0x3C, 0x0F, 0x03,
	0xC0, 0xF0, 0x3C, 0x0F, 0x03, 0xC0, 0x3C, 0xF3, 0xFF, 0x9E, 0x7D, 0xE1,
	0xEF, 0x0F, 0x78, 0x7B, 0xC3, 0xDE, 0x1E, 0x79, 0xF3, 0xFF, 0x87, 0x3C,
	0x01, 0xE4, 0x1E, 0x3F, 0xE0, 0xFE, 0x00, 0xF0, 0x0F, 0x00, 0xF0, 0x0F,
	0x00, 0xF3, 0x8F, 0xFC, 0xF9, 0xEF, 0x1E, 0xF1, 0xEF, 0x1E, 0xF1, 0xEF,
	0x1E, 0xF1, 0xEF, 0x1E, 0xF1, 0xE0, 0xF7, 0xBC, 0x0F, 0x7B, 0xDE, 0xF7,
	0xBD, 0xEF, 0x7B, 0xC0, 0x3C, 0x78, 0xF0, 0x03, 0xC7, 0x8F, 0x1E, 0x3C,
	0x78, 0xF1, 0xE3, 0xC7, 0x8F, 0x1E, 0x3D, 0xF3, 0xC0, 0xF0, 0x07, 0x80,
	0x3C, 0x01, 0xE0, 0x0F, 0x0E, 0x78, 0xE3, 0xCE, 0x1E, 0xE0, 0xFE, 0x07,
	0xF0, 0x3F, 0xC1, 0xEF, 0x0F, 0x3C, 0x78, 0xF3, 0xC3, 0xC0, 0xF7, 0xBD,
	0xEF, 0x7B, 0xDE, 0xF7, 0xBD, 0xEF, 0x7B, 0xC0, 0xF7, 0x8F, 0x1F, 0xFB,
	0xF3, 0xE7, 0xCF, 0x78, 0xF1, 0xEF, 0x1E, 0x3D, 0xE3, 0xC7, 0xBC, 0x78,
	0xF7, 0x8F, 0x1E, 0xF1, 0xE3, 0xDE, 0x3C, 0x7B, 0xC7, 0x8F, 0x00, 0xF3,
	0x8F, 0xFC, 0xF9, 0xEF, 0x1E, 0xF1, 0xEF, 0x1E, 0xF1, 0xEF, 0x1E, 0xF1,
	0xEF, 0x1E, 0xF1, 0xE0, 0x1F, 0x81, 0xFE, 0x1E, 0x79, 0xE1, 0xEF, 0x0F,
	0x78, 0x7B, 0xC3, 0xDE, 0x1E, 0x79, 0xE1, 0xFE, 0x07, 0xE0, 0xF3, 0xC7,
	0xFF, 0x3E, 0x79, 0xE1, 0xEF, 0x0F, 0x78, 0x7B, 0xC3, 0xDE, 0x1E, 0xF9,
	0xE7, 0xFF, 0x3C, 0xF1, 0xE0, 0x0F, 0x00, 0x78, 0x03, 0xC0, 0x00, 0x3C,
	0xF3, 0xFF, 0x9E, 0x7D, 0xE1, 0xEF, 0x0F, 0x78, 0x7B, 0xC3, 0xDE, 0x1E,
	0x79, 0xF3, 0xFF, 0x8F, 0x3C, 0x01, 0xE0, 0x0F, 0x00, 0x78, 0x03, 0xC0,
	0xF7, 0x7F, 0xBE, 0x1E, 0x0F, 0x07, 0x83, 0xC1, 0xE0, 0xF0, 0x78, 0x3C,
	0x00, 0x3F, 0x8F, 0xFB, 0xC1, 0x78, 0x0F, 0xC0, 0xFF, 0x07, 0xF0, 0x1E,
	0x83, 0xDF, 0xF1, 0xFC, 0x00, 0x3C, 0x07, 0x80, 0xF0, 0x7F, 0xEF, 0xFC,
	0x78, 0x0F, 0x01, 0xE0, 0x3C, 0x07, 0x80, 0xF0, 0x1E, 0x03, 0xF8, 0x3F,
	0x00, 0xF1, 0xEF, 0x1E, 0xF1, 0xEF, 0x1E, 0xF1, 0xEF, 0x1E, 0xF1, 0xEF,
	0x1E, 0xF3, 0xE7, 0xFE, 0x39, 0xE0, 0xF0, 0xF3, 0x87, 0x1E, 0x78, 0xF3,
	0xC3, 0x9C, 0x1C, 0xE0, 0xFF, 0x03, 0xF0, 0x1F, 0x80, 0x78, 0x03, 0xC0,
	0xF1, 0xC7, 0xBC, 0x71, 0xE7, 0x1C, 0x71, 0xEF, 0xBC, 0x7B, 0x6F, 0x0E,
	0xDB, 0x83, 0xB6, 0xE0, 0xF8, 0xF8, 0x3E, 0x3E, 0x07, 0x8F, 0x01, 0xE3,
	0xC0, 0xF0, 0xF3, 0xCF, 0x0E, 0x70, 0x3F, 0x01, 0xF8, 0x07, 0x80, 0x7E,
	0x07, 0xF8, 0x39, 0xC3, 0xCF, 0x3C, 0x3C, 0xF0, 0xF3, 0x87, 0x9E, 0x38,
	0xF3, 0xC3, 0x9C, 0x1C, 0xE0, 0x77, 0x03, 0xF0, 0x1F, 0x80, 0x7C, 0x03,
	0xC0, 0x1E, 0x01, 0xE0, 0x3F, 0x01, 0xF0, 0x00, 0xFF, 0xDF, 0xF8, 0x0F,
	0x03, 0xC0, 0xF0, 0x3C, 0x0F, 0x03, 0xC0, 0xF0, 0x1F, 0xFB, 0xFF, 0x00,
	0x0F, 0x87, 0xE1, 0xC0, 0x70, 0x1C, 0x07, 0x01, 0xC0, 0xF0, 0xF8, 0x3E,
	0x03, 0xC0, 0x70, 0x1C, 0x07, 0x01, 0xC0, 0x70, 0x1F, 0x83, 0xE0, 0xDB,
	0x6D, 0xB6, 0xDB, 0x6D, 0xB6, 0xDB, 0x60, 0xF8, 0x3F, 0x01, 0xC0, 0x70,
	0x1C, 0x07, 0x01, 0xC0, 0x78, 0x0F, 0x83, 0xE1, 0xE0, 0x70, 0x1C, 0x07,
	0x01, 0xC0, 0x70, 0xFC, 0x3E, 0x00, 0x3C, 0x7E, 0xE7, 0xC3, 0xC3, 0xE7,
	0x7E, 0x3C, 0xF0, 0xF7, 0x87, 0xBC, 0x3D, 0xE1, 0xEF, 0x0F, 0x78, 0x7B,
	0xC3, 0xDE, 0x1E, 0xF8, 0xF7, 0xFF, 0x3D, 0xF1, 0xE7, 0x0F, 0x00, 0x78,
	0x03, 0xC0, 0x00, 0x78, 0x7C, 0x06, 0x06, 0x1E, 0x1E, 0x06, 0x06, 0x7C,
	0x78};

const GFXglyph RAK_EPD_20pt_Glyphs[] PROGMEM = {
	{0, 1, 1, 8, 0, 0},			 // 0x20 ' '
	{1, 5, 15, 10, 3, -15},		 // 0x21 '!'
	{11, 7, 5, 11, 2, -15},		 // 0x22 '"'
	{16, 15, 15, 18, 1, -15},	 // 0x23 '#'
	{45, 13, 18, 15, 1, -15},	 // 0x24 '$'
	{75, 20, 15, 21, 1, -15},	 // 0x25 '%'
	{113, 16, 15, 18, 1, -15},	 // 0x26 '&'
	{143, 3, 5, 7, 2, -15},		 // 0x27 '''
	{145, 7, 18, 10, 2, -15},	 // 0x28 '('
	{161, 7, 18, 10, 1, -15},	 // 0x29 ')'
	{177, 11, 9, 11, 0, -15},	 // 0x2A '*'
	{190, 13, 12, 18, 2, -12},	 // 0x2B '+'
	{210, 6, 7, 9, 1, -4},		 // 0x2C ','
	{216, 7, 3, 9, 1, -7},		 // 0x2D '-'
	{219, 5, 4, 9, 2, -4},		 // 0x2E '.'
	{222, 8, 16, 8, 0, -15},	 // 0x2F '/'
	{238, 13, 15, 15, 1, -15},	 // 0x30 '0'
	{263, 11, 15, 15, 3, -15},	 // 0x31 '1'
	{284, 12, 15, 15, 2, -15},	 // 0x32 '2'
	{307, 12, 15, 15, 1, -15},	 // 0x33 '3'
	{330, 13, 15, 15, 1, -15},	 // 0x34 '4'
	{355, 12, 15, 15, 2, -15},	 // 0x35 '5'
	{378, 13, 15, 15, 1, -15},	 // 0x36 '6'
	{403, 12, 15, 15, 1, -15},	 // 0x37 '7'
	{426, 13, 15, 15, 1, -15},	 // 0x38 '8'
	{451, 13, 15, 15, 1, -15},	 // 0x39 '9'
	{476, 5, 11, 9, 2, -11},	 // 0x3A ':'
	{483, 6, 14, 9, 1, -11},	 // 0x3B ';'
	{494, 14, 11, 18, 2, -12},	 // 0x3C '<'
	{514, 14, 6, 18, 2, -9},	 // 0x3D '='
	{525, 14, 11, 18, 2, -12},	 // 0x3E '>'
	{545, 10, 15, 13, 1, -15},	 // 0x3F '?'
	{564, 18, 18, 21, 1, -15},	 // 0x40 '@'
	{605, 16, 15, 16, 0, -15},	 // 0x41 'A'
	{635, 13, 15, 16, 2, -15},	 // 0x42 'B'
	{660, 13, 15, 16, 1, -15},	 // 0x43 'C'
	{685, 15, 15, 18, 2, -15},	 // 0x44 'D'
	{714, 11, 15, 15, 2, -15},	 // 0x45 'E'
	{735, 11, 15, 15, 2, -15},	 // 0x46 'F'
	{756, 15, 15, 17, 1, -15},	 // 0x47 'G'
	{785, 14, 15, 18, 2, -15},	 // 0x48 'H'
	{812, 5, 15, 8, 2, -15},	 // 0x49 'I'
	{822, 8, 19, 8, -1, -15},	 // 0x4A 'J'
	{841, 15, 15, 17, 2, -15},	 // 0x4B 'K'
	{870, 11, 15, 14, 2, -15},	 // 0x4C 'L'
	{891, 17, 15, 21, 2, -15},	 // 0x4D 'M'
	{923, 14, 15, 18, 2, -15},	 // 0x4E 'N'
	{950, 16, 15, 18, 1, -15},	 // 0x4F 'O'
	{980, 13, 15, 16, 2, -15},	 // 0x50 'P'
	{1005, 16, 18, 18, 1, -15},	 // 0x51 'Q'
	{1041, 14, 15, 16, 2, -15},	 // 0x52 'R'
	{1068, 13, 15, 15, 1, -15},	 // 0x53 'S'
	{1093, 15, 15, 15, 0, -15},	 // 0x54 'T'
	{1122, 14, 15, 17, 2, -15},	 // 0x55 'U'
	{1149, 16, 15, 16, 0, -15},	 // 0x56 'V'
	{1179, 22, 15, 23, 1, -15},	 // 0x57 'W'
	{1221, 16, 15, 16, 0, -15},	 // 0x58 'X'
	{1251, 17, 15, 15, -1, -15}, // 0x59 'Y'
	{1283, 14, 15, 16, 1, -15},	 // 0x5A 'Z'
	{1310, 7, 18, 10, 2, -15},	 // 0x5B '['
	{1326, 8, 16, 8, 0, -15},	 // 0x5C '\'
	{1342, 7, 18, 10, 1, -15},	 // 0x5D ']'
	{1358, 14, 5, 18, 2, -15},	 // 0x5E '^'
	{1367, 11, 2, 11, 0, 3},	 // 0x5F '_'
	{1370, 7, 4, 11, 1, -16},	 // 0x60 '`'
	{1374, 12, 11, 15, 1, -11},	 // 0x61 'a'
	{1391, 13, 15, 15, 2, -15},	 // 0x62 'b'
	{1416, 11, 11, 13, 1, -11},	 // 0x63 'c'
	{1432, 13, 15, 15, 1, -15},	 // 0x64 'd'
	{1457, 13, 11, 15, 1, -11},	 // 0x65 'e'
	{1475, 10, 15, 10, 0, -15},	 // 0x66 'f'
	{1494, 13, 15, 15, 1, -11},	 // 0x67 'g'
	{1519, 12, 15, 15, 2, -15},	 // 0x68 'h'
	{1542, 5, 15, 8, 2, -15},	 // 0x69 'i'
	{1552, 7, 19, 8, 0, -15},	 // 0x6A 'j'
	{1569, 13, 15, 14, 2, -15},	 // 0x6B 'k'
	{1594, 5, 15, 8, 2, -15},	 // 0x6C 'l'
	{1604, 19, 11, 22, 2, -11},	 // 0x6D 'm'
	{1631, 12, 11, 15, 2, -11},	 // 0x6E 'n'
	{1648, 13, 11, 15, 1, -11},	 // 0x6F 'o'
	{1666, 13, 15, 15, 2, -11},	 // 0x70 'p'
	{1691, 13, 15, 15, 1, -11},	 // 0x71 'q'
	{1716, 9, 11, 11, 2, -11},	 // 0x72 'r'
	{1729, 11, 11, 13, 1, -11},	 // 0x73 's'
	{1745, 11, 14, 11, 0, -14},	 // 0x74 't'
	{1765, 12, 11, 15, 2, -11},	 // 0x75 'u'
	{1782, 13, 11, 14, 0, -11},	 // 0x76 'v'
	{1800, 18, 11, 19, 1, -11},	 // 0x77 'w'
	{1825, 13, 11, 14, 1, -11},	 // 0x78 'x'
	{1843, 13, 15, 14, 1, -11},	 // 0x79 'y'
	{1868, 11, 11, 13, 1, -11},	 // 0x7A 'z'
	{1884, 10, 18, 15, 3, -15},	 // 0x7B '{'
	{1907, 3, 20, 8, 3, -15},	 // 0x7C '|'
	{1915, 10, 18, 15, 2, -15},	 // 0x7D '}'
	{1938, 8, 8, 12, 2, -16},	 // 0x7E '°'
	{1946, 13, 15, 15, 1, -11},	 // 0x7F 'μ'
	{1971, 8, 10, 10, 1, -16}	 // 0x80 '³'
};

const GFXfont RAK_EPD_20pt PROGMEM = {
	(uint8_t *)RAK_EPD_20pt_Bitmaps, (GFXglyph *)RAK_EPD_20pt_Glyphs, 0x20, 0x80, 24};

#endif // RAK14000_GFX_H