// Copyright (c) Darrell Wright
//
// Distributed under the Boost Software License, Version 1.0. (See accompanying
// file LICENSE or copy at http://www.boost.org/LICENSE_1_0.txt)
//
// Official repository: https://github.com/beached/daw_json_link
//
#pragma once

#include "version.h"

#include <daw/daw_attributes.h>

namespace daw::json {
	inline namespace DAW_JSON_VER {
		namespace json_details {
			template<typename T>
			struct arrow_proxy {
				T value;

				[[nodiscard]] DAW_ATTRIB_RET_NONNULL constexpr T *operator->( ) && {
					return &value;
				}
			};
		} // namespace json_details
	} // namespace DAW_JSON_VER
} // namespace daw::json
