# CookBook

This folder contains examples of various JSON constructs and how to create a C++ class/contract to parse them

* [Aliases](aliases.md)
* [Arrays](array.md)
* [Automatic Code Generation](automated_code_generation.md)
* [Classes from Array/JSON Tuples](class_from_array.md)
* [Classes](class.md)
* [Dates](dates.md)
* [Enums](enums.md)
* [Graphs](graphs.md)
* [Inserting and Extracting Raw JSON](inserting_extracting_raw_json.md)
* [JSON Lines/NDJSON](json_lines.md)
* [JSON Schema Output](json_schema.md)
* [Key Values](key_values.md) - Map and Dictionary like things
* [Mapping Overview](mapping_overview.md) An overview of the mapping types using in `from_json` or `json_data_constract`
* [Mapping Deduction](mapping_deduction.md)
* [Member Options](member_options.md) - Options for the parse mappings
* [Numbers](numbers.md)
* [Nullable Concept](nullable_value_concept.md) - Trait for mapping Option/Nullable types used in deduction
* [Nullable JSON Values](json_nullable.md)
* [Output Options](output_options.md) - Options for serialization
* [Parser Options](parser_policies.md) - Options for parsing
* [Parsing Individual Members](parsing_individual_members.md)
* [Strings](strings.md)
* [Unknown JSON and Raw Parsing](unknown_types_and_raw_parsing.md) - Browsing the JSON Document and delaying of parsing of specified members
* [Variant](variant.md)
