# [Magento 2 Certified Solution Specialist](https://u.magento.com/magento-2-certified-professional-developer)

## Content Area Approximate Percentage of Exam
- [1. ecommerce 13%](#1-ecommerce)
- [2. Magento architecture 22%](#2-Magento-architecture)
- [3. Magento Admin and storefront 30%](#3-Magento-Admin-and-storefront)
- [4. Business and applications 13%](#4-Business-and-applications)
- [5. Catalog 22%](#5-Catalog)

## Topics and Objectives

### 1 Ecommerce

#### 1.1 Demonstrate ability to configure SEO features in Magento  [amasty](https://amasty.com/blog/magento-2-seo-full-overview-default-settings/), [mageplaza](https://www.mageplaza.com/blog/seo-setting-magento-2.html), [dckap](https://www.dckap.com/blog/how-to-setup-magento-2-seo/), [magento](https://magento.com/blog/small-business/7-seo-best-practices-setting-your-magento-store)
- Marketing strategies: Omnichannel, multichannel, SEO, affiliate marketing, social marketing, email marketing
- What are the principle methods of natively improving SEO in Magento 2 projects?
#### 1.2 Demonstrate understanding of securing a Magento project
[magehit](https://magehit.com/blog/7-tips-for-securing-your-magento-2-website/), [cloudways](https://www.cloudways.com/blog/magento-security/), [digitaloutlook](https://www.digitaloutlook.com.au/keep-magento-2-website-secure/), [magento](https://magento.com/pci-compliance0), [ziffity](https://www.ziffity.com/why-is-it-high-time-to-migrate-to-magento-2-now/), [mageplaza](https://www.mageplaza.com/kb/how-to-stop-brute-force-attacks-magento.html), [neklo](https://store.neklo.com/blog/ddos-attacks), [magenticians](https://magenticians.com/how-to-install-enable-magento-ssl/), [hostadvice](https://hostadvice.com/how-to/how-to-set-up-ssl-tls-https-encryption-on-magento/), [devdocs](https://devdocs.magento.com/guides/v2.3/install-gde/system-requirements_repo-tls1-2.html), [magecomp](https://magecomp.com/blog/apply-security-patches-magento-2/), [pixafy](https://www.pixafy.com/blog/3-magento-2-security-features-thatll-help-secure-ecommerce-ecosystem/), [devdocs](https://devdocs.magento.com/guides/v2.3/architecture/security_intro.html)
- What is the meaning of "PCI compliance"? []()
- What effects does PCI compliance have on the website? []()
- What is SSL, and when should it be used? []()
- What is a DDoS attack? What is a firewall?
-  What is difference between TLS and SSL?
- What other security features exist in Magento 2? []()
- How can security patches be applied? []()
#### 1.3 Demonstrate understanding of how to measure and analyze the user experience
[magento](https://magento.com/resources/user-experience-magento), [inchoo](https://inchoo.net/ux-ui-design/improve-usability-magento-store/)
- What are typical usability principles and issues? []()
- For instance, when a user leaves an ecommerce site without completing a purchase they began, what usability issues need to be planned for? []()

#### 1.4 Demonstrate knowledge of key laws and regulations impacting ecommerce
[amasty](https://amasty.com/blog/what-means-psd2-for-your-magento-2/), [mageplaza](https://www.mageplaza.com/blog/gdpr-comprehensive-step-by-step-guideline.html)

-  Disability compliance issues (ADA and its international equivalents)
-  US and EU privacy and data protection regulations and GDPR
#### 1.5 Demonstrate ability to use data analytics and testing
[inviqa](https://inviqa.com/blog/how-use-magento-2s-new-built-ab-testing-tool), [devdocs](https://devdocs.magento.com/guides/v2.3/config-guide/cli/config-cli-subcommands-perf-data.html)

-  Google Analytics, A/B testing, optimization and personalization
#### 1.6 Demonstrate understanding of implementing omnichannel
[magento](https://magento.com/solutions/omnichannel), [e-zest](https://blog.e-zest.com/delivering-omni-channel-customer-experience-with-magento), [devdocs](https://devdocs.magento.com/guides/v2.3/b2b/bk-b2b.html), [devdocs](https://devdocs.magento.com/guides/v2.3/inventory/), [mageplaza](https://www.mageplaza.com/kb/multi-source-inventory-in-magento-2.html), [firebearstudio](https://firebearstudio.com/blog/magento-2-multi-source-inventory-msi.html), [meetanshi](https://meetanshi.com/blog/magento-2-multi-source-inventory/), [cloudways](https://www.cloudways.com/blog/magento-drop-shipping/), [mageplaza](https://www.mageplaza.com/magento-2-dropship-extension/), [magestore](https://www.magestore.com/features/magento-order-management/store-pickup), [mageworx](https://www.mageworx.com/blog/2019/03/buy-online-pickup-in-store-in-magento-2/), [letstalkmagento](https://www.letstalkmagento.com/uncategorized/magento-2-customer-segmentation-and-personalization/), [devdocs](https://devdocs.magento.com/guides/v2.3/rest/tutorials/configurable-product/create-personalization-option.html), [commerceblend](https://www.commerceblend.com/personalization-with-magento-2-extensions/)
-  What products and tools does Magento have to handle complex inventory management? []()
- What B2B tools does Magento implement? []()
- What is MSI? []()
- How can MSI sourcing algorithms be used? []()
- Drop ship
- Buy-on-line / pickup-in-store
- Personalization
#### References:
- Magento Open

[GoToTop](#Magento-2-Certified-Solution-Specialist)

### 2 Magento 2 Architecture

### 2.1 Demonstrate ability to design a Cloud solution
[devdocs](https://devdocs.magento.com/guides/v2.3/cloud/bk-cloud.html), [sherocommerce](https://sherocommerce.com/magento-cloud-development/), [mconnectmedia](https://www.mconnectmedia.com/blog/magento-enterprise-cloud-service-for-your-magento-2-store/)
- What are the benefits and drawbacks of on-premise vs. Cloud? []()
- How do you move to Cloud? []()
- How does Cloud influence project development? []()
- What features are only available on Cloud? []()
- What are the differences between Starter and Pro plans? []()

#### 2.2 Demonstrate understanding of key concepts of Magento architecture
[devdocs](https://devdocs.magento.com/guides/v2.3/cloud/architecture/cloud-architecture.html), [magento](https://magento.com/resources/magento-2-architectural-overview), [devdocs](https://devdocs.magento.com/guides/v2.3/architecture/bk-architecture.html)
-  Architecture in Magento 2 – What is it and how is it used in Magento Commerce? []()
-  What are the benefits and costs of database sharding? []()
- What is the Varnish Full Page Cache and why is it better than the built in FPC? []()
-  What are the basic responsibilities of templates and layouts in Magento 2? []()
- What are the basic steps for extending Magento 2 functionality with a code change or a third-party extension? []()
- How can the site design be configured using the options found in the Admin UI under System > Design >Configuration? []()
#### 2.3 Demonstrate knowledge of how to use the Magento API for integrating with third-party systems
[devdocs1](https://devdocs.magento.com/guides/v2.3/get-started/bk-get-started-api.html), [devdocs2](https://devdocs.magento.com/guides/v2.3/get-started/create-integration.html), [devdocs3](https://devdocs.magento.com/guides/v2.3/rest/list.html), [devdocs4](https://devdocs.magento.com/guides/v2.3/b2b/integrations.html), [omsdocs1](https://omsdocs.magento.com/en/integration/api/integrating-with-magento-api/), [omsdocs](https://omsdocs.magento.com/en/integration/api/), [mageplaza](https://www.mageplaza.com/kb/how-to-create-new-api-information-for-integration-magento-2.html)
-  What types of API does Magento Commerce have? []()
- What are the intended use cases for the different API types? []()
- What are the pros and cons of each type? []()
- What methods of authentication do the Magento 2 APIs support? []()
- Demonstrate the ability to manage credentials for the Magento API
#### 2.4 Demonstrate ability to design and administer websites, stores, store views
[docs](https://docs.magento.com/m2/ee/user_guide/stores/websites-stores-views.html), [devdocs](https://devdocs.magento.com/guides/v2.3/config-guide/multi-site/ms_websites.html), [cloudways](https://www.cloudways.com/blog/magento-multi-store-importance-and-some-common-issues/)
- What are use cases for product attributes scopes? []()
- What is the effect of Website, Store, and Store View configuration scopes? []()
- Understand display of product catalogs in websites, stores, and store views
- Understand administration of websites, stores, and store views
- Understand localization taxes and pricing in websites, stores, and store views

#### 2.5 Demonstrate understanding of the differences between Magento editions
[serverguy](https://serverguy.com/magento/magento-community-vs-enterprise-edition/), [elogic](https://elogic.co/blog/magento-community-vs-enterprise-edition-comparison/), [mofluid](https://mofluid.com/blog/magento-community-vs-enterprise-edition/), [aheadworks](https://ecommerce.aheadworks.com/kbase/magento/magento-editions.html), [magento](https://magento.com/compare-open-source-and-magento-commerce), [iwdagency](https://www.iwdagency.com/blog/what-are-the-differences-in-magento-open-source-and-commerce-editions/), [bsscommerce](https://bsscommerce.com/blog/magento-2-community-vs-enterprise-edition-comparison/), [iwdagency](https://www.iwdagency.com/blog/what-are-the-differences-in-magento-open-source-and-commerce-editions/)

- What are the main differences between Magento Open Source and Magento Commerce? []()
- What features are available only on Magento Commerce? []() (Commerce, Open Source, and B2B)
- Differences between Magento 2 Commerce, Magento 2 Commerce Cloud, and Magento 2 Open Source
- Advantages of Magento Commerce, Magento Commerce Cloud, Magento Open Source
- Staging and previewing
- Payment methods in Magento 2 Commerce
- Customer attributes and segments in Magento 2 Commerce
- Full page cache and indexing differences between editions
- All other differences between Magento Open Source and Magento Commerce
#### 2.6 Demonstrate ability to identify infrastructure requirements for a Magento project
[devdocs1](https://devdocs.magento.com/guides/v2.3/install-gde/system-requirements-tech.html), [devdocs2](https://devdocs.magento.com/guides/v2.3/install-gde/system-requirements.html), [devdocs3](https://devdocs.magento.com/guides/v2.3/performance-best-practices/hardware.html), [meetanshi](https://meetanshi.com/blog/magento-2-system-requirements/)
- What are the infrastructure elements of a typical Magento installation (database, search, CDN, cache, sessions, etc.)? []()
#### 2.7 Demonstrate ability to configure the Magento storefront functionality
[docs1](https://docs.magento.com/m2/ce/user_guide/stores/cookie-reference.html), [docs2](https://docs.magento.com/m2/ce/user_guide/stores/compliance-cookie-restriction-mode.html), [mageplaza](https://www.mageplaza.com/kb/gdpr-pro-cookie-restriction.html), [belvg](https://belvg.com/blog/cookies-in-magento-2-0.html), [medium](https://medium.com/@abhishekjakhotiya/understanding-magento-2-cookies-9e1618f341a7), [devdocs](https://devdocs.magento.com/guides/v2.3/config-guide/cache/static-content-signing.html), [stackexchange](https://magento.stackexchange.com/questions/214594/magento-2-static-content-signing)
- How are cookies used in Magento? []()
- What must be done to configure cookies on multisite Magento implementations? []()
- What is static content signing? []()
#### References:
- Magento Open Source and Magento Commerce Documentation and Resources
- Magento U courses for Merchants and Marketers

[GoToTop](#Magento-2-Certified-Solution-Specialist)
### 3 Magento Admin and Storefront

#### 3.1 Demonstrate ability to use the Magento Admin
[docs](https://docs.magento.com/m2/ee/user_guide/stores/admin.html)
- Which sections exist in the Magento Admin UI? []()
- What are user roles? []()
- How can they be configured? Can a user have multiple roles? []()
- Demonstrate the ability to create complex user authorization configurations
- Demonstrate the ability to use grids and forms
#### 3.2 Demonstrate ability to use content staging and previews
[docs1](https://docs.magento.com/m2/ee/user_guide/cms/content-staging.html), [docs2](https://docs.magento.com/m2/ee/user_guide/cms/content-staging-preview.html), [quora](https://www.quora.com/What-is-content-staging-in-Magento-2-Commerce), [mag-manager](https://www.mag-manager.com/product-information/magento-product-management/magento-2-content-staging/), [magenest](https://store.magenest.com/blog/magento-2-content-staging/), [fisheye](https://www.fisheye.co.uk/magento-commerce/)
- What are staging timelines? []()
- How can staging be used? []()
- How can staging be previewed? []()
- What are the limitations of staging? []()
- Which entities can staging be used with? []()
- How can staging be used with third-party extensions? []()
#### 3.3 Demonstrate ability to configure the shopping cart
[docs1](https://docs.magento.com/m2/2.2/ee/user_guide/sales/cart-configuration.html), [docs2](https://docs.magento.com/m2/ee/user_guide/sales/shopping-assisted-cart-manage.html), [docs3](https://docs.magento.com/m2/ee/user_guide/sales/cart-link.html), [docs4](https://docs.magento.com/m2/ee/user_guide/configuration/customers/persistent-shopping-cart.html)
- Can guest customers place orders? []()
- How can pricing and tax display be influenced through the Magento Admin? []()
- How do you restrict checkout to registered customers? []()
- Demonstrate the ability to use the wish list? []()
- Demonstrate the ability to configure shopping cart rules? []()
#### 3.4 Demonstrate understanding of payment methods
[mageworx](https://www.mageworx.com/wiki/cat/magento-payment/), [docs](https://docs.magento.com/m2/ee/user_guide/payment/gateways.html), [elogic](https://elogic.co/blog/7-best-magento-2-payment-gateways/)
- Which payment methods are available natively in Magento Commerce? []()
- Which capture methods does Magento provide? []()
- What are advantages of hosted payment? []()
- What are the shopping cart gift options? []()
#### 3.5 Demonstrate ability to configure shipping methods
[mageplaza](https://www.mageplaza.com/kb/how-to-configure-shipping-method-magento-2.html), [docs](https://docs.magento.com/m2/ee/user_guide/configuration/sales/shipping-methods.html), [magestore](https://www.magestore.com/magento-2-tutorial/magento-2-shipping-methods-tuts/), [cloudways](https://www.cloudways.com/blog/magento-shipping/)
- What shipping methods does Magento 2 provide out of the box? []()
- How can table rates be configured? []()
- How can in-store pickup be set up? []()
#### 3.6 Demonstrate ability to create a checkout process
[docs](https://docs.magento.com/m2/ee/user_guide/sales/checkout-onepage.html), [appseconnect](https://www.appseconnect.com/fasten-checkout-process-on-magento/), [iksula](https://blog.iksula.com/optimize-checkout-with-magento-commerce/)
- What can registered customers do that guest customers cannot? []()
- Why is the payment step last before order placement? []()
- What kind of customizations does Magento checkout support? []()
- How is price calculation in the checkout  different from the catalog? []()
#### 3.7 Demonstrate ability to set up order processing
[docs1](https://docs.magento.com/m2/ee/user_guide/sales/order-processing.html), [docs2](https://docs.magento.com/m2/ee/user_guide/sales/order-management.html), [magento](https://magento.com/resources/magento-commerce-order-management), [docs](https://docs.magento.com/m2/ee/user_guide/sales/order-workflow.html), [omsdocs](https://omsdocs.magento.com/en/getting-started/)
- When an order is saved in the Magento database? []()
- what triggers a confirmation email to a customer using PayPal Express? []()
- Login to PayPal account? []()
- Clicking Checkout button & Clicking Purchase button? []()
- When editing a pending order, what order data can be changed? []()
#### 3.8 Understand the use of extensions and customizations
[amasty](https://amasty.com/blog/customizing-magento-2-extensions/)
- Where can a merchant find Magento extensions? []()
- How are extensions installed? []()
- How can a Magento extension be evaluated? []()
- What do you need to look out for when evaluating a third-party extension? []()
- When is a customization required? []()
#### 3.9 Demonstrate ability to manage customers
[docs1](https://docs.magento.com/m2/b2b/user_guide/customers/customer-account-manage.html), [docs2](https://docs.magento.com/m2/b2b/user_guide/customers/customer-account.html), [docs3](https://docs.magento.com/m2/ee/user_guide/customers/customer-account-manage.html), [docs4](https://docs.magento.com/m2/b2b/user_guide/customers/customers-menu.html)
- What are customer groups? []()
- What can customer groups be used for? []()
- How can customer groups be set up? []()
- What are customer segments? []()
- What can customer segments be used for? []()
- How can customer segments be configured? []()
- What are customer attributes used for? []()
- What kind of customer attributes can be created? []()
- What is the difference in customer attribute configuration between Magento Commerce and Magento Open Source? []()
- What are customer account features? []()
#### 3.10 Demonstrate ability to use the CMS
[kualo]( https://my.kualo.com/knowledgebase/50_magento-commerce/505_how-to-use-the-cms-in-magento-commerce.html), [scnsoft](https://www.scnsoft.com/blog/magento-cms), [](https://www.coredna.com/blogs/magento-ecommerce-platform)
- What are CMS pages and blocks? []()
- How can custom variables be used? []()
- How can external images be embedded in CMS content? []()
- How can multilingual CMS content be managed? []()
- What are widgets? []()
- How are widgets used? []()
- Demonstrate understanding of Magento Commerce banners
#### 3.11 Demonstrate ability to create promotions and price rules
[docs1](https://docs.magento.com/m2/ee/user_guide/marketing/price-rules-catalog.html), [docs2](https://docs.magento.com/m2/ee/user_guide/marketing/promotions.html), [docs3](https://docs.magento.com/m2/2.2/ee/user_guide/marketing/price-rules-catalog.html), [docs4](https://docs.magento.com/m2/b2b/user_guide/marketing/price-rule-multiple-sku.html)
- What is the difference between catalog price rules and shopping cart price rules? []()
- What are effects of many catalog price rules? []()
- What are effects of many shopping cart price rules? []()
- Demonstrate the ability to set up product relations (related products, upsells, cross-sells)
- Demonstrate an understanding of the possibilities and limitations of reward points
- What kind of coupons exist? []()
- How can they be configured? []()
#### 3.12 Demonstrate ability to import / export
[docs1](https://docs.magento.com/m2/b2b/user_guide/catalog/inventory-import-export.html), [docs2](https://docs.magento.com/m2/ee/user_guide/system/data-import.html), [docs3](https://docs.magento.com/m2/ee/user_guide/system/data-transfer-bundle-products.html), [docs4](https://docs.magento.com/m2/ee/user_guide/system/data-scheduled-import-export.html)
- Explain how to populate a product import template with product data that needs to be managed at the store view
level. For example, images and language differ across the store views. If I have 3 store views what would that look like? []()
- Can order data be imported without customization? []()
- Define the import behaviors: add/update, replace, delete? []()
- What is an empty attribute value constant and what is the default value? []()
#### 3.13 Demonstrate understanding of reporting in Magento
[docs](https://docs.magento.com/m2/ce/user_guide/reports/advanced-reporting.html), [devdocs](https://devdocs.magento.com/guides/v2.3/advanced-reporting/overview.html), [docs](https://docs.magento.com/m2/ee/user_guide/system/support-system-report.html)
- What native options exist for reporting in Magento? []()
- What are the benefits of Magento BI? []()
#### References:
- Magento Open Source and Magento Commerce Documentation and Resources
- Magento U courses for Merchants and Marketers

[GoToTop](#Magento-2-Certified-Solution-Specialist)

### 4 Business and Applications

#### 4.1 Demonstrate ability to gather requirements
[paulnrogers](https://paulnrogers.com/creating-initial-specification-magento-project/), [kensiumsolutions](https://www.kensiumsolutions.com/magento-capabilities-process.html)
- Given a customer need, how can it be implemented in Magento? []()
- Given a customer design request, what would be the easiest or most efficient way to accomplish the goal? []()
- When should you recommend that a client modify requests to fit
native functionality? []()
#### 4.2 Demonstrate ability to create internationalization / multisite setups
[inchoo](https://inchoo.net/magento-2/magento-2-administration/create-multi-language-store-magento-2-part-2/), [inviqa](https://inviqa.com/blog/guide-international-expansion-magento-commerce), [bsscommerce](https://bsscommerce.com/blog/magento-2-multiple-website-vs-magento-2-multiple-store-views/)
- When does a solution need to include multiple websites or stores? []()
- Multisite infrastructure
- Demonstrate understanding of Website, Stores, Store Views
- Creating localization, addressing and setting up international currencies and taxes, and multisite shipping
#### 4.3 Demonstrate ability to create customer loyalty programs
[docs](https://docs.magento.com/m2/ee/user_guide/marketing/rewards-loyalty.html), [mageplaza](https://www.mageplaza.com/blog/start-loyalty-program-for-magento-2-stores.html)

- Identify the actions that can acquire rewards points for customers
#### 4.4 Demonstrate understanding of laws and regulations
[mageplaza](https://www.mageplaza.com/blog/gdpr-comprehensive-step-by-step-guideline.html), [docs](https://docs.magento.com/m2/ce/user_guide/tax/tax-rules.html), [firebearstudio](https://firebearstudio.com/blog/magento-2-gdpr-compliance-guide.html), [magento](https://magento.com/gdpr)
- Distance selling, PCI-DSS, cross-border trade, GDPR? []()
- Fixed Product Tax (FPT) - How can it be configured natively to meet CA tax regulation requirements such as bottle deposit tax? []()
- EU / AU / CA tax regulations - How can native configurations meet storefront display requirements? []()
- How do you configure product prices to include tax? []()
- how do you configure product prices excluding tax? []()
- how do you break out tax only in the shopping cart or order confirmation? []()
#### 4.5 Demonstrate ability to apply taxes
[docs](https://docs.magento.com/m2/ce/user_guide/tax/tax-settings-general.html),
[belvg](https://belvg.com/blog/how-to-set-up-taxes-in-magento-2-a-complete-step-by-step-instruction.html), [ostraining](https://www.ostraining.com/blog/magento/magento-taxes/), [fastcomet](https://www.fastcomet.com/tutorials/magento2/taxes), [magestore](https://www.magestore.com/magento-2-tutorial/tax-rate-payment-and-shipping-methods-magento-2/)

- US and EU tax regulations; VAT; digital VAT; in-state and out-of-state taxes; cross-border taxes? []()
#### 4.6 Demonstrate ability to set up a returns process
[docs](https://docs.magento.com/m2/ee/user_guide/sales/rma-configure.html), [mageplaza](https://www.mageplaza.com/blog/manage-return-requests-by-rma.html), [twojay](https://www.twojay.co/developer-guides/rma-product-return-magento2), [amasty](https://amasty.com/blog/manage-refunds-with-rma-for-magento-2/)
- What is a return process? []()
- How is a return process configured? []()

#### References:
- Magento Open Source and Magento Commerce Documentation and Resources
- Magento U courses for Merchants and Marketers
- Magento U course: Requirements Discovery

[GoToTop](#Magento-2-Certified-Solution-Specialist)

### 5 Catalog

#### 5.1 Demonstrate how to use products
- Demonstrate the ability to create and use product videos. [docs](https://docs.magento.com/m2/ce/user_guide/catalog/product-video.html), [magenticians](https://magenticians.com/add-video-to-product-in-magento-2/), [mageplaza](https://www.mageplaza.com/kb/how-to-upload-product-videos-in-magento-2.html), [inchoo](https://inchoo.net/magento-2/adding-videos-product-page-magento2/), [shoppimon](https://www.shoppimon.com/2017/02/add-videos-to-product-pages-magento/)
- What determines whether a product is visible on the storefront? [docs](https://docs.magento.com/m2/ce/user_guide/catalog/product-video.html), [magenticians](https://magenticians.com/add-video-to-product-in-magento-2/), [mageplaza](https://www.mageplaza.com/kb/how-to-upload-product-videos-in-magento-2.html), [inchoo](https://inchoo.net/magento-2/adding-videos-product-page-magento2/), [shoppimon](https://www.shoppimon.com/2017/02/add-videos-to-product-pages-magento/)
- What determines whether a product can be sold on the storefront (saleable)? [docs](https://docs.magento.com/m2/b2b/user_guide/catalog/inventory-product-stock-options.html), [docs](https://docs.magento.com/m2/ce/user_guide/catalog/product-scope.html)
#### 5.2 Demonstrate ability to use different product types
- What are product types in Magento Commerce? [docs](https://docs.magento.com/m2/ee/user_guide/catalog/product-types.html), [mageworx](https://www.mageworx.com/wiki/cat/magento-2-product/)

#### 5.3 Demonstrate ability to use categories
- How can products and categories be added? [docs](https://docs.magento.com/m2/ee/user_guide/catalog/category-create.html), [magenticians](https://magenticians.com/magento-2-add-new-category-product/)
- What is the visual merchandiser? [docs](https://docs.magento.com/m2/ee/user_guide/marketing/visual-merchandiser.html)
- How can the visual merchandiser be used? [store](https://store.magenest.com/blog/magento-commerce-visual-merchandiser/)
- Demonstrate the ability to manage categories. [trellis](https://trellis.co/blog/managing-categories-in-magento-2/), [matridtech](https://www.matridtech.net/magento2-support/how-to-add-or-manage-categories-in-magento2//)
- How can multiple websites with independent category trees be created?
[firebearstudio](https://firebearstudio.com/blog/magento-2-page-hierarchy-import-export.html)https://devdocs.magento.com/guides/v2.3/config-guide/multi-site/ms_over.html)

 #### 5.4 Demonstrate ability to use product attributes
- What are attribute sets? [docs](https://docs.magento.com/m2/ce/user_guide/stores/attribute-sets.html), [mageworx](https://www.mageworx.com/wiki/magento-2-attribute-sets/
)
- What are the consequences of a few large attribute sets vs. many small attribute sets?  [magecom](https://magecom.net/attributes-and-attribute-set-planning-creation-in-magento-2/)
- What is the effect of using many configurable attributes with a product? [paulnrogers](https://paulnrogers.com/understanding-simple-products-versus-configurable-products-magento/), [docs](https://docs.magento.com/m2/ce/user_guide/catalog/product-create-configurable.html), [mageplaza](https://www.mageplaza.com/kb/how-create-configurable-product-magento-2.html)
- What is the effect of store scope vs. global scope attributes? [docs](https://docs.magento.com/m2/ce/user_guide/configuration/scope.html), [magestore](https://www.magestore.com/magento-2-tutorial/3259-2/), [cadence](https://www.cadence-labs.com/2018/03/magento-2-use-default-value-store-view-scope-fix/)
- What are possible strategies to use fewer product attributes? [magecom](https://magecom.net/attributes-and-attribute-set-planning-creation-in-magento-2/), [amasty](https://amasty.com/blog/why-product-attributes-in-magento-2-are-important/)

#### 5.5 Demonstrate ability to scale catalogs
- How to deal with large catalogs?  [magemonkeys](https://www.magemonkeys.com/can-magento-handle-very-huge-products-catalog/), [quora](https://www.quora.com/Can-Magento-2-handle-a-large-catalog-of-500K-products-and-3K-categories)
- High SKU catalogs?  [amasty](https://amasty.com/blog/improve-magento-2-performance-with-flat-catalog/)
- High volume sales?  [magestore](https://www.magestore.com/magento-2-tutorial/magento-2-how-to-configure-catalog-search/), [aionhill](https://aionhill.com/how-many-products-can-magento-handle)
#### 5.6 Demonstrate ability to configure inventory management
- Inventory management?  [magenticians](https://magenticians.com/magento-2-inventory-management/), [boostmyshop](https://www.boostmyshop.eu/erp-inventory-magento-2.html), [mageworx](https://www.mageworx.com/wiki/magento-2-stock-inventory/), [docs](https://docs.magento.com/m2/ce/user_guide/catalog/inventory.html)

[GoToTop](#Magento-2-Certified-Solution-Specialist)

### References:
- [theecommmanager](https://theecommmanager.com/magento-solutions-specialist-exam/)
