# Contributing to BatNoter

First off, thanks for taking the time to contribute! :tada::+1:

The following is a set of guidelines for contributing to BatNoter, which is hosted in the [BatNoter Repository](https://github.com/batnoter/batnoter) on GitHub. These are mostly guidelines, not rules. Use your best judgment, and feel free to propose changes to this document in a pull request.

## Development Process
We use GitHub to track issues and feature requests, as well as accept pull requests.

## Commit Message Guidelines
-   Use the imperative, present tense: "Change" not "Changed" nor "Changes".
-   Capitalize first letter.
-   Do not place a period . at the end.
-   Length of the commit message should not exceed 50 characters.

## Pull Requests
Feel free to submit pull requests.

1.  Fork the repo and create your branch from `main`.
2.  If you've added code that should be tested, add tests.
4.  Ensure the test suite passes.
5.  Make sure your code lints.
6.  Create pull request.

## Issues
GitHub Issues is used to track ideas, feedback, tasks, and bugs.
Please ensure your issue description is clear and has sufficient instructions.

## License
By contributing to BatNoter project, you agree that your contributions will be licensed under its MIT License.
