- [Awesome Deep Learning / Machine Learning / Data Science / Reinforcement Learning Questions](#awesome-deep-learning--machine-learning--data-science--reinforcement-learning-questions)
  - [简介 / Introduction](#简介--introduction)
  - [问题与答案 / Questions and Answers](#问题与答案--questions-and-answers)
    - [论文与科研](#论文与科研)
    - [书籍、资源、数据集](#书籍资源数据集)
    - [科普向](#科普向)
    - [项目](#项目)
    - [学习方法](#学习方法)
    - [数学与优化](#数学与优化)
    - [语言与框架](#语言与框架)
    - [经典机器学习](#经典机器学习)
    - [神经网络与深度学习](#神经网络与深度学习)
    - [计算机视觉](#计算机视觉)
    - [自然语言处理](#自然语言处理)
    - [强化学习](#强化学习)
    - [主动学习](#主动学习)
    - [数据科学](#数据科学)
    - [推荐系统](#推荐系统)
    - [比赛、面试与工作](#比赛面试与工作)
    - [行业与产品](#行业与产品)
    - [思考与展望](#思考与展望)
    - [数据标注](#数据标注)
    - [其他应用](#其他应用)
    - [未整理](#未整理)

# Awesome Deep Learning / Machine Learning / Data Science / Reinforcement Learning Questions

## 简介 / Introduction

这个仓库收集整理了一些网站中（如知乎、Quora、Reddit、Stack Exchange等）与机器学习、深度学习、强化学习、数据科学等相关的**有价值的问题/答案**（如有启发意义、科普意义、能开阔视野、让人脑洞大开的问题/答案，或者总结整理类的问题/答案）。



> **欢迎各位大佬提供您发现的优秀的问题与答案，集思广益~ 谢谢么么哒~**



## 问题与答案 / Questions and Answers




### 论文与科研

* CVPR 2019 有哪些值得关注的亮点？[zhihu link](https://www.zhihu.com/question/313967271)

* 如何评价谷歌大脑的EfficientNet？[zhihu link](https://www.zhihu.com/question/326833457)

* 如何复现renset-based FCN的准确度（IoU）？[zhihu link](https://www.zhihu.com/question/291057041)

* 深度学习方面的科研工作中的实验代码有什么规范和写作技巧？如何妥善管理实验数据？[zhihu link](https://www.zhihu.com/question/268193800)

* 深度学习科研，如何高效进行代码和实验管理？[zhihu link](https://www.zhihu.com/question/269707221)

* 人工智能从业者应该从哪里去寻找和阅读顶级论文？[zhihu link](https://www.zhihu.com/question/303022763)

* 人工智能领域有哪些重要的学术会议和顶级实验室？[zhihu link](https://www.zhihu.com/question/31617024)

* 深度学习入门必看的书和论文？有哪些必备的技能需学习？[zhihu link](https://www.zhihu.com/question/31785984)

* 如何理解深度学习中的deconvolution networks？[zhihu link](https://www.zhihu.com/question/43609045)

* 如何评价 Kaiming He 最新的 Mask R-CNN?[zhihu link](https://www.zhihu.com/question/57403701)
    
* 机器学习方面高质量的论文怎么找？[zhihu link](https://www.zhihu.com/question/31555786)

* 机器学习研究者需要能够在多久之内复现出一篇paper?[zhihu link](https://www.zhihu.com/question/275048106)

* 如何解析深度学习 Inception 从 v1 到 v4 的演化？[zhihu link](https://www.zhihu.com/question/66396783)

* 如何评价 MSRA 最新的 Deformable Convolutional Networks？[zhihu link](https://www.zhihu.com/question/57493889)

* 有哪些好看的CNN模型画法？[zhihu link](https://www.zhihu.com/question/62509034)

* 数据挖掘、机器学习领域有哪些知名的期刊或会议？[zhihu link](https://www.zhihu.com/question/38424588)

* 除了 arxiv.org, 机器学习与数据挖掘相关在哪可以阅读比较专业的文献？[zhihu link](https://www.zhihu.com/question/21434140)

* 深度学习目前主要有哪些研究方向?[zhihu link](https://www.zhihu.com/question/23140232)

* 如何理解谷歌团队的机器翻译新作《Attention is all you need》？[zhihu link](https://www.zhihu.com/question/61077555)

* 深度学习有哪些好玩的且易于实现的论文？[zhihu link](https://www.zhihu.com/question/41231774)

* 目前人工智能的主要研究方向都有哪些？[zhihu link](https://www.zhihu.com/question/51419290)

* distributed/stochastic optimization的研究热点在哪？[zhihu link](https://www.zhihu.com/question/32675289)

* 当前人工智能特别是深度学习最前沿的研究方向是什么？[zhihu link](https://www.zhihu.com/question/46485555)

* 请问在现阶段的神经科学和脑科学的研究中，有没有人脑结合AI（人工智能）的方向呢。如果有，进展又怎样呢？[zhihu link](https://www.zhihu.com/question/54424980)

* 请问机器学习生物医学图像处理方向研究前景如何？[zhihu link](https://www.zhihu.com/question/268733733)

* 当前，在图像处理领域，哪个方向比较火？或者比较好做？[zhihu link](https://www.zhihu.com/question/41250817)

* 从事计算机视觉和机器学习的研究，如何获得认知神经科学和脑科学的启发？[zhihu link](https://www.zhihu.com/question/35704088)

* 在 Deep Learning 方向，有哪些论文你认为不可错过？[zhihu link](https://www.zhihu.com/question/41182765)

* 本人现在研一，想水篇论文毕业，请问怎么在机器学习方面水paper？[zhihu link](https://www.zhihu.com/question/30912132)

* 机器学习方面的论文应该在哪找？[zhihu link](https://www.zhihu.com/question/313632967)

* 深度学习论文中的baseline方法如何调参？[zhihu link](https://www.zhihu.com/question/307805005)







### 书籍、资源、数据集

* 网络上深度学习、机器学习的在线课程是否值得学习？[zhihu link](https://www.zhihu.com/question/267126994)

* 有哪些比较好的机器学习，深度学习的网络资源可利用？[zhihu link](https://www.zhihu.com/question/43664024)

* 机器学习书籍选择?[zhihu link](https://www.zhihu.com/question/31091250)

* 如何评价深度学习领域圣经“花书”Deep Learning的中文版？[zhihu link](https://www.zhihu.com/question/62240525)

* 有哪些机器学习、图像识别方面的入门书籍？[zhihu link](https://www.zhihu.com/question/20523667)

* 自己学习深度学习时，有哪些途径寻找数据集？[zhihu link](https://www.zhihu.com/question/53655758)

* 最近开始学习机器学习，不知道看哪本书比较好（PRML ESL or MLAPP）？[zhihu link](https://www.zhihu.com/question/37868662)

* 深入机器学习应该从哪门课或哪本书开始？求推荐资源？[zhihu link](https://www.zhihu.com/question/268099849)

* 机器学习的学习应该看哪些书籍？[zhihu link](https://www.zhihu.com/question/22221180)

* 有哪些优秀的深度学习入门书籍？需要先学习机器学习吗？[zhihu link](https://www.zhihu.com/question/36675272)

* 有什么深度学习数学基础书推荐？[zhihu link](https://www.zhihu.com/question/41459109)

* 国内外有哪些比较好的人工智能学习平台？[zhihu link](https://www.zhihu.com/question/267305504)

* 学习机器学习有哪些好工具推荐？[zhihu link](https://www.zhihu.com/question/20472776)






### 科普向

* 机器学习、深度学习和强化学习的关系和区别是什么？[zhihu link](https://www.zhihu.com/question/279973545)

* 机器学习、优化理论、统计分析、数据挖掘、神经网络、人工智能、模式识别之间的关系是什么？[zhihu link](https://www.zhihu.com/question/20747381)

* 人工智能、机器学习和深度学习的区别?[zhihu link](https://www.zhihu.com/question/57770020)

* 神经网络啥时候改名叫“深度学习”了？[zhihu link](https://www.zhihu.com/question/50422088)

* 目前人工智能的主要研究方向都有哪些？[zhihu link](https://www.zhihu.com/question/51419290)

* 谁能详细讲解一下TensorFlow Playground所展示的神经网络的概念？[zhihu link](https://www.zhihu.com/question/42995089)







### 项目

* GitHub 上有哪些有关图像处理或是机器学习的有趣项目？[zhihu link](https://www.zhihu.com/question/36346612)

* GitHub 上有哪些有趣的关于 NLP 或者 DL 的项目？[zhihu link](https://www.zhihu.com/question/36853910)







### 学习方法

* 新入学的计算机研究生怎么安排三年学习深度学习？[zhihu link](https://www.zhihu.com/question/58343851)

* 有没有必要把机器学习算法自己实现一遍？[zhihu link](https://www.zhihu.com/question/36768514)

* 计算资源有限的人如何在Deep Learning领域成长？[zhihu link](https://www.zhihu.com/question/304263105)





### 数学与优化

* 机器学习中的优化理论，需要学习哪些资料才能看懂？[zhihu link](https://www.zhihu.com/question/25120338)

* 为什么凸优化这么重要？[zhihu link](https://www.zhihu.com/question/24641575)

* 为什么有些学数学的看不惯甚至鄙视 Deep Learning？[zhihu link](https://www.zhihu.com/question/58992444)

* 优化理论能给深度学习带来怎样的革命？[zhihu link](https://www.zhihu.com/question/310314918)

* 概率论与数理统计在机器学习中为什么这么重要？[zhihu link](https://www.zhihu.com/question/285189181)










### 语言与框架

* 2017年1月18日Facebook发行的PyTorch相比TensorFlow、MXNet有何优势？[zhihu link](https://www.zhihu.com/question/54914188)

* 如何有效地阅读PyTorch的源代码？[zhihu link](https://www.zhihu.com/question/58253344)

* PyTorch中在反向传播前为什么要手动将梯度清零？[zhihu link](https://www.zhihu.com/question/303070254)

* Pytorch有什么节省内存（显存）的小技巧？[zhihu link](https://www.zhihu.com/question/274635237)

* 如何评价 PyTorch 1.0 Roadmap？[zhihu link](https://www.zhihu.com/question/275682850)

* 如何评价PyTorch 1.0？[zhihu link](https://www.zhihu.com/question/296983686)

* 如何评价PyTorch 1.0正式版？[zhihu link](https://www.zhihu.com/question/305054691)

* PyTorch 有哪些坑/bug？[zhihu link](https://www.zhihu.com/question/67209417)

* Pytorch1.0.0 有哪些坑？[zhihu link](https://www.zhihu.com/question/305416101)

* 和 Python 相比，Matlab 能否成为深入学习数据挖掘的工具?[zhihu link](https://www.zhihu.com/question/25508497)

* 如何评价编程语言Julia 1.0？[zhihu link](https://www.zhihu.com/question/289648396)

* 为什么谈论深度学习工具时，很少有人讨论matlab的神经网络工具包？[zhihu link](https://www.zhihu.com/question/48676862)

* 2018年了，MXNet 发展的如何了？[zhihu link](https://www.zhihu.com/question/293996867)

* 为什么强大的 MXNet 一直火不起来？[zhihu link](https://www.zhihu.com/question/52498007)

* MXNet 的代码要怎么读？[zhihu link](https://www.zhihu.com/question/35924234)

* 如何高效的学习 TensorFlow 代码?[zhihu link](https://www.zhihu.com/question/41667903)

* 有哪些相见恨晚的 TensorFlow 小技巧？[zhihu link](https://www.zhihu.com/question/268375146)

* 为什么说 TensorFlow 是适用于部署生产的机器学习框架？[zhihu link](https://www.zhihu.com/question/294646695)

* 开发者如何选择深度学习框架？[zhihu link](https://www.zhihu.com/question/68114194)

* 学习机器学习有哪些好工具推荐？[zhihu link](https://www.zhihu.com/question/20472776)

* 人工智能库，有没有结合Deep Learning 和Reinforcement Learning的呢？[zhihu link](https://www.zhihu.com/question/48682064)








### 经典机器学习

* 机器学习里的 kernel 是指什么？[zhihu link](https://www.zhihu.com/question/30371867)

* 机器学习中如何处理缺失数据？[zhihu link](https://www.zhihu.com/question/26639110)

* 机器学习应该准备哪些数学预备知识？[zhihu link](https://www.zhihu.com/question/36324957)

* 机器学习的算法和普通《算法导论》里的算法有什么本质上的异同？[zhihu link](https://www.zhihu.com/question/24976006)

* 机器学习到底是什么，如何使用这项技术？[zhihu link](https://www.zhihu.com/question/294147625)

* 机器学习中的数据预处理有哪些常见/重要的工具？[zhihu link](https://www.zhihu.com/question/38273898)

* 机器学习里的弱标签学习，属于半监督学习吗？[zhihu link](https://www.zhihu.com/question/56875030/)

* 为什么机器学习中, 要假设我们的数据是独立同分布的?[zhihu link](https://www.zhihu.com/question/41222495)

* 机器学习中用来防止过拟合的方法有哪些？[zhihu link](https://www.zhihu.com/question/59201590)

* 训练集准确率接近100%，验证集准确率80%但是随着训练step增加不增也不降。算是过拟合还是欠拟合？[zhihu link](https://www.zhihu.com/question/65200055)









### 神经网络与深度学习

* 深度学习调参有哪些技巧？[zhihu link](https://www.zhihu.com/question/25097993) 

* 神经网络为什么可以（理论上）拟合任何函数？[zhihu link](https://www.zhihu.com/question/268384579)

* 为啥在训练神经网络时，梯度下降成为主流？[zhihu link](https://www.zhihu.com/question/291963981)

* CNN 中池化是否会丢失有价值特征信息？[zhihu link](https://www.zhihu.com/question/284156420)

* 卷积神经网络的卷积核大小、卷积层数、每层map个数都是如何确定下来的呢？[zhihu link](https://www.zhihu.com/question/38098038)

* 怎么选取训练神经网络时的Batch size?[zhihu link](https://www.zhihu.com/question/61607442)

* 是不是并不是所有问题都适合用神经网络预测？[zhihu link](https://www.zhihu.com/question/277551944)

* 为什么都说神经网络是个黑箱？[zhihu link](https://www.zhihu.com/question/263672028)

* 为什么神经网络同一套参数 训练出来的准确率不一样？[zhihu link](https://www.zhihu.com/question/294058968)

* 请问人工神经网络中的activation function的作用具体是什么？为什么ReLu要好过于tanh和sigmoid function? [zhihu link](https://www.zhihu.com/question/29021768)

* 为什么现在的CNN模型都是在GoogleNet、VGGNet或者AlexNet上调整的？[zhihu link](https://www.zhihu.com/question/43370067)

* 如何理解神经网络中通过add的方式融合特征？[zhihu link](https://www.zhihu.com/question/306213462)








### 计算机视觉

* 目标检测领域还有什么可以做的？[zhihu link](https://www.zhihu.com/question/280703314)

* 小目标检测问题中“小目标”如何定义？其主要技术难点在哪？有哪些比较好的传统的或深度学习方法[zhihu link](？https://www.zhihu.com/question/269877902)

* 神经网络和图像处理近年来的发展与趋势是什么？[zhihu link](https://www.zhihu.com/question/269303790)

* 有关语义分割的奇技淫巧有哪些？[zhihu link](https://www.zhihu.com/question/272988870)

* 目前主流的attention方法都有哪些？[zhihu link](https://www.zhihu.com/question/68482809)

* 计算机视觉是否已经进入瓶颈期？[zhihu link](https://www.zhihu.com/question/51863955)

* Attention mechanism目前有什么缺点和改进空间？[zhihu link](https://www.zhihu.com/question/305644438)

* Attention机制可以应用在图像分割的改善中吗？[zhihu link](https://www.zhihu.com/question/291446237)

* 深度学习在路径规划上有哪些应用？[zhihu link](https://www.zhihu.com/question/57456575)

* 弱监督学习在语义分割中的进展与应用?[zhihu link](https://www.zhihu.com/question/53263115/)







### 自然语言处理

* 为什么 Deep Learning 目前在 NLP 上还没有什么成功的应用？[zhihu link](https://www.zhihu.com/question/20981008)

* 在文本分类任务中，有哪些论文中很少提及却对性能有重要影响的tricks？[zhihu link](https://www.zhihu.com/question/265357659)

* 目前常用的自然语言处理开源项目/开发包有哪些？[zhihu link](https://www.zhihu.com/question/19929473)

* 工业界中NLP(自然语言处理)算法工程师的核心竞争力是什么？[zhihu link](https://www.zhihu.com/question/296661606)

* 如何在自然语言处理方向学习？[zhihu link](https://www.zhihu.com/question/266856019)

* 如何评价 BERT 模型？[zhihu link](https://www.zhihu.com/question/298203515)

* NLP中有什么比较好的sentence/paragraph embedding方法 ？[zhihu link](https://www.zhihu.com/question/299549788)

* 在NLP领域，现阶段最有希望突破深度学习牢笼的研究/思路有哪些？[zhihu link](https://www.zhihu.com/question/265118704)

* 文本情感分析有什么好资料、网站、工具推荐呢？[zhihu link](https://www.zhihu.com/question/20631050)









### 强化学习

* 强化学习（reinforcement learning)有什么好的开源项目、网站、文章推荐一下？[zhihu link](https://www.zhihu.com/question/49230922)

* 请问强化学习做新闻推荐能够取得不错的效果吗？[zhihu link](https://www.zhihu.com/question/307126367)

* 有研究强化学习（Reinforcement Learning）的不，强化学习的研究价值和应用前景如何？[zhihu link](https://www.zhihu.com/question/20335959)

* 强化学习怎么入门好？[zhihu link](https://www.zhihu.com/question/277325426)

* 强化学习是什么？[zhihu link](https://www.zhihu.com/question/31140846)

* 关于《reinforcement learning :an introduction》的理解？[zhihu link](https://www.zhihu.com/question/50461146)

* 强化学习（RL）是否是人工智能的关键之处，能够给人工智能带来质变？[zhihu link](https://www.zhihu.com/question/40554481)

* 强化学习（RL）中有哪些重要的理论结果？[zhihu link](https://www.zhihu.com/question/312164724)

* 怎么在监督学习的基础上做强化学习？[zhihu link](https://www.zhihu.com/question/51780401)

* 能否介绍一下强化学习（Reinforcement Learning），以及与监督学习的不同？[zhihu link](https://www.zhihu.com/question/41775291)

* 强化学习（reinforcement learning)有什么好的开源项目、网站、文章推荐一下？[zhihu link](https://www.zhihu.com/question/49230922/)

* 请问DeepMind和OpenAI身后的两大RL流派有什么具体的区别？[zhihu link](https://www.zhihu.com/question/316626294)

* 国内有哪些做强化学习的公司？[zhihu link](https://www.zhihu.com/question/313928115)

* 关于强化学习中经验回放（experience replay）的两个问题？[zhihu link](https://www.zhihu.com/question/278182581)

* 如何用简单例子讲解 Q - learning 的具体过程？[zhihu link](https://www.zhihu.com/question/26408259)

* 遗传算法和深度强化学习的结合会是新的方向吗？[zhihu link](https://www.zhihu.com/question/61174186)








### 主动学习

* 主动学习（Active Learning）从90年代发展至今，并且具有实质价值的潜力，为什么默默无闻？[zhihu link](https://www.zhihu.com/question/285149644)

* 主动学习(Active learning)算法的原理是什么，有哪些比较具体的应用？[zhihu link](https://www.zhihu.com/question/265479171)

* active learning还有人在做这方面的研究吗?[zhihu link](https://www.zhihu.com/question/65263436)










### 数据科学

* 数据分析师的前景怎么样?[zhihu link](https://www.zhihu.com/question/305422763)

* 你为什么离开数据科学（Data Science）行业?[zhihu link](https://www.zhihu.com/question/278539797)

* 未来五年，数据科学家（Data Scientist）的岗位需求会如何变化？[zhihu link](https://www.zhihu.com/question/301686177)

* 数据科学家 (Data Scientist) 的核心技能是什么？[zhihu link](https://www.zhihu.com/question/27604790)

* 同样是数据分析方法，为什么时间序列分析没有数据挖掘或机器学习那么火？[zhihu link](https://www.zhihu.com/question/24189178)

* 28 岁女孩想转行做数据挖掘靠谱吗？[zhihu link](https://www.zhihu.com/question/49490009)

* 数据挖掘中常用的数据清洗方法有哪些？[zhihu link](https://www.zhihu.com/question/22077960)










### 推荐系统

* 类似今日头条这样的个性化推荐网站怎么评价推荐质量的优劣？[zhihu link](https://www.zhihu.com/question/26990692)

* 在你做推荐系统的过程中都遇到过什么坑？[zhihu link](https://www.zhihu.com/question/32218407)

* 推荐系统的模型如何调参？[zhihu link](https://www.zhihu.com/question/319552319)

* Deep Learning 可以用来做推荐系统吗？[zhihu link](https://www.zhihu.com/question/20830906)










### 比赛、面试与工作

* 面试官如何判断面试者的机器学习水平？[zhihu link](https://www.zhihu.com/question/62482926)

* 如何准备机器学习工程师的面试 ？[zhihu link](https://www.zhihu.com/question/23259302)

* 机器学习工作内容和kaggle竞赛有什么区别？[zhihu link](https://www.zhihu.com/question/295475618)

* 从事AI真的需要CS科班出身吗？[zhihu link](https://www.zhihu.com/question/305531586)

* 为什么在实际的kaggle比赛中，GBDT和Random Forest效果非常好？[zhihu link](https://www.zhihu.com/question/51818176)










### 行业与产品

* 为什么所有号称聪明的人工智能产品都有点傻？[zhihu link](https://www.zhihu.com/question/59378498)

* 人工智能在工业界用到的模型都是最前沿的吗？[zhihu link](https://www.zhihu.com/question/304599202)

* 业界现在有哪些比较成熟的基于深度学习（deep learning）的应用？[zhihu link](https://www.zhihu.com/question/30237124)










### 思考与展望


* 你理想的未来 AI 时代什么样？未来 25 年内，各行业、个人生活会有哪些变化？我们该如何准备？[zhihu link](https://www.zhihu.com/question/300390366)

* 机器学习，深度神经网络等方法是否是正确的方向？[zhihu link](https://www.zhihu.com/question/26970857)

* 机器学习、深度学习领域有哪些被广泛提及但你不认同的结论或观点？[zhihu link](https://www.zhihu.com/question/292134377)

* 深度神经网络（DNN）是否模拟了人类大脑皮层结构？[zhihu link](https://www.zhihu.com/question/59800121)

* Deep Learning 一书中有哪些论述被最新研究验证、拓展或推翻了？[zhihu link](https://www.zhihu.com/question/61600406)

* 深度学习（机器学习）的下一步如何发展？[zhihu link](https://www.zhihu.com/question/47602063)

* 计算机视觉和自然语言处理，哪个更具有发展前景呢，还是各有千秋呢？[zhihu link](https://www.zhihu.com/question/49432647)

* 机器学习、深度学习等人工智能技术在工业界的应用状况是怎样的？人力供需状况如何？[zhihu link](https://www.zhihu.com/question/41012507)

* 人工智能在未来能彻底取代脑力工作者吗？[zhihu link](https://www.zhihu.com/question/294072941)

* 深度学习（deep learning）距离实际应用还有多远，会有大规模应用吗？[zhihu link](https://www.zhihu.com/question/23481177/)

* 机器学习成就人工智能，还是人工智能成就机器学习？[zhihu link](https://www.zhihu.com/question/20335960)

* 深度学习的研究领域是否有被过度夸大？[zhihu link](https://www.zhihu.com/question/27434103)

* 目前火热的Deep Learning会灭绝传统的SIFT/ SURF的特征提取的算法吗？[zhihu link](https://www.zhihu.com/question/48315686)

* 深度学习会不会淘汰掉其他所有机器学习算法?[zhihu link](https://www.zhihu.com/question/42061396)










### 数据标注

* 机器学习需要大量人工标注，尤其是深度学习，有没有什么好办法解决？[zhihu link](https://www.zhihu.com/question/60056259)

* 如何看待正在兴起的人工智能产业背后底层数据标注团队和数据工厂？[zhihu link](https://www.zhihu.com/question/292513220)

* 互联网数据标注员是做什么的？有什么发展前途吗？[zhihu link](https://www.zhihu.com/question/30654399)

* AI数据标注的未来？[zhihu link](https://www.zhihu.com/question/266510095)

* 国外的人工智能领域，数据标注是怎么做的？[zhihu link](https://www.zhihu.com/question/49433475)

* 有图像标注工具推荐或者分享吗？[zhihu link](https://www.zhihu.com/question/30626971)











### 其他应用

* 机器学习在无线通信领域的研究意义？[zhihu link](https://www.zhihu.com/question/296782869)

* 国内有哪些高校在做深度学习芯片方面的研究？[zhihu link](https://www.zhihu.com/question/64578383)

* 机器学习，神经网络在控制科学中的前景和应用大吗？为什么？[zhihu link](https://www.zhihu.com/question/29727968)














### 未整理


在控制验证集不变的前提下，随着训练集样本数的增加，验证集准确率不升反降？[zhihu link](https://www.zhihu.com/question/289025990)


人工智能算法能否通过输出结果改进准确率？[zhihu link](https://www.zhihu.com/question/296724405)


精确率、召回率、F1 值、ROC、AUC 各自的优缺点是什么？[zhihu link](https://www.zhihu.com/question/30643044)


机器学习专家与统计学家观点上有哪些不同？[zhihu link](https://www.zhihu.com/question/29687860)


如何评价Yann LeCun 说的「要研究机器学习，本科应尽量多学物理和数学课」？[zhihu link](https://www.zhihu.com/question/55260138)


如何理解fine-grained和coarse-grained？[zhihu link](https://www.zhihu.com/question/299171510)


有哪些值得关注的控制（动态系统与反馈控制、状态估计等）与机器学习（深度学习、强化学习等）理论上的结合？[zhihu link](https://www.zhihu.com/question/315809187)


机器学习（包括但不限于深度学习）算法的 fundamental limitation 有哪些？[zhihu link](https://www.zhihu.com/question/303886191)


机器学习方向的研究生是否需要学习研发岗知识？[zhihu link](https://www.zhihu.com/question/324066869)


要研究深度学习的可解释性（Interpretability)，应从哪几个方面着手？[zhihu link](https://www.zhihu.com/question/320688440)


现代人工神经网络是不是一个死胡同？这个技术是不是骗人的？[zhihu link](https://www.zhihu.com/question/324684293)


如今神经网络快速发展，传统的机器学习何去何从？[zhihu link](https://www.zhihu.com/question/323689418)












