## 插件钩子

钩子的机制是允许插件把一些功能“挂载”到系统中。系统运行至某个环节时，去调用插件内的一些函数。钩子分为两种：

* 动作 Action

  动作是 ginkgo 运行到某些环节时，就会被执行的一种钩子。插件可以通过动作来指示系统在遇到这些环节的时候，执行指定的函数。

* 过滤器 Filter

  过滤器的是 ginkgo 用于修改将要保存或发送出去的数据的一种钩子。插件可以通过过滤器来指示系统在遇到某些环节的时候，就执行指定的函数去修改特定的数据。

某些时候动作和过滤器可以达到相同的效果。比如要修改文章的内容，可以把插件挂载到过滤器 `filter_console_article_edit` 上，在文章的内容保存到数据库前就修改它。也可以把插件挂载到过滤器 `filter_pub_article_show` 上，在文章的内容发送到浏览器前修改它。

动作钩子和过滤器钩子最大的区别是过滤器有回传参数，可以利用插件将修改过的数据回传给系统，不同的钩子处理修改过的数据时也有所不同，有的是保存到数据库之前就修改，有的是在内容发送到浏览器前修改。

----------

##### ginkgo 框架内置钩子

| 名称 | 类型 | 描述 |
| - | - | - |
| action_fw_init | action | 框架初始化时触发 |
| action_fw_response_send | action | 响应发送时触发 |
| action_fw_response_end | action | 响应输出后触发 |
| action_fw_end | action | 框架运行结束时触发 |
| filter_fw_view | filter | 视图渲染时过滤 |

`filter_fw_view` 返回参数为渲染后的 HTML，回传参数也必须是 HTML。
