## 安装

将下载到的程序包解压，然后将所有文件上传到服务器，假设网站 URL 为 http://server 项目部署目录为 /project，以下说明均以此为例。

----------

##### 目录结构

```
project 应用部署目录
+-- app                    应用目录
|   +-- classes            类库目录
|   +-- config             配置目录
|   +-- ctrl               控制器目录
|   +-- lang               语言目录
|   +-- model              模型目录
|   +-- tpl                模板目录
|   +-- validate           验证器目录
|   +-- common.php         公共文件
|
+-- ginkgo                 框架目录
+-- extend                 扩展目录
|   +-- plugin             插件目录
+-- public                 web 部署目录（公开访问目录）
|   +-- static             静态资源存放目录（css、js、image）
|   +-- index.php          入口文件
|   +-- .htaccess          用于 apache 的重写
|
+-- runtime                运行时目录（可写、可设置）
+-- vendor                 第三方类库目录（Composer）
+-- composer.json          composer 定义文件
```

建议 public 目录作为公开访问目录，其它都是公开目录之外，当然必须修改 `public/index.php` 中的相关路径。如果没法做到这点，请记得设置目录的访问权限或者添加目录保护的文件。

> 如果是 mac 或者 linux 环境，请确保 runtime 目录有可写权限

----------

##### 服务器环境检查

用浏览器打开 http://server/index.php/install，将会进行 PHP 扩展验证，如果验证没有通过，将会显示详细错误。

----------

##### 数据库设置

| 项目 | 描述 |
| - | - |
| 服务器 | 请按照服务器提供商所提供的资料填写 |
| 服务器端口 | |
| 数据库名称 | |
| 用户名 | |
| 密码 | |
| 字符编码 | 一般为 utf8 |
| 数据表名前缀 | 默认为 cms_，推荐用默认值 |

----------

##### 创建数据

系统会自动为您创建数据表和初始数据

----------

##### 创建管理员

本操作将向 SSO 注册新用户，并自动将新注册的用户授权为超级管理员，拥有所有的管理权限。

----------

##### 完成安装

安装程序将进行最后的操作，成功后点击登录可以直接登录到后台。
