## FAQ 常见问题

----------

1. ### 经常出现令牌错误是什么原因？如何解决？

  令牌是本系统的一种安全机制，可能是暂时性网络故障造成的。如果遇到令牌错误的问题，可将警告窗口关闭，将已经输入的内容妥善保存后，刷新当前页面便可解决。

2. ### 我刚修改了栏目，但为何网站上显示的还是原来的内容？

  由于本系统对栏目的信息保存采用了缓存机制，在修改栏目的时候，一般会更新缓存，但也有可能更新缓存失败，只需要点击 “栏目管理 » 所有栏目” 上方的 “更新缓存” 便可。

3. ### 我刚修改了文章，但为何网站上显示的还是原来的内容？

  假如您的网站采用了纯静态模式，修改文章内容成功后，需要重新生成静态页面，只需要在“文章管理 » 所有文章”界面，找到您刚刚修改过的文章，点击生成菜单即可。

4. ### 创建或编辑文章时，上传图片无法插入到内容中是什么原因？如何指定图片插入的位置？

  创建或编辑文章时，内容编辑器还处于未激活状态，需要将其激活才能进行操作。激活方式非常简单，就是在编辑器的内容输入窗口里点一下，看到输入光标闪烁变说明已经激活成功。如果要指定图片插入的位置，可以将光标移到该处，图片就可以顺利插入。

5. ### 为何生成文章时，有时候会显示暂时无法生成？

  生成文章时，必须要满足文章本身已发布、定时上线的时间晚于当前时间、定时下线的时间早于当前时间、所隶属的栏目状态为显示等条件。

6. ### 安装过程中出现“数据库无法连接”和“数据库名错误”如何解决？

  安装过程中出现的“数据库无法连接”和“数据库名错误”错误又可能是系统提前生成了数据库配置文件，而配置文件的数据又不符合实际情况，解决方法是修改 `./app/config/dbconfig.inc.php` 文件，填入正确的数据库信息。

7. ### 安装过程中出现“安全码错误”如何解决？

  安装过程中出现的“安全码错误”可能是系统提前生成了安全码文件造成的，可以返回“安装方式”重新执行即可。

8. ### 如何开启“静态页面生成模块”？

  开启方法是修改 `./app/config/config.inc.php` 文件，找到 module 数组下的 gen 键，如未定义可以自行增加，这个键控制“静态页面生成模块”的开启与关闭，定义为 true 或者 'true' 即表示开启，定义为 false 或者 'false' 或者删除即表示关闭，如：

  ``` php
  'module' => array(
    ...
    'gen' => true,
    ...
  ),
  ```

9. ### 如何开启“FTP 分发模块”？

  开启方法是修改 `./app/config/config.inc.php` 文件，找到 module 数组下的 ftp 键，如未定义可以自行增加，这个键控制“FTP 分发模块”的开启与关闭，定义为 true 或者 'true' 即表示开启，定义为 false 或者 'false' 或者删除即表示关闭，如：

  ``` php
  'module' => array(
    ...
    'ftp' => true,
    ...
  ),
  ```

10. ### 如何开启“内容采集模块”？

  开启方法是修改 `./app/config/config.inc.php` 文件，找到 module 数组下的 gather 键，如未定义可以自行增加，这个键控制“内容采集模块”的开启与关闭，定义为 true 或者 'true' 即表示开启，定义为 false 或者 'false' 或者删除即表示关闭，如：

  ``` php
  'module' => array(
      ...
    'gather' => true,
      ...
  ),
  ```

11. ### 请讲述一下纯静态模式的机制。

  本系统的纯静态模式只选择生成最前的几页（此页数可以在 “系统设置 -> 访问设置 -> 静态页数” 进行自定义），超出部分将由伪静态页面负责显示。为何选择这种模式的解释如下：

  * 系统隶属于栏目、专题的文章较多时会设置分页，在纯静态模式下，系统需要逐页生成静态文件，随着时间的推移分页越来越多，如果系统按照总页数全部生成一遍会非常耗时。
  * 由于栏目的访问量会随着页码的增加而逐步减少，也就是说页码越靠前访问量越多，纯静态模式是为了应付日益增大的访问量而设置的，只需要减小访问量最大的一些页面就能有效的起到减负的作用。

12. ### 栏目内的 $cateRow['cate_url']['url_more'] 与 $cateRow['cate_url']['url'] 有什么区别？为何如此设定？

  `url_more` 是专门为纯静态模式设置的。

  系统采取的纯静态机制请查看上一个问题，由此机制产生了一个问题，就是当分页超过“静态页数”时，访问者如何访问到后面的页码？因此便有了 url_more 这个参数，开发者在分页超过“静态页数”时，可以将访问者引导到这个 URL。
