## 采集点管理

> 本功能需要用户具备一定的 Web、HTML 等技术基础，尤其是需要熟悉选择器，基于这些基础才能顺利完成设置。

完成内容采集需要经过如下的流程：`创建采集点 -> 数据采集 -> 采集审核`，采集完成后，如网站为纯静态模式，还需要运行生成程序才能最终在网站上发布。

本部分设置完成后方可采集数据。

----------

##### 创建（编辑）采集点

在此，您可以对采集点进行各项操作。

在编辑采集点时，界面下方将会解析出目标网站的 HTML 源代码，您可以根据需要进行操作。

在编辑采集点时，界面上方将会出现“列表设置”、“内容设置”、“分页列表设置”、“分页内容设置”等标签页，点这些标签页可以进行相应的设置。这些标签页的解释请点 [名词解释](#glossary)。

| 项目 | 描述 |
| - | - |
| 采集点 | 采集点的名称。 |
| URL | 准备采集的网站的 URL，注意：此处必须输入网址的 URL，而非域名，如：https://www.baigo.net/cate/baigoSSO/update/。 |
| 字符集 | 指准备采集的网站 HTML 代码所采用的字符编码，您需要自行查看目标网站的 HTML 代码确认字符集，也可以在右侧常用字符集中选择。 |
| 备注 | 采集点的备注。 |
| 隶属于栏目 | 选择某个栏目，采集到的数据将自动分类到此栏目。 |
| 状态 | 可选启用或禁用。 |

----------

### 列表设置

在编辑采集点节目，点列表解析标签，可以对列表解析作出修改。本系统采用 jQuery 选择器来解析 HTML 元素，关于选择器，你可以点上方的选择器帮助来查看常用的选择器。

列表选择器是指包含列表的 HTML 元素的选择器，务必以标签选择器 `a` 结尾，因为文章列表是一个索引，引导访问者点链接阅读文章，因此，所有的文章 URL 都是包含在 `a` 标签的链接 `href` 属性里，系统将自动读取 `href` 属性。

----------

### 分页列表设置

分页列表设置与列表设置相似。

----------

### 内容设置

在编辑采集点节目，点内容设置标签，可以对内容设置作出修改，以标题为例设置，“内容、时间、来源、作者”填写方法基本一样。

##### 标题

此处的设置可以解析出文章标题

* 选择器

    指包含标题的 HTML 元素的选择器

* 采集属性

  可选以下 3 类，也可以在右侧选择常用属性。

  | 值 | 描述 |
  | - | - |
  | html | 采集 HTML 代码 |
  | text | 采集纯文本 |
  | HTML 属性 | 采集 HTML 属性（如 src、href、name、data-src 等），如：&lt;a `href="http://www.domail.com"`&gt;链接&lt;/a&gt;，红色部分为属性（名称="值"） |

* 过滤器

  过滤器可以过滤掉不需要的元素，多个值请用 <kbd>,</kbd> 分隔。

  | 选项 | 描述 |
  | - | - |
  | 带 <kbd>-</kbd> 符号 | 移除该标签以及标签内容（此时可以为任意的 jQuery 选择器，如：`-p,-.title`）。
  | 无符号 | 当 `采集属性` 值为 html 时，表示要过滤掉的 HTML 标签，当 `采集属性` 值为 text 时，表示要保留的 HTML 标签（此时可以为 HTML 标签名，如：`div,strong`）。 |

* 替换

  替换可以将“查找”字符更换为“替换”字符（为空则删除“查找”字符），用法与 Word、WPS 的查找替换类似，点 <kbd>+</kbd> 按钮，可以创建多个替换。

##### 内容过滤

参数只针对文章内容，默认将剔除所有 HTML 属性。

* 保留标签

  系统将会剔除文章内容中除系统保留标签以外的所有标签，系统保留标签可以点右侧 <kbd>?</kbd> 按钮查询，请在此输入其他需要保留的标签，多个标签请用 <kbd>,</kbd> 分隔，如：`div,strong`。

* 图片源属性

  默认为 `src`，有些网站为了特殊需要，会将图片源属性改成自己的特有属性，为了能够顺利采集到图片，可以在此进行修改。

* 图片过滤

  系统在采集数据时，会自动将图片抓取到本地服务器，而有些图片，比如装饰、按钮、广告等是不需要的，管理员可以在此输入关键词，一旦图片的路径中包含有这些内容，将自动忽略这些图片。

* 保留属性

  这些属性将被全部保留，多个属性请用 <kbd>,</kbd> 分隔，如：`href,class`。

* 忽略标签

    这些标签的属性全部保留，多个标签请用 <kbd>,</kbd> 分隔，如：`div,strong`。

* 例外

  这些标签的特定属性将被保留，点 <kbd>+</kbd> 按钮，可以创建多个例外，同一标签下的多个属性请用 <kbd>,</kbd> 分隔。点右侧 <kbd>?</kbd> 按钮可以查询系统默认保留的属性。

----------

### 分页内容设置

分页内容设置与内容设置相似。

----------

<span id="glossary"></span>

### 名词解释

在编辑采集点时，界面上方将会出现“列表设置”、“内容设置”、“分页列表设置”、“分页内容设置”等标签页，这些标签页的解释如下：

* 列表设置

  用来解析目标网站 URL 中的文章列表，比如目标 URL 是一个栏目，此处的设置将会解析出此栏目的文章列表，将每一篇文章的 URL 解析出来，然后送到下一步进行处理。

* 内容设置

  上一步列表设置以后，将会得到某个文章的 URL，系统会根据此处的设置解析出文章标题、文章内容、发布时间、作者等信息，然后保存到数据库。

* 分页列表设置

  有些网站的文章可能比较长，一般会做出分页处理，第一步得到的文章 URL 往往是第一页，也就是文章的部分内容，如需要将文章的全部内容解析出来，就需要用到此处的设置，此处的设置可以将文章内容的第二页、第三页……的 URL 解析出来，然后送到下一步进行处理。

* 分页内容设置

  此设置就是为了配合上一步解析分页列表而设立，在得到第二页、第三页……的 URL 以后，可以根据此处的设置解析出文章剩下的内容，然后保存到数据库。
