<?php
/*-----------------------------------------------------------------
！！！！警告！！！！
以下为系统文件，请勿修改
-----------------------------------------------------------------*/

namespace app\ctrl\console;

use app\classes\console\Ctrl;
use ginkgo\Loader;
use ginkgo\Func;

//不能非法包含或直接执行
if (!defined('IN_GINKGO')) {
  return 'Access denied';
}

class Login extends Ctrl {

  protected function c_init($param = array()) {
    parent::c_init();

    $_str_hrefBase = $this->hrefBase . 'login/';

    $_arr_hrefRow = array(
      'login'  => $_str_hrefBase,
      'submit' => $_str_hrefBase . 'submit/',
      'cookie' => $this->url['route_console'] . 'cookie/clear/',
      'captcha'       => $this->url['route_misc'] . 'captcha/index/id/console_login/',
      'captcha-check' => $this->url['route_misc'] . 'captcha/check/id/console_login/',
    );

    $this->generalData['hrefRow']   = array_replace_recursive($this->generalData['hrefRow'], $_arr_hrefRow);
  }

  public function index() {
    $_mix_init = $this->init(false);

    if ($_mix_init !== true) {
      return $this->error($_mix_init['msg'], $_mix_init['rcode']);
    }

    $_str_urlJump = $this->url['route_console'] . 'login/sync/';

    //print_r($this->adminLogged);

    if ($this->adminLogged['rcode'] == 'y020102') {
      return $this->redirect($this->url['route_console']);
    }

    $_arr_tplData = array(
      'jump'  => $_str_urlJump,
      'token' => $this->obj_request->token(),
    );

    $_arr_tpl = array_replace_recursive($this->generalData, $_arr_tplData);

    $this->assign($_arr_tpl);

    return $this->fetch();
  }


  public function sync() {
    $_mix_init = $this->init();

    if ($_mix_init !== true) {
      return $this->error($_mix_init['msg'], $_mix_init['rcode']);
    }

    $_str_forward = $this->redirect()->restore();

    if (Func::isEmpty($_str_forward) || stristr($_str_forward, 'sync') || !stristr($_str_forward, 'console')) {
      $_str_forward = $this->url['route_console'];
    }

    $_obj_sync = Loader::classes('Sync', 'sso');

    $_arr_sync = array();

    if (isset($this->adminLogged['admin_prefer']['sync']['sync']) && $this->adminLogged['admin_prefer']['sync']['sync'] === 'on') {
      $_arr_syncSubmit = array(
        'user_id'           => $this->adminLogged['admin_id'],
        'user_access_token' => $this->adminLogged['admin_access_token'],
      );
      $_arr_sync = $_obj_sync->login($_arr_syncSubmit);

      if (isset($_arr_sync['urlRows']) && Func::notEmpty($_arr_sync['urlRows'])) {
        foreach ($_arr_sync['urlRows'] as $_key=>$_value) {
          if (stristr($_value, $this->url['url_root'])) {
            unset($_arr_sync['urlRows'][$_key]);
          }
        }
      }
    }

    $_arr_tplData = array(
      'sync'       => $_arr_sync,
      'forward'    => $_str_forward,
    );

    $_arr_tpl = array_replace_recursive($this->generalData, $_arr_tplData);

    $this->assign($_arr_tpl);

    return $this->fetch();
  }


  public function submit() {
    $_mix_init = $this->init(false);

    if ($_mix_init !== true) {
      return $this->fetchJson($_mix_init['msg'], $_mix_init['rcode']);
    }

    if (!$this->isAjaxPost) {
      return $this->fetchJson('Access denied', '', 405);
    }

    $_arr_inputSubmit = $this->mdl_login->inputSubmit();

    if ($_arr_inputSubmit['rcode'] != 'y020201') {
      return $this->fetchJson($_arr_inputSubmit['msg'], $_arr_inputSubmit['rcode']);
    }

    $_obj_login    = Loader::classes('Login', 'sso');

    $_arr_loginResult = $_obj_login->login($_arr_inputSubmit['admin_name'], $_arr_inputSubmit['admin_pass']);

    //print_r($_arr_loginResult);

    if ($_arr_loginResult['rcode'] != 'y010103') {
      return $this->fetchJson($_arr_loginResult['msg'], $_arr_loginResult['rcode']);
    }

    $_arr_adminRow = $this->mdl_login->read($_arr_loginResult['user_id']);

    //print_r($_arr_adminRow);

    if ($_arr_adminRow['rcode'] != 'y020102') {
      return $this->fetchJson($_arr_adminRow['msg'], $_arr_adminRow['rcode']);
    }

    if ($_arr_adminRow['admin_status'] != 'enable') {
      return $this->fetchJson('Administrator is disabled', 'x020402');
    }

    $_arr_adminRow['admin_access_token']    = $_arr_loginResult['user_access_token'];
    $_arr_adminRow['admin_access_expire']   = $_arr_loginResult['user_access_expire'];
    $_arr_adminRow['admin_refresh_token']   = $_arr_loginResult['user_refresh_token'];
    $_arr_adminRow['admin_refresh_expire']  = $_arr_loginResult['user_refresh_expire'];

    $_arr_loginResult = $this->sessionLogin($_arr_adminRow, $_arr_inputSubmit['admin_remember']);

    return $this->fetchJson($_arr_loginResult['msg'], $_arr_loginResult['rcode']);
  }


  public function logout() {
    $this->obj_auth->end(true);

    return $this->redirect($this->url['route_console']);
  }
}
