# Domain Generation Algorithms 
Domain Generation Algorithms (DGAs) of Malware reimplemented in Python.

## Overview

<details><summary>banjori (aka MultiBanker 2, BankPatch(er))</summary>

### Links
- [http://johannesbader.ch/2015/02/the-dga-of-banjori/](http://johannesbader.ch/2015/02/the-dga-of-banjori/)

### Example Domains
- earnestnessbiophysicalohax.com
- kwtoestnessbiophysicalohax.com
- rvcxestnessbiophysicalohax.com
- hjbtestnessbiophysicalohax.com
- txmoestnessbiophysicalohax.com
- agekestnessbiophysicalohax.com
- dbzwestnessbiophysicalohax.com
- sgjxestnessbiophysicalohax.com
- igjyestnessbiophysicalohax.com
- zxahestnessbiophysicalohax.com
</details>

<details><summary>bazarbackdoor (aka BazarLoader Team9Backdoor))</summary>

### Links
- [https://johannesbader.ch/blog/the-dga-of-bazarbackdoor/](https://johannesbader.ch/blog/the-dga-of-bazarbackdoor/)
- [https://johannesbader.ch/blog/the-buggy-dga-of-bazarbackdoor/](https://johannesbader.ch/blog/the-buggy-dga-of-bazarbackdoor/)
- [https://johannesbader.ch/blog/the-buggy-dga-of-bazarbackdoor/](https://johannesbader.ch/blog/yet-another-bazarloader-dga/)

### Example Domains
Real DGA:
- adegjkaiggjm.bazar
- eehhjmejjhjo.bazar
- dehiildjjiin.bazar
- ceeiklcjgikn.bazar
- dceikkdhgikm.bazar
- bfehjmbkghjo.bazar
- adegjmaiggjo.bazar
- dchiikdhjiim.bazar
- efehikekghim.bazar
- bdhhjkbijhjm.bazar

Buggy DGA:
-\_fdgimzkfgio.bazaar
-e\`bfkieedfkk.bazaar
-efdgikekfgim.bazaar
-\]begimzgggio.bazaar
-bbbfhlbgdfhn.bazaar
-\^ehikizjjikk.bazaar
-aechimajehio.bazaar
-\]defiizigfik.bazaar
-\`\`geiizeieik.bazaar
-degfjkdjifjm.bazaar



</details>


<details><summary>bumblebee</summary>

### Example Domains
- cmid1s1zeiu.life
- itszko2ot5u.life
- 3v1n35i5kwx.life
- newdnq1xnl9.life
- jkyj6awt1ao.life
- ddrjv6y42b8.life
- 1pnhp5o5za1.life
- y13iqvlfjl5.life
- xp0btfgegbo.life
</details>


<details><summary>chinad</summary>

### Links
- [https://github.com/360netlab/DGA/issues/1](https://github.com/360netlab/DGA/issues/1)

### Example Domains
- 8f6bacmw30xxv6sc.cn
- 486txu3yjly0xcmz.ru
- xmi6x8zg9rkanmyo.info
- spy1jhdbmvt2ueva.net
- evybt5gtf2tprvbi.info
- 7qbys97e3pcw262c.info
- kz89iy97c7n7vbur.biz
- zmkvvlsvkbffnuez.ru
- tr1yy6lxtry1gsts.biz
- mfq6uwq3p2hvc8zn.cn
</details>


<details><summary>corebot</summary>

### Links
- [https://johannesbader.ch/2015/09/the-dga-of-corebot/](https://johannesbader.ch/2015/09/the-dga-of-corebot/)

### Example Domains
- lkhylm0mhyfuhg.ddns.net
- s63234wluv5v365bwp5.ddns.net
- afe6mfy23xcxgfa.ddns.net
- 7rsl1f34sfq0oj3jwvmfa6c.ddns.net
- ir7l3po0gjy8ypqjm8o.ddns.net
- 3lgrupwdivsfm2w4kng2iha.ddns.net
- i8a0q2wdu8otulkfylo2gdq.ddns.net
- kh1her76avy0qnelivijwd1.ddns.net
- ubgp1f1han7lu410eh5.ddns.net
- uliry8knadmpmdm4wti6oro.ddns.net
</details>

<details><summary>darkcracks</summary>

### Links
- [https://blog.xlab.qianxin.com/uncovering_darkcracks_payload_delivery_framework_cn/#part2-runner%E5%88%86%E6%9E%90](https://blog.xlab.qianxin.com/uncovering_darkcracks_payload_delivery_framework_cn/#part2-runner%E5%88%86%E6%9E%90)

### Example Domains
- sTDFUgOAgjL.com
- EVDFUgOAgjL.com
- AVDFUgOAgjL.com
- MVDFUgOAgjL.com
- IVDFUgOAgjL.com
- UVDFUgOAgjL.com
- QVDFUgOAgjL.com
- YTCFUgOAgjL.com
- kTCFUgOAgjL.com
- gTCFUgOAgjL.com
</details>


<details><summary>dircrypt</summary>

### Links
- [http://johannesbader.ch/2015/03/the-dga-of-dircrypt/](http://johannesbader.ch/2015/03/the-dga-of-dircrypt/)

### Example Domains
- rauggyguyp.com
- llullzza.com
- mluztamhnngwgh.com
- mycojenxktsmozzthdv.com
- inbxvqkegoyapgv.com
- furiararji.com
- zrkdvzjhse.com
- wyuhdsdttczd.com
- hpaxgpkteomjaxywwelr.com
- mydojltbqjnwailyyoa.com
</details>


<details><summary>dnschanger (aka Alureon)</summary>

### Links
- [https://johannesbader.ch/2016/01/the-dga-in-alureon-dnschanger/](https://johannesbader.ch/2016/01/the-dga-in-alureon-dnschanger/)

### Example Domains
- aktklyvbiu.com
- zgimjzlnrl.com
- tcfejerekw.com
- tfaunnjmxt.com
- ydvlfpkguw.com
</details>


<details><summary>fobber (aka Tinba v3)</summary>

### Example Domains
- vhkintjtksyxgjrzz.net
- btpnxlsfdqbhzazyx.net
- ukfmknjdenthvktgc.net
- qupxsrhrmuoinqrit.net
- gjsbydmrpfzsmnfiu.net
- indpstqbetcpcqprx.net
- gwrdmhyjfcpcutmhp.net
- bwnzcyypcbmnlpfsw.net
- twkpwfuecvvzcincq.net
- pdwfuxgnahmgsxhit.net
</details>

<details><summary>fosniw</summary>

### Example Domains
- app2.winsoft0.com
- app2.winsoft1.com
- app2.winsoft2.com
- app2.winsoft3.com
- app2.winsoft4.com
- app2.winsoft5.com
- app2.winsoft6.com
- app2.winsoft7.com
- app2.winsoft8.com
- app2.winsoft9.com
</details>


<details><summary>gozi (aka Ursnif, Snifula, Papras)</summary>

### Links
- [http://www.govcert.admin.ch/blog/18/gozi-isfb-when-a-bug-really-is-a-feature](http://www.govcert.admin.ch/blog/18/gozi-isfb-when-a-bug-really-is-a-feature)

### Example Domains
- quodpresidentemaxsagit.com
- pertantumfitusu.com
- indulgentiarumlicet.com
- moriblasphemianegocii.com
- ptribueretnossetnonin.com
- nonsicordinario.com
- svivacpecunias.com
- inestimabiler.com
- ulpurgatoriopetrum.com
- papacricognitisipro.com
</details>


<details><summary>kraken/v1 (aka Bobax, Oderoor)</summary>

### Links
- [https://johannesbader.ch/2015/12/krakens-two-domain-generation-algorithms/](https://johannesbader.ch/2015/12/krakens-two-domain-generation-algorithms/)

### Example Domains
- ibbwnhgh.mooo.com
- rbqdxflojkj.mooo.com
- smhburg.dyndns.org
- bltjhzqp.dyndns.org
- clwafrfuuxq.yi.org
- cffxugijxn.yi.org
- ivxcxbj.dynserv.com
- etllejr.dynserv.com
- otpxmk.mooo.com
- ejfjyd.mooo.com
</details>


<details><summary>kraken/v2 (aka Bobax, Oderoor)</summary>

### Links
- [https://johannesbader.ch/2015/12/krakens-two-domain-generation-algorithms/](https://johannesbader.ch/2015/12/krakens-two-domain-generation-algorithms/)

### Example Domains
- xpdbwuimwag.com
- nwpegpjtx.com
- smmyuhxlt.net
- xjvyvnzivvt.net
- lvctmusxcyz.tv
- lvctmusxcyz.tv
- cjuszcfwo.cc
- egbmbdey.cc
- wjxaprgne.com
- vxbuggxhrgi.com
</details>


<details><summary>locky</summary>

### Links
- [https://blogs.forcepoint.com/security-labs/lockys-new-dga-seeding-new-domains](https://blogs.forcepoint.com/security-labs/lockys-new-dga-seeding-new-domains)

### Example Domains
- gegjiimqmlgtdmk.tf
- pccibcjncnhjn.yt
- rddipikmrap.us
- mmhmkqfc.be
- vkcims.pm
- qtysmobytagnrv.it
- suhpqiumpjsv.ru
- cscffbwbhs.uk
</details>


<details><summary>m0yv</summary>

### Links

- [https://malpedia.caad.fkie.fraunhofer.de/details/win.m0yv](https://malpedia.caad.fkie.fraunhofer.de/details/win.m0yv)
- [YouTube video "Sinkholing the Domain Generation Algorithm of m0yv"](https://youtu.be/3RYbkORtFnk)

Time independent version in `dga.py`, time-dependent version in `dga-td.py`.

### Example Domains

- pywolwnvd.biz
- ssbzmoy.biz
- cvgrf.biz
- npukfztj.biz
- przvgke.biz
- zlenh.biz
- knjghuig.biz
- uhxqin.biz
- anpmnmxo.biz
- lpuegx.biz

</details>


<details><summary>monerodownloader</summary>

### Example Domains
- 31b4bd31fg1x2.org
- 31b4bd31fg1x2.tickets
- 31b4bd31fg1x2.blackfriday
- 31b4bd31fg1x2.hosting
- 31b4bd31fg1x2.feedback
- 3f8c8079fd4c5.org
- 3f8c8079fd4c5.tickets
- 3f8c8079fd4c5.blackfriday
- 3f8c8079fd4c5.hosting
- 3f8c8079fd4c5.feedback
</details> 

<details><summary>murofet/v1 (aka LICAT)</summary>

### Links
- [https://johannesbader.ch/2015/09/three-variants-of-murofets-dga/](https://johannesbader.ch/2015/09/three-variants-of-murofets-dga/)

### Example Domains
- giywswshrgxcvoqgvrkthmfa.ru
- xaiqpbprgymbvrwmzgiyprgdsk.com
- amgqgularpzxeapztxenbx.net
- pfscijbmthyfiyjgergugtkbqyh.org
- xglfcmsgorvwfilhmzlcxxvkfege.info
- rcteqwkequojntibvfyfaluwh.biz
- mjfqylbiaunffuaeunzdqdwscu.ru
- qobeylpxgpfknlptukyddqvklztg.com
- rgwgizukficdgetwsxovtcknwkfm.info
- betgyaeswxorwcvsdezdupbmb.org
</details>


<details><summary>murofet/v2 (aka LICAT)</summary>

### Links
- [https://johannesbader.ch/2015/09/three-variants-of-murofets-dga/](https://johannesbader.ch/2015/09/three-variants-of-murofets-dga/)

### Example Domains
- cmqvvxtppnibli.biz
- cmqvvxtppnibli.com
- rloqpoiongsuwyq.net
- rloqpoiongsuwyq.org
- zsophzovtfor.info
- zsophzovtfor.biz
- nlifthjnbgnfweq.org
- nlifthjnbgnfweq.com
- hykpttqsxsmvkoc.info
- hykpttqsxsmvkoc.org
</details>


<details><summary>murofet/v3 (aka LICAT)</summary>

### Links
- [https://johannesbader.ch/2015/09/three-variants-of-murofets-dga/](https://johannesbader.ch/2015/09/three-variants-of-murofets-dga/)

### Example Domains
- nxlya47huo61czerb18o51e11d30i55gycwe31lx.ru
- jwdzptm69p62izcve41f22k37oyj16g63fqote11.com
- p42p52nvd50izkqazaqe21lvo21pycqotp22e61.net
- b28n40i25b68gte41o61dwc19htc29jwgxiqfzbr.org
- ktirhsn50kzc49b58cyf32fwh14h64dzgxiqcz.info
- bre41hvc29kri15ewpwdsazjyn40p52kwe21gw.biz
- n30mwhsoxfqe51j56lunsg13o11hyd60ewf52nu.ru
- hvcsjxd20mzm29d40nznunta27c29kyi55fun50.com
- nzosg13oymzg63ntpxaro51btkvfyoshrk27.info
- czfsn20exg53nzcqcrg43exf62b28p22pyd50lu.org
</details>


<details><summary>mydoom (aka Novarg, Mimail.R, Shimgapi)</summary>

### Example Domains
- qehspqnmrn.info
- mmahaesqar.in
- pwprhhnqqn.in
- mrspmramrn.in
- arphansaqh.com
- hrhspsrenn.net
- aepaaemrmn.com
- wsaehwmnms.in
- arwrseqssh.com
- ewamspqwha.ws
</details>


<details><summary>necurs</summary>

### Links
- [http://johannesbader.ch/2015/02/the-dgas-of-necurs/](http://johannesbader.ch/2015/02/the-dgas-of-necurs/)

### Example Domains
- nccojqvabqvkiwhj.mx
- hoedwwwywnmmbi.ac
- aeaeneaoinf.mu
- ccecggc.us
- mfffpmgtplxbyagbtegh.com
- thlxuwnadtdtsm.biz
- edkomqpeufjyafccj.in
- mxomklaqau.pw
- nvutiptwteltin.tv
- nhysbiomr.ir
</details>


<details><summary>newgoz (aka Gameover Zeus, Peer-to-Peer Zeus)</summary>

### Links
- [https://johannesbader.ch/2014/12/the-dga-of-newgoz/](https://johannesbader.ch/2014/12/the-dga-of-newgoz/)

### Example Domains
- xzz3ug32bale1uo60y7xj6rge.com
- 1hyzmw3l2phycet88hzr2do34.net
- 2ppq821cfem5m1mdua46pxg7bj.biz
- unlm9w9l8upy1kdde0kba7ktf.org
- 1ixhw3p1ncr3cf1pjfrpz14n1u0e.com
- 1o460ktpdhna1k0lk3ecwujxn.net
- 183t0wjzlthe51wigptk4rl29.org
- 1i3ux5a1hj6ndqejmxone45g0v.net
- 5mcdp71mbutpb1tglu0s4p0lrf.com
- n3i5yn19w82vmmpxv1k1l4xrjg.org
</details>


<details><summary>ngioweb</summary>

### Links
- [Netlab - An Analysis of Linux.Ngioweb Botnet](https://blog.netlab.360.com/an-analysis-of-linux-ngioweb-botnet-en/)
- [Netlab - Quick update on the Linux.Ngioweb botnet, now it is going after IoT devices](https://blog.netlab.360.com/linux-ngioweb-v2-going-after-iot-devices-en/)

### Example Domains
minihileth-subatudofy.org
revodihudom.info
enisobure-antidimadom-minikevuship.org
semiridinution-postepudency.com
prolefexity-disorisance.org
nonebazish-disahibelen-misehurarage.name
ilolupage-nonurisudize-minikazolike.net
semicofaxiful-enixakor-subafapehen.info
overedaxive-nonameraness.net
prevomozary-microfemaly.info
</details>


<details><summary>nymaim</summary>

### Example Domains
- oftbpec.com
- lotmpwyk.info
- seikpwq.info
- bcfatyltdvp.info
- rfwstgy.com
- hokybhnf.biz
- evlovrxuw.net
- mtzpbzbfvy.info
- hacckgiakhl.com
- mosmeuw.net
</details>


<details><summary>nymaim2</summary>

### Links
- [https://johannesbader.ch/2018/04/the-new-domain-generation-algorithm-of-nymaim/](https://johannesbader.ch/2018/04/the-new-domain-generation-algorithm-of-nymaim/)

### Example Domains
- surfaces-drawing.com
- shaft-criterion.cc
- stops-hash.id
- unitsknowledge.com
- wiredgraph.tm
- timelydesignation.co
- stablelikely.ch
- stainless-loan.lk
- wagon-documents.sc
- trainerprocessors.tk
</details>


<details><summary>padcrypt</summary>

### Links
- [http://johannesbader.ch/2016/03/the-dga-of-padcrypt/](http://johannesbader.ch/2016/03/the-dga-of-padcrypt/)

### Example Domains
- elkfcfnacacmofdf.com
- mkmeeefncfnfdmbm.de
- ffcdcnbmmnaeddcd.com
- ddkfodnaadmbmofo.co.uk
- efneboaodnmbecoa.co
- bafomkfalcfcdkom.info
- onlmcddadnacfclc.com
- dcfmddfbobkmafma.com
- lmmfdccmnnfnmfdl.co
- kcknconmceeemlnm.com
</details>


<details><summary>pitou</summary>

### Links
- [https://johannesbader.ch/2019/07/the-dga-of-pitou/](https://johannesbader.ch/2019/07/the-dga-of-pitou/)

### Example Domains
- --------------+
- koohoavab.net |
- koohoavac.net |
- koohoavad.net |
- koohoavaf.net |
- koohoavag.net |
- koohoavah.net |
- koohoavaj.net |
- koohoavak.net |
- koohoaval.net |
</details>


<details><summary>pizd</summary>

### Links
- [https://blog.avast.com/2013/06/18/your-facebook-connection-is-now-secured/](https://blog.avast.com/2013/06/18/your-facebook-connection-is-now-secured/)

### Example Domains
- difficultnearly.net
- dollarnearly.net
- difficultpossible.net
- dollarpossible.net
- eearlynation.net
- escapenation.net
- eearlypleasure.net
- escapepleasure.net
- eearlynearly.net
- escapenearly.net
</details>


<details><summary>proslikefan</summary>

### Links
- [https://johannesbader.ch/2016/06/proslikefan/](https://johannesbader.ch/2016/06/proslikefan/)

### Example Domains
- flarvcpk.eu
- stjneohiod.biz
- vcevvkc.se
- qylptiin.info
- bsvisbttr.com
- hjiknr.net
- arpeiezki.org
- gobqca.ru
- tivqfahrmxdl.in
- smutloo.name
</details>

<details><summary>pushdo</summary>

### Example Domains
- weafokuggeir.kz
- sictemuborug.kz
- cirpicficj.kz
- geijanmap.kz
- fuxhuxsabi.kz
- siclisozdokq.kz
- sozcoqnafrex.kz
- qeobifups.kz
- cokoqdeah.kz
- latqafbuxwic.kz
</details>


<details><summary>pykspa/improved</summary>

### Links
- [http://johannesbader.ch/2015/03/the-dga-of-pykspa/](http://johannesbader.ch/2015/03/the-dga-of-pykspa/)

### Example Domains
- uammskmq.org
- jqplflktas.info
- rybwtr.net
- uyznvxlof.info
- gakcmqiw.com
- wewsvat.net
- owhadwkskevw.net
- nkndlzhjgrpc.info
- isypszqe.net
- joebbaamoyt.info
</details>


<details><summary>pykspa/precursor</summary>

### Links
- [http://johannesbader.ch/2015/07/pykspas-inferior-dga-version/](http://johannesbader.ch/2015/07/pykspas-inferior-dga-version/)

### Example Domains
- llfwhgn.com
- guqqkaiq.biz
- wctymo.net
- lovfjsfox.com
- oruhbanansnan.cc
- mkncjk.biz
- yunonsuiwcymao.net
- yxpojufqbex.com
- qhxgzufqbex.cc
- yywiywiq.biz
</details>


<details><summary>qadars</summary>

### Links
- [https://www.johannesbader.ch/2016/04/the-dga-of-qadars/](https://www.johannesbader.ch/2016/04/the-dga-of-qadars/)

### Example Domains
- jk9enwhansl2.org
- sdqfodmf81m7.net
- 5uro1uzspejk.net
- ub4hinsduf0p.net
- zs9ijo1er81u.com
- 0t67c5arw9yf.net
- lev41encha38.net
- 67k1q3c1mr8x.org
- 7w1yf49irk5m.net
- gdunwhq7s9qb.org
</details>


<details><summary>qakbot</summary>

### Links
- [https://johannesbader.ch/2016/02/the-dga-of-qakbot/](https://johannesbader.ch/2016/02/the-dga-of-qakbot/)

### Example Domains
- bqkrtxgkmriwsiwcngtivpx.info
- jdtmfupdyueqeldvhsjzdvzob.net
- guhmpoxzivhba.com
- nqqxqhuacaqhzurde.org
- lgqsqgpqzijwid.info
- ykolyecdcyk.biz
- ztvflnxqzpxvpfobv.biz
- zqrmkpivrbxccawozqwqpfzh.org
- iqyqwhntrxfeq.org
- ftadkbomxlnsib.info
</details>

<details><summary>qsnatch</summary>

### Links
- [https://www.kyberturvallisuuskeskus.fi/en/news/qsnatch-malware-designed-qnap-nas-devices](https://www.kyberturvallisuuskeskus.fi/en/news/qsnatch-malware-designed-qnap-nas-devices)

- [https://johannesbader.ch/blog/the-dga-of-qsnatch/](https://johannesbader.ch/blog/the-dga-of-qsnatch/)

### Example Domains
- t2q2r.cf
- gc9nz.tk
- 07tvvc.com
- 7ubqo.ml
- 53bcm.de
- 6zltf.rocks
- hv7uv.mx
- nypno.biz
- qkzccy.net
- rassb.cn
</details>


<details><summary>ramnit</summary>

### Links
- [https://johannesbader.ch/2014/12/the-dga-of-ramnit/](https://johannesbader.ch/2014/12/the-dga-of-ramnit/)

### Example Domains
- knpqxlxcwtlvgrdyhd.com
- nvlyffua.com
- hgyudheedieibxy.com
- anrylixwcbnjopdd.com
- vrndmdrdrjoff.com
- jhghrlufoh.com
- tqjhvylf.com
- hufqifjq.com
- itktxexjghvvxa.com
- ppyblaohb.com
</details>


<details><summary>ranbyus/may</summary>

### Links
- [http://johannesbader.ch/2015/05/the-dga-of-ranbyus/](http://johannesbader.ch/2015/05/the-dga-of-ranbyus/)

### Example Domains
- ikwoqkwuajpbyx.com
- niukpdrluwlfox.pw
- rcnxisuibbadng.in
- wbqtidjvsdiwee.me
- jrdyumcieyipnv.cc
- yvyfwikedfxitk.su
- tviurcntxylxnj.tw
- lycyrvfcemepfm.net
- epddeukdimbpft.com
- trbhxhmbsikoaq.pw
</details>


<details><summary>ranbyus/september</summary>

### Links
- [http://johannesbader.ch/2015/09/ranbyuss-dga-revisited/](http://johannesbader.ch/2015/09/ranbyuss-dga-revisited/)

### Example Domains
- jxbdxeyxttdmcjagi.me
- iqmadgybfhnrssadm.cc
- gdoldaognceaedkke.su
- jnbnyrmxmpblfgstk.tw
- ucjetnyaitygjidva.net
- jejocqwtcbtuymvao.com
- stuctjsqfxghcesyw.pw
- gfidctymbxiaqyuyk.in
- ojrqwrlhesfshawva.me
- bqjqvwwjirftwkjel.cc
</details>


<details><summary>reconyc</summary>

**This DGA has unpredictable seeding**, i.e., it uses ``GetTickCount`` as the seed. I still list the DGA as it might be useful for testing or training DGA detection algorithms.

### Example Domains
- E5zHail0Mw.com
- gabbvK2o6s.com
- CumpP2A4d7.com
- 5eswmwNQyF.com
- lExfSzyuwP.com
- JZpESGsPFF.com
- UmIaRnijeT.com
- sHr0xE9Idm.com
- nYcEX7wlCF.com
- VCiZNQXwpO.com
</details>

<details><summary>sharkbot</summary>

### Example Domains
- 64f30398ecda3bbf.xyz
- f008fc473fddedc4.live
- cfbadaf0cd7b0ac3.com
- b8d28386413029fe.store
- 99c485497c079a09.info
- 6d54b683fc2cc58f.top
- abb7547058fef9fb.net
</details>


<details><summary>shiotob (aka Urlzone, Bebloh)</summary>

### Links
- [https://johannesbader.ch/2015/01/the-dga-of-shiotob/](https://johannesbader.ch/2015/01/the-dga-of-shiotob/)

### Example Domains
- wtipubctwiekhir.net
- rwmu35avqo12tqc.com
- rskb5bsfhm2fk5h.net
- rbp9pprrxgflut9.com
- zzxeyzgy45yy2a.net
- e3oa4wglvd21xa.com
- mqmq1hvmtxzjv.net
- pd4o4wu24vimn.com
- tlmrzvpbpsqsb.net
- pbmnz59uzndpo.com
</details>


<details><summary>simda (aka Shiz)</summary>

### Links
- [http://johannesbader.ch/2015/03/the-dga-of-simda-shiz/](http://johannesbader.ch/2015/03/the-dga-of-simda-shiz/)

### Example Domains
- gatyfus.com
- lyvyxor.com
- vojyqem.com
- qetyfuv.com
- puvyxil.com
- gahyqah.com
- lyryfyd.com
- vocyzit.com
- qegyqaq.com
- purydyv.com
</details>


<details><summary>sisron (aka TOMB, Win32/Agent.WRQ, Trojan.Scar)</summary>

### Links
- [https://www.johannesbader.ch/2016/06/the-dga-of-sisron/](https://www.johannesbader.ch/2016/06/the-dga-of-sisron/)

### Example Domains
- mdiwnjiwmtya.com
- mdewnjiwmtya.com
- mzewntiwmtya.com
- mzawntiwmtya.com
- mjkwntiwmtya.com
- mjgwntiwmtya.com
- mjcwntiwmtya.com
- mjywntiwmtya.com
- mjuwntiwmtya.com
- mjqwntiwmtya.com
</details>


<details><summary>suppobox</summary>

### Links
- [http://www.rsaconference.com/writable/presentations/file_upload/br-r01-end-to-end-analysis-of-a-domain-generating-algorithm-malware-family.pdf](http://www.rsaconference.com/writable/presentations/file_upload/br-r01-end-to-end-analysis-of-a-domain-generating-algorithm-malware-family.pdf)

### Example Domains
- journey
- destroy
- against
- night
- within
- effort
- street
- better
- husband
- little
</details>


<details><summary>symmi</summary>

### Links
- [http://johannesbader.ch/2015/01/the-dga-of-symmi/](http://johannesbader.ch/2015/01/the-dga-of-symmi/)

### Example Domains
- ogovugtuipawi.ddns.net
- afowkaupbabe.ddns.net
- ipkureleakm.ddns.net
- hegiruqo.ddns.net
- luimreim.ddns.net
- tiakqukoahuvu.ddns.net
- loelkuanduur.ddns.net
- agdehukoev.ddns.net
- giagkuekorla.ddns.net
- leufiroqipomu.ddns.net
</details>


<details><summary>tempedreve</summary>

### Links
- [https://github.com/baderj/domain_generation_algorithms/tree/master/tempedreve/images](https://github.com/baderj/domain_generation_algorithms/tree/master/tempedreve/images)

### Example Domains
- dlbebsga.net
- enqbgrmt.com
- xjlwpfnk.info
- ebabkjcx.org
- hvisietg.net
- svyjglen.com
- glknxfgq.info
- adoduloh.org
- jgrxrxwh.net
- ctmrgbmz.com
</details>


<details><summary>tinba (aka TinyBanker, Zusy)</summary>

### Links
- [http://johannesbader.ch/2015/04/new-top-level-domains-for-tinbas-dga/](http://johannesbader.ch/2015/04/new-top-level-domains-for-tinbas-dga/)

### Example Domains
- blackfreeqazyio.cc
- nvfowikhevmy.com
- nvfowikhevmy.net
- nvfowikhevmy.in
- nvfowikhevmy.ru
- sjhuqlwrqhqx.com
- sjhuqlwrqhqx.net
- sjhuqlwrqhqx.in
- sjhuqlwrqhqx.ru
- pxqgonyogeee.com
</details>

<details><summary>tufik</summary>

### Example Domains
- dbqwpmpnruesywj.com
- qxxmubfleztlnkx.com
- rrnywowqgmjvnltg.com
- rqnjdvzpsmbuw.com
- utoiopxjrphvoiy.org
- ttoouemmimnxnmj.com
- nmjsoourllgveecj.org
- juprvzxqotonvvs.biz
- nmjsoourllgveecj.biz
- dotqwjmhqlushjlo.biz
</details>


<details><summary>dmsniff</summary>

### Example Domains
- albdfhln.com
- alcgkown.com
- aldjpvqt.com
- alemuown.com
- alfpmrnq.org
- algspvqt.org
- alhvrytw.org
- aliyuown.org
- aljnwpyo.org
- alkpmrnq.net
</details>


<details><summary>unnamed_downloader</summary>

### Example Domains
- ddknt.github.io
- ddktn.github.io
- ddnkt.github.io
- ddntk.github.io
- ddtkn.github.io
- ddtnk.github.io
- dkdnt.github.io
- dkdtn.github.io
- dkndt.github.io
- dkntd.github.io
</details>


<details><summary>unnamed_javascript_dga</summary>

### Links
- [https://johannesbader.ch/2015/11/a-javascript-based-dga/](https://johannesbader.ch/2015/11/a-javascript-based-dga/)

### Example Domains
- rxxeqcoy.cc
- kmymbyzd.co
- cfukbzbmg.eu
- sblwtafc.cc
- lqdoacat.co
- dplmjcjic.eu
- ttukaiwjdx.cc
- meimklqh.co
- enmxqcxhtl.eu
- unmias.cc
</details>


<details><summary>vawtrak</summary>

### Links
- [http://www.threatgeek.com/2016/11/vawtrak-dga-round-2.html](http://www.threatgeek.com/2016/11/vawtrak-dga-round-2.html)

### Example Domains
- usahwutle.com
- folocnam.com
- awumsah.com
- edorwufli.com
- misocgutlah.com
- edarwotda.com
- melarwetdic.com
- usucnitdohg.com
- regomseh.com
- osicnumd.com
</details>


<details><summary>xmrig_genesis (a XMRig malware using the bitcoin genesis block as seed))</summary>

### Example Domains
- 1d78e50d.com
- 1d78e50d.net
- 1d78e50d.org
- 1d78e50d.duckdns.org
- 2b04216f.com
- 2b04216f.net
- 2b04216f.org
- 2b04216f.duckdns.org
- 2e1d985c.com
- 2e1d985c.net
</details>

<details><summary>zloader</summary>

### Links
- [https://johannesbader.ch/blog/the-dga-of-zloader/](https://johannesbader.ch/blog/the-dga-of-zloader/)


### Example Domains
- gdurfdsywubjaaqcqhrh.com
- vudktykcecigekhtwwqn.com
- jcaofaekffeojktmpdax.com
- iiphrhkculpnubvvxnbh.com
- bjdbpgbjdyredhfyvpie.com
- wramitvqeojecedajxoj.com
- ohyjybhogoeoabjqvpie.com
- fscqtelyeogmxudotlao.com
- nsdtxvnwtxjwphbuqffe.com
- bohchavtvhbejwcmekvo.com
</details>
