# Machine Learning Research & Engineering - Flashcards

![image](https://user-images.githubusercontent.com/20059131/180619266-6319972e-03c3-42f7-8d88-bdd240cb13bc.png)

These are 200+ flashcards I made to review everything from my years of ML research, classes, and independent study. Creating them helped me prepare for machine learning engineer interviews and was able to get offers from several companies in 2022 (including Google, Tesla, Samsung, Motional, UiPath, and TikTok). Hopefully other people can benefit from them as well!

The PDFs in this repo are mostly for convenience. __Check out these presentation slide links for the most up to date and animated Q&A versions__, with additional links in the speaker notes:

* [1 Computer Science Slides](https://docs.google.com/presentation/d/1uGIda3-VgQqzA3KQUDieiuPPF2-dJsH9-c1sRv0gfRs/edit?usp=sharing)
* [2 Machine Learning General Slides](https://docs.google.com/presentation/d/1qSOwBrjEmZTXQqNqB9XRAV7QsB6SJrLZ4pZBCkpvzyA/edit?usp=sharing)
* [3 Fundamentals for Computer Vision & Deep Learning Slides](https://docs.google.com/presentation/d/1Ru9UPxlXnx7FZ3bxcQ-SH9TB6nHtOflYYA1N_UMzv2g/edit?usp=sharing)
* [4 Selected Topics in Computer Vision & Deep Learning Slides](https://docs.google.com/presentation/d/1tWWiKR-GI3uO0QKU-CBfLdGOvSyv-pD8g_kjuZvm4Mc/edit?usp=sharing)

Questions are loosely based off [Chip Huyen's ML Interviews Book questions](https://huyenchip.com/ml-interviews-book/contents/part-ii.-questions.html). However, some slides might be overly technical or academic, and not relevant to engineers. The most important slides (in my opinion) are marked with a star in the lower left corner.

__<ins>Disclaimer: These slides do not contain any specific interview questions from any companies. I actually completed them before I interviewed anywhere, as an academic exercise for myself. The flashcards cover various fundamental topics and would likely serve as a good foundation for broad knowledge in the fields of CS and ML.</ins>__

# Intended Scope and Audience

This covers computer science, classical machine learning, and modern deep learning with an emphasis on computer vision. It generally assumes a good foundation in these topics, and a lot of technical terminology is used. I think the approach might be different depending on your current experience:

* Already have a __good foundation in ML__: you can probably use them __as-is to review__ and fill in any missing knowledge gaps

* __Newer to ML__, this may provide a good overview of what is out there, and I'd suggest also __refering to other materials focused on education__ & learning (see "additional links" below)

# Contributing

Because of gaps in my understanding, and because the field is constantly changing, this is not meant to be a definitive resource. There may be errors in these slides, or things that I've missed. If so, feel free to make a post as an issue in github.

__*Please mark the slide in question so others can easily find it, e.g. if you want to discuss Machine Learning General slide 14, add [2.14] to the title.*__

# Additional Links & Resources

* The most useful resource I've found to learn about the MLE interview process holistically
  * https://huyenchip.com/ml-interviews-book/
* Useful course materials for ML from stanford and UC Berkeley
  * http://cs231n.stanford.edu/
  * https://fullstackdeeplearning.com/spring2021/
* Resources for the programming portion
  * https://www.crackingthecodinginterview.com/
  * https://leetcode.com/
