/*
 * Kubernetes
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: v1.21.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.kubernetes.autoscaling.models;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * ContainerResourcePolicy controls how autoscaler computes the recommended resources for a specific container.
 */
@ApiModel(description = "ContainerResourcePolicy controls how autoscaler computes the recommended resources for a specific container.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-02T17:31:04.907Z[Etc/UTC]")
public class V1VerticalPodAutoscalerSpecResourcePolicyContainerPolicies {
  public static final String SERIALIZED_NAME_CONTAINER_NAME = "containerName";
  @SerializedName(SERIALIZED_NAME_CONTAINER_NAME)
  private String containerName;

  public static final String SERIALIZED_NAME_CONTROLLED_RESOURCES = "controlledResources";
  @SerializedName(SERIALIZED_NAME_CONTROLLED_RESOURCES)
  private List<String> controlledResources = null;

  /**
   * Specifies which resource values should be controlled. The default is \&quot;RequestsAndLimits\&quot;.
   */
  @JsonAdapter(ControlledValuesEnum.Adapter.class)
  public enum ControlledValuesEnum {
    REQUESTSANDLIMITS("RequestsAndLimits"),

    REQUESTSONLY("RequestsOnly");

    private final String value;

    ControlledValuesEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ControlledValuesEnum fromValue(String value) {
      for (ControlledValuesEnum b : ControlledValuesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<ControlledValuesEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ControlledValuesEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ControlledValuesEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return ControlledValuesEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_CONTROLLED_VALUES = "controlledValues";
  @SerializedName(SERIALIZED_NAME_CONTROLLED_VALUES)
  private ControlledValuesEnum controlledValues;

  public static final String SERIALIZED_NAME_MAX_ALLOWED = "maxAllowed";
  @SerializedName(SERIALIZED_NAME_MAX_ALLOWED)
  private Map<String, Object> maxAllowed = null;

  public static final String SERIALIZED_NAME_MIN_ALLOWED = "minAllowed";
  @SerializedName(SERIALIZED_NAME_MIN_ALLOWED)
  private Map<String, Object> minAllowed = null;

  /**
   * Whether autoscaler is enabled for the container. The default is \&quot;Auto\&quot;.
   */
  @JsonAdapter(ModeEnum.Adapter.class)
  public enum ModeEnum {
    AUTO("Auto"),

    OFF("Off");

    private final String value;

    ModeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ModeEnum fromValue(String value) {
      for (ModeEnum b : ModeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<ModeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ModeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ModeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return ModeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_MODE = "mode";
  @SerializedName(SERIALIZED_NAME_MODE)
  private ModeEnum mode;


  public V1VerticalPodAutoscalerSpecResourcePolicyContainerPolicies containerName(String containerName) {

    this.containerName = containerName;
    return this;
  }

   /**
   * Name of the container or DefaultContainerResourcePolicy, in which case the policy is used by the containers that don&#39;t have their own policy specified.
   * @return containerName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Name of the container or DefaultContainerResourcePolicy, in which case the policy is used by the containers that don't have their own policy specified.")

  public String getContainerName() {
    return containerName;
  }


  public void setContainerName(String containerName) {
    this.containerName = containerName;
  }


  public V1VerticalPodAutoscalerSpecResourcePolicyContainerPolicies controlledResources(List<String> controlledResources) {

    this.controlledResources = controlledResources;
    return this;
  }

  public V1VerticalPodAutoscalerSpecResourcePolicyContainerPolicies addControlledResourcesItem(String controlledResourcesItem) {
    if (this.controlledResources == null) {
      this.controlledResources = new ArrayList<>();
    }
    this.controlledResources.add(controlledResourcesItem);
    return this;
  }

   /**
   * Specifies the type of recommendations that will be computed (and possibly applied) by VPA. If not specified, the default of [ResourceCPU, ResourceMemory] will be used.
   * @return controlledResources
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Specifies the type of recommendations that will be computed (and possibly applied) by VPA. If not specified, the default of [ResourceCPU, ResourceMemory] will be used.")

  public List<String> getControlledResources() {
    return controlledResources;
  }


  public void setControlledResources(List<String> controlledResources) {
    this.controlledResources = controlledResources;
  }


  public V1VerticalPodAutoscalerSpecResourcePolicyContainerPolicies controlledValues(ControlledValuesEnum controlledValues) {

    this.controlledValues = controlledValues;
    return this;
  }

   /**
   * Specifies which resource values should be controlled. The default is \&quot;RequestsAndLimits\&quot;.
   * @return controlledValues
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Specifies which resource values should be controlled. The default is \"RequestsAndLimits\".")

  public ControlledValuesEnum getControlledValues() {
    return controlledValues;
  }


  public void setControlledValues(ControlledValuesEnum controlledValues) {
    this.controlledValues = controlledValues;
  }


  public V1VerticalPodAutoscalerSpecResourcePolicyContainerPolicies maxAllowed(Map<String, Object> maxAllowed) {

    this.maxAllowed = maxAllowed;
    return this;
  }

  public V1VerticalPodAutoscalerSpecResourcePolicyContainerPolicies putMaxAllowedItem(String key, Object maxAllowedItem) {
    if (this.maxAllowed == null) {
      this.maxAllowed = new HashMap<>();
    }
    this.maxAllowed.put(key, maxAllowedItem);
    return this;
  }

   /**
   * Specifies the maximum amount of resources that will be recommended for the container. The default is no maximum.
   * @return maxAllowed
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Specifies the maximum amount of resources that will be recommended for the container. The default is no maximum.")

  public Map<String, Object> getMaxAllowed() {
    return maxAllowed;
  }


  public void setMaxAllowed(Map<String, Object> maxAllowed) {
    this.maxAllowed = maxAllowed;
  }


  public V1VerticalPodAutoscalerSpecResourcePolicyContainerPolicies minAllowed(Map<String, Object> minAllowed) {

    this.minAllowed = minAllowed;
    return this;
  }

  public V1VerticalPodAutoscalerSpecResourcePolicyContainerPolicies putMinAllowedItem(String key, Object minAllowedItem) {
    if (this.minAllowed == null) {
      this.minAllowed = new HashMap<>();
    }
    this.minAllowed.put(key, minAllowedItem);
    return this;
  }

   /**
   * Specifies the minimal amount of resources that will be recommended for the container. The default is no minimum.
   * @return minAllowed
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Specifies the minimal amount of resources that will be recommended for the container. The default is no minimum.")

  public Map<String, Object> getMinAllowed() {
    return minAllowed;
  }


  public void setMinAllowed(Map<String, Object> minAllowed) {
    this.minAllowed = minAllowed;
  }


  public V1VerticalPodAutoscalerSpecResourcePolicyContainerPolicies mode(ModeEnum mode) {

    this.mode = mode;
    return this;
  }

   /**
   * Whether autoscaler is enabled for the container. The default is \&quot;Auto\&quot;.
   * @return mode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Whether autoscaler is enabled for the container. The default is \"Auto\".")

  public ModeEnum getMode() {
    return mode;
  }


  public void setMode(ModeEnum mode) {
    this.mode = mode;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    V1VerticalPodAutoscalerSpecResourcePolicyContainerPolicies v1VerticalPodAutoscalerSpecResourcePolicyContainerPolicies = (V1VerticalPodAutoscalerSpecResourcePolicyContainerPolicies) o;
    return Objects.equals(this.containerName, v1VerticalPodAutoscalerSpecResourcePolicyContainerPolicies.containerName) &&
        Objects.equals(this.controlledResources, v1VerticalPodAutoscalerSpecResourcePolicyContainerPolicies.controlledResources) &&
        Objects.equals(this.controlledValues, v1VerticalPodAutoscalerSpecResourcePolicyContainerPolicies.controlledValues) &&
        Objects.equals(this.maxAllowed, v1VerticalPodAutoscalerSpecResourcePolicyContainerPolicies.maxAllowed) &&
        Objects.equals(this.minAllowed, v1VerticalPodAutoscalerSpecResourcePolicyContainerPolicies.minAllowed) &&
        Objects.equals(this.mode, v1VerticalPodAutoscalerSpecResourcePolicyContainerPolicies.mode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(containerName, controlledResources, controlledValues, maxAllowed, minAllowed, mode);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class V1VerticalPodAutoscalerSpecResourcePolicyContainerPolicies {\n");
    sb.append("    containerName: ").append(toIndentedString(containerName)).append("\n");
    sb.append("    controlledResources: ").append(toIndentedString(controlledResources)).append("\n");
    sb.append("    controlledValues: ").append(toIndentedString(controlledValues)).append("\n");
    sb.append("    maxAllowed: ").append(toIndentedString(maxAllowed)).append("\n");
    sb.append("    minAllowed: ").append(toIndentedString(minAllowed)).append("\n");
    sb.append("    mode: ").append(toIndentedString(mode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

