/*
 * Copyright 2022 LinkedIn Corp.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package azkaban.imagemgmt.dto;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.codehaus.jackson.annotate.JsonProperty;


public class RampRuleOwnershipDTO extends BaseDTO {
  // Represents the name of the Ramp rule
  @JsonProperty("ruleName")
  @NotBlank(message = "ruleName cannot be blank.", groups = ValidationOnCreate.class)
  @NotNull(message = "ruleName cannot be null.", groups = ValidationOnCreate.class)
  private String ruleName;
  // Represents the name of the ownerships for the rule
  @JsonProperty("ownerships")
  @NotBlank(message = "rule ownerships cannot be blank.", groups = ValidationOnCreate.class)
  @NotNull(message = "rule ownerships cannot be null.", groups = ValidationOnCreate.class)
  private String ownerships;

  public void setRuleName(String ruleName) {
    this.ruleName = ruleName;
  }

  public String getRuleName() {
    return ruleName;
  }

  public void setOwnerships(String ownerships) {
    this.ownerships = ownerships;
  }

  public String getOwnerships() {
    return ownerships;
  }
}
