/*
 * Decompiled with CFR 0.152.
 */
package azkaban.webapp.servlet;

import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableFlowBase;
import azkaban.executor.ExecutableNode;
import azkaban.executor.ExecutionOptions;
import azkaban.executor.ExecutorManagerAdapter;
import azkaban.executor.ExecutorManagerException;
import azkaban.executor.Status;
import azkaban.flow.Flow;
import azkaban.project.Project;
import azkaban.project.ProjectManager;
import azkaban.scheduler.Schedule;
import azkaban.scheduler.ScheduleManager;
import azkaban.scheduler.ScheduleManagerException;
import azkaban.user.Permission;
import azkaban.user.User;
import azkaban.utils.FileIOUtils;
import azkaban.webapp.AzkabanWebServer;
import azkaban.webapp.plugin.PluginRegistry;
import azkaban.webapp.servlet.ExecutorServlet;
import azkaban.webapp.servlet.HttpRequestUtils;
import azkaban.webapp.servlet.LoginAbstractAzkabanServlet;
import azkaban.webapp.servlet.Page;
import azkaban.webapp.session.Session;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ExecutorServlet
extends LoginAbstractAzkabanServlet {
    private static final long serialVersionUID = 1L;
    private ProjectManager projectManager;
    private ExecutorManagerAdapter executorManager;
    private ScheduleManager scheduleManager;
    private ExecutorVelocityHelper velocityHelper;
    private static /* synthetic */ int[] $SWITCH_TABLE$azkaban$executor$ExecutionOptions$FailureAction;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        AzkabanWebServer server = (AzkabanWebServer)this.getApplication();
        this.projectManager = server.getProjectManager();
        this.executorManager = server.getExecutorManager();
        this.scheduleManager = server.getScheduleManager();
        this.velocityHelper = new ExecutorVelocityHelper(this);
    }

    protected void handleGet(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
        if (this.hasParam(req, "ajax")) {
            this.handleAJAXAction(req, resp, session);
        } else if (this.hasParam(req, "execid")) {
            if (this.hasParam(req, "job")) {
                this.handleExecutionJobDetailsPage(req, resp, session);
            } else {
                this.handleExecutionFlowPage(req, resp, session);
            }
        } else {
            this.handleExecutionsPage(req, resp, session);
        }
    }

    private void handleAJAXAction(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
        HashMap<String, String> ret = new HashMap<String, String>();
        String ajaxName = this.getParam(req, "ajax");
        if (this.hasParam(req, "execid")) {
            int execid = this.getIntParam(req, "execid");
            ExecutableFlow exFlow = null;
            try {
                exFlow = this.executorManager.getExecutableFlow(execid);
            }
            catch (ExecutorManagerException e) {
                ret.put("error", "Error fetching execution '" + execid + "': " + e.getMessage());
            }
            if (exFlow == null) {
                ret.put("error", "Cannot find execution '" + execid + "'");
            } else if (ajaxName.equals("fetchexecflow")) {
                this.ajaxFetchExecutableFlow(req, resp, ret, session.getUser(), exFlow);
            } else if (ajaxName.equals("fetchexecflowupdate")) {
                this.ajaxFetchExecutableFlowUpdate(req, resp, ret, session.getUser(), exFlow);
            } else if (ajaxName.equals("cancelFlow")) {
                this.ajaxCancelFlow(req, resp, ret, session.getUser(), exFlow);
            } else if (ajaxName.equals("pauseFlow")) {
                this.ajaxPauseFlow(req, resp, ret, session.getUser(), exFlow);
            } else if (ajaxName.equals("resumeFlow")) {
                this.ajaxResumeFlow(req, resp, ret, session.getUser(), exFlow);
            } else if (ajaxName.equals("fetchExecFlowLogs")) {
                this.ajaxFetchExecFlowLogs(req, resp, ret, session.getUser(), exFlow);
            } else if (ajaxName.equals("fetchExecJobLogs")) {
                this.ajaxFetchJobLogs(req, resp, ret, session.getUser(), exFlow);
            } else if (ajaxName.equals("fetchExecJobStats")) {
                this.ajaxFetchJobStats(req, resp, ret, session.getUser(), exFlow);
            } else if (ajaxName.equals("retryFailedJobs")) {
                this.ajaxRestartFailed(req, resp, ret, session.getUser(), exFlow);
            } else if (ajaxName.equals("flowInfo")) {
                this.ajaxFetchExecutableFlowInfo(req, resp, ret, session.getUser(), exFlow);
            }
        } else if (ajaxName.equals("getRunning")) {
            String projectName = this.getParam(req, "project");
            String flowName = this.getParam(req, "flow");
            this.ajaxGetFlowRunning(req, resp, ret, session.getUser(), projectName, flowName);
        } else if (ajaxName.equals("flowInfo")) {
            String projectName = this.getParam(req, "project");
            String flowName = this.getParam(req, "flow");
            this.ajaxFetchFlowInfo(req, resp, ret, session.getUser(), projectName, flowName);
        } else {
            String projectName = this.getParam(req, "project");
            ret.put("project", projectName);
            if (ajaxName.equals("executeFlow")) {
                this.ajaxAttemptExecuteFlow(req, resp, ret, session.getUser());
            }
        }
        if (ret != null) {
            this.writeJSON(resp, ret);
        }
    }

    protected void handlePost(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
        if (this.hasParam(req, "ajax")) {
            this.handleAJAXAction(req, resp, session);
        }
    }

    private void handleExecutionJobDetailsPage(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
        Page page = this.newPage(req, resp, session, "azkaban/webapp/servlet/velocity/jobdetailspage.vm");
        User user = session.getUser();
        int execId = this.getIntParam(req, "execid");
        String jobId = this.getParam(req, "job");
        int attempt = this.getIntParam(req, "attempt", 0);
        page.add("execid", (Object)execId);
        page.add("jobid", (Object)jobId);
        page.add("attempt", (Object)attempt);
        ExecutableFlow flow = null;
        ExecutableNode node = null;
        try {
            flow = this.executorManager.getExecutableFlow(execId);
            if (flow == null) {
                page.add("errorMsg", (Object)("Error loading executing flow " + execId + ": not found."));
                page.render();
                return;
            }
            node = flow.getExecutableNodePath(jobId);
            if (node == null) {
                page.add("errorMsg", (Object)("Job " + jobId + " doesn't exist in " + flow.getExecutionId()));
                return;
            }
            List jobViewerPlugins = PluginRegistry.getRegistry().getViewerPluginsForJobType(node.getType());
            page.add("jobViewerPlugins", (Object)jobViewerPlugins);
        }
        catch (ExecutorManagerException e) {
            page.add("errorMsg", (Object)("Error loading executing flow: " + e.getMessage()));
            page.render();
            return;
        }
        int projectId = flow.getProjectId();
        Project project = this.getProjectPageByPermission(page, projectId, user, Permission.Type.READ);
        if (project == null) {
            page.render();
            return;
        }
        page.add("projectName", (Object)project.getName());
        page.add("flowid", (Object)flow.getId());
        page.add("parentflowid", (Object)node.getParentFlow().getFlowId());
        page.add("jobname", (Object)node.getId());
        page.render();
    }

    private void handleExecutionsPage(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
        Page page = this.newPage(req, resp, session, "azkaban/webapp/servlet/velocity/executionspage.vm");
        List runningFlows = this.executorManager.getRunningFlows();
        page.add("runningFlows", (Object)(runningFlows.isEmpty() ? null : runningFlows));
        List finishedFlows = this.executorManager.getRecentlyFinishedFlows();
        page.add("recentlyFinished", (Object)(finishedFlows.isEmpty() ? null : finishedFlows));
        page.add("vmutils", (Object)this.velocityHelper);
        page.render();
    }

    private void handleExecutionFlowPage(HttpServletRequest req, HttpServletResponse resp, Session session) throws ServletException, IOException {
        Page page = this.newPage(req, resp, session, "azkaban/webapp/servlet/velocity/executingflowpage.vm");
        User user = session.getUser();
        int execId = this.getIntParam(req, "execid");
        page.add("execid", (Object)execId);
        ExecutableFlow flow = null;
        try {
            flow = this.executorManager.getExecutableFlow(execId);
            if (flow == null) {
                page.add("errorMsg", (Object)("Error loading executing flow " + execId + " not found."));
                page.render();
                return;
            }
        }
        catch (ExecutorManagerException e) {
            page.add("errorMsg", (Object)("Error loading executing flow: " + e.getMessage()));
            page.render();
            return;
        }
        int projectId = flow.getProjectId();
        Project project = this.getProjectPageByPermission(page, projectId, user, Permission.Type.READ);
        if (project == null) {
            page.render();
            return;
        }
        page.add("projectId", (Object)project.getId());
        page.add("projectName", (Object)project.getName());
        page.add("flowid", (Object)flow.getFlowId());
        page.render();
    }

    protected Project getProjectPageByPermission(Page page, int projectId, User user, Permission.Type type) {
        Project project = this.projectManager.getProject(projectId);
        if (project == null) {
            page.add("errorMsg", (Object)("Project " + project + " not found."));
        } else if (!this.hasPermission(project, user, type)) {
            page.add("errorMsg", (Object)("User " + user.getUserId() + " doesn't have " + type.name() + " permissions on " + project.getName()));
        } else {
            return project;
        }
        return null;
    }

    protected Project getProjectAjaxByPermission(Map<String, Object> ret, String projectName, User user, Permission.Type type) {
        Project project = this.projectManager.getProject(projectName);
        if (project == null) {
            ret.put("error", "Project '" + project + "' not found.");
        } else if (!this.hasPermission(project, user, type)) {
            ret.put("error", "User '" + user.getUserId() + "' doesn't have " + type.name() + " permissions on " + project.getName());
        } else {
            return project;
        }
        return null;
    }

    protected Project getProjectAjaxByPermission(Map<String, Object> ret, int projectId, User user, Permission.Type type) {
        Project project = this.projectManager.getProject(projectId);
        if (project == null) {
            ret.put("error", "Project '" + project + "' not found.");
        } else if (!this.hasPermission(project, user, type)) {
            ret.put("error", "User '" + user.getUserId() + "' doesn't have " + type.name() + " permissions on " + project.getName());
        } else {
            return project;
        }
        return null;
    }

    private void ajaxRestartFailed(HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> ret, User user, ExecutableFlow exFlow) throws ServletException {
        Project project = this.getProjectAjaxByPermission(ret, exFlow.getProjectId(), user, Permission.Type.EXECUTE);
        if (project == null) {
            return;
        }
        if (exFlow.getStatus() == Status.FAILED || exFlow.getStatus() == Status.SUCCEEDED) {
            ret.put("error", "Flow has already finished. Please re-execute.");
            return;
        }
        try {
            this.executorManager.retryFailures(exFlow, user.getUserId());
        }
        catch (ExecutorManagerException e) {
            ret.put("error", e.getMessage());
        }
    }

    private void ajaxFetchExecFlowLogs(HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> ret, User user, ExecutableFlow exFlow) throws ServletException {
        Project project = this.getProjectAjaxByPermission(ret, exFlow.getProjectId(), user, Permission.Type.READ);
        if (project == null) {
            return;
        }
        int offset = this.getIntParam(req, "offset");
        int length = this.getIntParam(req, "length");
        resp.setCharacterEncoding("utf-8");
        try {
            FileIOUtils.LogData data = this.executorManager.getExecutableFlowLog(exFlow, offset, length);
            if (data == null) {
                ret.put("length", 0);
                ret.put("offset", offset);
                ret.put("data", "");
            } else {
                ret.put("length", data.getLength());
                ret.put("offset", data.getOffset());
                ret.put("data", data.getData());
            }
        }
        catch (ExecutorManagerException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void ajaxFetchJobLogs(HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> ret, User user, ExecutableFlow exFlow) throws ServletException {
        Project project = this.getProjectAjaxByPermission(ret, exFlow.getProjectId(), user, Permission.Type.READ);
        if (project == null) {
            return;
        }
        int offset = this.getIntParam(req, "offset");
        int length = this.getIntParam(req, "length");
        String jobId = this.getParam(req, "jobId");
        resp.setCharacterEncoding("utf-8");
        try {
            ExecutableNode node = exFlow.getExecutableNodePath(jobId);
            if (node == null) {
                ret.put("error", "Job " + jobId + " doesn't exist in " + exFlow.getExecutionId());
                return;
            }
            int attempt = this.getIntParam(req, "attempt", node.getAttempt());
            FileIOUtils.LogData data = this.executorManager.getExecutionJobLog(exFlow, jobId, offset, length, attempt);
            if (data == null) {
                ret.put("length", 0);
                ret.put("offset", offset);
                ret.put("data", "");
            } else {
                ret.put("length", data.getLength());
                ret.put("offset", data.getOffset());
                ret.put("data", data.getData());
            }
        }
        catch (ExecutorManagerException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void ajaxFetchJobStats(HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> ret, User user, ExecutableFlow exFlow) throws ServletException {
        Project project = this.getProjectAjaxByPermission(ret, exFlow.getProjectId(), user, Permission.Type.READ);
        if (project == null) {
            return;
        }
        String jobId = this.getParam(req, "jobid");
        resp.setCharacterEncoding("utf-8");
        try {
            ExecutableNode node = exFlow.getExecutableNodePath(jobId);
            if (node == null) {
                ret.put("error", "Job " + jobId + " doesn't exist in " + exFlow.getExecutionId());
                return;
            }
            List jsonObj = this.executorManager.getExecutionJobStats(exFlow, jobId, node.getAttempt());
            ret.put("jobStats", jsonObj);
        }
        catch (ExecutorManagerException e) {
            ret.put("error", "Error retrieving stats for job " + jobId);
            return;
        }
    }

    private void ajaxFetchFlowInfo(HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> ret, User user, String projectName, String flowId) throws ServletException {
        Project project = this.getProjectAjaxByPermission(ret, projectName, user, Permission.Type.READ);
        if (project == null) {
            return;
        }
        Flow flow = project.getFlow(flowId);
        if (flow == null) {
            ret.put("error", "Error loading flow. Flow " + flowId + " doesn't exist in " + projectName);
            return;
        }
        ret.put("successEmails", flow.getSuccessEmails());
        ret.put("failureEmails", flow.getFailureEmails());
        Schedule sflow = null;
        try {
            for (Schedule sched : this.scheduleManager.getSchedules()) {
                if (sched.getProjectId() != project.getId() || !sched.getFlowName().equals(flowId)) continue;
                sflow = sched;
                break;
            }
        }
        catch (ScheduleManagerException e) {
            throw new ServletException((Throwable)e);
        }
        if (sflow != null) {
            ret.put("scheduled", sflow.getNextExecTime());
        }
    }

    /*
     * Exception decompiling
     */
    private void ajaxFetchExecutableFlowInfo(HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> ret, User user, ExecutableFlow exflow) throws ServletException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void ajaxCancelFlow(HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> ret, User user, ExecutableFlow exFlow) throws ServletException {
        Project project = this.getProjectAjaxByPermission(ret, exFlow.getProjectId(), user, Permission.Type.EXECUTE);
        if (project == null) {
            return;
        }
        try {
            this.executorManager.cancelFlow(exFlow, user.getUserId());
        }
        catch (ExecutorManagerException e) {
            ret.put("error", e.getMessage());
        }
    }

    private void ajaxGetFlowRunning(HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> ret, User user, String projectId, String flowId) throws ServletException {
        Project project = this.getProjectAjaxByPermission(ret, projectId, user, Permission.Type.EXECUTE);
        if (project == null) {
            return;
        }
        List refs = this.executorManager.getRunningFlows(project.getId(), flowId);
        if (!refs.isEmpty()) {
            ret.put("execIds", refs);
        }
    }

    private void ajaxPauseFlow(HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> ret, User user, ExecutableFlow exFlow) throws ServletException {
        Project project = this.getProjectAjaxByPermission(ret, exFlow.getProjectId(), user, Permission.Type.EXECUTE);
        if (project == null) {
            return;
        }
        try {
            this.executorManager.pauseFlow(exFlow, user.getUserId());
        }
        catch (ExecutorManagerException e) {
            ret.put("error", e.getMessage());
        }
    }

    private void ajaxResumeFlow(HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> ret, User user, ExecutableFlow exFlow) throws ServletException {
        Project project = this.getProjectAjaxByPermission(ret, exFlow.getProjectId(), user, Permission.Type.EXECUTE);
        if (project == null) {
            return;
        }
        try {
            this.executorManager.resumeFlow(exFlow, user.getUserId());
        }
        catch (ExecutorManagerException e) {
            ret.put("resume", e.getMessage());
        }
    }

    private Map<String, Object> getExecutableFlowUpdateInfo(ExecutableNode node, long lastUpdateTime) {
        HashMap<String, Object> nodeObj = new HashMap<String, Object>();
        if (node instanceof ExecutableFlowBase) {
            ExecutableFlowBase base = (ExecutableFlowBase)node;
            ArrayList<Map> nodeList = new ArrayList<Map>();
            for (ExecutableNode subNode : base.getExecutableNodes()) {
                Map subNodeObj = this.getExecutableFlowUpdateInfo(subNode, lastUpdateTime);
                if (subNodeObj.isEmpty()) continue;
                nodeList.add(subNodeObj);
            }
            if (!nodeList.isEmpty()) {
                nodeObj.put("flow", base.getFlowId());
                nodeObj.put("nodes", nodeList);
            }
        }
        if (node.getUpdateTime() > lastUpdateTime || !nodeObj.isEmpty()) {
            nodeObj.put("id", node.getId());
            nodeObj.put("status", node.getStatus());
            nodeObj.put("startTime", node.getStartTime());
            nodeObj.put("endTime", node.getEndTime());
            nodeObj.put("updateTime", node.getUpdateTime());
            nodeObj.put("attempt", node.getAttempt());
            if (node.getAttempt() > 0) {
                nodeObj.put("pastAttempts", node.getAttemptObjects());
            }
        }
        return nodeObj;
    }

    private Map<String, Object> getExecutableNodeInfo(ExecutableNode node) {
        HashMap<String, Object> nodeObj = new HashMap<String, Object>();
        nodeObj.put("id", node.getId());
        nodeObj.put("status", node.getStatus());
        nodeObj.put("startTime", node.getStartTime());
        nodeObj.put("endTime", node.getEndTime());
        nodeObj.put("updateTime", node.getUpdateTime());
        nodeObj.put("type", node.getType());
        nodeObj.put("nestedId", node.getNestedId());
        nodeObj.put("attempt", node.getAttempt());
        if (node.getAttempt() > 0) {
            nodeObj.put("pastAttempts", node.getAttemptObjects());
        }
        if (node.getInNodes() != null && !node.getInNodes().isEmpty()) {
            nodeObj.put("in", node.getInNodes());
        }
        if (node instanceof ExecutableFlowBase) {
            ExecutableFlowBase base = (ExecutableFlowBase)node;
            ArrayList<Map> nodeList = new ArrayList<Map>();
            for (ExecutableNode subNode : base.getExecutableNodes()) {
                Map subNodeObj = this.getExecutableNodeInfo(subNode);
                if (subNodeObj.isEmpty()) continue;
                nodeList.add(subNodeObj);
            }
            nodeObj.put("flow", base.getFlowId());
            nodeObj.put("nodes", nodeList);
            nodeObj.put("flowId", base.getFlowId());
        }
        return nodeObj;
    }

    private void ajaxFetchExecutableFlowUpdate(HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> ret, User user, ExecutableFlow exFlow) throws ServletException {
        Long lastUpdateTime = Long.parseLong(this.getParam(req, "lastUpdateTime"));
        System.out.println("Fetching " + exFlow.getExecutionId());
        Project project = this.getProjectAjaxByPermission(ret, exFlow.getProjectId(), user, Permission.Type.READ);
        if (project == null) {
            return;
        }
        Map map = this.getExecutableFlowUpdateInfo((ExecutableNode)exFlow, lastUpdateTime.longValue());
        map.put("status", exFlow.getStatus());
        map.put("startTime", exFlow.getStartTime());
        map.put("endTime", exFlow.getEndTime());
        map.put("updateTime", exFlow.getUpdateTime());
        ret.putAll(map);
    }

    private void ajaxFetchExecutableFlow(HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> ret, User user, ExecutableFlow exFlow) throws ServletException {
        System.out.println("Fetching " + exFlow.getExecutionId());
        Project project = this.getProjectAjaxByPermission(ret, exFlow.getProjectId(), user, Permission.Type.READ);
        if (project == null) {
            return;
        }
        ret.put("submitTime", exFlow.getSubmitTime());
        ret.put("submitUser", exFlow.getSubmitUser());
        ret.put("execid", exFlow.getExecutionId());
        ret.put("projectId", exFlow.getProjectId());
        ret.put("project", project.getName());
        Map flowObj = this.getExecutableNodeInfo((ExecutableNode)exFlow);
        ret.putAll(flowObj);
    }

    private void ajaxAttemptExecuteFlow(HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> ret, User user) throws ServletException {
        String projectName = this.getParam(req, "project");
        String flowId = this.getParam(req, "flow");
        Project project = this.getProjectAjaxByPermission(ret, projectName, user, Permission.Type.EXECUTE);
        if (project == null) {
            ret.put("error", "Project '" + projectName + "' doesn't exist.");
            return;
        }
        ret.put("flow", flowId);
        Flow flow = project.getFlow(flowId);
        if (flow == null) {
            ret.put("error", "Flow '" + flowId + "' cannot be found in project " + project);
            return;
        }
        this.ajaxExecuteFlow(req, resp, ret, user);
    }

    private void ajaxExecuteFlow(HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> ret, User user) throws ServletException {
        String projectName = this.getParam(req, "project");
        String flowId = this.getParam(req, "flow");
        Project project = this.getProjectAjaxByPermission(ret, projectName, user, Permission.Type.EXECUTE);
        if (project == null) {
            ret.put("error", "Project '" + projectName + "' doesn't exist.");
            return;
        }
        ret.put("flow", flowId);
        Flow flow = project.getFlow(flowId);
        if (flow == null) {
            ret.put("error", "Flow '" + flowId + "' cannot be found in project " + project);
            return;
        }
        ExecutableFlow exflow = new ExecutableFlow(project, flow);
        exflow.setSubmitUser(user.getUserId());
        exflow.addAllProxyUsers((Collection)project.getProxyUsers());
        ExecutionOptions options = HttpRequestUtils.parseFlowOptions((HttpServletRequest)req);
        exflow.setExecutionOptions(options);
        if (!options.isFailureEmailsOverridden()) {
            options.setFailureEmails((Collection)flow.getFailureEmails());
        }
        if (!options.isSuccessEmailsOverridden()) {
            options.setSuccessEmails((Collection)flow.getSuccessEmails());
        }
        options.setMailCreator(flow.getMailCreator());
        try {
            String message = this.executorManager.submitExecutableFlow(exflow, user.getUserId());
            ret.put("message", message);
        }
        catch (ExecutorManagerException e) {
            e.printStackTrace();
            ret.put("error", "Error submitting flow " + exflow.getFlowId() + ". " + e.getMessage());
        }
        ret.put("execid", exflow.getExecutionId());
    }

    static /* synthetic */ ProjectManager access$0(ExecutorServlet executorServlet) {
        return executorServlet.projectManager;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$azkaban$executor$ExecutionOptions$FailureAction() {
        if ($SWITCH_TABLE$azkaban$executor$ExecutionOptions$FailureAction != null) {
            return $SWITCH_TABLE$azkaban$executor$ExecutionOptions$FailureAction;
        }
        int[] nArray = new int[ExecutionOptions.FailureAction.values().length];
        try {
            nArray[ExecutionOptions.FailureAction.CANCEL_ALL.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExecutionOptions.FailureAction.FINISH_ALL_POSSIBLE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExecutionOptions.FailureAction.FINISH_CURRENTLY_RUNNING.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$azkaban$executor$ExecutionOptions$FailureAction = nArray;
        return nArray;
    }
}

