# basehangul-online

[Try out the tool!](https://ayaka14732.github.io/basehangul-online/)

## What is Hangul?

Hangul is the Korean writing system that consists of syllabic characters representing the sounds of the Korean language. It was created in the 15th century and is now the official script of Korea. Hangul is composed of individual characters called "jamo" that represent syllables and can be combined to form complex words.

## What is BaseHangul?

Similar to Base64, BaseHangul is a binary encoding that uses Hangul (Korean writing system) characters to represent binary data. It converts 5 bytes (40 bits) into 4 Hangul characters based on the KS C 5601 standard. The 40-bit conversion is chosen because it is the least common multiple of 8 and 10, which are the number of bits used to represent 1 character. 1028 Hangul characters out of 2350 in the standard are selected in dictionary order for the encoding. The character "흐" is outside of the selected range but used as a padding character.

## What is the Online BaseHangul Encoder and Decoder?

Online BaseHangul Encoder and Decoder is a cutting-edge tool designed for quick and efficient encoding and decoding of BaseHangul data. With its fast and reliable implementation in JavaScript, this tool provides a seamless user experience right in your web browser. The computation is done locally, ensuring that your information is kept secure and confidential at all times, as it does not transmit any data to any third-party servers. With just one click, you can easily convert text data into Hangul characters and vice versa, saving you time and effort. Whether you're a professional or simply looking for a convenient way to encode and decode BaseHangul data, this online tool is the perfect solution.

## More information

The Online BaseHangul Encoder and Decoder is built upon the [basehangul-javascript](https://github.com/basehangul/basehangul-javascript) project, which is a JavaScript implementation of the BaseHangul 1.1 encoding standard. The project provides a reliable and efficient platform for encoding and decoding binary data into Hangul characters.

For more information on BaseHangul, we encourage you to visit the [official website](https://basehangul.github.io/). Here, you will find detailed information about the encoding standard, including its history, development, and implementation. Additionally, the site provides a wealth of resources and information about how to use BaseHangul, including tutorials, examples, and APIs. Whether you're a developer, researcher, or simply interested in learning more about BaseHangul, the official website is an excellent resource that provides all the information you need to get started.
