---
title: Retrievers overview
description: An overview of retrievers
---

A retriever is a component or mechanism used to fetch relevant information from a large corpus of data or a database in response to a query. This process is crucial in enhancing the performance and accuracy of LLMs, especially in tasks that require accessing and utilizing external knowledge sources.

## Key Roles of a Retriever
1. **Improving Context and Relevance:**

    Retrievers help in providing the LLM with relevant context or information that may not be included in its training data or that is too specific to be generated purely from the model's internal knowledge.

2. **Memory Augmentation:**

    Retrievers act as an extended memory for the LLM, allowing it to access up-to-date information or detailed data on specific topics, thereby improving the relevance and accuracy of the generated responses.

3. **Efficiency:**

    Instead of training the model on an enormous and ever-growing dataset, retrievers allow the model to pull in only the necessary information on-demand, making the system more efficient.