import Head from "next/head";
import { useEffect } from "react";
import Footer from "../components/Footer";
import Sidebar from "../components/Sidebar";
import { db } from "../firebase";
import firebase from "firebase/compat/app";
import "firebase/compat/firestore";
import Fade from "react-reveal/Fade";
import Image from "next/image";
import { useUser } from "@clerk/clerk-react";

export default function Home() {
  const user = useUser();

  useEffect(() => {
    if (user) {
      db.collection("users").doc(user?.primaryEmailAddress?.emailAddress).set(
        {
          email: user.primaryEmailAddress?.emailAddress,
          name: user.fullName,
          lastSeen: firebase.firestore.FieldValue.serverTimestamp(),
          photoURL: user.profileImageUrl,
          firstName: user.firstName,
        },
        { merge: true }
      );
    }
  });

  return (
    <div className="flex flex-col min-h-screen shadow-md">
      <Head>
        <title>ChatCube</title>
        <meta name="description" content="Generated by create next app" />
        <link rel="icon" href="/Icon.png" />
      </Head>
      <div className="flex w-full">
        <Sidebar />
        <Fade right>
          <div className="flex-col items-center justify-center hidden m-4 text-center md:flex md:w-[63vw] h-[80vh] md:m-1 md:ml-16 rounded-xl !mt-auto !mb-auto w-[93vw] text-white">
            <h2 className="text-2xl w-[280px] font-semibold">
              Click on a chat or create a new chat
            </h2>
          </div>
        </Fade>
        <a
          href="https://github.com/avneesh0612/ChatCube"
          target="_blank"
          className="absolute top-0 right-0"
          rel="noreferrer"
        >
          <Image
            alt="github"
            src="/github-corner.svg"
            objectFit="contain"
            width={100}
            height={100}
          />
        </a>
      </div>
      <Footer />
    </div>
  );
}
