# Recommended Resources for Web Developers

An ongoing collective list of recommended resources for web developers. The vast majority of which are free, though some, however, are paid.

Please read the [contributing guidelines](./CONTRIBUTING.md) before submitting new resources.

---

## Index
* [General Resources](#general-resources)
  * [Tutorials and Docs](#tutorials-and-docs)
  * [YouTube Channels](#youtube-channels)
  * [Blogs, Chats, and Forums](#blogs-chats-and-forums)
  * [Challenges, Algorithms, and Data Structures](#challenges-algorithms-and-data-structures)
  * [MOOCs](#moocs)
  * [Books](#books)
  * [General Links and Tools](#general-links-and-tools)
* [JavaScript](#javascript)
  * [ES6 Syntax](#es6-syntax)
  * [Web Requests and Asynchronous JavaScript](#web-requests-and-asynchronous-javascript)
  * [Regular Expressions](#regular-expressions)
  * [TypeScript](#typescript)
* [HTML and CSS](#html-and-css)
  * [Flexbox and CSS Grid](#flexbox-and-css-grid)
  * [Bootstrap](#bootstrap)
  * [Sass](#sass)
  * [HTML and CSS Tools](#html-and-css-tools)
* [Fonts, Icons, and Images](#fonts-icons-and-images)
  * [Fonts](#fonts)
  * [Icon Font Libraries](#icon-font-libraries)
  * [Stock Images](#stock-images)
  * [Image Editing Tools](#image-editing-tools)
* [Command Line, Git, and Markdown](#command-line-git-and-markdown)
* [React.js](#reactjs)
  * [Redux](#redux)
* [Node.js](#nodejs)
  * [Express.js](#expressjs)
  * [JavaScript Testing](#javascript-testing)
* [Other JavaScript Libraries](#other-javascript-libraries)
* [MongoDB](#mongodb)
* [WordPress](#wordpress)
* [Python](#python)

## General Resources

### Tutorials and Docs
Name | Cost
---- | ----
[W3Schools](https://www.w3schools.com) | Free with some Paid content
[MDN (Mozilla Developer Network)](https://developer.mozilla.org) | Free
[freeCodeCamp](https://www.freecodecamp.org) | Free
[JavaScript.info](https://javascript.info) | Free
[DevDocs.io](https://devdocs.io) | Free
[Devhints](https://devhints.io) | Free
[The Odin Project](https://www.theodinproject.com) | Free
[LinkedIn Learning](https://www.linkedin.com/learning) | Paid, but Free with some public library and university library memberships
[Codecademy](https://www.codecademy.com) | Free and Paid content
[Udacity](https://www.udacity.com) | Free and Paid content
[Sololearn](https://www.sololearn.com) | Free with Paid features

**[&#8679; Back to Index](#index)**

### YouTube Channels
Name | Cost
---- | ----
[freeCodeCamp.org](https://www.youtube.com/c/Freecodecamp) | Free
[Traversy Media](https://www.youtube.com/c/TraversyMedia) | Free
[LearnWebCode](https://www.youtube.com/user/LearnWebCode) | Free
[Web Dev Simplified](https://www.youtube.com/c/WebDevSimplified) | Free
[CS Dojo](https://www.youtube.com/c/CSDojo) | Free
[Kevin Powell](https://www.youtube.com/kepowob) | Free
[CS50](https://www.youtube.com/c/cs50) | Free
[Faraday Academy](https://www.youtube.com/c/FaradayAcademy) | Free
[The Coding Train](https://www.youtube.com/c/TheCodingTrain) | Free
[Florin Pop](https://www.youtube.com/c/FlorinPopA) | Free

**[&#8679; Back to Index](#index)**

### Blogs, Chats, and Forums
Name | Cost
---- | ----
[Stack Overflow](https://stackoverflow.com) | Free with Paid features
[freeCodeCamp's Programming Tutorials blog](https://www.freecodecamp.org/news) | Free
[freeCodeCamp's forum](https://forum.freecodecamp.org) | Free
[CSS-Tricks](https://css-tricks.com) | Free
[DEV Community](https://dev.to) | Free
[The Odin Project's Discord server](https://discord.com/invite/fbFCkYabZB) | Free
[Codecademy's forum](https://discuss.codecademy.com) | Free
[Codecademy's Discord server](https://discord.com/invite/codecademy) | Free
[W3Schools's Discord server](https://discord.gg/6Z7UaRbUQM) | Free
[Thinkful's blog](https://www.thinkful.com/blog) | Free
[Ben Ilegbodu's blog](https://www.benmvp.com) | Free
[Web Dev Simplified's blog](https://blog.webdevsimplified.com) | Free
[Web Dev Simplified's Discord server](https://discord.com/invite/7StTjnR) | Free
[Kevin Powell's Discord server](https://discord.com/invite/nTYCvrK) | Free
[CS50's Discord server](https://discord.com/invite/cs50) | Free

**[&#8679; Back to Index](#index)**

### Challenges, Algorithms, and Data Structures
Name | Description | Cost
---- | ----------- | ----
[Codewars](https://www.codewars.com) | A popular gamified site for completing community-driven challenges customized by your preferred programming languages and experience level.   | Free with some Paid features
Algorithms on freeCodeCamp | A collection of JavaScript algorithms split by difficulty listed as [Basic](https://www.freecodecamp.org/learn/javascript-algorithms-and-data-structures/#basic-algorithm-scripting), [Intermediate](https://www.freecodecamp.org/learn/javascript-algorithms-and-data-structures/#intermediate-algorithm-scripting), [Advanced](https://www.freecodecamp.org/learn/javascript-algorithms-and-data-structures/#javascript-algorithms-and-data-structures-projects), and [Interview Prep](https://www.freecodecamp.org/learn/coding-interview-prep/#algorithms). | Free
[Project Euler](https://projecteuler.net) | Hundreds of mathematical programming challenges that can be solved in the programming language of your choice. | Free
[Computer Science course](https://www.khanacademy.org/computing/computer-science) on Khan Academy | A course for learning sorting algorithms and cryptography challenges in JavaScript. | Free
[A Bit of Computer Science tutorial](https://www.theodinproject.com/paths/full-stack-javascript/courses/javascript#a-bit-of-computer-science) on The Odin Project | A taste of computer science for the JavaScript developer featuring articles and projects for learning DSA. | Free
freeCodeCamp's [Data Structures course](https://www.freecodecamp.org/learn/coding-interview-prep/#data-structures) | Test your knowledge of Data Structures with these lessons and challenges on the subject provided in JavaScript. | Free
[Sorting Algorithms Visualization Comparisons](https://www.cs.usfca.edu/~galles/visualization/ComparisonSort.html) | Animated visualizations of the functioning of various popular sorting algorithms. | Free
[Frontend Mentor](https://www.frontendmentor.io) | A collection of several frontend projects that can be completed and shared with other developers in the community. | Free and Paid content
[NeetCode](https://neetcode.io) | Practice algorithms for interview prep for free and watch courses on DSA with a Pro membership. | Free and Paid content
[LeetCode](https://leetcode.com) | Challenges, Study Plans, Interview Prep for top companies, and more. A well known study platform in the industry. | Free and Paid content

**[&#8679; Back to Index](#index)**

### MOOCs
Name | Description | Cost
---- | ----------- | ----
[CS50's Introduction to Computer Science](https://www.edx.org/course/introduction-computer-science-harvardx-cs50x) | Taught by Harvard University on edX, and one of the most well-known programming MOOCs, this course covers introductory computer science concepts and algorithms using C, Python, and JavaScript. | Free to take, certificate is Paid
[CS50's Introduction to Programming with Python](https://www.edx.org/course/cs50s-introduction-to-programming-with-python) | Taught by Harvard University on edX, an introduction to programming using Python. | Free to take, certificate is Paid
[CS50's Web Programming with Python and JavaScript](https://www.edx.org/course/cs50s-web-programming-with-python-and-javascript) | Taught by Harvard University on edX, and a continuation of [CS50](https://www.edx.org/course/introduction-computer-science-harvardx-cs50x), this course goes deeper into the languages of Python and JavaScript by teaching web app development using frameworks like Django and React.  | Free to take, certificate is Paid
[CS50's Introduction to Artificial Intelligence with Python](https://www.edx.org/course/cs50s-introduction-to-artificial-intelligence-with-python) | Taught by Harvard University on edX, and a continuation of [CS50](https://www.edx.org/course/introduction-computer-science-harvardx-cs50x), this course introduces machine learning with Python for the use of adding artificial intelligence to applications. | Free to take, certificate is Paid
[CS50's Introduction to Game Development](https://www.edx.org/course/cs50s-introduction-to-game-development) | Taught by Harvard University on edX, and a continuation of [CS50](https://www.edx.org/course/introduction-computer-science-harvardx-cs50x), this course teaches how to implement graphics, sound, animation, etc into video games using technologies such as Lua, C#, and Unity. | Free to take, certificate is Paid
[CS50's Mobile App Development with React Native](https://www.edx.org/course/cs50s-mobile-app-development-with-react-native) | Taught by Harvard University on edX, and a continuation of [CS50](https://www.edx.org/course/introduction-computer-science-harvardx-cs50x), this course teaches modern mobile app development using React Native and JavaScript. | Free to take, certificate is Paid
[The Web Developer Bootcamp 2021](https://www.udemy.com/course/the-web-developer-bootcamp) on Udemy | This course teaches the core of what any modern web developer needs to know in order to make full-stack web applications with HTML, CSS, JavaScript, and Node.js. | Paid
[The Advanced Web Developer Bootcamp](https://www.udemy.com/course/the-advanced-web-developer-bootcamp) on Udemy | A continuation of [The Web Developer Bootcamp](https://www.udemy.com/course/the-web-developer-bootcamp), this courses dives deeper into web development, exploring more concepts including libraries like React and D3, JavaScript testing, and advanced CSS. | Paid
[The Complete Node.js Developer Course (3rd Edition)](https://www.udemy.com/course/the-complete-nodejs-developer-course-2) on Udemy | This courses teaches how to build modern back-end web applications using Node.js, Express.js, and MongoDB. | Paid
[Become a WordPress Developer: Unlocking Power With Code](https://www.udemy.com/course/become-a-wordpress-developer-php-javascript) on Udemy | This course teaches how to create modern custom-built WordPress sites from scratch with PHP and JavaScript. | Paid

**[&#8679; Back to Index](#index)**

### Books
Consider the probability of the information in the books provided to be out of date due to the passage of time since publishing. Technologies and practices in the software industry grow and change pretty rapidly. So keep this thought in mind and compare it with other resources you come across.

Name | Cost
---- | ----
*JavaScript: The Definitive Guide* by David Flanagan | Paid, but Free if available at your public or university library
*Learning Web App Development: Build Quickly with Proven JavaScript Techniques* by Semmy Purewal | Paid, but Free if available at your public or university library
*JavaScript: The Good Parts* by Douglas Crockford | Paid, but Free if available at your public or university library
*[Think Like a Programmer: An Introduction to Creative Problem Solving](http://vantonspraul.com/TLAP)* by V. Anton Spraul | Paid, but Free if available at your public or university library
*[A Mind For Numbers: How to Excel at Math and Science (Even If You Flunked Algebra)](https://barbaraoakley.com/books/a-mind-for-numbers)* by Barbara Oakley | Paid, but Free if available at your public or university library
*[Functional Design Patterns for Express.js: A step-by-step guide to building elegant, maintainable Node.js backends.](https://jonathanleemartin.com/books)* by Jonathan Lee Martin | Paid
*[Express in Action: Writing, building, and testing Node.js applications](https://www.manning.com/books/express-in-action)* by Evan M. Hahn | Free online, but print book and ebook are Paid
*[Pro Git](https://git-scm.com/book/en/v2)* by Scott Chacon and Ben Straub | Free

**[&#8679; Back to Index](#index)**

### General Links and Tools
Name | Cost
---- | ----
[Visual Studio Code](https://code.visualstudio.com) | Free
[VS Code keyboard shortcuts cheat sheet](https://devhints.io/vscode) on Devhints | Free
[Replit](https://replit.com) | Free with some Paid features
[Code Playground](https://www.sololearn.com/codes) on Sololearn | Free
[CodePen](https://codepen.io) | Free with some Paid features
[Scratch](https://scratch.mit.edu) | Free
[Diffchecker](https://www.diffchecker.com) | Free with some Paid features
[Can I use...](https://caniuse.com) | Free
[Lorem Ipsum Generator](https://loremipsum.io) | Free
["How to Use Google to Solve Your Programming Questions" article](https://codinginflow.com/google-programming-questions) | Free

**[&#8679; Back to Index](#index)**

## JavaScript
Name | Cost
---- | ----
freeCodeCamp's [JavaScript Algorithms and Data Structures Certification](https://www.freecodecamp.org/learn/javascript-algorithms-and-data-structures) | Free
W3Schools's [JavaScript Tutorial](https://www.w3schools.com/js/default.asp) | Free
Udacity's [Intro to JavaScript course](https://www.udacity.com/course/intro-to-javascript--ud803) | Free
Scrimba.com's [Introduction to JavaScript course](https://scrimba.com/learn/introductiontojavascript) | Free
Scrimba.com's [Learn JavaScript for free course](https://scrimba.com/learn/learnjavascript) | Free
[JavaScript Basics tutorial](https://www.theodinproject.com/paths/foundations/courses/foundations#javascript-basics) on The Odin Project | Free
[JavaScript course](https://www.theodinproject.com/paths/full-stack-javascript/courses/javascript) on The Odin Project | Free
Codecademy's [Learn JavaScript course](https://www.codecademy.com/learn/introduction-to-javascript) | Free
Codecademy's [Learn JavaScript: Fundamentals course](https://www.codecademy.com/learn/learn-javascript-fundamentals) | Free
Codecademy's [Learn Intermediate JavaScript course](https://www.codecademy.com/learn/learn-intermediate-javascript) | Free
Codecademy's [Learn JavaScript: Arrays and Loops course](https://www.codecademy.com/learn/learn-javascript-arrays-and-loops) | Free
Codecademy's [Learn JavaScript: Objects course](https://www.codecademy.com/learn/learn-javascript-objects) | Free
Codecademy's [Learn JavaScript: Functions and Scope course](https://www.codecademy.com/learn/learn-javascript-functions-and-scope) | Free
Codecademy's [Learn JavaScript: Error Handling course](https://www.codecademy.com/learn/javascript-errors-debugging) | Free
Codecademy's [Learn JavaScript: Iterators course](https://www.codecademy.com/learn/learn-javascript-iterators) | Free
Codecademy's [Learn JavaScript: Classes and Modules course](https://www.codecademy.com/learn/learn-javascript-classes-and-modules) | Free
Codecademy's [Building Interactive JavaScript Websites course](https://www.codecademy.com/learn/build-interactive-websites) | Paid
Codecademy's [Learn JavaScript: Best Practices course](https://www.codecademy.com/learn/learn-javascript-best-practices) | Free
[JavaScript.info](https://javascript.info) | Free
Sololearn's [JavaScript course](https://www.sololearn.com/learning/1024) | Free with some Paid features
[Beginner JavaScript! course](https://beginnerjavascript.com) by Wes Bos | Paid
JavaScript Best Practices tutorial by Thinkful: [Part 1](https://www.thinkful.com/learn/javascript-best-practices-1), [Part 2](https://www.thinkful.com/learn/javascript-best-practices-2) | Free
[JavaScript Formatter](https://jsonformatter.org/jsbeautifier) | Free
Udacity's [JavaScript and the DOM course](https://www.udacity.com/course/javascript-and-the-dom--ud117) | Free
Udacity's [Building High Conversion Web Forms course](https://www.udacity.com/course/building-high-conversion-web-forms--ud890) | Free
Udacity's [Object-Oriented JavaScript course](https://www.udacity.com/course/object-oriented-javascript--ud711) | Free
[JavaScript30 course](https://javascript30.com) by Wes Bos | Free
[Web APIs list](https://developer.mozilla.org/en-US/docs/Web/API) on MDN | Free
[JavaScript Arrays cheat sheet](https://devhints.io/js-array) on Devhints | Free
[JavaScript Date cheat sheet](https://devhints.io/js-date) on Devhints | Free
[JavaScript Interview Questions](https://github.com/sudheerj/javascript-interview-questions) by [@sudheerj](https://github.com/sudheerj) on GitHub | Free
Codecademy's [Technical Interview Practice with JavaScript course](https://www.codecademy.com/learn/technical-interview-practice-with-javascript) | Paid

**[&#8679; Back to Index](#index)**

### ES6 Syntax
Name | Cost
---- | ----
freeCodeCamp's [ES6 course](https://www.freecodecamp.org/learn/javascript-algorithms-and-data-structures/#es6) | Free
Scrimba.com's [Introduction to ES6+ course](https://scrimba.com/learn/introtoes6) | Free
Udacity's [ES6 - JavaScript Improved course](https://www.udacity.com/course/es6-javascript-improved--ud356) | Free
[List of ES6 Features](https://github.com/lukehoban/es6features) by [@lukehoban](https://github.com/lukehoban) on GitHub | Free
[ES6 for Everyone course](https://es6.io) by Wes Bos | Paid
[ES6 cheat sheet](https://devhints.io/es6) on Devhints | Free

**[&#8679; Back to Index](#index)**

### Web Requests and Asynchronous JavaScript
Name | Cost
---- | ----
[Postman](https://www.postman.com) | Free with some Paid features
[Axios website](https://axios-http.com) | Free
[Fetch cheat sheet](https://devhints.io/python) on Devhints | Free
W3Schools's [JSON Tutorial](https://www.w3schools.com/js/js_json_intro.asp) | Free
Udacity's [JavaScript Promises course](https://www.udacity.com/course/javascript-promises--ud898) | Free
[Asynchronous JavaScript and APIs tutorial](https://www.theodinproject.com/paths/full-stack-javascript/courses/javascript#asynchronous-javascript-and-apis) on The Odin Project | Free
Codecademy's [Learn JavaScript: Asynchronous Programming](https://www.codecademy.com/learn/asynchronous-javascript) | Free
Codecademy's [Learn JavaScript: Requests course](https://www.codecademy.com/learn/learn-javascript-requests) | Free
[ProgrammableWeb](https://www.programmableweb.com) | Free
[API list](https://github.com/public-apis/public-apis) by [@public-apis](https://github.com/public-apis) on GitHub | Free
[API list](https://github.com/n0shake/Public-APIs) by [@n0shake](https://github.com/n0shake) on GitHub | Free
[JSONView extension for Chrome](https://chrome.google.com/webstore/detail/jsonview/chklaanhfefbnpoihckbnefhakgolnmc?hl=en-US) | Free
[HTTP Status Codes cheat sheet](http://www.cheat-sheets.org/saved-copy/http-response-codes-1.pdf) | Free
[JSON Formatter, Validator, Minifier, and Converter](https://jsonformatter.org) | Free
[XML to JSON Converter](https://jsonformatter.org/xml-to-json) | Free
[YAML to JSON Converter](https://jsonformatter.org/yaml-to-json) | Free

**[&#8679; Back to Index](#index)**

### Regular Expressions
Name | Cost
---- | ----
freeCodeCamp's [Regular Expressions course](https://www.freecodecamp.org/learn/javascript-algorithms-and-data-structures/#regular-expressions) | Free
Codecademy's [Learn the Basics of Regular Expressions course](https://www.codecademy.com/learn/introduction-to-regular-expressions) | Free
[Regular Expressions cheat sheet](https://cheatography.com/davechild/cheat-sheets/regular-expressions/pdf) | Free
[Regular Expressions cheat sheet](https://devhints.io/regexp) on Devhints | Free
[regex101](https://regex101.com) | Free
[HTML5Pattern](https://www.html5pattern.com) | Free

**[&#8679; Back to Index](#index)**

### TypeScript
Name | Cost
---- | ----
[TypeScript website](https://www.typescriptlang.org) | Free
Codecademy's [Learn TypeScript course](https://www.codecademy.com/learn/learn-typescript) | Free
Codecademy's [Learn TypeScript: Fundamentals course](https://www.codecademy.com/learn/learn-typescript-fundamentals) | Free
Codecademy's [Learn TypeScript: Functions course](https://www.codecademy.com/learn/learn-typescript-functions) | Free
Codecademy's [Learn TypeScript: Object Types course](https://www.codecademy.com/learn/learn-typescript-object-types) | Free
Codecademy's [Learn TypeScript: Union Types course](https://www.codecademy.com/learn/learn-typescript-union-types) | Free
Codecademy's [Learn TypeScript: Complex Types coures](https://www.codecademy.com/learn/learn-typescript-complex-types) | Free
Codecademy's [Learn TypeScript: Type Narrowing course](https://www.codecademy.com/learn/learn-typescript-type-narrowing) | Free
Codecademy's [Learn Intermediate TypeScript course](https://www.codecademy.com/learn/learn-intermediate-type-script) | Paid
[TypeScript cheat sheet](https://devhints.io/typescript) on Devhints | Free

**[&#8679; Back to Index](#index)**

## HTML and CSS
Name | Cost
---- | ----
freeCodeCamp's [Responsive Web Design Certification](https://www.freecodecamp.org/learn/responsive-web-design) | Free
W3Schools's [HTML Tutorial](https://www.w3schools.com/html/default.asp) | Free
W3Schools's [CSS Tutorial](https://www.w3schools.com/css/default.asp) | Free
Scrimba.com's [HTML & CSS Crash Course](https://scrimba.com/learn/htmlcss) | Free
Scrimba.com's [Introduction to HTML course](https://scrimba.com/learn/html) | Free
Scrimba.com's [Introduction to CSS course](https://scrimba.com/learn/introtocss) | Free
Udacity's [Intro to HTML and CSS course](https://www.udacity.com/course/intro-to-html-and-css--ud001) | Free
[HTML Foundations tutorial](https://www.theodinproject.com/paths/foundations/courses/foundations#html-foundations) on The Odin Project | Free
[CSS Foundations tutorial](https://www.theodinproject.com/paths/foundations/courses/foundations#css-foundations) on The Odin Project | Free
[Intermediate HTML and CSS course](https://www.theodinproject.com/paths/full-stack-javascript/courses/intermediate-html-and-css) on The Odin Project | Free
[Advanced HTML and CSS course](https://www.theodinproject.com/paths/full-stack-javascript/courses/advanced-html-and-css) on The Odin Project | Free
Codecademy's [Learn HTML course](https://www.codecademy.com/learn/learn-html) | Free
Codecademy's [Learn HTML: Fundamentals course](https://www.codecademy.com/learn/learn-html-fundamentals) | Free
Codecademy's [Learn HTML: Semantic HTML course](https://www.codecademy.com/learn/learn-html-semantic-html) | Free
Codecademy's [Learn HTML: Forms course](https://www.codecademy.com/learn/learn-html-forms) | Free
Codecademy's [Learn HTML: Tables course](https://www.codecademy.com/learn/learn-html-tables) | Free
Codecademy's [Learn CSS course](https://www.codecademy.com/learn/learn-css) | Free
Codecademy's [Learn CSS: Introduction course](https://www.codecademy.com/learn/learn-css-introduction) | Free
Codecademy's [Learn CSS: Box Model and Layout course](https://www.codecademy.com/learn/learn-css-box-model-and-layout) | Free
Codecademy's [Learn CSS: Colors course](https://www.codecademy.com/learn/learn-css-colors) | Free
Codecademy's [Learn Color Design course](https://www.codecademy.com/learn/learn-color-design) | Paid
Codecademy's [Learn CSS: Typography and Fonts course](https://www.codecademy.com/learn/learn-css-typography-and-fonts) | Free
Codecademy's [Learn CSS: Accessibility course](https://www.codecademy.com/learn/learn-css-accessibility) | Free
Codecademy's [Learn CSS: Browser Compatibility course](https://www.codecademy.com/learn/learn-css-browser-compatibility) | Free
Codecademy's [Learn Intermediate CSS course](https://www.codecademy.com/learn/learn-intermediate-css) | Free
Codecademy's [Learn CSS: Responsive Design course](https://www.codecademy.com/learn/learn-responsive-design) | Paid
Codecademy's [Learn CSS: Transitions and Animations course](https://www.codecademy.com/learn/learn-css-transitions-and-animations) | Free
Codecademy's [Learn CSS: Variables and Functions course](https://www.codecademy.com/learn/learn-css-variables-and-functions) | Free
Sololearn's [HTML course](https://www.sololearn.com/learning/1014) | Free with some Paid features
Sololearn's [CSS course](https://www.sololearn.com/learning/1023) | Free
Udacity's [Responsive Web Design Fundamentals course](https://www.udacity.com/course/responsive-web-design-fundamentals--ud893) | Free
Udacity's [Responsive Images course](https://www.udacity.com/course/responsive-images--ud882) | Free
Sololearn's [Responsive Web Design course](https://www.sololearn.com/learning/1162) | Free
W3Schools's [Accessibility Tutorial](https://www.w3schools.com/accessibility/index.php) | Free
Udacity's [Web Accessibility course](https://www.udacity.com/course/web-accessibility--ud891) | Free
Scrimba.com's [Learn UI Design Fundamentals course](https://scrimba.com/learn/design) | Free
Scrimba.com's [Learn CSS Variables for free course](https://scrimba.com/learn/cssvariables) | Free

**[&#8679; Back to Index](#index)**

### Flexbox and CSS Grid
Name | Cost
---- | ----
Codecademy's [Learn CSS: Flexbox and Grid course](https://www.codecademy.com/learn/learn-css-flexbox-and-grid) | Free
freeCodeCamp's [CSS Flexbox course](https://www.freecodecamp.org/learn/responsive-web-design/#css-flexbox) | Free
Scrimba.com's [Learn Flexbox for free course](https://scrimba.com/learn/flexbox) | Free
[Flexbox tutorial](https://www.theodinproject.com/paths/foundations/courses/foundations#flexbox) on The Odin Project | Free
[What the Flexbox?! course](https://flexbox.io) by Wes Bos | Free
[Flexbox Playground](https://the-echoplex.net/flexyboxes) | Free
[Flexbox cheat sheet](https://yoksel.github.io/flex-cheatsheet) | Free
[Flexbox cheat sheet](https://devhints.io/css-flexbox) on Devhints | Free
freeCodeCamp's [CSS Grid course](https://www.freecodecamp.org/learn/responsive-web-design/#css-grid) | Free
Scrimba.com's [Learn CSS Grid for free course](https://scrimba.com/learn/cssgrid) | Free
[Grid tutorial](https://www.theodinproject.com/paths/full-stack-javascript/courses/intermediate-html-and-css#grid) on The Odin Project | Free
[CSS Grid course](https://cssgrid.io) by Wes Bos | Free
[CSS Grid cheat sheet](https://yoksel.github.io/grid-cheatsheet) | Free
[CSS Grid cheat sheet](https://devhints.io/css-grid) on Devhints | Free

**[&#8679; Back to Index](#index)**

### Bootstrap
Name | Cost
---- | ----
[Bootstrap website](https://getbootstrap.com) | Free
W3Schools's [Bootstrap 3 Tutorial](https://www.w3schools.com/bootstrap/default.asp) | Free
W3Schools's [Bootstrap 4 Tutorial](https://www.w3schools.com/bootstrap4/default.asp) | Free
[Bootstrap 4 cheat sheet](https://hackerthemes.com/bootstrap-cheatsheet) | Free
Scrimba.com's [Learn Bootstrap 4 for free course](https://scrimba.com/learn/bootstrap4) | Free
freeCodeCamp's [Bootstrap course](https://www.freecodecamp.org/learn/front-end-libraries/#bootstrap) | Free
Codecademy's [Learn Bootstrap course](https://www.codecademy.com/learn/learn-bootstrap) | Paid

**[&#8679; Back to Index](#index)**

### Sass
Name | Cost
---- | ----
[Sass website](https://sass-lang.com) | Free
freeCodeCamp's [SASS course](https://www.freecodecamp.org/learn/front-end-libraries/#sass) | Free
W3Schools's [Sass Tutorial](https://www.w3schools.com/sass/default.php) | Free
Codecademy's [Learn Sass course](https://www.codecademy.com/learn/learn-sass) | Paid
Codecademy's [Learn Sass: Fundamentals course](https://www.codecademy.com/learn/learn-sass-fundamentals) | Free
Codecademy's [Learn Sass: Functions and Operations course](https://www.codecademy.com/learn/learn-sass-functions-and-operations) | Free
Codecademy's [Learn Sass: Mixins and Parent Selector course](https://www.codecademy.com/learn/learn-sass-mixins-and-the-parent-selector) | Free
Codecademy's [Learn Sass: Best Practices course](https://www.codecademy.com/learn/learn-sass-best-practices) | Free
[Sass cheat sheet](https://devhints.io/sass) on Devhints | Free
[CSS to SCSS Converter](https://jsonformatter.org/css-to-scss) | Free
[SCSS to CSS Converter](https://jsonformatter.org/scss-to-css) | Free
[SCSS Formatter](https://jsonformatter.org/scss-formatter) | Free

**[&#8679; Back to Index](#index)**

### HTML and CSS Tools
Name | Cost
---- | ----
[W3C Markup Validator](https://validator.w3.org) | Free
[HTML Validator](https://jsonformatter.org/html-validator) from JSONformatter.org | Free
[W3C CSS Validator](http://jigsaw.w3.org/css-validator) | Free
[HTML tags list](https://html-css-js.com/html/tags) | Free
[HTML input tag cheat sheet](https://devhints.io/html-input) on Devhints | Free
[CSS cheat sheet](https://websitesetup.org/wp-content/uploads/2019/11/wsu-css-cheat-sheet-gdocs.pdf) | Free
[CSS cheat sheet](https://devhints.io/css) on Devhints | Free
[HTML Formatter](https://jsonformatter.org/html-formatter) | Free
[CSS Formatter](https://jsonformatter.org/css-beautifier) | Free
W3Schools's [HTML Color Picker](https://www.w3schools.com/colors/colors_picker.asp) | Free
[Color Contrast Checker](https://webaim.org/resources/contrastchecker) | Free
[Web Accessibility Evaluation Tool](https://wave.webaim.org) | Free
[Normalize.css website](https://necolas.github.io/normalize.css) | Free
[Autoprefixer CSS online](https://autoprefixer.github.io) | Free
[CSS Gradient Generator](https://angrytools.com/gradient) | Free
[Gradient Hunt](https://gradienthunt.com) | Free
[Gradienta CSS gradients](https://gradienta.io) | Free
[Image to Colors Palette Generator](http://www.cssdrive.com/imagepalette/index.php) | Free
[Palette List](https://www.palettelist.com) | Free
[Color Hunt](https://colorhunt.co) | Free
[CSS Minifier](https://jsonformatter.org/minify-css) | Free

**[&#8679; Back to Index](#index)**

## Fonts, Icons, and Images

### Fonts
Check whether the owner allows their fonts to be used for both commercial use and personal use or for just personal use only. Also check if the owner requires credit attribution.

Name | Cost
---- | ----
[Google Fonts](https://fonts.google.com) | Free
[DaFont](https://www.dafont.com) | Free, but it's important to check the source of the font that you use to be sure
[Fonts2u.com](https://fonts2u.com) | Free, but it's important to check the source of the font that you use to be sure
[1001 Free Fonts](https://www.1001freefonts.com) | Free, but it's important to check the source of the font that you use to be sure
[BeFonts](https://befonts.com) | Free, but full features and license are Paid

**[&#8679; Back to Index](#index)**

### Icon Font Libraries
Name | Cost
---- | ----
[Font Awesome](https://fontawesome.com) | Free and Paid content
[Material Icons](https://fonts.google.com/icons) | Free
[Weather Icons by erikflowers](https://erikflowers.github.io/weather-icons) | Free
[Ionicons](https://ionicons.com) | Free

**[&#8679; Back to Index](#index)**

### Stock Images
Check whether the owner allows their images to be used for both commercial use and personal use or for just personal use only. Also, check if the owner requests credit attribution.

Name | Cost
---- | ----
[Burst](https://burst.shopify.com) by Shopify | Free
[Unsplash](https://unsplash.com) | Free
[Pexels](https://www.pexels.com) | Free
[Pixabay](https://pixabay.com) | Free
[PicSpree](https://picspree.com/en) | Free
[StockSnap.io](https://stocksnap.io) | Free
[ISO Republic](https://isorepublic.com) | Free
[reshot](https://www.reshot.com) | Free
[Pickup Image](https://pickupimage.com) | Free
[Foodiesfeed](https://www.foodiesfeed.com) | Free
[CleanPNG transparent images](https://www.cleanpng.com) | Free
[Free-Images.com](https://free-images.com) | Free
[Icons8](https://icons8.com) | Free with Paid features
[Iconfinder](https://www.iconfinder.com) | Free and Paid content
[Feather Icons](https://feathericons.com/) | Free
[Noun Project](https://thenounproject.com) | Free with Paid features

**[&#8679; Back to Index](#index)**

### Image Editing Tools
Name | Cost
---- | ----
[cssFilters.co](https://www.cssfilters.co) | Free
[Dynamic Dummy Image Generator](https://dummyimage.com) | Free
[TinyPNG](https://tinypng.com) | Free with Paid features
[Remove Image Background tool](https://www.remove.bg) | Free with Paid features
[Photopea](https://www.photopea.com) | Free
[Photo Image Editor Pixelstyle](https://apps.apple.com/us/app/photo-image-editor-pixelstyle/id1244649277?mt=12) | Free
[Inkscape](https://inkscape.org/) | Free

**[&#8679; Back to Index](#index)**

## Command Line, Git, and Markdown
Name | Cost
---- | ----
[Command Line Power User course](https://commandlinepoweruser.com) by Wes Bos | Free
Codecademy's [Learn the Command Line course](https://www.codecademy.com/learn/learn-the-command-line) | Paid
[Unix/Linux Commands cheat sheet](http://www.cheat-sheets.org/saved-copy/fwunixref.pdf) | Free
[Mastering Markdown course](https://masteringmarkdown.com) by Wes Bos | Free
[Markdown cheat sheet](https://guides.github.com/pdfs/markdown-cheatsheet-online.pdf) | Free
[Markdown cheat sheet](https://devhints.io/markdown) on Devhints | Free
[Markdown Formatter](https://jsonformatter.org/markdown-formatter) | Free
Udacity's [Writing READMEs course](https://www.udacity.com/course/writing-readmes--ud777) | Free
[GitHub Desktop](https://desktop.github.com) | Free
[Git Basics tutorial](https://www.theodinproject.com/paths/foundations/courses/foundations#git-basics) on The Odin Project | Free
[Git cheat sheet](https://training.github.com/downloads/github-git-cheat-sheet.pdf) | Free
W3Schools's [Git Tutorial](https://www.w3schools.com/git/default.asp) | Free
Udacity's [Version Control with Git course](https://www.udacity.com/course/version-control-with-git--ud123) | Free
Codecademy's [Learn Git: Introduction course](https://www.codecademy.com/learn/learn-git-introduction) | Free
Codecademy's [Learn Git: Branching and Collaboration](https://www.codecademy.com/learn/learn-git-branching-and-collaboration) | Free
Codecademy's [Learn GitHub: Introduction course](https://www.codecademy.com/learn/learn-github-introduction) | Free
Codecademy's [Deploying Websites using Git and GitHub course](https://www.codecademy.com/learn/deploying-websites-using-git-and-github) | Free
Codecademy's [Learn GitHub: Best Practices course](https://www.codecademy.com/learn/learn-github-best-practices) | Free
Codecademy's [Learn Git & GitHub course](https://www.codecademy.com/learn/learn-git) | Paid

**[&#8679; Back to Index](#index)**

## React.js
Name | Cost
---- | ----
[React.js website](https://reactjs.org) | Free
W3Schools's [React Tutorial](https://www.w3schools.com/react/default.asp) | Free
Codecademy's [Learn React course](https://www.codecademy.com/learn/react-101) | Free
Codecademy's [Learn React: Introduction course](https://www.codecademy.com/learn/learn-react-introduction) | Free
Codecademy's [Learn React: Additional Basics course](https://www.codecademy.com/learn/learn-react-additional-basics) | Free
Codecademy's [Learn React: State Management course](https://www.codecademy.com/learn/learn-react-state-management) | Free
Codecademy's [Learn React: Hooks course](https://www.codecademy.com/learn/learn-react-hooks) | Free
Codecademy's [Learn React: Lifecycle Methods course](https://www.codecademy.com/learn/learn-react-lifecycle-methods) | Free
Codecademy's [Learn Advanced React course](https://www.codecademy.com/learn/learn-advanced-react) | Paid
Scrimba.com's [Learn React for free course](https://scrimba.com/learn/learnreact) | Free
[React JS tutorial](https://www.theodinproject.com/paths/full-stack-javascript/courses/javascript#react-js) on The Odin Project | Free
Sololearn's [React + Redux course](https://www.sololearn.com/learning/1097) | Free
freeCodeCamp's [React course](https://www.freecodecamp.org/learn/front-end-libraries/#react) | Free
[React Hooks Simplified course](https://courses.webdevsimplified.com/react-hooks-simplified) | Free
[React Resources](https://github.com/enaqx/awesome-react) by [@enaqx](https://github.com/enaqx) on GitHub | Free
[React cheat sheet](https://devhints.io/react) on Devhints | Free
[React Developer Tools extension for Chrome](https://chrome.google.com/webstore/detail/react-developer-tools/fmkadmapgofadopljbjfkapdkoienihi?hl=en-US) | Free
[React Router website](https://reactrouter.com) | Free
Codecademy's [Learn React Router v6 course](https://www.codecademy.com/learn/learn-react-router) | Free
Codecademy's [Learn React Native course](https://www.codecademy.com/learn/learn-react-native) | Free
[React Interview Questions](https://github.com/sudheerj/reactjs-interview-questions) by [@sudheerj](https://github.com/sudheerj) on GitHub | Free

**[&#8679; Back to Index](#index)**

### Redux
Name | Cost
---- | ----
[Redux website](https://redux.js.org) | Free
Codecademy's [Learn Redux course](https://www.codecademy.com/learn/learn-redux) | Free
Codecademy's [Learn Redux: Fundamentals course](https://www.codecademy.com/learn/learn-redux-fundamentals) | Free
Codecademy's [Learn Redux: Redux Toolkit course](https://www.codecademy.com/learn/learn-redux-redux-toolkit) | Free
Codecademy's [Learn Redux: Middleware and Thunks course](https://www.codecademy.com/learn/learn-redux-middleware-and-thunks) | Free
Codecademy's [Learn Redux: React Redux course](https://www.codecademy.com/learn/learn-redux-react-redux) | Free
freeCodeCamp's [Redux course](https://www.freecodecamp.org/learn/front-end-libraries/#redux) | Free
freeCodeCamp's [React and Redux course](https://www.freecodecamp.org/learn/front-end-libraries/#react-and-redux) | Free
[Redux cheat sheet](https://devhints.io/redux) on Devhints | Free

**[&#8679; Back to Index](#index)**

## Node.js
Name | Cost
---- | ----
[Node.js website](https://nodejs.org/en) | Free
[NPM website](https://www.npmjs.com) | Free with some Paid features
[NPM cheat sheet](https://devhints.io/npm) on Devhints | Free
freeCodeCamp's [Managing Packages with NPM course](https://www.freecodecamp.org/learn/apis-and-microservices/#managing-packages-with-npm) | Free
Codecademy's [Learn Node.js course](https://www.codecademy.com/learn/learn-node-js) | Free
Codecademy's [Learn Node.js: Fundamentals course](https://www.codecademy.com/learn/learn-nodejs-fundamentals) | Free
Codecademy's [Learn Node.js: Setting Up a Server course](https://www.codecademy.com/learn/learn-nodejs-setting-up-a-server) | Free
Codecademy's [Learn to Prevent Cross-Site Scripting with Node.js course](https://www.codecademy.com/learn/learn-to-prevent-cross-site-scripting-with-node-js) | Paid
W3Schools's [Node.js Tutorial](https://www.w3schools.com/nodejs/default.asp) | Free
[nodemon website](https://nodemon.io) | Free

**[&#8679; Back to Index](#index)**

### Express.js
Name | Cost
---- | ----
[Express.js website](https://expressjs.com) | Free
["Understanding Express.js" article](http://evanhahn.com/understanding-express) by Evan Hahn | Free
[Express.js cheat sheet](https://overapi.com/express) | Free
freeCodeCamp's [Basic Node and Express course](https://www.freecodecamp.org/learn/apis-and-microservices/#basic-node-and-express) | Free
[NodeJS course](https://www.theodinproject.com/paths/full-stack-javascript/courses/nodejs) on The Odin Project | Free
[Pug website](https://pugjs.org) | Free
[EJS website](https://ejs.co) | Free
[Passport.js website](http://www.passportjs.org) | Free
freeCodeCamp's [Advanced Node and Express course](https://www.freecodecamp.org/learn/quality-assurance/#advanced-node-and-express) | Free
Codecademy's [Learn Express course](https://www.codecademy.com/learn/learn-express) | Paid
Codecademy's [User Authentication & Authorization in Express course](https://www.codecademy.com/learn/user-authentication-authorization-express) | Free
[Helmet.js website](https://helmetjs.github.io) | Free
freeCodeCamp's [Information Security with HelmetJS course](https://www.freecodecamp.org/learn/information-security/#information-security-with-helmetjs) | Free
[Socket.IO website](https://socket.io) | Free

**[&#8679; Back to Index](#index)**

### JavaScript Testing
Name | Cost
---- | ----
[Mocha.js website](https://mochajs.org) | Free
[Chai.js website](https://www.chaijs.com) | Free
[Chai.js cheat sheet](https://devhints.io/chai) on Devhints | Free
[Jasmine website](https://jasmine.github.io) | Free
[Jasmine cheat sheet](https://devhints.io/jasmine) on Devhints | Free
[Jest website](https://jestjs.io) | Free
[Jest cheat sheet](https://devhints.io/jest) on Devhints | Free
freeCodeCamp's [Quality Assurance and Testing with Chai course](https://www.freecodecamp.org/learn/quality-assurance/#quality-assurance-and-testing-with-chai) | Free
Udacity's [JavaScript Testing course](https://www.udacity.com/course/javascript-testing--ud549) | Free
[Testing JavaScript tutorial](https://www.theodinproject.com/paths/full-stack-javascript/courses/javascript#testing-javascript) on The Odin Project | Free
Codecademy's [Learn React Testing course](https://www.codecademy.com/learn/learn-react-testing) | Free
Codecademy's [Learn JavaScript Unit Testing course](https://www.codecademy.com/learn/learn-javascript-unit-testing) | Paid
Codecademy's [Learn Testing for Web Development course](https://www.codecademy.com/learn/learn-testing-for-web-development) | Paid

**[&#8679; Back to Index](#index)**

## Other JavaScript Libraries
Name | Cost
---- | ----
[D3.js website](https://d3js.org) | Free
freeCodeCamp's [Data Visualization Certification](https://www.freecodecamp.org/learn/data-visualization) | Free
Scrimba.com's [Learn D3 for free course](https://scrimba.com/learn/d3js) | Free
Udacity's [Data Visualization and D3.js course](https://www.udacity.com/course/data-visualization-and-d3js--ud507) | Free
Codecademy's [Learn D3 course](https://www.codecademy.com/learn/learn-d3) | Paid
[Chart.js website](https://www.chartjs.org) | Free
[Moment.js website](https://momentjs.com) | Free
[Moment.js cheat sheet](https://devhints.io/moment) on Devhints | Free
[Vue.js website](https://vuejs.org) | Free
Scrimba.com's [Learn Vue.js for free course](https://scrimba.com/learn/learnvue) | Free
Codecademy's [Learn Vue.js course](https://www.codecademy.com/learn/learn-vue-js) | Paid
[Vue.js cheat sheet](https://devhints.io/vue) on Devhints | Free
[Angular website](https://angular.io) | Free
Scrimba.com's [Build your first Angular app course](https://scrimba.com/learn/yourfirstangularapp) | Free
[AngularJS website](https://angularjs.org) | Free
W3Schools's [AngularJS Tutorial](https://www.w3schools.com/angular/default.asp) | Free
Codecademy's [Learn AngularJS 1.X course](https://www.codecademy.com/learn/learn-angularjs) | Free
[Angular.js cheat sheet](https://devhints.io/angularjs) on Devhints | Free
[jQuery website](https://jquery.com) | Free
W3Schools's [jQuery Tutorial](https://www.w3schools.com/jquery/default.asp) | Free
Sololearn's [jQuery course](https://www.sololearn.com/learning/1082) | Free
Codecademy's [Learn jQuery course](https://www.codecademy.com/learn/learn-jquery) | Paid
Codecademy's [Learn jQuery: Fundamentals course](https://www.codecademy.com/learn/learn-jquery-fundamentals) | Free
Codecademy's [Learn jQuery: Effects and Event Handling course](https://www.codecademy.com/learn/learn-jquery-effects-and-event-handling) | Free
Codecademy's [Learn jQuery: Styles course](https://www.codecademy.com/learn/learn-jquery-styles) | Free
Codecademy's [Learn jQuery: DOM Traversing course](https://www.codecademy.com/learn/learn-jquery-dom-traversing) | Free
[p5.js website](https://p5js.org) | Free
Codecademy's [Learn p5.js course](https://www.codecademy.com/learn/learn-p5js) | Free
Codecademy's [Learn p5.js: Fundamentals course](https://www.codecademy.com/learn/learn-p5js-fundamentals) | Free
Codecademy's [Learn p5.js: Interaction course](https://www.codecademy.com/learn/learn-p5js-interaction) | Free
Codecademy's [Learn p5.js: Media course](https://www.codecademy.com/learn/learn-p5js-media) | Free
[Three.js webspite](https://threejs.org) | Free
[ProgressBar.js website](https://progressbarjs.readthedocs.io/en/latest/) | Free
[Webpack.js website](https://webpack.js.org) | Free
[Babel.js website](https://babeljs.io) | Free
[TensorFlow website](https://www.tensorflow.org) | Free
W3Schools's [TensorFlow Tutorial](https://www.w3schools.com/ai/ai_tensorflow_intro.asp) | Free
[Brain.js website](https://brain.js.org) | Free
Scrimba.com's [Neural networks in JavaScript course](https://scrimba.com/learn/neuralnetworks) | Free

**[&#8679; Back to Index](#index)**

## MongoDB
Name | Cost
---- | ----
[MongoDB website](https://www.mongodb.com) | Free and Paid services
freeCodeCamp's [MongoDB and Mongoose course](https://www.freecodecamp.org/learn/apis-and-microservices/#mongodb-and-mongoose) | Free
Codecademy's [Learn MongoDB course](https://www.codecademy.com/learn/learn-mongodb) | Free
[MongoDB University](https://university.mongodb.com) | Free
Udacity's [Data Wrangling with MongoDB course](https://www.udacity.com/course/data-wrangling-with-mongodb--ud032) | Free
[Mongoose.js website](https://mongoosejs.com) | Free
[MongoDB cheat sheet](https://webdevsimplified.com/mongodb-cheat-sheet.html) | Free

**[&#8679; Back to Index](#index)**

## SQL Databases
Name | Cost
---- | ----
[Postgres website](https://www.postgresql.org) | Free
[Intro to SQL: Querying and managing data course](https://www.khanacademy.org/computing/computer-programming/sql) on Khan Academy | Free
freeCodeCamp's [Relational Database Certification](https://www.freecodecamp.org/learn/relational-database) | Free
Codecademy's [Learn SQL course](https://www.codecademy.com/learn/learn-sql) | Free
Codecademy's [How to Transform Tables with SQL course](https://www.codecademy.com/learn/sql-table-transformation) | Paid
Codecademy's [How to Analyze Business Metrics with SQL course](https://www.codecademy.com/learn/sql-analyzing-business-metrics) | Paid
Codecademy's [Learn to Prevent SQL Injections with Node.js course](https://www.codecademy.com/learn/learn-to-prevent-sql-injections-with-node-js) | Paid
Codecademy's [Learn Node-SQLite course](https://www.codecademy.com/learn/learn-node-sqlite) | Free
[Knex Query Lab](https://michaelavila.com/knex-querylab) | Free
[Knex cheat sheet](https://devhints.io/knex) on Devhints | Free

**[&#8679; Back to Index](#index)**

## WordPress
Name | Cost
---- | ----
[WordPress Developer Resources](https://developer.wordpress.org) | Free
[WordPress Codex](https://codex.wordpress.org) | Free
[WPBeginner](https://www.wpbeginner.com) | Free
[WordPress Stack Exchange](https://wordpress.stackexchange.com) | Free
[Local](https://localwp.com) by Flywheel | Free
Codecademy's [Learn PHP course](https://www.codecademy.com/learn/learn-php) | Free
Codecademy's [Learn PHP: Introduction course](https://www.codecademy.com/learn/learn-php-introduction) | Free
Codecademy's [Learn Intermediate PHP course](https://www.codecademy.com/learn/learn-intermediate-php) | Free
Codecademy's [Learn PHP: Arrays and Loops course](https://www.codecademy.com/learn/learn-php-arrays-and-loops) | Free
Codecademy's [Learn PHP: Conditionals and Logic course](https://www.codecademy.com/learn/learn-php-conditionals-and-logic) | Free
Codecademy's [Learn PHP: Functions course](https://www.codecademy.com/learn/learn-php-functions) | Free
Codecademy's [Learn PHP: Form Handling and Validation course](https://www.codecademy.com/learn/learn-php-form-handling-and-validation) | Free
Codecademy's [Learn PHP: Objects and Classes coure](https://www.codecademy.com/learn/learn-php-objects-and-classes) | Free
W3Schools's [PHP Tutorial](https://www.w3schools.com/php/default.asp) | Free
Sololearn's [PHP course](https://www.sololearn.com/learning/1059) | Free
[PHP tutorial](https://www.alphacodingskills.com/php/php-tutorial.php) on AlphaCodingSkills | Free
[PHP interview questions](https://www.alphacodingskills.com/interview/php-interview-questions.php) on AlphaCodingSkills | Free
[PHP Formatter](https://jsonformatter.org/php-formatter) | Free

**[&#8679; Back to Index](#index)**

## Python
Name | Cost
---- | ----
[Python website](https://www.python.org) | Free
[PyPi website](https://pypi.org) | Free
W3Schools's [Python Tutorial](https://www.w3schools.com/python/default.asp) | Free
[Python cheat sheet](https://overapi.com/python) | Free
[Python cheat sheet](https://devhints.io/python) on Devhints | Free
[pytest](https://docs.pytest.org/en/7.1.x) | Free
Sololearn's [Python for Beginners course](https://www.sololearn.com/learning/1157) | Free with some Paid features
Sololearn's [Intermediate Python course](https://www.sololearn.com/learning/1158) | Free with some Paid features
Sololearn's [Python Core course](https://www.sololearn.com/learning/1073) | Free with some Paid features
Sololearn's [Data Science course](https://www.sololearn.com/learning/1093) | Free
Sololearn's [Python for Data Science course](https://www.sololearn.com/learning/1161) | Free with some Paid features
Sololearn's [Python Data Structures course](https://www.sololearn.com/learning/1159) | Free with some Paid features
Sololearn's [Machine Learning course](https://www.sololearn.com/learning/1094) | Free
Scrimba.com's [Learn Python for free course](https://scrimba.com/learn/python) | Free
freeCodeCamp's [Scientific Computing with Python Certification](https://www.freecodecamp.org/learn/scientific-computing-with-python) | Free
freeCodeCamp's [Data Analysis with Python Certification](https://www.freecodecamp.org/learn/data-analysis-with-python) | Free
freeCodeCamp's [Python for Penetration Testing course](https://www.freecodecamp.org/learn/information-security/#python-for-penetration-testing) | Free
freeCodeCamp's [Machine Learning with Python Certification](https://www.freecodecamp.org/learn/machine-learning-with-python) | Free
[Python tutorial](https://www.alphacodingskills.com/python/python-tutorial.php) on AlphaCodingSkills | Free
[Python interview questions](https://www.alphacodingskills.com/interview/python-interview-questions.php) on AlphaCodingSkills | Free
Udacity's [Introduction to Python Programming course](https://www.udacity.com/course/introduction-to-python--ud1110) | Free
Codecademy's [Python for Programmers course](https://www.codecademy.com/learn/python-for-programmers) | Free
Codecademy's [Learn Python 3 course](https://www.codecademy.com/learn/learn-python-3) | Paid
Codecademy's [Learn Intermediate Python 3 course](https://www.codecademy.com/learn/learn-intermediate-python-3) | Paid
Codecademy's [Learn Intermediate Python 3: Object-Oriented Programming course](https://www.codecademy.com/learn/learn-intermediate-python-3-object-oriented-programming) | Free
Codecademy's [Learn Intermediate Python 3: Functions, Namespaces, and Scope course](https://www.codecademy.com/learn/learn-intermediate-python-3-functions-namespaces-and-scope) | Free
Codecademy's [Learn Intermediate Python 3: Iterators and Generators course](https://www.codecademy.com/learn/learn-intermediate-python-3-iterators-and-generators) | Free
Codecademy's [Learn Intermediate Python 3: Exceptions and Unit Testing coures](https://www.codecademy.com/learn/learn-intermediate-python-3-exceptions-and-unit-testing) | Free
Codecademy's [Learn Intermediate Python 3: Sets and Specialized Collections course](https://www.codecademy.com/learn/learn-intermediate-python-3-sets-and-specialized-collections) | Free
Codecademy's [Learn Intermediate Python 3: Resource Management course](https://www.codecademy.com/learn/learn-intermediate-python-3-resource-management) | Free
Codecademy's [Learn Object Oriented Programming with Python & Project-Based Learning course](https://www.codecademy.com/learn/learn-object-oriented-programming-with-python) | Free
Codecademy's [Learn Advanced Python 3 course](https://www.codecademy.com/learn/learn-advanced-python) | Paid
Codecademy's [Learn Advanced Python 3: Functional Programming course](https://www.codecademy.com/learn/learn-advanced-python-3-functional-programming) | Free
Codecademy's [Learn Advanced Python 3: Database Operations course](https://www.codecademy.com/learn/learn-advanced-python-3-database-operations) | Free
Codecademy's [Learn Advanced Python 3: Concurrency course](https://www.codecademy.com/learn/learn-advanced-python-3-concurrency) | Free
Codecademy's [Learn Advanced Python 3: Logging course](https://www.codecademy.com/learn/learn-advanced-python-3-logging) | Free
Codecademy's [Hypothesis Testing with Python course](https://www.codecademy.com/learn/hypothesis-testing-python) | Paid
Codecademy's [Learn Data Analysis with Pandas course](https://www.codecademy.com/learn/data-processing-pandas) | Paid
Codecademy's [Learn Statistics with NumPy course](https://www.codecademy.com/learn/intro-statistics-numpy) | Paid
Codecademy's [Learn Statistics with Python course](https://www.codecademy.com/learn/learn-statistics-with-python) | Paid
Codecademy's [Exploratory Data Analysis in Python course](https://www.codecademy.com/learn/eda-exploratory-data-analysis-python) | Paid
Codecademy's [Getting Started with Python for Data Science course](https://www.codecademy.com/learn/getting-started-with-python-for-data-science) | Free
Codecademy's [Learn Data Visualization with Python course](https://www.codecademy.com/learn/data-visualization-python) | Free
Codecademy's [How to Clean Data with Python coures](https://www.codecademy.com/learn/practical-data-cleaning) | Paid
Codecademy's [Learn Data Structures and Algorithms with Python course](https://www.codecademy.com/learn/learn-data-structures-and-algorithms-with-python) | Paid
Codecademy's [Learn Advanced Algorithms and Data Structures with Python course](https://www.codecademy.com/learn/learn-advanced-algorithms-and-data-structures) | Paid
Codecademy's [Learn Recursion with Python course](https://www.codecademy.com/learn/learn-recursion-python) | Paid
Codecademy's [Learn Sorting Algorithms with Python course](https://www.codecademy.com/learn/sorting-algorithms) | Paid
Codecademy's [How to Implement Search Algorithms with Python course](https://www.codecademy.com/learn/search-algorithms) | Paid
Codecademy's [Linear Data Structures course](https://www.codecademy.com/learn/linear-data-structures) | Paid
Codecademy's [Learn Advanced Algorithms with Python: String Searching Algorithms course](https://www.codecademy.com/learn/learn-advanced-algorithms-with-python-string-searching-algorithms) | Free
Codecademy's [Learn Advanced Algorithms with Python: Hamiltonian Algorithms course](https://www.codecademy.com/learn/learn-advanced-algorithms-with-python-hamiltonian-algorithms) | Free
Codecademy's [Learn Advanced Data Structures with Python: Trees course](https://www.codecademy.com/learn/learn-advanced-data-structures-with-python-trees) | Free
Codecademy's [Linear Regression in Python course](https://www.codecademy.com/learn/linear-regression-mssp) | Free
Codecademy's [Learn the Basics of Machine Learning course](https://www.codecademy.com/learn/machine-learning) | Paid
Codecademy's [Technical Interview Practice with Python course](https://www.codecademy.com/learn/technical-interview-practice-python) | Paid

**[&#8679; Back to Index](#index)**