[![Contribute](https://img.shields.io/badge/contribute-now-green?logo=discourse&style=for-the-badge)](https://forum.authpass.app/c/contributors/contribute/13) [![Contribute](https://img.shields.io/discourse/topics?label=Forum%20Discussions&logo=discourse&server=https%3A%2F%2Fforum.authpass.app&style=for-the-badge)](https://forum.authpass.app/)
[<img align="right" src="https://badges.crowdin.net/e/df2e0329a54542fef35ab5412a893d23/localized.svg">](https://authpass.crowdin.com/authpass)

[![AuthPass.app](_docs/logo-header.png)](https://authpass.app)

# AuthPass.app - Open Source Password Manager for mobile and desktop

AuthPass - Password Manager based on Flutter for all platforms. Keepass 2.x (kdbx 3.x) compatible.

* Mac Desktop: [Mac App Store](https://apps.apple.com/app/authpass-password-manager/id1478552452?ls=1&mt=12) or [check the releases](https://github.com/authpass/authpass/releases)
* Android: [Google Play Store](https://play.google.com/store/apps/details?id=design.codeux.authpass)
* iOS: [App Store](https://apps.apple.com/app/authpass-password-manager/id1479297675?ls=1&at=11l8ru)
* Linux Desktop: [Snapcraft Store](https://snapcraft.io/authpass), [Flathub flatpak](https://flathub.org/apps/details/app.authpass.AuthPass) [Check out our blog post for installation instructions](https://authpass.app/articles/linux-desktop-release-authpass-1.6.3/)
* Windows Desktop: [Microsoft Store](https://www.microsoft.com/store/apps/9P5N6ZNPSFBN?cid=readme) or [Windows Install Guide](https://authpass.app/docs/install/windows-installation/)
* Browser/Web: https://web.authpass.app/

![Mac OS, iOS and Android Screenshot](_docs/authpass-platform-composition.png)

## Contribute to AuthPass

[Need ideas how to contribute? Visit the forum for many different ways to contribute.](https://forum.authpass.app/c/contributors/contribute/13) [![Contribute](https://img.shields.io/badge/contribute-now-green?logo=discourse)](https://forum.authpass.app/c/contributors/contribute/13)

If you like AuthPass, and want to contribute. First, spread the word ;-) Writing reviews, vote or
share AuthPass on twitter, reddit, etc.

* Help us translate AuthPass (work in progress): [![Crowdin](https://badges.crowdin.net/e/df2e0329a54542fef35ab5412a893d23/localized.svg)](https://authpass.crowdin.com/authpass)
  * [Contact us for new languages](https://authpass.app/docs/contact/)
* Interested in writing documentation? Let us know in our [discord channel](https://authpass.app/go/discord)
* Want to code? See [CONTRIBUTING.md](https://github.com/authpass/authpass/blob/master/CONTRIBUTING.md).
  * If you need some slight introduction to the code, ask in the [discord channel](https://authpass.app/go/discord).
* Good at design? Or marketing? Just get in contact ;-)

## Roadmap/TODOs

see also https://github.com/authpass/authpass/issues

[![GitHub issues](https://img.shields.io/github/issues-raw/authpass/authpass)](https://github.com/authpass/authpass/issues)

* [x] Read/Decrypt kdbx 3.x using password
* [x] Download of kdbx files through url
* [x] Parse decrypted XML/handle protected values
* [x] Flutter scaffold for mobile (ios/android)
* [X] Platforms 🎉️👍️✅️
  * [x] iOS: [App Store](https://apps.apple.com/app/authpass-password-manager/id1479297675?ls=1&at=11l8ru)
  * [x] Android: [Google Play Store](https://play.google.com/store/apps/details?id=design.codeux.authpass)
  * [x] Mac OS [Mac App Store](https://apps.apple.com/app/authpass-password-manager/id1478552452?ls=1&mt=12)
  * [x] [Windows](https://authpass.app/articles/authpass-released-for-windows-desktop-authpass-1.7.0/) https://github.com/authpass/authpass/issues/27
  * [x] [Linux](https://authpass.app/articles/linux-desktop-release-authpass-1.6.3/) https://github.com/authpass/authpass/issues/26
* [x] Decrypt with keyfile https://github.com/authpass/authpass/issues/3
* [x] List of password entries
* [x] 👆️ Search through entries
* [x] 👆️ Entry details
* [x] 👆️ mobile: copy usernames, passwords
* [x] mobile: integrate with biometrics (fingerprint)
* [ ] mac: Auto-Type https://github.com/authpass/authpass/issues/13
* [ ] 👆️ Auto-lock after x minutes of inactivity. https://github.com/authpass/authpass/issues/14
* [x] Editing existing entries
* [x] Saving of changes into kdbx file.
* [x] Creating of new kdbx files.
* [ ] Syncing of kdbx files via custom cloud service and QR codes. https://github.com/authpass/authpass/issues/29
* [x] Syncing with cloud services like dropbox or google drive?
* [x] 👆️ CI pipeline/continous builds, releases
* [x] kdbx 4 support (missing argon2) compatibility https://github.com/authpass/authpass/issues/4
* [x] Android: Auto Fill https://github.com/authpass/authpass/issues/30
* [ ] iOS: Auto Fill https://github.com/authpass/authpass/issues/31

# Donations

If you like AuthPass check out the [website for ways to support us](https://authpass.app/docs/support-authpass-get-involved/).

* Bitcoin: 3NcBacCmJbYWpwxj6rWzpM7sx48etMrPtc
* GitHub Sponsor: https://github.com/sponsors/hpoul (Or just hit the *Sponsor* button up top).

# License

AuthPass - Password Manager <hello@authpass.app>

This program is free software: you can redistribute it and/or modify
it under the terms of the [GNU General Public License](LICENSE) as published by
the Free Software Foundation **version 3** of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

Contributors must agree to [our CLA](https://cla-assistant.io/authpass/authpass).

